/* Martin Strigl */

#include <bluetooth/bluetooth.h>
#include <bluetooth/rfcomm.h>

#include "bluez.h"


GSM_Error GSM_Device_Bluetooth::Connect(char *address, int channel)
{
	struct sockaddr_rc		so_addr = { 0 };
	GSM_Error			error;

	(*Debug)->Deb("[DEVICE    : BLUELINUZ - connecting to address %s channel %i]\n",address,channel);

	error = Sock->Init(Debug);
	if (error.Code != GSM_ERR_NONE) return error;

	Device = socket(AF_BLUETOOTH, SOCK_STREAM, BTPROTO_RFCOMM);
	if (Device < 0) {
		return GSM_Return_Error(GSM_ERR_DRIVER_NOT_AVAILABLE);
	}

	memset (&so_addr, 0, sizeof(so_addr));
	so_addr.rc_family = AF_BLUETOOTH;
	so_addr.rc_channel = (uint8_t) channel;
	str2ba( address, &so_addr.rc_bdaddr );

	if (connect(Device, (struct sockaddr *)&so_addr, sizeof(so_addr)) != 0) {
		close(Device);
		return GSM_Return_Error(GSM_ERR_DEVICE_OPEN);
	}

	Opened = true;
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Device_Bluetooth::Open(char *Dev, char *Prot, char *Pho, char **DeviceModel, GSM_AllPhones *Phones)
{

	(*Debug)->Deb("[DEVICE    : BLUELINUZ - opening device blue\n");
	return Connect(Dev, 15);
}

GSM_Error GSM_Device_Bluetooth::Close()
{
        (*Debug)->Deb("[STATE     : BLUELINUZ - closing device]\n");
	if (!Opened) return GSM_Return_Error(GSM_ERR_NONE); 
	return Sock->Close(Device);
}

GSM_Error GSM_Device_Bluetooth::Read(unsigned char *buf, int *len)
{
	return Sock->Read(Device,buf,len);
}

GSM_Error GSM_Device_Bluetooth::Write(const unsigned char *buf, int len)
{
	return Sock->Write(Device,buf,len);
}
