//---------------------------------------------------------------------------
//
// Name:        SMSEditorDlg.cpp
// Author:      Marcinello
// Created:     2007-02-06 23:39:09
// Description: SMSEditorDlg class implementation
//
//---------------------------------------------------------------------------

#include "../cfg/config.h"
#include "../common/service/smsmms/gsmmsg.h"
#include "../common/service/gsmmisc.h"
#include "../common/service/backup/gsmback.h"
#include "../common/gsmstate.h"
#include "../common/misc/misc.h"

#include "SMSEditorDlg.h"
#include "shared.h"

//Do not add custom headers
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// SMSEditorDlg
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(SMSEditorDlg,wxDialog)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(SMSEditorDlg::OnClose)
	EVT_CHECKBOX(ID_REPLYWXCHECKBOX,SMSEditorDlg::ReplyWxCheckBoxClick)
	EVT_BUTTON(ID_SENDWXBUTTON,SMSEditorDlg::SendWxButtonClick)
	EVT_BUTTON(ID_CANCELWXBUTTON,SMSEditorDlg::CancelWxButtonClick)
	EVT_BUTTON(ID_RECIPIENTDELETEWXBUTTON,SMSEditorDlg::RecipientDeleteWxButtonClick)
	
	EVT_TEXT(ID_NEWRECIPIENTWXEDIT,SMSEditorDlg::NewRecipientWxEditUpdated)
	EVT_BUTTON(ID_NEWRECIPIENTADDWXBUTTON,SMSEditorDlg::NewRecipientAddWxButtonClick)
	EVT_CHOICE(ID_WXCHOICE4,SMSEditorDlg::WxChoice4Selected)
	EVT_CHOICE(ID_WXCHOICE3,SMSEditorDlg::WxChoice3Selected)
	EVT_CHOICE(ID_WXCHOICE2,SMSEditorDlg::WxChoice2Selected)
	EVT_CHOICE(ID_WXCHOICE1,SMSEditorDlg::WxChoice1Selected)
	
	EVT_TEXT(ID_WXEDIT2,SMSEditorDlg::WxEdit2Updated)
	
	EVT_TEXT(ID_WXEDIT1,SMSEditorDlg::WxEdit1Updated1)
	
	EVT_TEXT(ID_WXCOMBOBOX4,SMSEditorDlg::WxComboBox4Updated)
	EVT_CHECKBOX(ID_WXCHECKBOX4,SMSEditorDlg::WxCheckBox4Click)
	
	EVT_TEXT(ID_WXCOMBOBOX1,SMSEditorDlg::WxComboBox1Updated)
	EVT_CHECKBOX(ID_WXCHECKBOX1,SMSEditorDlg::WxCheckBox1Click1)
	
	EVT_TEXT(ID_TEXTSMSWXMEMO,SMSEditorDlg::TextSMSWxMemoUpdated)
	EVT_CHECKBOX(ID_TEXTSMSCLASSWXCHECKBOX,SMSEditorDlg::TextSMSClassWxCheckBoxClick)
	EVT_CHECKBOX(ID_TEXTSMSUNICODEWXCHECKBOX,SMSEditorDlg::TextSMSUnicodeWxCheckBoxClick)
END_EVENT_TABLE()
////Event Table End

SMSEditorDlg::SMSEditorDlg(GSM_StateMachine *s2, GSM_SMSList *List2, wxWindow *parent, wxWindowID id, const wxString &title, const wxPoint &position, const wxSize& size, long style)
: wxDialog(parent, id, title, position, size, style)
{
    GSM_SMSC    SMSC;
    int         Num=1,i;
    GSM_Error   error;
    char        buff[200];

	num = 0;
    s=s2;
    List = List2;
    start = true;
    
	CreateGUIControls();
    
    SetTitle(title);
    
    while (true) {
    	SMSC.Location = Num;
    	error = s->Phones->Current->GetSMSC(&SMSC);
    	if (error.Code != GSM_ERR_NONE) break;
     	sprintf(buff,"%s",UnicodeToStringReturn(SMSC.GetSMSCNumber()));
    //    	if (UnicodeLength(SMSC.GetName())!=0) {
    //        	sprintf(buff+strlen(buff)," (%s)",UnicodeToStringReturn(SMSC.GetName()));
    //        }
        if (strlen(buff)!=0) SMSCWxComboBox->Append(buff);
        Num++;
    }
    SMSCWxComboBox->Select(0);    
    ValidityWxComboBox->Select(5);
    TextSMSWxMemo->SetFocus();
    WxComboBox1->Select(0);
    
    for(i=1;i<255;i++) {
        sprintf(buff,"%i messages",i); 
        WxChoice1->Append(buff);
        WxChoice2->Append(buff);
        WxChoice3->Append(buff);
        WxChoice4->Append(buff);
    }
    sprintf(buff,"255 or more messages"); 
    WxChoice1->Append(buff);
    WxChoice2->Append(buff);
    WxChoice3->Append(buff);
    WxChoice4->Append(buff);
    
    WxChoice1->Select(0);
    WxChoice2->Select(0);
    WxChoice3->Select(0);
    WxChoice4->Select(0);
  
    for(i=0;i<256;i++) {
        sprintf(buff,"%i",i);
        WxComboBox4->Append(buff);
    }
    WxComboBox4->Select(0);
    
    i=0;
    while (i<WxNotebook1->GetPageCount()) {
        if (WxNotebook1->GetPageText(i) == "Calendar note") {
            WxNotebook1->DeletePage(i);
            break;
        }
        i++;
    }
    i=0;
    while (i<WxNotebook1->GetPageCount()) {
        if (WxNotebook1->GetPageText(i) == "Phonebook entry") {
            WxNotebook1->DeletePage(i);
            break;
        }
        i++;
    }
    start=false;        
}

SMSEditorDlg::~SMSEditorDlg()
{
} 

void SMSEditorDlg::CreateGUIControls()
{
	//Do not add custom code between
        //GUI Items Creation Start and GUI Items Creation End.
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	WxPanel1 = new wxPanel(this, ID_WXPANEL1, wxPoint(0,0), wxSize(543,451));

	WxNotebook2 = new wxNotebook(WxPanel1, ID_WXNOTEBOOK2, wxPoint(5,5),wxSize(417,440));

	WxNoteBookPage2 = new wxPanel(WxNotebook2, ID_WXNOTEBOOKPAGE2, wxPoint(4,24), wxSize(409,412));
	WxNotebook2->AddPage(WxNoteBookPage2, wxT("Content"));

	WxNotebook1 = new wxNotebook(WxNoteBookPage2, ID_WXNOTEBOOK1, wxPoint(2,7),wxSize(400,404));

	WxNoteBookPage1 = new wxPanel(WxNotebook1, ID_WXNOTEBOOKPAGE1, wxPoint(4,24), wxSize(392,376));
	WxNotebook1->AddPage(WxNoteBookPage1, wxT("Text SMS"));

	WxStaticBox1 = new wxStaticBox(WxNoteBookPage1, ID_WXSTATICBOX1, wxT("Text (0 SMS/160 chars left)"), wxPoint(4,3), wxSize(381,124));

	WxStaticBox2 = new wxStaticBox(WxNoteBookPage1, ID_WXSTATICBOX2, wxT("Text preview in recipients' phone(s)"), wxPoint(3,129), wxSize(383,122));

	WxStaticBox3 = new wxStaticBox(WxNoteBookPage1, ID_WXSTATICBOX3, wxT("Options"), wxPoint(3,252), wxSize(382,122));

	TextSMSUnicodeWxCheckBox = new wxCheckBox(WxNoteBookPage1, ID_TEXTSMSUNICODEWXCHECKBOX, wxT("Use Unicode alphabet (less chars in single SMS, all national supported)"), wxPoint(10,266), wxSize(369,17), 0, wxDefaultValidator, wxT("TextSMSUnicodeWxCheckBox"));

	TextSMSClassWxCheckBox = new wxCheckBox(WxNoteBookPage1, ID_TEXTSMSCLASSWXCHECKBOX, wxT("Send in class 0 (displayed immediately on screen)"), wxPoint(10,282), wxSize(259,24), 0, wxDefaultValidator, wxT("TextSMSClassWxCheckBox"));

	TextSMSWxMemo = new wxTextCtrl(WxNoteBookPage1, ID_TEXTSMSWXMEMO, wxT(""), wxPoint(13,21), wxSize(366,98), wxTE_MULTILINE, wxDefaultValidator, wxT("TextSMSWxMemo"));
	TextSMSWxMemo->SetMaxLength(0);
	TextSMSWxMemo->SetFocus();
	TextSMSWxMemo->SetInsertionPointEnd();

	TextSMSPreviewWxMemo = new wxTextCtrl(WxNoteBookPage1, ID_TEXTSMSPREVIEWWXMEMO, wxT(""), wxPoint(13,147), wxSize(365,96), wxTE_READONLY | wxTE_WORDWRAP | wxTE_MULTILINE, wxDefaultValidator, wxT("TextSMSPreviewWxMemo"));
	TextSMSPreviewWxMemo->SetMaxLength(0);
	TextSMSPreviewWxMemo->SetFocus();
	TextSMSPreviewWxMemo->SetInsertionPointEnd();
	TextSMSPreviewWxMemo->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_BTNFACE));

	WxCheckBox1 = new wxCheckBox(WxNoteBookPage1, ID_WXCHECKBOX1, wxT("Replace SMS with specified ID (saved in recipient phone)"), wxPoint(10,304), wxSize(293,18), 0, wxDefaultValidator, wxT("WxCheckBox1"));

	wxArrayString arrayStringFor_WxComboBox1;
	arrayStringFor_WxComboBox1.Add(wxT("0"));
	arrayStringFor_WxComboBox1.Add(wxT("1"));
	arrayStringFor_WxComboBox1.Add(wxT("2"));
	arrayStringFor_WxComboBox1.Add(wxT("3"));
	arrayStringFor_WxComboBox1.Add(wxT("4"));
	arrayStringFor_WxComboBox1.Add(wxT("5"));
	arrayStringFor_WxComboBox1.Add(wxT("6"));
	arrayStringFor_WxComboBox1.Add(wxT("7"));
	WxComboBox1 = new wxComboBox(WxNoteBookPage1, ID_WXCOMBOBOX1, wxT("WxComboBox1"), wxPoint(320,303), wxSize(54,21), arrayStringFor_WxComboBox1, wxCB_DROPDOWN | wxCB_READONLY, wxDefaultValidator, wxT("WxComboBox1"));

	WxCheckBox4 = new wxCheckBox(WxNoteBookPage1, ID_WXCHECKBOX4, wxT("Replace SMS with specified TPMR (if waiting in SMS Center)"), wxPoint(10,345), wxSize(311,18), 0, wxDefaultValidator, wxT("WxCheckBox4"));

	wxArrayString arrayStringFor_WxComboBox4;
	WxComboBox4 = new wxComboBox(WxNoteBookPage1, ID_WXCOMBOBOX4, wxT("WxComboBox4"), wxPoint(320,344), wxSize(54,21), arrayStringFor_WxComboBox4, wxCB_DROPDOWN | wxCB_READONLY, wxDefaultValidator, wxT("WxComboBox4"));

	WxNoteBookPage4 = new wxPanel(WxNotebook1, ID_WXNOTEBOOKPAGE4, wxPoint(4,24), wxSize(392,376));
	WxNotebook1->AddPage(WxNoteBookPage4, wxT("Calendar note"));

	WxStaticText3 = new wxStaticText(WxNoteBookPage4, ID_WXSTATICTEXT3, wxT("Format"), wxPoint(6,8), wxDefaultSize, 0, wxT("WxStaticText3"));

	wxArrayString arrayStringFor_WxComboBox2;
	arrayStringFor_WxComboBox2.Add(wxT("EMS"));
	arrayStringFor_WxComboBox2.Add(wxT("Nokia"));
	WxComboBox2 = new wxComboBox(WxNoteBookPage4, ID_WXCOMBOBOX2, wxT("WxComboBox2"), wxPoint(65,6), wxSize(158,21), arrayStringFor_WxComboBox2, 0, wxDefaultValidator, wxT("WxComboBox2"));

	WxListCtrl1 = new wxListCtrl(WxNoteBookPage4, ID_WXLISTCTRL1, wxPoint(7,37), wxSize(379,241), wxLC_REPORT);

	WxNoteBookPage5 = new wxPanel(WxNotebook1, ID_WXNOTEBOOKPAGE5, wxPoint(4,24), wxSize(392,376));
	WxNotebook1->AddPage(WxNoteBookPage5, wxT("Phonebook entry"));

	WxListCtrl2 = new wxListCtrl(WxNoteBookPage5, ID_WXLISTCTRL2, wxPoint(7,37), wxSize(379,241), wxLC_REPORT);

	WxStaticText4 = new wxStaticText(WxNoteBookPage5, ID_WXSTATICTEXT4, wxT("Format"), wxPoint(8,11), wxDefaultSize, 0, wxT("WxStaticText4"));

	wxArrayString arrayStringFor_WxComboBox3;
	WxComboBox3 = new wxComboBox(WxNoteBookPage5, ID_WXCOMBOBOX3, wxT("WxComboBox3"), wxPoint(65,6), wxSize(158,21), arrayStringFor_WxComboBox3, 0, wxDefaultValidator, wxT("WxComboBox3"));

	WxNoteBookPage6 = new wxPanel(WxNotebook1, ID_WXNOTEBOOKPAGE6, wxPoint(4,24), wxSize(392,376));
	WxNotebook1->AddPage(WxNoteBookPage6, wxT("WAP bookmark"));

	WxStaticText8 = new wxStaticText(WxNoteBookPage6, ID_WXSTATICTEXT8, wxT("Name"), wxPoint(5,17), wxDefaultSize, 0, wxT("WxStaticText8"));

	WxStaticText9 = new wxStaticText(WxNoteBookPage6, ID_WXSTATICTEXT9, wxT("URL"), wxPoint(4,49), wxDefaultSize, 0, wxT("WxStaticText9"));

	WxEdit1 = new wxTextCtrl(WxNoteBookPage6, ID_WXEDIT1, wxT(""), wxPoint(90,14), wxSize(295,22), 0, wxDefaultValidator, wxT("WxEdit1"));

	WxEdit2 = new wxTextCtrl(WxNoteBookPage6, ID_WXEDIT2, wxT(""), wxPoint(90,44), wxSize(295,23), 0, wxDefaultValidator, wxT("WxEdit2"));

	WxNoteBookPage7 = new wxPanel(WxNotebook1, ID_WXNOTEBOOKPAGE7, wxPoint(4,24), wxSize(392,376));
	WxNotebook1->AddPage(WxNoteBookPage7, wxT("Indicators"));

	WxStaticBox8 = new wxStaticBox(WxNoteBookPage7, ID_WXSTATICBOX8, wxT("Voice"), wxPoint(1,4), wxSize(193,54));

	WxStaticBox9 = new wxStaticBox(WxNoteBookPage7, ID_WXSTATICBOX9, wxT("Fax"), wxPoint(196,4), wxSize(194,54));

	WxStaticBox10 = new wxStaticBox(WxNoteBookPage7, ID_WXSTATICBOX10, wxT("Email"), wxPoint(1,64), wxSize(193,65));

	wxArrayString arrayStringFor_WxChoice1;
	arrayStringFor_WxChoice1.Add(wxT("Don't set"));
	arrayStringFor_WxChoice1.Add(wxT("Disable"));
	WxChoice1 = new wxChoice(WxNoteBookPage7, ID_WXCHOICE1, wxPoint(55,15), wxSize(133,21), arrayStringFor_WxChoice1, 0, wxDefaultValidator, wxT("WxChoice1"));
	WxChoice1->SetSelection(-1);

	WxStaticText5 = new wxStaticText(WxNoteBookPage7, ID_WXSTATICTEXT5, wxT("State"), wxPoint(9,18), wxDefaultSize, 0, wxT("WxStaticText5"));

	WxStaticBox11 = new wxStaticBox(WxNoteBookPage7, ID_WXSTATICBOX11, wxT("Other"), wxPoint(196,63), wxSize(193,65));

	WxStaticText6 = new wxStaticText(WxNoteBookPage7, ID_WXSTATICTEXT6, wxT("State"), wxPoint(205,17), wxDefaultSize, 0, wxT("WxStaticText6"));

	wxArrayString arrayStringFor_WxChoice2;
	arrayStringFor_WxChoice2.Add(wxT("Don't set"));
	arrayStringFor_WxChoice2.Add(wxT("Disable"));
	WxChoice2 = new wxChoice(WxNoteBookPage7, ID_WXCHOICE2, wxPoint(249,14), wxSize(133,21), arrayStringFor_WxChoice2, 0, wxDefaultValidator, wxT("WxChoice2"));
	WxChoice2->SetSelection(-1);

	WxStaticText7 = new wxStaticText(WxNoteBookPage7, ID_WXSTATICTEXT7, wxT("State"), wxPoint(8,80), wxDefaultSize, 0, wxT("WxStaticText7"));

	wxArrayString arrayStringFor_WxChoice3;
	arrayStringFor_WxChoice3.Add(wxT("Don't set"));
	arrayStringFor_WxChoice3.Add(wxT("Disable"));
	WxChoice3 = new wxChoice(WxNoteBookPage7, ID_WXCHOICE3, wxPoint(55,75), wxSize(134,21), arrayStringFor_WxChoice3, 0, wxDefaultValidator, wxT("WxChoice3"));
	WxChoice3->SetSelection(-1);

	wxArrayString arrayStringFor_WxChoice4;
	arrayStringFor_WxChoice4.Add(wxT("Don't set"));
	arrayStringFor_WxChoice4.Add(wxT("Disable"));
	WxChoice4 = new wxChoice(WxNoteBookPage7, ID_WXCHOICE4, wxPoint(249,76), wxSize(132,21), arrayStringFor_WxChoice4, 0, wxDefaultValidator, wxT("WxChoice4"));
	WxChoice4->SetSelection(-1);

	WxStaticText10 = new wxStaticText(WxNoteBookPage7, ID_WXSTATICTEXT10, wxT("State"), wxPoint(205,78), wxDefaultSize, 0, wxT("WxStaticText10"));

	WxNoteBookPage3 = new wxPanel(WxNotebook2, ID_WXNOTEBOOKPAGE3, wxPoint(4,24), wxSize(409,412));
	WxNotebook2->AddPage(WxNoteBookPage3, wxT("Sending options"));

	WxStaticBox5 = new wxStaticBox(WxNoteBookPage3, ID_WXSTATICBOX5, wxT("New recipient"), wxPoint(4,9), wxSize(398,74));

	NewRecipientAddWxButton = new wxButton(WxNoteBookPage3, ID_NEWRECIPIENTADDWXBUTTON, wxT("Add"), wxPoint(287,27), wxSize(107,23), 0, wxDefaultValidator, wxT("NewRecipientAddWxButton"));
	NewRecipientAddWxButton->Enable(false);

	NewRecipientWxEdit = new wxTextCtrl(WxNoteBookPage3, ID_NEWRECIPIENTWXEDIT, wxT(""), wxPoint(15,27), wxSize(263,23), 0, wxDefaultValidator, wxT("NewRecipientWxEdit"));

	WxStaticBox6 = new wxStaticBox(WxNoteBookPage3, ID_WXSTATICBOX6, wxT("Current recipients"), wxPoint(3,85), wxSize(400,164));

	RecipientsWxListCtrl = new wxListCtrl(WxNoteBookPage3, ID_RECIPIENTSWXLISTCTRL, wxPoint(13,106), wxSize(263,135), wxLC_REPORT | wxLC_NO_HEADER);
	RecipientsWxListCtrl->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,200 );
	RecipientsWxListCtrl->InsertColumn(0,wxT("Number"),wxLIST_FORMAT_LEFT,100 );

	WxButton6 = new wxButton(WxNoteBookPage3, ID_WXBUTTON6, wxT("Add from phonebook"), wxPoint(287,52), wxSize(107,22), 0, wxDefaultValidator, wxT("WxButton6"));
	WxButton6->Show(false);

	RecipientDeleteWxButton = new wxButton(WxNoteBookPage3, ID_RECIPIENTDELETEWXBUTTON, wxT("Delete"), wxPoint(287,106), wxSize(106,21), 0, wxDefaultValidator, wxT("RecipientDeleteWxButton"));
	RecipientDeleteWxButton->Enable(false);

	WxStaticBox7 = new wxStaticBox(WxNoteBookPage3, ID_WXSTATICBOX7, wxT("Other"), wxPoint(2,250), wxSize(399,77));

	WxStaticText2 = new wxStaticText(WxNoteBookPage3, ID_WXSTATICTEXT2, wxT("SMS center"), wxPoint(11,264), wxDefaultSize, 0, wxT("WxStaticText2"));

	wxArrayString arrayStringFor_SMSCWxComboBox;
	SMSCWxComboBox = new wxComboBox(WxNoteBookPage3, ID_SMSCWXCOMBOBOX, wxT("SMSCWxComboBox"), wxPoint(74,260), wxSize(202,21), arrayStringFor_SMSCWxComboBox, wxCB_DROPDOWN | wxCB_READONLY | wxTE_READONLY, wxDefaultValidator, wxT("SMSCWxComboBox"));

	ReportWxCheckBox = new wxCheckBox(WxNoteBookPage3, ID_REPORTWXCHECKBOX, wxT("Delivery reports (no extra costs)"), wxPoint(10,305), wxSize(314,19), 0, wxDefaultValidator, wxT("ReportWxCheckBox"));

	WxStaticText1 = new wxStaticText(WxNoteBookPage3, ID_WXSTATICTEXT1, wxT("Validity"), wxPoint(11,285), wxDefaultSize, 0, wxT("WxStaticText1"));

	wxArrayString arrayStringFor_ValidityWxComboBox;
	arrayStringFor_ValidityWxComboBox.Add(wxT("1 hour"));
	arrayStringFor_ValidityWxComboBox.Add(wxT("6 hours"));
	arrayStringFor_ValidityWxComboBox.Add(wxT("1 day"));
	arrayStringFor_ValidityWxComboBox.Add(wxT("3 days"));
	arrayStringFor_ValidityWxComboBox.Add(wxT("1 week"));
	arrayStringFor_ValidityWxComboBox.Add(wxT("Max time"));
	ValidityWxComboBox = new wxComboBox(WxNoteBookPage3, ID_VALIDITYWXCOMBOBOX, wxT("ValidityWxComboBox"), wxPoint(74,283), wxSize(202,21), arrayStringFor_ValidityWxComboBox, wxCB_DROPDOWN | wxCB_READONLY, wxDefaultValidator, wxT("ValidityWxComboBox"));

	CancelWxButton = new wxButton(WxPanel1, ID_CANCELWXBUTTON, wxT("Cancel"), wxPoint(431,115), wxSize(104,26), 0, wxDefaultValidator, wxT("CancelWxButton"));

	SendWxButton = new wxButton(WxPanel1, ID_SENDWXBUTTON, wxT("Send"), wxPoint(431,26), wxSize(104,25), 0, wxDefaultValidator, wxT("SendWxButton"));
	SendWxButton->Enable(false);

	ReplyWxCheckBox = new wxCheckBox(WxNoteBookPage1, ID_REPLYWXCHECKBOX, wxT("Allow reply for your cost"), wxPoint(10,324), wxSize(216,20), 0, wxDefaultValidator, wxT("ReplyWxCheckBox"));

	SetTitle(wxT("Untitled1"));
	SetIcon(wxNullIcon);
	SetSize(8,0,551,478);
	Center();
	
	////GUI Items Creation End
}

void SMSEditorDlg::OnClose(wxCloseEvent& /*event*/)
{
	Destroy();
}

void SMSEditorDlg::SetInfo()
{
    char                   buff[200];
	GSM_SMSListSubEntry    *SubEntry;
	int                    Parts=0;

	RecipientDeleteWxButton->Enable((RecipientsWxListCtrl->GetItemCount()!=0));

    SubEntry = NULL;
    while (List->GetNext(&SubEntry)) Parts++;

    if (RecipientsWxListCtrl->GetItemCount()!=0 && Parts!=0) {
    	SendWxButton->Enable(TRUE);
        sprintf(buff,"Send (%i parts)",Parts*RecipientsWxListCtrl->GetItemCount());        
    } else {
    	SendWxButton->Enable(FALSE);
        sprintf(buff,"Send");
    }
    SendWxButton->SetLabel(buff);
}

/*
 * CancelWxButtonClick
 */
void SMSEditorDlg::CancelWxButtonClick(wxCommandEvent& event)
{
	EndModal(wxID_CANCEL);
}

/*
 * TextSMSWxMemoUpdated
 */
void SMSEditorDlg::TextSMSWxMemoUpdated(wxCommandEvent& event)
{
    GSM_Error                   error;
    unsigned char               buff[10010];
    char                        buff2[500];
    int                         len,i,left,len2,used;
    GSM_SMSEntry                SMS;
    GSM_SMSListSubEntry         *SMS2;
    wchar_t                     Buffer[200],Destination[500];
    GSM_SMSMMSDecodedEntry      Decoded;
    GSM_SMSMMSDecodedSubEntry   *Decoded2,*Decoded3;
    wchart                      dest;

    List->ClearAll();

    Decoded.SMSUnicode = TextSMSUnicodeWxCheckBox->GetValue();
    
    Decoded2 = new GSM_SMSMMSDecodedSubEntry;
    Decoded2->Type = MSG_MMSSMS_File;
    Decoded2->Text.append(StringToUnicodeReturn("text/plain"));
    UnicodeToUTF8((const wchar_t *)TextSMSWxMemo->GetValue().wc_str(wxConvLibc), &Decoded2->File.Buffer);
    Decoded.Add(Decoded2);
                   
    error = Decoded.SaveToSMS(List, SMS_Text_Short, &left);
    PrintError (error);

    i=0;
    SMS2 = NULL;
    while (List->GetNext(&SMS2)) {
        i++;
    }

    sprintf(buff2,"Text (%i SMS/%i chars left)",i,left);
    WxStaticBox1->SetLabel(buff2);

    WxCheckBox1->Enable((i<2));
    WxComboBox1->Enable((i<2));

    //preview
    TextSMSPreviewWxMemo->Clear();
    if (i!=0) {
    	Decoded.ClearAll();
        error = Decoded.ReadFromSMS(List);
        PrintError (error);
        Decoded3 = NULL;
        Decoded.GetNext(&Decoded3);
        UTF8ToUnicode(Decoded3->File.Buffer.data(),&dest,Decoded3->File.Buffer.size());
        TextSMSPreviewWxMemo->AppendText(dest.data());
    }

    SetInfo();

    SMS2 = NULL;
    while (List->GetNext(&SMS2)) {
    	SMS2->GetSMS()->SetType(SMS_Submit);
        if (TextSMSClassWxCheckBox->GetValue()) SMS2->GetSMS()->SetClass(0);
        if (WxCheckBox1->GetValue() && WxCheckBox1->IsEnabled()) {
            SMS2->GetSMS()->SetReplace(WxComboBox1->GetCurrentSelection());
        } else {
            SMS2->GetSMS()->SetReplace(-1);
        }
        if (WxCheckBox4->GetValue() && WxCheckBox4->IsEnabled()) {
            SMS2->GetSMS()->SetRejectDuplicates(TRUE);
            SMS2->GetSMS()->TPMR = WxComboBox4->GetCurrentSelection();
        } else {
            SMS2->GetSMS()->SetRejectDuplicates(FALSE);
        }   
    	if (ReplyWxCheckBox->GetValue()) SMS2->GetSMS()->SetSenderSMSCReply(TRUE);             
    }
}

/*
 * RecipientDeleteWxButtonClick
 */
void SMSEditorDlg::RecipientDeleteWxButtonClick(wxCommandEvent& event)
{
    long item=-1;

    for (;;) {
        item = RecipientsWxListCtrl->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
        if (item==-1) break;
        RecipientsWxListCtrl->DeleteItem(item);
        item=-1;
    }
    SetInfo();
}

/*
 * SendWxButtonClick
 */
void SMSEditorDlg::SendWxButtonClick(wxCommandEvent& event)
{
	GSM_SMSListSubEntry *SMS2;
    
	SMS2 = NULL;
	while (List->GetNext(&SMS2) == TRUE) {
    	SMS2->GetSMS()->SetType(SMS_Submit);

        SMS2->GetSMS()->SetSMSCNumber((wchar_t *)((const wchar_t *)SMSCWxComboBox->GetValue().wc_str(wxConvLibc)));

        switch (ValidityWxComboBox->GetCurrentSelection()) {
            case 0:SMS2->GetSMS()->SetRelativeValidity(SMS_RelativeValidity_1_Hour);break;
            case 1:SMS2->GetSMS()->SetRelativeValidity(SMS_RelativeValidity_6_Hours);break;
            case 2:SMS2->GetSMS()->SetRelativeValidity(SMS_RelativeValidity_1_Day);break;
            case 3:SMS2->GetSMS()->SetRelativeValidity(SMS_RelativeValidity_3_Days);break;
            case 4:SMS2->GetSMS()->SetRelativeValidity(SMS_RelativeValidity_1_Week);break;
            case 5:SMS2->GetSMS()->SetRelativeValidity(SMS_RelativeValidity_Max_Time);break;
        }

    	if (ReportWxCheckBox->GetValue()) SMS2->GetSMS()->SetReportRequest(TRUE);
    }        
	EndModal(wxID_OK);
}

/*
 * TextSMSUnicodeWxCheckBoxClick
 */
void SMSEditorDlg::TextSMSUnicodeWxCheckBoxClick(wxCommandEvent& event)
{
    TextSMSWxMemoUpdated(event);
}

/*
 * NewRecipientAddWxButtonClick
 */
void SMSEditorDlg::NewRecipientAddWxButtonClick(wxCommandEvent& event)
{
    long tmp;

    tmp = RecipientsWxListCtrl->InsertItem((num)++, NewRecipientWxEdit->GetValue(), 0);
    SetInfo();
}

/*
 * NewRecipientWxEditUpdated
 */
void SMSEditorDlg::NewRecipientWxEditUpdated(wxCommandEvent& event)
{
	NewRecipientAddWxButton->Enable((NewRecipientWxEdit->GetValue()!=""));
}

/*
 * TextSMSClassWxCheckBoxClick
 */
void SMSEditorDlg::TextSMSClassWxCheckBoxClick(wxCommandEvent& event)
{
    TextSMSWxMemoUpdated(event);
}

/*
 * WxCheckBox1Click1
 */
void SMSEditorDlg::WxCheckBox1Click1(wxCommandEvent& event)
{
    TextSMSWxMemoUpdated(event);
}

/*
 * WxComboBox1Updated
 */
void SMSEditorDlg::WxComboBox1Updated(wxCommandEvent& event )
{
    TextSMSWxMemoUpdated(event);
}

/*
 * WxChoice1Selected
 */
void SMSEditorDlg::WxChoice1Selected(wxCommandEvent& event )
{
    Indicators();
}

void SMSEditorDlg::Indicators()
{
//    GSM_SMSList     List;
    GSM_Error       error;
    unsigned char   buff[10010];
    char            buff2[500];
    int             len,i,left,len2,used;
    GSM_SMSEntry    SMS;
    GSM_SMSListSubEntry *SMS2;
    wchar_t         Buffer[200],Destination[500];
    GSM_SMSMMSDecodedEntry Decoded;
    GSM_SMSMMSDecodedSubEntry *Decoded2,*Decoded3;
    BOOLEAN added = FALSE;

    List->ClearAll();

    if (WxChoice1->GetCurrentSelection()!=0) {
        Decoded2 = new GSM_SMSMMSDecodedSubEntry;
        Decoded2->Type = MSG_SMS_Voice_Indicator;
        Decoded2->IntVal = WxChoice1->GetCurrentSelection() - 1;
        Decoded.Add(Decoded2);
        added=TRUE;
    }
    if (WxChoice2->GetCurrentSelection()!=0) {
        Decoded2 = new GSM_SMSMMSDecodedSubEntry;
        Decoded2->Type = MSG_SMS_Fax_Indicator;
        Decoded2->IntVal = WxChoice2->GetCurrentSelection() - 1;
        Decoded.Add(Decoded2);
        added=TRUE;
    }
    if (WxChoice3->GetCurrentSelection()!=0) {
        Decoded2 = new GSM_SMSMMSDecodedSubEntry;
        Decoded2->Type = MSG_SMS_Email_Indicator;
        Decoded2->IntVal = WxChoice3->GetCurrentSelection() - 1;
        Decoded.Add(Decoded2);
        added=TRUE;
    }
    if (WxChoice4->GetCurrentSelection()!=0) {
        Decoded2 = new GSM_SMSMMSDecodedSubEntry;
        Decoded2->Type = MSG_SMS_Other_Indicator;
        Decoded2->IntVal = WxChoice4->GetCurrentSelection() - 1;
        Decoded.Add(Decoded2);
        added=TRUE;
    }

    if (!added) {
        SetInfo();        
        return;
    }
    
    error = Decoded.SaveToSMS(List, SMS_Indicators, &left);
    
    SetInfo();    
}

/*
 * WxChoice2Selected
 */
void SMSEditorDlg::WxChoice2Selected(wxCommandEvent& event )
{
Indicators();
}

/*
 * WxChoice3Selected
 */
void SMSEditorDlg::WxChoice3Selected(wxCommandEvent& event )
{
Indicators();

}

/*
 * WxChoice4Selected
 */
void SMSEditorDlg::WxChoice4Selected(wxCommandEvent& event )
{
Indicators();

}

void SMSEditorDlg::WAPBookmark()
{
    //    GSM_SMSList     List;
    GSM_Error       error;
    unsigned char   buff[10010];
    char            buff2[500];
    int             len,i,left,len2,used;
    GSM_SMSEntry    SMS;
    GSM_SMSListSubEntry *SMS2;
    wchar_t         Buffer[200],Destination[500];
    GSM_SMSMMSDecodedEntry Decoded;
    GSM_SMSMMSDecodedSubEntry *Decoded2,*Decoded3;
    wchart dest;

    if (start) return;
    
    List->ClearAll();

    Decoded2 = new GSM_SMSMMSDecodedSubEntry;
    Decoded2->Type = MSG_SMS_WAP_Bookmark;
    Decoded2->Text.append(WxEdit1->GetValue().wc_str(wxConvLibc));
    Decoded2->Text2.append(WxEdit2->GetValue().wc_str(wxConvLibc));
    Decoded.Add(Decoded2);

    error = Decoded.SaveToSMS(List, SMS_WAP_Bookmark, &left);
    PrintError (error);

    SetInfo();
}

/*
 * WxEdit1Updated1
 */
void SMSEditorDlg::WxEdit1Updated1(wxCommandEvent& event)
{
  WAPBookmark();
}

/*
 * WxEdit2Updated
 */
void SMSEditorDlg::WxEdit2Updated(wxCommandEvent& event)
{
  WAPBookmark();
}

/*
 * WxComboBox4Updated
 */
void SMSEditorDlg::WxComboBox4Updated(wxCommandEvent& event )
{
    TextSMSWxMemoUpdated(event);
}

/*
 * WxCheckBox4Click
 */
void SMSEditorDlg::WxCheckBox4Click(wxCommandEvent& event)
{
    TextSMSWxMemoUpdated(event);
}

/*
 * ReplyWxCheckBoxClick
 */
void SMSEditorDlg::ReplyWxCheckBoxClick(wxCommandEvent& event)
{
    TextSMSWxMemoUpdated(event);
}
