//---------------------------------------------------------------------------
//
// Name:        RestoreDlg.cpp
// Author:      Marcinello
// Created:     2007-02-17 22:20:42
// Description: RestoreDlg class implementation
//
//---------------------------------------------------------------------------

#include "RestoreDlg.h"
#include "shared.h"

//Do not add custom headers
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// RestoreDlg
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(RestoreDlg,wxDialog)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(RestoreDlg::OnClose)
	EVT_BUTTON(ID_WXBUTTON5,RestoreDlg::WxButton5Click)
	EVT_CHECKBOX(ID_WXCHECKBOX8,RestoreDlg::WxCheckBox8Click)
	EVT_CHECKBOX(ID_WXCHECKBOX7,RestoreDlg::WxCheckBox7Click)
	EVT_BUTTON(ID_WXBUTTON4,RestoreDlg::WxButton4Click)
	EVT_BUTTON(ID_WXBUTTON3,RestoreDlg::WxButton3Click)
	EVT_BUTTON(ID_WXBUTTON2,RestoreDlg::WxButton2Click)
	EVT_CHECKBOX(ID_WXCHECKBOX5,RestoreDlg::WxCheckBox5Click)
	EVT_CHECKBOX(ID_WXCHECKBOX4,RestoreDlg::WxCheckBox4Click)
	EVT_CHECKBOX(ID_WXCHECKBOX3,RestoreDlg::WxCheckBox3Click)
	EVT_CHECKBOX(ID_WXCHECKBOX2,RestoreDlg::WxCheckBox2Click)
	EVT_COMBOBOX(ID_WXCOMBOBOX1,RestoreDlg::WxComboBox1Selected)
	EVT_BUTTON(ID_WXBUTTON1,RestoreDlg::WxButton1Click)
	EVT_CHECKBOX(ID_WXCHECKBOX1,RestoreDlg::WxCheckBox1Click)
END_EVENT_TABLE()
////Event Table End

RestoreDlg::RestoreDlg(GSM_Backup **Backup2, char *IMEI, GSM_Backup_FileFormatFunctions *Func2, wxFileDialog *WxOpenFileDialog2, wxWindow *parent, wxWindowID id, const wxString &title, const wxPoint &position, const wxSize& size, long style)
: wxDialog(parent, id, title, position, size, style)
{
    Func = Func2;
    Backup = Backup2;
    WxOpenFileDialog = WxOpenFileDialog2;
    IMEI2 = IMEI;
    
	CreateGUIControls();
	
	SetTitle(title);
    
    WxComboBox1->Select(0);
    WxButton3->Enable(FALSE);
    
    WxCheckBox1->Enable(Func->PhonePBK);    
    WxCheckBox2->Enable(Func->SIMPBK);
    WxCheckBox3->Enable(Func->Calendar);
    WxCheckBox4->Enable(Func->Notes);
    WxCheckBox5->Enable(Func->ToDo);
    WxCheckBox7->Enable(Func->PhonePBKPointers);
    WxCheckBox8->Enable(Func->PhonePBKCallers);
}

RestoreDlg::~RestoreDlg()
{
} 

void RestoreDlg::CreateGUIControls()
{
	//Do not add custom code between
        //GUI Items Creation Start and GUI Items Creation End.
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	SetTitle(wxT("Untitled1"));
	SetIcon(wxNullIcon);
	SetSize(8,8,465,386);
	Center();
	

	WxStaticText2 = new wxStaticText(this, ID_WXSTATICTEXT2, wxT("(we suggest NOT to restore them !)"), wxPoint(43,247), wxDefaultSize, 0, wxT("WxStaticText2"));

	WxButton5 = new wxButton(this, ID_WXBUTTON5, wxT("Open file"), wxPoint(351,20), wxSize(88,22), 0, wxDefaultValidator, wxT("WxButton5"));

	WxCheckBox13 = new wxCheckBox(this, ID_WXCHECKBOX13, wxT("Clear phone ToDo"), wxPoint(276,247), wxSize(137,16), 0, wxDefaultValidator, wxT("WxCheckBox13"));

	WxCheckBox6 = new wxCheckBox(this, ID_WXCHECKBOX6, wxT("Set phone clock from computer"), wxPoint(276,301), wxSize(169,16), 0, wxDefaultValidator, wxT("WxCheckBox6"));

	WxCheckBox12 = new wxCheckBox(this, ID_WXCHECKBOX12, wxT("Clear phone notes"), wxPoint(276,229), wxSize(123,15), 0, wxDefaultValidator, wxT("WxCheckBox12"));

	WxCheckBox11 = new wxCheckBox(this, ID_WXCHECKBOX11, wxT("Clear phone calendar"), wxPoint(276,210), wxSize(126,16), 0, wxDefaultValidator, wxT("WxCheckBox11"));

	WxCheckBox10 = new wxCheckBox(this, ID_WXCHECKBOX10, wxT("Clear phone phonebook"), wxPoint(276,190), wxSize(155,20), 0, wxDefaultValidator, wxT("WxCheckBox10"));

	WxCheckBox9 = new wxCheckBox(this, ID_WXCHECKBOX9, wxT("Clear SIM phonebook"), wxPoint(276,173), wxSize(145,16), 0, wxDefaultValidator, wxT("WxCheckBox9"));

	WxStaticBox3 = new wxStaticBox(this, ID_WXSTATICBOX3, wxT("Before restore"), wxPoint(266,154), wxSize(183,171));

	WxCheckBox8 = new wxCheckBox(this, ID_WXCHECKBOX8, wxT("ID for caller groups"), wxPoint(25,211), wxSize(110,20), 0, wxDefaultValidator, wxT("WxCheckBox8"));

	WxListCtrl1 = new wxListCtrl(this, ID_WXLISTCTRL1, wxPoint(16,46), wxSize(423,96), wxLC_REPORT | wxLC_NO_HEADER);
	WxListCtrl1->InsertColumn(0,wxT("Value"),wxLIST_FORMAT_LEFT,300 );
	WxListCtrl1->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,80 );

	WxCheckBox7 = new wxCheckBox(this, ID_WXCHECKBOX7, wxT("ID for sms lists, ringtones, logos, voice tags"), wxPoint(25,232), wxSize(232,14), 0, wxDefaultValidator, wxT("WxCheckBox7"));

	WxButton4 = new wxButton(this, ID_WXBUTTON4, wxT("Cancel"), wxPoint(358,332), wxSize(92,25), 0, wxDefaultValidator, wxT("WxButton4"));

	WxButton3 = new wxButton(this, ID_WXBUTTON3, wxT("OK"), wxPoint(8,333), wxSize(92,24), 0, wxDefaultValidator, wxT("WxButton3"));

	WxStaticText1 = new wxStaticText(this, ID_WXSTATICTEXT1, wxT("Format"), wxPoint(16,24), wxDefaultSize, 0, wxT("WxStaticText1"));

	WxButton2 = new wxButton(this, ID_WXBUTTON2, wxT("Unselect all"), wxPoint(186,196), wxSize(64,20), 0, wxDefaultValidator, wxT("WxButton2"));

	WxCheckBox5 = new wxCheckBox(this, ID_WXCHECKBOX5, wxT("Phone ToDo"), wxPoint(15,302), wxSize(159,16), 0, wxDefaultValidator, wxT("WxCheckBox5"));

	WxCheckBox4 = new wxCheckBox(this, ID_WXCHECKBOX4, wxT("Phone notes"), wxPoint(15,282), wxSize(138,17), 0, wxDefaultValidator, wxT("WxCheckBox4"));

	WxCheckBox3 = new wxCheckBox(this, ID_WXCHECKBOX3, wxT("Phone calendar"), wxPoint(15,264), wxSize(134,17), 0, wxDefaultValidator, wxT("WxCheckBox3"));

	WxCheckBox2 = new wxCheckBox(this, ID_WXCHECKBOX2, wxT("SIM phonebook"), wxPoint(15,175), wxSize(100,17), 0, wxDefaultValidator, wxT("WxCheckBox2"));

	wxArrayString arrayStringFor_WxComboBox1;
	arrayStringFor_WxComboBox1.Add(wxT("Gammu format"));
	WxComboBox1 = new wxComboBox(this, ID_WXCOMBOBOX1, wxT("WxComboBox1"), wxPoint(71,21), wxSize(237,21), arrayStringFor_WxComboBox1, wxCB_DROPDOWN | wxCB_READONLY, wxDefaultValidator, wxT("WxComboBox1"));

	WxButton1 = new wxButton(this, ID_WXBUTTON1, wxT("Select all"), wxPoint(186,173), wxSize(64,20), 0, wxDefaultValidator, wxT("WxButton1"));

	WxCheckBox1 = new wxCheckBox(this, ID_WXCHECKBOX1, wxT("Phone phonebook"), wxPoint(15,194), wxSize(137,18), 0, wxDefaultValidator, wxT("WxCheckBox1"));

	WxStaticBox1 = new wxStaticBox(this, ID_WXSTATICBOX1, wxT("Features to restore"), wxPoint(6,154), wxSize(254,171));

	WxStaticBox2 = new wxStaticBox(this, ID_WXSTATICBOX2, wxT("File"), wxPoint(6,0), wxSize(443,147));
	////GUI Items Creation End
}

void RestoreDlg::OnClose(wxCloseEvent& /*event*/)
{
	Destroy();
}

/*
 * WxButton3Click
 */
void RestoreDlg::WxButton3Click(wxCommandEvent& event)
{
	Func->PhonePBK = Func3.PhonePBK;
    Func->SIMPBK = Func3.SIMPBK;
    Func->Calendar = Func3.Calendar;
	Func ->Notes = Func3.Notes;
	Func->ToDo = Func3.ToDo;
	Func->PhonePBKPointers = Func3.PhonePBKPointers;
	Func->PhonePBKCallers = Func3.PhonePBKCallers;

	EndModal(wxID_OK);
}

/*
 * WxButton4Click
 */
void RestoreDlg::WxButton4Click(wxCommandEvent& event)
{
    if (*Backup != NULL) delete *Backup;
	EndModal(wxID_CANCEL);
}

/*
 * WxComboBox1Selected
 */
void RestoreDlg::WxComboBox1Selected(wxCommandEvent& event )
{
//	GSM_Backup                     Backup;
//	GSM_Backup_FileFormatFunctions Func;
	
//	Backup.GetFileFunctions(Backup_Gammu, &Func);
	
//	WxCheckBox1->Enable(Func.PhonePBK);
//	WxCheckBox2->Enable(Func.SIMPBK);
//	WxCheckBox3->Enable(Func.Calendar);	
//	WxCheckBox4->Enable(Func.Notes);
//	WxCheckBox5->Enable(Func.ToDo);
//	WxCheckBox7->Enable(Func.PhonePBKPointers);
//	Check();	
}

/*
 * WxButton1Click
 */
void RestoreDlg::WxButton1Click(wxCommandEvent& event)
{
	if (WxCheckBox1->IsEnabled()) WxCheckBox1->SetValue(TRUE);
	if (WxCheckBox2->IsEnabled()) WxCheckBox2->SetValue(TRUE);
	if (WxCheckBox3->IsEnabled()) WxCheckBox3->SetValue(TRUE);
	if (WxCheckBox4->IsEnabled()) WxCheckBox4->SetValue(TRUE);
	if (WxCheckBox5->IsEnabled()) WxCheckBox5->SetValue(TRUE);
	if (WxCheckBox8->IsEnabled()) WxCheckBox8->SetValue(TRUE);
	Check();
}

/*
 * WxButton2Click
 */
void RestoreDlg::WxButton2Click(wxCommandEvent& event)
{
	WxCheckBox1->SetValue(FALSE);
	WxCheckBox2->SetValue(FALSE);
	WxCheckBox3->SetValue(FALSE);
	WxCheckBox4->SetValue(FALSE);
	WxCheckBox5->SetValue(FALSE);
	WxCheckBox8->SetValue(FALSE);
	Check();
}

void RestoreDlg::Check()
{
	Func3.PhonePBK = WxCheckBox1->GetValue();
    Func3.SIMPBK = WxCheckBox2->GetValue();
    Func3.Calendar = WxCheckBox3->GetValue();
	Func3.Notes = WxCheckBox4->GetValue();
	Func3.ToDo = WxCheckBox5->GetValue();
	Func3.PhonePBKPointers = WxCheckBox7->GetValue();
	Func3.PhonePBKCallers = WxCheckBox8->GetValue();
    WxButton3->Enable(TRUE);
    if (!WxCheckBox1->GetValue() &&
	    !WxCheckBox2->GetValue() &&
    	!WxCheckBox3->GetValue() &&
        !WxCheckBox4->GetValue() &&
        !WxCheckBox5->GetValue()) {
            //fixme
    	WxButton3->Enable(FALSE);
    }    
}

/*
 * WxCheckBox1Click
 */
void RestoreDlg::WxCheckBox1Click(wxCommandEvent& event)
{
	Check();
}

/*
 * WxCheckBox2Click
 */
void RestoreDlg::WxCheckBox2Click(wxCommandEvent& event)
{
	Check();
}

/*
 * WxCheckBox3Click
 */
void RestoreDlg::WxCheckBox3Click(wxCommandEvent& event)
{
	Check();
}

/*
 * WxCheckBox7Click
 */
void RestoreDlg::WxCheckBox7Click(wxCommandEvent& event)
{
	Check();
}

/*
 * WxButton5Click
 */
void RestoreDlg::WxButton5Click(wxCommandEvent& event)
{
    GSM_Error                       error;
    long                            num=0,tmp;
    char                            buff[200];
    GSM_Backup_PBKEntry             *PBKEntry;
	GSM_PBKEntry 		            PBKEntry2;
    GSM_Backup_CalEntry             *CalEntry;
    GSM_CalendarEntry               CalEntry2;
    GSM_Backup_ToDoEntry            *ToDoEntry;
    GSM_Backup_NoteEntry            *NoteEntry;
    BOOLEAN                         Found;
	GSM_PBKSubEntry 	            *SubEntry;
       
    if (*Backup != NULL) delete (Backup);
    *Backup = new GSM_Backup;

    if (WxOpenFileDialog->ShowModal()!=wxID_OK) return;

    error = (*Backup)->ReadFromFile((char *)WxOpenFileDialog->GetPath().c_str());
    if (PrintError(error)) {
        delete Backup;
        Backup = NULL;
        return;
    }

    Func3.Calendar = Func->Calendar;
    Func3.Notes = Func->Notes;
    Func3.ToDo = Func->ToDo;
    Func3.PhonePBK = Func->PhonePBK;
    Func3.SIMPBK = Func->SIMPBK;
    
    if (Func3.Notes) {
        NoteEntry = NULL;
        Func3.Notes = (*Backup)->GetNext_Note(&NoteEntry);
    }
    if (Func3.ToDo) {
        ToDoEntry = NULL;
        Func3.ToDo = (*Backup)->GetNext_ToDo(&ToDoEntry);
    }
    if (Func3.Calendar) {
        CalEntry = NULL;
        Func3.Calendar = (*Backup)->GetNext_Cal(&CalEntry);
    }
    if (Func3.PhonePBK) {
        Found = FALSE;
        PBKEntry = NULL;
        while((*Backup)->GetNext_PBK(&PBKEntry)) {
            if (PBKEntry->GetEntry()->Memory == MEM_PHONE) {
                Found = TRUE;
                break;
            }
        }
        Func3.PhonePBK = Found;
        Func3.PhonePBKPointers = FALSE;
        Func3.PhonePBKCallers = FALSE;
        if (Found) {
            Found = FALSE;
            PBKEntry = NULL;
            while((*Backup)->GetNext_PBK(&PBKEntry)) {
                SubEntry = NULL;
                while (PBKEntry->GetEntry()->GetNext(&SubEntry)) {
        			switch (SubEntry->GetType()) {
        			case PBK_ID_Caller_Group:
                        Func3.PhonePBKCallers = TRUE;
        				break;
        			case PBK_ID_Picture:
        			case PBK_ID_Ringtone:
                        Func3.PhonePBKPointers = TRUE;
        				break;
                	case PBK_Text_Phone_General:
                	case PBK_Text_Phone_Mobile:
                	case PBK_Text_Phone_Home:
                	case PBK_Text_Phone_Work:
                	case PBK_Text_Phone_Fax:
        				if (SubEntry->VoiceTag!=-1) {
                            Func3.PhonePBKPointers = TRUE;
        				}
        				break;
    				default:
                        break;
        			}                    
                }
                if (Func3.PhonePBKCallers && Func3.PhonePBKPointers) break;
            }
        }
    }
//    if (Func3.PhonePBKPointers) {
//        if (strcmp((*Backup)->DeviceIMEI,IMEI2)) {
//            WxCheckBox7->SetValue(FALSE);
//        }
//    }
    if (Func3.SIMPBK) {
        Found = FALSE;
        PBKEntry = NULL;
        while((*Backup)->GetNext_PBK(&PBKEntry)) {
            if (PBKEntry->GetEntry()->Memory == MEM_SIM) {
                Found = TRUE;
                break;
            }
        }
        Func3.SIMPBK = Found;
    }

    WxListCtrl1->DeleteAllItems();
        
    tmp = WxListCtrl1->InsertItem(num++, "File name", 0);
    WxListCtrl1->SetItem(tmp, 1, WxOpenFileDialog->GetPath().c_str());

    if ((*Backup)->FileMD5Original[0] != 0) {
        tmp = WxListCtrl1->InsertItem(num++, "File checksum", 0);
        if (!strcmp((*Backup)->FileMD5Original,(*Backup)->FileMD5Calculated)) {
            WxListCtrl1->SetItem(tmp, 1, "ok");
        } else {
            WxListCtrl1->SetItem(tmp, 1, "not ok");
        }
    }
    if ((*Backup)->FileCreator[0] != 0) {
        tmp = WxListCtrl1->InsertItem(num++, "File creator", 0);
        WxListCtrl1->SetItem(tmp, 1, (*Backup)->FileCreator);
    }
    if ((*Backup)->FileDateTimeAvailable) {
        tmp = WxListCtrl1->InsertItem(num++, "File created", 0);
        PrintDT(&(*Backup)->FileDateTime, buff);
        WxListCtrl1->SetItem(tmp, 1, buff);
    }
    if ((*Backup)->DeviceModel[0] != 0) {
        tmp = WxListCtrl1->InsertItem(num++, "Source", 0);
        WxListCtrl1->SetItem(tmp, 1, (*Backup)->DeviceModel);
    }
    if ((*Backup)->DeviceIMEI[0] != 0) {
        tmp = WxListCtrl1->InsertItem(num++, "Device IMEI", 0);
        sprintf(buff,"%s",(*Backup)->DeviceIMEI);
        if (!strcmp((*Backup)->DeviceIMEI,IMEI2)) {
            sprintf(buff+strlen(buff)," (current)");
        }
        WxListCtrl1->SetItem(tmp, 1, buff);
    }

    WxComboBox1->Enable(FALSE);
    
    WxCheckBox1->Enable(Func3.PhonePBK);
    WxCheckBox2->Enable(Func3.SIMPBK);
    WxCheckBox3->Enable(Func3.Calendar);
    WxCheckBox4->Enable(Func3.Notes);
    WxCheckBox5->Enable(Func3.ToDo);
    WxCheckBox7->Enable(Func3.PhonePBKPointers);
    WxStaticText2->Enable(Func3.PhonePBKPointers);
    WxCheckBox8->Enable(Func3.PhonePBKCallers);
}

/*
 * WxCheckBox8Click
 */
void RestoreDlg::WxCheckBox8Click(wxCommandEvent& event)
{
	Check();
}

/*
 * WxCheckBox4Click
 */
void RestoreDlg::WxCheckBox4Click(wxCommandEvent& event)
{
	Check();
}

/*
 * WxCheckBox5Click
 */
void RestoreDlg::WxCheckBox5Click(wxCommandEvent& event)
{
	Check();
}
