//---------------------------------------------------------------------------
//
// Name:        MMSFrm.cpp
// Author:      Marcinello
// Created:     2007-02-06 18:25:05
// Description: MMSFrm class implementation
//
//---------------------------------------------------------------------------

#include "MMSFrm.h"

#include "../cfg/config.h"
#include "../common/service/smsmms/gsmmsg.h"
#include "../common/service/gsmmisc.h"
#include "../common/service/backup/gsmback.h"
#include "../common/gsmstate.h"

#include "shared.h"

//Do not add custom headers between
//Header Include Start and Header Include End
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// MMSFrm
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(MMSFrm,wxMDIChildFrame)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(MMSFrm::OnClose)
	
	EVT_MEDIA_LOADED(ID_WXMEDIACTRL1,MMSFrm::WxMediaCtrl1MediaLoaded)
	EVT_BUTTON(ID_WXBUTTON1,MMSFrm::WxButton1Click)
	EVT_COMBOBOX(ID_WXCOMBOBOX1,MMSFrm::WxComboBox1Selected)
END_EVENT_TABLE()
////Event Table End

MMSFrm::MMSFrm(MainFrm *parent2, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style, const wxString& name, GSM_File *File2, GSM_SMSMMSDecodedEntry *Decoded2)
: wxMDIChildFrame(parent2, id, title, pos, size, style, name)
{
    int            num;
    wxCommandEvent event;
    
    File = File2;
    Decoded = Decoded2;
    
	CreateGUIControls();
    SetTitle(title);
    
    num=ViewMMSFile(File, Decoded, WxListCtrl1, WxComboBox1, WxListBox1, WxBoxSizer2, WxPanel1);
    if (num!=-1) {
        WxComboBox1->Select(num-1);
        WxComboBox1Selected(event);
    }    
}

MMSFrm::~MMSFrm()
{
    delete File;
    delete Decoded;
}

void MMSFrm::CreateGUIControls()
{
	//Do not add custom code between
        //GUI Items Creation Start and GUI Items Creation End
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	WxGridSizer1 = new wxGridSizer(1, 1, 0, 0);
	this->SetSizer(WxGridSizer1);
	this->SetAutoLayout(true);

	WxNotebook1 = new wxNotebook(this, ID_WXNOTEBOOK1, wxPoint(0,0),wxSize(499,367));
	WxGridSizer1->Add(WxNotebook1,1,wxEXPAND | 0,0);

	WxNoteBookPage1 = new wxPanel(WxNotebook1, ID_WXNOTEBOOKPAGE1, wxPoint(4,24), wxSize(491,339));
	WxNotebook1->AddPage(WxNoteBookPage1, wxT("Summary"));

	WxBoxSizer2 = new wxBoxSizer(wxVERTICAL);
	WxNoteBookPage1->SetSizer(WxBoxSizer2);
	WxNoteBookPage1->SetAutoLayout(true);

	WxPanel1 = new wxPanel(WxNoteBookPage1, ID_WXPANEL1, wxPoint(5,5), wxSize(480,31));
	WxBoxSizer2->Add(WxPanel1,0,wxALIGN_TOP | wxALL,5);

	wxArrayString arrayStringFor_WxComboBox1;
	WxComboBox1 = new wxComboBox(WxPanel1, ID_WXCOMBOBOX1, wxT("WxComboBox1"), wxPoint(4,5), wxSize(224,21), arrayStringFor_WxComboBox1, wxCB_DROPDOWN | wxCB_READONLY, wxDefaultValidator, wxT("WxComboBox1"));

	WxButton1 = new wxButton(WxPanel1, ID_WXBUTTON1, wxT("Save to file"), wxPoint(233,4), wxSize(89,21), 0, wxDefaultValidator, wxT("WxButton1"));
	WxButton1->Enable(false);

	wxArrayString arrayStringFor_WxListBox1;
	WxListBox1 = new wxListBox(WxPanel1, ID_WXLISTBOX1, wxPoint(328,3), wxSize(289,22), arrayStringFor_WxListBox1, wxLB_SINGLE | wxNO_BORDER);
	WxListBox1->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_MENU));

	WxBoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
	WxBoxSizer2->Add(WxBoxSizer3, 1, wxEXPAND | wxALL, 5);

	WxMemo1 = new wxTextCtrl(WxNoteBookPage1, ID_WXMEMO1, wxT(""), wxPoint(5,35), wxSize(185,89), wxTE_READONLY | wxTE_MULTILINE, wxDefaultValidator, wxT("WxMemo1"));
	WxMemo1->SetMaxLength(0);
	WxMemo1->Show(false);
	WxMemo1->AppendText(wxT("WxMemo1"));
	WxMemo1->SetFocus();
	WxMemo1->SetInsertionPointEnd();
	WxBoxSizer3->Add(WxMemo1,1,wxEXPAND | wxALL,5);

	WxMediaCtrl1 = new wxMediaCtrl(WxNoteBookPage1, ID_WXMEDIACTRL1,wxT(""), wxPoint(200,5), wxSize(150,150) );
	WxMediaCtrl1->Enable(false);
	WxMediaCtrl1->ShowPlayerControls(wxMEDIACTRLPLAYERCONTROLS_NONE);
	WxBoxSizer3->Add(WxMediaCtrl1,1,wxEXPAND | wxALL,5);

	WxNoteBookPage2 = new wxPanel(WxNotebook1, ID_WXNOTEBOOKPAGE2, wxPoint(4,24), wxSize(491,339));
	WxNotebook1->AddPage(WxNoteBookPage2, wxT("Details"));

	WxBoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
	WxNoteBookPage2->SetSizer(WxBoxSizer1);
	WxNoteBookPage2->SetAutoLayout(true);

	WxListCtrl1 = new wxListCtrl(WxNoteBookPage2, ID_WXLISTCTRL1, wxPoint(5,5), wxSize(353,300), wxLC_REPORT);
	WxListCtrl1->InsertColumn(0,wxT("Value"),wxLIST_FORMAT_LEFT,400 );
	WxListCtrl1->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,150 );
	WxBoxSizer1->Add(WxListCtrl1,1,wxEXPAND | wxALL,5);

	WxSaveFileDialog1 =  new wxFileDialog(this, wxT("Choose a file"), wxT(""), wxT(""), wxT("*.*"), wxSAVE | wxOVERWRITE_PROMPT);

	SetTitle(wxT("Untitled1"));
	SetIcon(wxNullIcon);
	
	GetSizer()->Fit(this);
	GetSizer()->SetSizeHints(this);
	Center();
	
	////GUI Items Creation End
}

void MMSFrm::OnClose(wxCloseEvent& event)
{
	Destroy();
}

/*
 * WxComboBox1Selected
 */
void MMSFrm::WxComboBox1Selected(wxCommandEvent& event )
{
    MMSSelect(WxComboBox1->GetSelection(), Decoded, WxMediaCtrl1, WxMemo1, WxBoxSizer3, WxButton1);
}

/*
 * WxMediaCtrl1MediaLoaded
 */
void MMSFrm::WxMediaCtrl1MediaLoaded(wxMediaEvent& event)
{
//	WxMediaCtrl1->Pause();
    WxMediaCtrl1->Play();
#ifdef WIN32
    DeleteFile("tmpbitmap.amr");
    DeleteFile("tmpbitmap.jpg");
    DeleteFile("tmpbitmap.gif");
#endif    
}

/*
 * WxButton1Click
 */
void MMSFrm::WxButton1Click(wxCommandEvent& event)
{
    SaveMMSFile(Decoded, WxSaveFileDialog1, WxComboBox1->GetSelection());
}
