//---------------------------------------------------------------------------
//
// Name:        AboutDlg.cpp
// Author:      Marcinello
// Created:     2006-12-05 00:38:26
// Description: AboutDlg class implementation
//
//---------------------------------------------------------------------------

#include "AboutDlg.h"
#include "../cfg/config.h"
#include "../common/gsmstate.h"
#include "../common/misc/misc.h"
#include "../common/service/gsmmisc.h"

//Do not add custom headers
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// AboutDlg
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(AboutDlg,wxDialog)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(AboutDlg::OnClose)
	EVT_BUTTON(ID_WXBUTTON1,AboutDlg::WxButton1Click)
END_EVENT_TABLE()
////Event Table End

AboutDlg::AboutDlg(wxWindow *parent, wxWindowID id, const wxString &title, const wxPoint &position, const wxSize& size, long style)
: wxDialog(parent, id, title, position, size, style)
{
    char                                buff[200];	
	list<GSM_Device_Info>::iterator 	devinfo;
	list<GSM_Protocol_Info>::iterator 	proinfo;
	list<GSM_Phone_Info>::iterator 		phoinfo;
    GSM_Device              		    *dev;
    GSM_Protocol            		    *pro;
    GSM_Phone               		    *pho;
    int                                 NumDev = 0, PhoneMod=0,Phone=0,Protocol=0;
    GSM_StateMachine                    *s;

	CreateGUIControls();

    s = new GSM_StateMachine(NULL,"",false);

    dev = NULL;
    while(1) {
        if (!s->Devices->GetNext(&dev)) break;
    	for (devinfo=dev->Info.begin(); devinfo!=dev->Info.end(); ++devinfo) {
            NumDev++;
	    }
    }

    pro = NULL;
    while(1) {
        if (!s->Protocols->GetNext(&pro)) break;
	    for (proinfo=pro->Info.begin(); proinfo!=pro->Info.end(); ++proinfo) {
            Protocol++;
        }
    }

    pho = NULL;
    while(1) {
        if (!s->Phones->GetNext(&pho)) break;
        PhoneMod++;
    	for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
            Phone++;
        }
    }
    
    sprintf(buff,"%i devices + %i protocols + %i phone modules for %i models",NumDev,Protocol,PhoneMod,Phone);
	WxStaticText18->SetLabel(buff);
	
	delete s;
	
	sprintf(buff,"%i.%i.%i.%i",wxMAJOR_VERSION,wxMINOR_VERSION,wxRELEASE_NUMBER,wxSUBRELEASE_NUMBER);
	WxStaticText5->SetLabel(buff);

	sprintf(buff,"%s",GetCompiler());
	WxStaticText13->SetLabel(buff);

	sprintf(buff,"%s",GetOS());
	WxStaticText14->SetLabel(buff);
	
	sprintf(buff,"%s %s",__TIME__,__DATE__);
	WxStaticText16->SetLabel(buff);	
}

AboutDlg::~AboutDlg()
{
} 

void AboutDlg::CreateGUIControls()
{
	//Do not add custom code here
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	SetTitle(wxT("About Gammu+"));
	SetIcon(wxNullIcon);
	SetSize(8,8,413,437);
	Center();
	

	WxStaticText19 = new wxStaticText(this, ID_WXSTATICTEXT19, wxT("Created since 2003 (core and CLI) and December 2006 (GUI)"), wxPoint(15,25), wxDefaultSize, 0, wxT("WxStaticText19"));

	WxStaticText18 = new wxStaticText(this, ID_WXSTATICTEXT18, wxT("WxStaticText18"), wxPoint(88,303), wxDefaultSize, 0, wxT("WxStaticText18"));

	WxStaticText17 = new wxStaticText(this, ID_WXSTATICTEXT17, wxT("statistics"), wxPoint(13,303), wxDefaultSize, 0, wxT("WxStaticText17"));

	WxHyperLinkCtrl4 = new wxHyperlinkCtrl(this, ID_WXHYPERLINKCTRL4, wxT("(full source + win32 packages)"), wxT("http://www.mwiacek.com/zips/gsm/gplus"), wxPoint(101,40), wxSize(240, 17), wxNO_BORDER | wxHL_CONTEXTMENU, wxT("WxHyperLinkCtrl4"));
	WxHyperLinkCtrl4->SetNormalColour(*wxBLUE);
	WxHyperLinkCtrl4->SetFont(wxFont(8, wxSWISS, wxNORMAL,wxNORMAL, TRUE));

	WxStaticText16 = new wxStaticText(this, ID_WXSTATICTEXT16, wxT("WxStaticText16"), wxPoint(88,286), wxDefaultSize, 0, wxT("WxStaticText16"));

	WxStaticText15 = new wxStaticText(this, ID_WXSTATICTEXT15, wxT("built"), wxPoint(13,286), wxDefaultSize, 0, wxT("WxStaticText15"));

	WxStaticText14 = new wxStaticText(this, ID_WXSTATICTEXT14, wxT("WxStaticText14"), wxPoint(88,346), wxDefaultSize, 0, wxT("WxStaticText14"));

	WxStaticText7 = new wxStaticText(this, ID_WXSTATICTEXT7, wxT("OS"), wxPoint(13,346), wxDefaultSize, 0, wxT("WxStaticText7"));

	WxStaticBox4 = new wxStaticBox(this, ID_WXSTATICBOX4, wxT("Runtime"), wxPoint(5,328), wxSize(395,39));

	WxStaticText13 = new wxStaticText(this, ID_WXSTATICTEXT13, wxT("WxStaticText13"), wxPoint(88,269), wxDefaultSize, 0, wxT("WxStaticText13"));

	WxStaticText10 = new wxStaticText(this, ID_WXSTATICTEXT10, wxT("compiler"), wxPoint(13,269), wxDefaultSize, 0, wxT("WxStaticText10"));

	WxHyperLinkCtrl3 = new wxHyperlinkCtrl(this, ID_WXHYPERLINKCTRL3, wxT("wxWidgets"), wxT("http://www.wxwidgets.org"), wxPoint(13,253), wxSize(59, 17), wxNO_BORDER | wxHL_CONTEXTMENU, wxT("WxHyperLinkCtrl3"));
	WxHyperLinkCtrl3->SetNormalColour(*wxBLUE);
	WxHyperLinkCtrl3->SetFont(wxFont(8, wxSWISS, wxNORMAL,wxNORMAL, TRUE));

	WxStaticText5 = new wxStaticText(this, ID_WXSTATICTEXT5, wxT("WxStaticText5"), wxPoint(88,254), wxDefaultSize, 0, wxT("WxStaticText5"));

	WxStaticBox3 = new wxStaticBox(this, ID_WXSTATICBOX3, wxT("Compilation"), wxPoint(6,237), wxSize(394,88));

	WxStaticLine2 = new wxStaticLine(this, ID_WXSTATICLINE2, wxPoint(15,92), wxSize(373,-1), wxLI_HORIZONTAL);

	WxStaticText12 = new wxStaticText(this, ID_WXSTATICTEXT12, wxT("You can help by giving donations (money, hardware, ...) or job to developer(s)."), wxPoint(15,187), wxDefaultSize, 0, wxT("WxStaticText12"));

	WxStaticText11 = new wxStaticText(this, ID_WXSTATICTEXT11, wxT("More info:"), wxPoint(15,214), wxDefaultSize, 0, wxT("WxStaticText11"));

	WxStaticLine1 = new wxStaticLine(this, ID_WXSTATICLINE1, wxPoint(15,206), wxSize(373,-1), wxLI_HORIZONTAL);

	WxStaticText6 = new wxStaticText(this, ID_WXSTATICTEXT6, wxT("This is project given for free. Writing it need some resources and time."), wxPoint(15,171), wxDefaultSize, 0, wxT("WxStaticText6"));

	WxStaticText9 = new wxStaticText(this, ID_WXSTATICTEXT9, wxT("Ready for many OS (Linux, MacOS, ...) and phones."), wxPoint(15,58), wxDefaultSize, 0, wxT("WxStaticText9"));

	WxStaticText8 = new wxStaticText(this, ID_WXSTATICTEXT8, wxT("Available for free"), wxPoint(15,42), wxDefaultSize, 0, wxT("WxStaticText8"));

	WxHyperLinkCtrl2 = new wxHyperlinkCtrl(this, ID_WXHYPERLINKCTRL2, wxT("Donation page for Marcin Wicek"), wxT("http://www.mwiacek.com/gsm/money/money.htm"), wxPoint(91,215), wxSize(261, 17), wxNO_BORDER | wxHL_CONTEXTMENU, wxT("WxHyperLinkCtrl2"));
	WxHyperLinkCtrl2->SetNormalColour(*wxBLUE);
	WxHyperLinkCtrl2->SetFont(wxFont(8, wxSWISS, wxNORMAL,wxNORMAL, TRUE));

	WxButton1 = new wxButton(this, ID_WXBUTTON1, wxT("&OK"), wxPoint(149,375), wxSize(101,25), 0, wxDefaultValidator, wxT("WxButton1"));

	WxHyperLinkCtrl1 = new wxHyperlinkCtrl(this, ID_WXHYPERLINKCTRL1, wxT("Gammu+ section on www.gammu.org "), wxT("http://www.gammu.org/wiki/index.php?title=GPlus:Main_Page"), wxPoint(91,123), wxSize(196, 17), wxNO_BORDER | wxHL_CONTEXTMENU, wxT("WxHyperLinkCtrl1"));
	WxHyperLinkCtrl1->SetNormalColour(*wxBLUE);
	WxHyperLinkCtrl1->SetFont(wxFont(8, wxSWISS, wxNORMAL,wxNORMAL, TRUE));

	WxStaticText4 = new wxStaticText(this, ID_WXSTATICTEXT4, wxT("Online info:"), wxPoint(15,123), wxDefaultSize, 0, wxT("WxStaticText4"));

	WxStaticText3 = new wxStaticText(this, ID_WXSTATICTEXT3, wxT("GPL/LGPL for free, commercial on request"), wxPoint(91,106), wxDefaultSize, 0, wxT("WxStaticText3"));

	WxStaticText2 = new wxStaticText(this, ID_WXSTATICTEXT2, wxT("License:"), wxPoint(15,106), wxDefaultSize, 0, wxT("WxStaticText2"));

	WxStaticText1 = new wxStaticText(this, ID_WXSTATICTEXT1, wxT("Written mainly in C++ using free compilators/tools (like wxWidgets) only."), wxPoint(15,74), wxDefaultSize, 0, wxT("WxStaticText1"));

	WxStaticBox2 = new wxStaticBox(this, ID_WXSTATICBOX2, wxT("Donations and job"), wxPoint(7,148), wxSize(393,87));

	WxStaticBox1 = new wxStaticBox(this, ID_WXSTATICBOX1, wxT("Facts"), wxPoint(7,8), wxSize(393,137));
	////GUI Items Creation End
}

void AboutDlg::OnClose(wxCloseEvent& /*event*/)
{
	Destroy();
}

/*
 * WxButton1Click
 */
void AboutDlg::WxButton1Click(wxCommandEvent& event)
{
    EndModal(wxID_OK);
}

/*
 * WxButton2Click
 */
void AboutDlg::WxButton2Click(wxCommandEvent& event)
{

}
