/* (C) 2003 - 2006 by Marcin Wiacek www.mwiacek.com */

#include <stdio.h>
#include <stdarg.h>

#include "../cfg/config.h"
#include "../common/misc/files.h"
#include "../common/misc/misc.h"
#include "../common/misc/coding/coding.h"
#include "../common/gsmstate.h"
#include "../common/service/gsmmisc.h"
#include "../common/service/backup/gsmback.h"

#include "gplus.h"
#include "gsms.cpp"
#include "gfiles.cpp"

char *DayOfWeekStr(int Year, int Month, int Day)
{
	switch (DayOfWeek(Year,Month,Day)) {
	case 1: return "Monday";
	case 2: return "Tuesday";
	case 3: return "Wednesday";
	case 4: return "Thursday";
	case 5: return "Friday";
	case 6: return "Saturday";
	case 7: return "Sunday";
	default:return "";
	}
}

void PrintError(GSM_Error error)
{
	if (error.Code != GSM_ERR_NONE) {
		printf("%s",GSM_GetErrorInfo(error));
		exit(-1);
	}
}

void PrintStdErr(char *format, ...)
{
	va_list	argp;
	int 	chars,i;
	char 	buff[200];

	va_start(argp, format);
	chars = vsprintf(buff,format,argp);
	va_end(argp);

	fprintf(stderr,"%c%s",13,buff);
	if (PrevStdErr!=0) for(i=strlen(buff);i<PrevStdErr;i++) fprintf(stderr," ");
	fprintf(stderr,"%c",13);	
	PrevStdErr = chars;
}

void PrintTimeLeftReset()
{
	told	  = 0;
	toldfirst = TRUE;
	GSM_GetCurrentDateTime(&DTStart);
}

void PrintTimeLeft(char *buffer, int small_, int large_)
{
	time_t 		t;
	GSM_DateTime 	DTNow;
	char 		buff[200];

	sprintf(buff,"%s",buffer);
	sprintf(buff+strlen(buff),"%i %%",small_*100/large_);

	GSM_GetCurrentDateTime(&DTNow);

	t=GSMDateTime2TimeT(&DTNow)-GSMDateTime2TimeT(&DTStart);
	sprintf(buff+strlen(buff),", time %02i:",t/60);
	sprintf(buff+strlen(buff),"%02i",t%60);
	t=t*(large_-small_)/small_;
	told = t;
	if (told!=0) {
		sprintf(buff+strlen(buff),", %02i:",told/60);
		sprintf(buff+strlen(buff),"%02i left",told%60);
	}
	PrintStdErr("%s",buff);
}

#define DCT4GetUEM 50000

GSM_Error DCT4ReplyGetUEM(int MsgLength, unsigned char MsgType, unsigned char *MsgBuffer, void *Struct, int RequestID)
{
	// Struct is pointer to any structure given during frame sending
	char *Buf = (char *)Struct;

	//we must check Type of message
	//and how long it is
	if (MsgType == 0x1B && MsgLength > 4) {
		//message is enough long and now we check subtype
		if (MsgBuffer[3] == 0x08) {
			//if we didn't ask for it return error
			if (RequestID != DCT4GetUEM) return GSM_Return_Error(GSM_ERR_FRAME_NOT_REQUESTED);
			//we wanted it now and we fill our structure and return
			strcpy(Buf,(const char *)MsgBuffer+10);
			return GSM_Return_Error(GSM_ERR_NONE);
		}
	}

	//we must tell Gammu+, that we want to parse this frame by internal
	//module
	return GSM_Return_Error(GSM_ERR_FRAME_TYPE_UNKNOWN);
}

void Identify(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
        GSM_Error 		error;
	unsigned char 		IMEI[20], Model[50], Model2[50], Firm[50], Man[50], Firm2[50];


//    GSM_SMSMMSDecodedEntry Decoded;
//    GSM_SMSMMSDecodedSubEntry *Decoded2;
//    GSM_SMSList List;
//    GSM_SMSListSubEntry *SMS2;
//unsignedstring UDH;
//    int i,left;
//    wchar_t x[2];
//    List.ClearAll();
//    Decoded2 = new GSM_SMSMMSDecodedSubEntry;
//    Decoded2->Type = MSG_MMSSMS_File;
//    Decoded2->Text.append(StringToUnicodeReturn("text/plain"));
//    UnicodeToUTF8(StringToUnicodeReturn("ddddddddddddddddddddddddxxxxxxxxdddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd"), &Decoded2->File.Buffer);
  //  x[0]=1*256+5;
//x[0]='{';
//    x[1] = 0;
//    UnicodeToUTF8(x, &Decoded2->File.Buffer);
//    Decoded.Add(Decoded2);
//    Decoded.SaveToSMS(&List, SMS_Text_Short,&left);
//    i=0;
//int w;
//    SMS2 = NULL;
//    while (List.GetNext(&SMS2)) {
//        i++;
//	printf("%i\n",SMS2->GetSMS()->UserData.size());
//SMS2->GetSMS()->GetUDH(&UDH);
//for (w=0;w<UDH.size();w++) printf("%02x ",UDH.data()[w]);
//    }
//    printf("sms num %i %i\n",i,left);

//unsignedstring x;
//int len2,w,z,m;
//wchar_t buff[50];
//unsigned char buff2[50];
//for (z=0;z<20;z++) {
//for (w=0;w<z;w++) buff[w] = '9';
//buff[z]=0;
//len2 = StringToBCD((const unsigned char *)UnicodeToStringReturn(buff), buff2, UnicodeLength(buff));
//printf("%i\n",len2);
//x.clear();
//GSM_EncodeSMSNumber(&x, buff, TRUE);
//for(m=0;m<x.length();m++) printf("%02x ",x.data()[m]);
//printf("\n");
//}

	printf("Gammu+\n");
	printf("  Version      : %s",VERSION);
	printf(" built %s %s",__TIME__,__DATE__);
	if (strlen(GetCompiler()) != 0) printf(" using %s",GetCompiler());
	printf("\n");
	if (strlen(GetOS()) != 0) printf("  Run on       : %s\n",GetOS());
	
	error = s->Open(CFG);
	PrintError(error);

	if (!strcmp(s->Protocols->CurrentName,"irdaphonet")) {
		printf("  Connection   : infrared (%s)",s->Protocols->CurrentName);
#ifndef WIN32
		printf(" on %s",s->Devices->CurrentName);
#endif
	} else if (!strcmp(s->Protocols->CurrentName,"bluephonet")) {
		printf("  Connection   : bluetooth (%s)",s->Protocols->CurrentName);
#ifndef WIN32
		printf(" on %s",s->Devices->CurrentName);
#endif
	} else {
		printf("  Connection   : %s",s->Protocols->CurrentName);
	}
	printf("\n  Phone module : %s\n",s->Phones->Current->ModuleName);

	printf("Phone\n");

	error = s->Phones->Current->GetIMEI(IMEI);
	PrintError(error);
	printf("  IMEI         : %s\n",IMEI);

	error = s->Phones->Current->GetManufacturer(Man);
	PrintError(error);
	error = s->Phones->Current->GetModel(Model);
	PrintError(error);
	error = s->Phones->Current->GetCodeNameModel(Model2);
	PrintError(error);
	printf("  Model        : %s %s (%s)\n",Man, Model, Model2);

	error = s->Phones->Current->GetFirmwareVersion(Firm);
	PrintError(error);
	printf("  Firmware     : %s",Firm);
	error = s->Phones->Current->GetFirmwareDate(Firm2);
	PrintError(error);
	printf(" (%s)\n",Firm2);

	if (!strcmp(s->Phones->Current->ModuleName,"dct4 (n6510)")) {
		//we set handler
		s->SetUserReply(DCT4ReplyGetUEM);
		error = s->Phones->Current->Write((unsigned char *)"\x00\x03\x02\x07\x00\x08",6, 0x1B, 4, DCT4GetUEM, Model);
		PrintError(error);
		s->SetUserReply(NULL);		
		printf("  UEM          : %s\n",Model);
	}
}

void Monitor(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
        GSM_Error 		error;
	GSM_PBKStatus 		Status;

	error = s->Open(CFG);
	PrintError(error);

	while (1) {
		Status.Memory=MEM_PHONE;
		error = s->Phones->Current->GetPBKStatus(&Status);
		if (error.Code != GSM_ERR_NOT_SUPPORTED) PrintError(error);

		Status.Memory=MEM_SIM;
		error = s->Phones->Current->GetPBKStatus(&Status);
		if (error.Code != GSM_ERR_NOT_SUPPORTED) PrintError(error);
	}
}

void Restore(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
        GSM_Error 		error;
	GSM_Backup		Backup;
	GSM_PBKStatus 		Status;
	GSM_Backup_PBKEntry	*PBKEntry;
	GSM_PBKEntry 		PBKEntry2;
	GSM_Backup_CalEntry	*CalEntry;
	GSM_CalendarEntry	CalEntry2;
	int			i;
	char			ch;

	error = Backup.ReadFromFile(argv[0]);
	PrintError(error);

	error = s->Open(CFG);
	PrintError(error);

	Status.Memory=MEM_PHONE;
	error = s->Phones->Current->GetPBKStatus(&Status);
	if (error.Code != GSM_ERR_NONE) {
		PrintError(error);
	} else {
		printf("Do you want to restore phone phonebook ?");
		do {
		      ch = toupper(getc(stdin));
		} while(ch != 'Y' && ch != 'N');
		if (ch == 'Y') {
			PBKEntry2.Memory=MEM_PHONE;
			for(i=1;i<=Status.Used + Status.Free;i++) {
				PBKEntry = NULL;
				while (Backup.GetNext_PBK(&PBKEntry)) {
					if (PBKEntry->GetEntry()->Memory != MEM_PHONE) continue;
					if (PBKEntry->GetEntry()->Location != i) continue;
					error = s->Phones->Current->SetPBK(PBKEntry->GetEntry());
					PrintError(error);
					break;
				}
				if (PBKEntry != NULL && PBKEntry->GetEntry()->Location == i) continue;
				PBKEntry2.Location = i;
				error = s->Phones->Current->DeletePBK(&PBKEntry2);
				PrintError(error);
			}
		}
	}

	printf("Do you want to restore phone calendar ?");
	do {
	      ch = toupper(getc(stdin));
	} while(ch != 'Y' && ch != 'N');
	if (ch == 'Y') {
		CalEntry = NULL;
		while (Backup.GetNext_Cal(&CalEntry)) {
			error = s->Phones->Current->AddCalendar(CalEntry->GetEntry());
			PrintError(error);
		}
	}
}

void GetAllCalendar(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
        GSM_Error 		error;
	GSM_CalendarEntry 	Entry;
	GSM_CalendarSubEntry 	*SubEntry;
	BOOLEAN			start = TRUE;
	int			RepeatEach,RepeatDay,RepeatMonth,RepeatDOW,Current,Max;

	error = s->Open(CFG);
	PrintError(error);

	while (1) {
		error = s->Phones->Current->GetNextCalendar(&Entry,start,&Current,&Max);
		if (error.Code == GSM_ERR_EMPTY) break;
		PrintError(error);

		printf("\nNote type    : ");
		switch(Entry.Type) {
		case Calendar_Type_Meeting:
			printf("meeting\n");
			break;
		case Calendar_Type_Memo:
			printf("memo\n");
			break;
		case Calendar_Type_Call:
			printf("phone call\n");
			break;
		case Calendar_Type_Birthday:
			printf("birthday\n");
			break;
		case Calendar_Type_Reminder:
			printf("reminder\n");
			break;
		}

		RepeatEach 	= -1;
		RepeatDay 	= -1;
		RepeatMonth 	= -1;
		RepeatDOW 	= -1;
		SubEntry 	= NULL;
		while (Entry.GetNext(&SubEntry) == TRUE) {
			switch (SubEntry->GetType()) {
			case Calendar_Text_Text:
				printf("Text         : \"%s\"\n",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case Calendar_Text_Phone:
				printf("Phone number : \"%s\"\n",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case Calendar_Text_Location:
				printf("Location     : \"%s\"\n",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case Calendar_DateTime_Start:
				printf("Start time   : %02i:%02i:%02i %02i-%02i-%04i %s\n",
					SubEntry->GetDateTime()->Hour,
					SubEntry->GetDateTime()->Minute,
					SubEntry->GetDateTime()->Second,
					SubEntry->GetDateTime()->Day,
					SubEntry->GetDateTime()->Month,
					SubEntry->GetDateTime()->Year,
					DayOfWeekStr(
						SubEntry->GetDateTime()->Year,
						SubEntry->GetDateTime()->Month,
						SubEntry->GetDateTime()->Day));
				break;
			case Calendar_DateTime_End:
				printf("End time     : %02i:%02i:%02i %02i-%02i-%04i %s\n",
					SubEntry->GetDateTime()->Hour,
					SubEntry->GetDateTime()->Minute,
					SubEntry->GetDateTime()->Second,
					SubEntry->GetDateTime()->Day,
					SubEntry->GetDateTime()->Month,
					SubEntry->GetDateTime()->Year,
					DayOfWeekStr(
						SubEntry->GetDateTime()->Year,
						SubEntry->GetDateTime()->Month,
						SubEntry->GetDateTime()->Day));
				break;
			case Calendar_DateTime_SilentAlarm:
			case Calendar_DateTime_ToneAlarm:
				if (SubEntry->GetType() == Calendar_DateTime_SilentAlarm) {
					printf("Silent alarm : ");
				} else {
					printf("Tone alarm   : ");
				}
				if (Entry.Type == Calendar_Type_Birthday) {
					printf("%02i:%02i:%02i %02i-%02i in each year\n",
						SubEntry->GetDateTime()->Hour,
						SubEntry->GetDateTime()->Minute,
						SubEntry->GetDateTime()->Second,
						SubEntry->GetDateTime()->Day,
						SubEntry->GetDateTime()->Month);
				} else {
					printf("%02i:%02i:%02i %02i-%02i-%04i %s\n",
						SubEntry->GetDateTime()->Hour,
						SubEntry->GetDateTime()->Minute,
						SubEntry->GetDateTime()->Second,
						SubEntry->GetDateTime()->Day,
						SubEntry->GetDateTime()->Month,
						SubEntry->GetDateTime()->Year,
						DayOfWeekStr(
							SubEntry->GetDateTime()->Year,
							SubEntry->GetDateTime()->Month,
							SubEntry->GetDateTime()->Day));
				}
				break;
			case Calendar_DateTime_End_Repeat:
				printf("Repeat end   : %02i:%02i:%02i %02i-%02i-%04i %s\n",
					SubEntry->GetDateTime()->Hour,
					SubEntry->GetDateTime()->Minute,
					SubEntry->GetDateTime()->Second,
					SubEntry->GetDateTime()->Day,
					SubEntry->GetDateTime()->Month,
					SubEntry->GetDateTime()->Year,
					DayOfWeekStr(
						SubEntry->GetDateTime()->Year,
						SubEntry->GetDateTime()->Month,
						SubEntry->GetDateTime()->Day));
				break;
			case Calendar_Int_Repeat_Frequency:
				RepeatEach = SubEntry->GetInt();
				break;
			case Calendar_Int_Repeat_DayOfWeek:
				RepeatDOW = SubEntry->GetInt();
				break;			
			case Calendar_Int_Repeat_Day:
				RepeatDay = SubEntry->GetInt();
				break;
			case Calendar_Int_Repeat_Month:
				RepeatMonth = SubEntry->GetInt();
				break;
			}
		}

		if (RepeatEach != -1 || RepeatDOW != -1 ||
		    RepeatDay != -1 || RepeatMonth != -1) {
			printf("Repeat note  : ");
			if (RepeatEach == 1) printf("each ");
			if (RepeatEach == 2) printf("each second ");
			if (RepeatDOW != -1) {
				switch (RepeatDOW) {
					case 1: printf("Monday ");	break;
					case 2: printf("Tuesday ");	break;
					case 3: printf("Wednesday ");	break;
					case 4: printf("Thursday ");	break;
					case 5: printf("Friday ");	break;
					case 6: printf("Saturday ");	break;
					case 7: printf("Sunday ");	break;
					default:printf(" ");
				}
			}
			if (RepeatDay != -1) {
				printf("%i ",RepeatDay);
				if (RepeatMonth != -1) {
					switch (RepeatMonth) {
						case  1: printf("January ");	break;
						case  2: printf("February ");	break;
						case  3: printf("March ");	break;
						case  4: printf("April ");	break;
						case  5: printf("May ");	break;
						case  6: printf("June ");	break;
						case  7: printf("July ");	break;
						case  8: printf("August ");	break;
						case  9: printf("September ");	break;
						case 10: printf("October ");	break;
						case 11: printf("November ");	break;
						case 12: printf("December ");	break;
						default:printf(" ");
					}
				} else {
					printf("month day ");
				}
			}
			printf("\n");
		}

		start = FALSE;
	}
}

void GetAllNotes(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
        GSM_Error 		error;
	GSM_NoteEntry	 	Entry;
	BOOLEAN			start = TRUE;
	int Current,Max;

	error = s->Open(CFG);
	PrintError(error);

	while (1) {
		error = s->Phones->Current->GetNextNote(&Entry,start,&Current,&Max);
		if (error.Code == GSM_ERR_EMPTY) break;
		PrintError(error);

		printf("text %s\n",UnicodeToStringReturn(Entry.Text.data()));

		start = FALSE;
	}
}

void GetDateTime(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
        GSM_Error 		error;
	GSM_DateTime		DT;

	error = s->Open(CFG);
	PrintError(error);

	error = s->Phones->Current->GetDateTime(&DT);
	PrintError(error);

	printf("Date & time %02i:%02i:%02i %02i-%02i-%04i %s\n",
		DT.Hour,DT.Minute,DT.Second,DT.Day,DT.Month,DT.Year,
		DayOfWeekStr(DT.Year,DT.Month,DT.Day));
}

void GetMemory(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
        GSM_Error 		error;
	GSM_PBKEntry 		Entry;
	GSM_PBKSubEntry 	*SubEntry;
	int			Start, End, Tmp;

	Start = End = atoi(argv[1]);
	if (argc > 2) End = atoi(argv[2]);

	if (End < Start) {
		Tmp   = End;
		End   = Start;
		Start = Tmp;
		printf("Swapped last and first location\n");		
	}

	Entry.Memory = GSM_GetMemoryType(argv[0]);
	if (Entry.Memory == MEM_Unknown) {
		printf("Unknown memory type: %s\n",argv[0]);
		return;		
	}

	error = s->Open(CFG);
	PrintError(error);

	for (Tmp = Start; Tmp <= End; Tmp++) {	
		Entry.ClearAll();

		Entry.Memory = GSM_GetMemoryType(argv[0]);
		Entry.Location = Tmp;

		error = s->Phones->Current->GetPBK(&Entry);
		PrintError(error);

		SubEntry = NULL;
		while (Entry.GetNext(&SubEntry) == TRUE) {
			switch (SubEntry->GetType()) {
			case PBK_Text_Phone_General:
				printf("General number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Phone_Mobile:
				printf("Mobile number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Phone_Home:
				printf("Home number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Phone_Work:
				printf("Work number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Phone_Fax:
				printf("Fax number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Phone_Video:
				printf("Video number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal:
				printf("Postal address \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_Street:
				printf("Street \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_City:
				printf("City \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_State:
				printf("State \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_ZIP_Code:
				printf("ZIP \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_Country:
				printf("Country \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Email:
				printf("Email \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_URL:
				printf("URL \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_UserID:
				printf("User ID \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Note:
				printf("Text note \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Name:
				printf("Name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Name_Last:
				printf("Last name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Name_First:
				printf("First name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Name_Formal:
				printf("Formal name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Company_Name:
				printf("Company name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Nick_Name:
				printf("Nickname \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_PTT:
				printf("PTT \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Video_Sharing_SIP:
				printf("Video SIP \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Job_Title:
				printf("Job title \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_DateTime_Call_Length:
				printf("Date & time %02i:%02i:%02i %02i-%02i-%04i",
					SubEntry->GetDateTime()->Hour,
					SubEntry->GetDateTime()->Minute,
					SubEntry->GetDateTime()->Second,
					SubEntry->GetDateTime()->Day,
					SubEntry->GetDateTime()->Month,
					SubEntry->GetDateTime()->Year);
				break;
			case PBK_DateTime_Birthday:
				printf("Birthday %02i-%02i-%04i",
					SubEntry->GetDateTime()->Day,
					SubEntry->GetDateTime()->Month,
					SubEntry->GetDateTime()->Year);
				break;
			case PBK_ID_Caller_Group:
				printf("Caller group \"%i\"",SubEntry->LongValue);
				break;
			case PBK_ID_Picture:
				printf("Picture ID \"%i\"",SubEntry->LongValue);
				break;
			case PBK_ID_Ringtone:
				printf("Ringtone ID \"%i\"",SubEntry->LongValue);
				break;
			case PBK_ID_Video_File:
				printf("Video file ID \"%i\"",SubEntry->LongValue);
				break;
			case PBK_Bool_PTT_Subscribed:
//				printf(" \"%i\"",SubEntry->GetLongValue());
				break;
			}
			if (SubEntry->CallLength != -1) {
				printf(" (length %i:%i:%i)",SubEntry->CallLength/(60*60),SubEntry->CallLength/60,SubEntry->CallLength%60);
			}
			printf("\n");
		}
	}
}

void ClearAll(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
        GSM_Error 		error;
	GSM_CalendarEntry 	Entry;
	char			ch;
	int				Current,Max;

	error = s->Open(CFG);
	PrintError(error);

	printf("Do you want to clear phone calendar ?");
	do {
	      ch = toupper(getc(stdin));
	} while(ch != 'Y' && ch != 'N');
	if (ch == 'Y') {
		while (1) {
			error = s->Phones->Current->GetNextCalendar(&Entry,TRUE,&Current,&Max);
			if (error.Code == GSM_ERR_EMPTY) break;
			PrintError(error);
	
			error = s->Phones->Current->DeleteCalendar(&Entry);
			PrintError(error);		
		}
	}
}

void Modules(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	list<GSM_Device_Info>::iterator 	devinfo;
	list<GSM_Protocol_Info>::iterator 	proinfo;
	list<GSM_Phone_Info>::iterator 		phoinfo;
        GSM_Device              		*dev;
        GSM_Protocol            		*pro;
        GSM_Phone               		*pho;

        printf("Available device modules\n");
        dev = NULL;
        while(1) {
                if (!s->Devices->GetNext(&dev)) break;
		for (devinfo=dev->Info.begin(); devinfo!=dev->Info.end(); ++devinfo) {
                        printf("  \"%s\"\n",(*devinfo).Device);
		}
        }

        printf("Available protocol modules\n");
        pro = NULL;
        while(1) {
                if (!s->Protocols->GetNext(&pro)) break;
		for (proinfo=pro->Info.begin(); proinfo!=pro->Info.end(); ++proinfo) {
                        printf("  \"%s\" dev \"%s\"\n",(*proinfo).Protocol,(*proinfo).Device);
	        }
        }

        printf("Available phone modules\n");
        pho = NULL;
        while(1) {
                if (!s->Phones->GetNext(&pho)) break;
	        printf("%s\n",pho->ModuleName);
		for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
                        printf("  \"%s\" prot \"%s\" cname \"%s\" devname \"%s\" feat \"%s\"\n",
                                (*phoinfo).Model,(*phoinfo).Protocol, (*phoinfo).CodeNameModel, 
                                (*phoinfo).DeviceModel, (*phoinfo).Features);
	        }
        }
}

void GetMMSFolders(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_Error			error;
	GSM_SMSMMSFolders		Folders;
	GSM_SMSMMSFoldersSubEntry  	*SubEntry;
	int				i=1;
	
	error = s->Open(CFG);
	PrintError(error);

	error = s->Phones->Current->GetSMSMMSFolders(&Folders);
	PrintError(error);

	SubEntry = NULL;
	while (Folders.GetNext(&SubEntry) == TRUE) {
		if (!SubEntry->MMS) continue;
		printf("%i. %s - memory %s\n",i++,UnicodeToStringReturn(SubEntry->GetName()),GSM_GetMemoryName(SubEntry->Memory));
//		printf(" %s\n",UnicodeToStringReturn(SubEntry->ID.data()));
	}
}

void Help(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[]);

static CommandLineFunction CommandLineFunctions[] = {
	"--identify",		0, 0, Identify,      "",
	"--modules",		0, 0, Modules,       "",
	"--help",		0, 0, Help,   	     "",
	"--monitor",		0, 0, Monitor, 	     "",
	"--getmemory",		2, 3, GetMemory,     "ME|SM location",
	"--restore",		1, 1, Restore,       "",
	"--getallcalendar",	0, 0, GetAllCalendar,"",
	"--getallnotes",	0, 0, GetAllNotes,   "",
	"--getdatetime",	0, 0, GetDateTime,   "",
	"--clearall",		0, 0, ClearAll,	     "",
	"--getmmsfolders",	0, 0, GetMMSFolders, "",
	"--getsmsstatus",	0, 0, GetSMSStatus,  "",
	"--getallsms",		0, 0, GetAllSMS,     "",
	"--geteachsms",		0, 0, GetEachSMS,    "",
	"--getsmsfolders",	0, 0, GetSMSFolders, "",
	"--getsmsc",		1, 1, GetSMSC, 	     "",
	"--addsms",		0, 0, AddSMS, 	     "",
	"--sendsms",		2, 2, SendSMS, 	     "number text",
	"--deletesms",		2, 2, DeleteSMS,     "ID",
	"--getfilesystem",	0, 0, GetFileSystem, "",
	"--getfile",		1, 1, GetFile,       "fileID",
	"--addfile",		2, 2, AddFile,       "ParentFolderID FileName",
	"--addfolder",		2, 2, AddFolder,     "ParentFolderID Name",
	"--deletefolder",	1, 1, DeleteFolder,  "ID",
	"--deletefile",		1, 1, DeleteFile,    "ID",
	"--displayjava",	0, 0, DisplayJava,   "",
	"--addjavagame",	1, 1, AddJavaGame,   "name(without JAD/JAR extensions)",
	"--addjavaapp",		1, 1, AddJavaApp,    "name(without JAD/JAR extensions)",

	"",			0, 0, NULL,	     "",
};

void Help(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	int i = 0;

	while (CommandLineFunctions[i].Parameter[0] != 0) {
		printf("%s %s\n",CommandLineFunctions[i].Parameter,CommandLineFunctions[i].Params);
		i++;
	}
}

int main2(int argc, char *argv[])
{
        GSM_StateMachine 	s(DebFile,"",UseDeb);
	GSM_GPlusConfig 		CFGFile;
        int 			i=0,startarg=0;
	unsignedstring		Stable,Test;

	Stable.append((unsigned char *)"[CMD LINE  :",12);
	for (i=1;i<argc;i++) {
		Stable.push_back(' ');
		Stable.push_back('\"');
		Stable.append((unsigned char *)argv[i],strlen(argv[i]));
		Stable.push_back('\"');
	}
	Stable.append((unsigned char *)"]\n",2);
	s.Debug->Deb((char *)Stable.data());
	Stable.clear();

	i=0;

	if (argc > 1 && StringCaseCmp(argv[1],"nothing",-1)) {
		startarg++;
	} else if (argc > 1 && StringCaseCmp(argv[1],"textall",-1)) {
		startarg++;
	}
	s.ReadCfg(1,&CFGFile);

	if (CFGFile.RSSLevel[0]!=0) {
		CheckRSS(&Stable, &Test);
		if (StringCaseCmp(CFGFile.RSSLevel, "teststable", -1)) {
			if (Test.length()!=0) printf("You are using Gammu+ version %s, but there is already newer test version %s. See www.gammu.org for more.\n",VERSION,Test.data());
		}
		if (StringCaseCmp(CFGFile.RSSLevel, "teststable", -1) ||
			StringCaseCmp(CFGFile.RSSLevel, "stable", -1)) {
			if (Stable.length()!=0) printf("You are using Gammu+ version %s, but there is already newer stable version %s. See www.gammu.org for more.\n",VERSION,Stable.data());
		}
	}

	if (argc-startarg==1) {
		Help(&s,&CFGFile,argc-2-startarg,argv+2+startarg);
		return 0;
	}

	while(1) {
		if (CommandLineFunctions[i].Parameter[0] == 0) break;
		if (!StringCaseCmp(argv[1+startarg],CommandLineFunctions[i].Parameter,-1)) {
			i++;
			continue;
		}
		if (argc-2-startarg < CommandLineFunctions[i].MinArguments) {
			printf("Give more arguments (required ");
			if (CommandLineFunctions[i].MinArguments!=CommandLineFunctions[i].MaxArguments) {
				printf("%i to %i",
					CommandLineFunctions[i].MinArguments,
					CommandLineFunctions[i].MaxArguments);
			} else {
				printf("%i",CommandLineFunctions[i].MaxArguments);
			}
			if (CommandLineFunctions[i].Params[0]!=0) {
				printf(": %s",CommandLineFunctions[i].Params);
			}
			printf(")\n");
			return 0;
		}
		if (argc-2-startarg > CommandLineFunctions[i].MaxArguments) {
			printf("Too many arguments (required ");
			if (CommandLineFunctions[i].MinArguments!=CommandLineFunctions[i].MaxArguments) {
				printf("%i to %i",
					CommandLineFunctions[i].MinArguments,
					CommandLineFunctions[i].MaxArguments);
			} else {
				printf("%i",CommandLineFunctions[i].MaxArguments);
			}
			if (CommandLineFunctions[i].Params[0]!=0) {
				printf(": %s",CommandLineFunctions[i].Params);
			}
			printf(")\n");
			return 0;
		}
		CommandLineFunctions[i].Function(&s,&CFGFile,argc-2-startarg,argv+2+startarg);
		return 0;
	}

	Help(&s,&CFGFile,argc-2-startarg,argv+2+startarg);
	return 0;
}

int main(int argc, char *argv[])
{
#ifdef DEBUG
	UseDeb 	= true;
	DebFile = stdout;
#endif
	if (argc > 1 && StringCaseCmp(argv[1],"nothing",-1)) {
		UseDeb 	= false;
		DebFile = NULL;
	} else if (argc > 1 && StringCaseCmp(argv[1],"textall",-1)) {
		UseDeb 	= true;
		DebFile = stdout;
	}

	main2(argc,argv);
}
