/* (C) 2007 by Marcin Wiacek www.mwiacek.com */

#ifndef gsm_data_h
#define gsm_data_h

#include "../gsmfiles.h"
#include "gsmsms.h"

class GSM_SMSMMSFoldersSubEntry
{
public:
	GSM_SMSMMSFoldersSubEntry();
	~GSM_SMSMMSFoldersSubEntry();

	int				Number;
	int				OtherNumber;
	BOOLEAN				FileSystem;
	BOOLEAN				Inbox;
	BOOLEAN				MMS;
	GSM_MemoryType			Memory;
	wchart				ID;

	void				SetName(wchar_t *N);
	wchar_t 			*GetName();
	void				SetNext(GSM_SMSMMSFoldersSubEntry *Nxt);
	GSM_SMSMMSFoldersSubEntry	*GetNext();
private:
	GSM_SMSMMSFoldersSubEntry	*Next;
	wchar_t				*Name;
};

class GSM_SMSMMSFolders
{
public:
	GSM_SMSMMSFolders();
	~GSM_SMSMMSFolders();

	BOOLEAN 			GetNext(GSM_SMSMMSFoldersSubEntry **En);
	GSM_Error	 		Add(wchar_t *Name, BOOLEAN FF, BOOLEAN Inbox, BOOLEAN MMS, GSM_MemoryType mem, wchart *ID, int Num, int OtherNum);
	void 				ClearAll();	
private:
	GSM_SMSMMSFoldersSubEntry	*Entries;
};

class GSM_MMSEntry
{
public:
	int		Folder;
	GSM_File	File;
};

typedef enum {
	MSG_MMSSMS_Address_Phone_Source = 1,
	MSG_MMS_Address_Unknown_Source,
	MSG_MMS_Address_Phone_Destination,
	MSG_MMS_Address_Unknown_Destination,
	MSG_MMS_Address_Phone_CC,
	MSG_MMS_Address_Unknown_CC,
	MSG_MMS_Address_Phone_BCC,
	MSG_MMS_Address_Unknown_BCC,
	MSG_MMS_Text_TransactionID,
	MSG_MMS_Text_Subject,
	MSG_MMS_Text_ContentLocation,
	MSG_MMS_Text_ContentType,
	MSG_MMS_Text_MessageType,
	MSG_MMS_Text_MessageID,
	MSG_MMS_Text_MessageClass,
	MSG_MMS_Text_Priority,
	MSG_MMS_Text_Version,
	MSG_MMS_Text_Response_Status,
	MSG_MMS_Text_Status,
	MSG_MMS_DT_DateTime,
	MSG_MMS_DT_Expiry,
	MSG_MMS_Bool_Report,
	MSG_MMS_Bool_Read_Reply,
	MSG_MMS_Bool_Report_Allowed,
	MSG_MMSSMS_File,
	MSG_SMS_Fax_Indicator,
	MSG_SMS_Voice_Indicator,
	MSG_SMS_Email_Indicator,
	MSG_SMS_Other_Indicator,
	MSG_SMS_WAP_Bookmark,

	MSG_Unknown
} GSM_MSG_Types;

typedef enum {
	SMS_Text_Short = 1,
	SMS_Text_Long,
	SMS_Indicators,
	SMS_WAP_Bookmark,
	SMS_EMS
} GSM_SMS_Types;

class GSM_SMSMMSDecodedSubEntry
{
	friend class GSM_SMSMMSDecodedEntry;
public:
	GSM_SMSMMSDecodedSubEntry();
	~GSM_SMSMMSDecodedSubEntry();

	GSM_MSG_Types			Type;
	GSM_File			File;

	wchart				Text;
	wchart				Text2;
	wchart				Header;
	BOOLEAN				Bool;
	GSM_DateTime			DT;
	int				IntVal;

	GSM_SMSMMSDecodedSubEntry	*GetNext();
private:
	void 				SetNext(GSM_SMSMMSDecodedSubEntry *Nxt);

	GSM_SMSMMSDecodedSubEntry	*Next;
};

class GSM_SMSMMSDecodedEntry
{
public:
	GSM_SMSMMSDecodedEntry();
	~GSM_SMSMMSDecodedEntry();

	//specific to SMS
	BOOLEAN				SMSUnicode;

	void 				ClearAll();	
	BOOLEAN 			GetNext(GSM_SMSMMSDecodedSubEntry **En);
	GSM_Error	 		Add(GSM_SMSMMSDecodedSubEntry *En);

	GSM_Error			ReadFromMMS(GSM_File *File);
	GSM_Error 			ReadFromSMS(GSM_SMSList *List);
	GSM_Error			SaveToSMS(GSM_SMSList *List, GSM_SMS_Types Type, int *CharsLeft);
private:
	GSM_SMSMMSDecodedSubEntry	*Entries;

	void 				DecodeAddress(unsignedstring *buffer, GSM_MSG_Types *Type);
	void 				DecodeVersion(unsignedstring *Buff, long *Pos, unsignedstring *Dest, float *Version);
	int 				DecodeContentType(unsignedstring *Buff, long *Pos, unsignedstring *Dest, unsignedstring *Dest2, wchart *Name, float Version);

	int 				DecodeValuelength(unsignedstring *Buff, long *Pos);
	int 				DecodeShortinteger(unsignedstring *Buff, long *Pos);
	long 				DecodeUintvar(unsignedstring *Buff, long *Pos);
	long 				DecodeLonginteger(unsignedstring *Buff, long *Pos);
	void 				DecodeText(unsignedstring *Buff, long *Pos, unsignedstring *Dest);
	void 				DecodeEncodedString(unsignedstring *Buff, long *Pos, unsignedstring *Dest);
	long 				DecodeInteger(unsignedstring *Buff, long *Pos);

	GSM_Error 			PackContentToSMS(GSM_SMSList *Destination, SMS_UDH_Type UDH1, SMS_UDH_Type UDH2, unsignedstring *src, SMS_Coding_Type Coding, int *CharsLeft);
	void 				AddWAPSMSParameterText(unsigned char ID, unsignedstring *Text, unsignedstring *Dest);
};

#endif
