/* (C) 2007 by Marcin Wiacek www.mwiacek.com */

#include "../../../cfg/config.h"
#include "../../misc/coding/coding.h"
#include "gsmmsg.h"
#include "_mms.cpp"
#include "_sms.cpp"

GSM_SMSMMSDecodedSubEntry::GSM_SMSMMSDecodedSubEntry()
{
	Next = NULL;
}

GSM_SMSMMSDecodedSubEntry::~GSM_SMSMMSDecodedSubEntry()
{
	delete(Next);
}

GSM_SMSMMSDecodedSubEntry *GSM_SMSMMSDecodedSubEntry::GetNext()
{
	return Next;
}

void GSM_SMSMMSDecodedSubEntry::SetNext(GSM_SMSMMSDecodedSubEntry *Nxt)
{
	Next = Nxt;
}

/* ------------------------------------------------------------------------ */

GSM_SMSMMSDecodedEntry::GSM_SMSMMSDecodedEntry()
{
	SMSUnicode = FALSE;
	Entries = NULL;
}


GSM_SMSMMSDecodedEntry::~GSM_SMSMMSDecodedEntry()
{
	delete(Entries);
}

BOOLEAN GSM_SMSMMSDecodedEntry::GetNext(GSM_SMSMMSDecodedSubEntry **En)
{
	if ((*En) == NULL) {
		(*En) = Entries;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

GSM_Error GSM_SMSMMSDecodedEntry::Add(GSM_SMSMMSDecodedSubEntry *En)
{
	GSM_SMSMMSDecodedSubEntry	*Entry2;
	GSM_Error			error;

	if (Entries == NULL) {
		Entries = En;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(En);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

void GSM_SMSMMSDecodedEntry::ClearAll()
{
	delete(Entries);
	Entries = NULL;
}

//-----------------------------------------------------------------------------

GSM_SMSMMSFoldersSubEntry::GSM_SMSMMSFoldersSubEntry()
{
	Name = NULL;
	Next = NULL;
}

GSM_SMSMMSFoldersSubEntry::~GSM_SMSMMSFoldersSubEntry()
{
	delete(Next);
}

void GSM_SMSMMSFoldersSubEntry::SetName(wchar_t *N)
{
	int len = (UnicodeLength(N)+1)*sizeof(wchar_t);
	
	Name = (wchar_t *)realloc(Name,len);
	memcpy(Name,N,len);
}

wchar_t *GSM_SMSMMSFoldersSubEntry::GetName()
{
	if (Name == NULL) return 0x00;
	return Name;
}

void GSM_SMSMMSFoldersSubEntry::SetNext(GSM_SMSMMSFoldersSubEntry *Nxt)
{
	Next = Nxt;
}

GSM_SMSMMSFoldersSubEntry *GSM_SMSMMSFoldersSubEntry::GetNext()
{
	return Next;
}

/* ------------------------------------------------------------------------ */

GSM_SMSMMSFolders::GSM_SMSMMSFolders()
{
	Entries = NULL;
}

GSM_SMSMMSFolders::~GSM_SMSMMSFolders()
{
	delete(Entries);
}

BOOLEAN GSM_SMSMMSFolders::GetNext(GSM_SMSMMSFoldersSubEntry **En)
{
	if ((*En) == NULL) {
		(*En) = Entries;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

void GSM_SMSMMSFolders::ClearAll()
{
	delete(Entries);
	Entries = NULL;
}

GSM_Error GSM_SMSMMSFolders::Add(wchar_t *Name, BOOLEAN FF, BOOLEAN Inbox, BOOLEAN MMS, GSM_MemoryType mem, wchart *ID, int Num, int OtherNum)
{
	GSM_SMSMMSFoldersSubEntry *Entry,*Entry2;

	Entry 			= new GSM_SMSMMSFoldersSubEntry;
	Entry->Inbox  		= Inbox;
	Entry->MMS		= MMS;
	Entry->Memory 		= mem;
	Entry->FileSystem 	= FF;
	Entry->Number 		= Num;
	Entry->OtherNumber 	= OtherNum;
	Entry->ID.append(ID->data());
	Entry->SetName(Name);

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}
