
GSM_Error GSM_SMSMMSDecodedEntry::ReadFromSMS(GSM_SMSList *List)
{
	GSM_SMSListSubEntry 		*SMS2;
	GSM_SMSMMSDecodedSubEntry 	*Sub2 = new GSM_SMSMMSDecodedSubEntry;
	wchar_t 			buff[400];
	unsignedstring 			dest;
    	unsignedstring              	UDH;
    	UDHList                     	UDH2;
	GSM_Error			error;
	unsigned int			found=0,j;
	GSM_SMSNumbersSubEntry  	*Number;

	ClearAll();

	SMS2 = NULL;
	while (List->GetNext(&SMS2)) {
		error = SMS2->GetSMS()->GetUDH(&UDH);
               	if (error.Code != GSM_ERR_NONE) return error;
            	if (UDH.size()!=0) {
                	error = SMS2->GetSMS()->DecodeUDH(&UDH2);
	               	if (error.Code != GSM_ERR_NONE) return error;
			for (j=0;j<UDH2.size();j++) {
	                        switch (UDH2.data()[j].Type) {
	                        case SMS_UDH_Linked_Short:
					if (found!=0 && found!=1) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
					found = 1;
					break;
	                        case SMS_UDH_Linked_Long:
					if (found!=0 && found!=2) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
					found = 2;
					break;
	                        default:
					break;
				}
			}
		}
//		SMS2->GetSMS()->GetDecodedText(buff);		
//		UnicodeToUTF8(buff, &dest);		
	}
	//text sms
	if (found == 0 || found == 1 || found == 2) {
		SMS2 = NULL;
		while (List->GetNext(&SMS2)) {
			error = SMS2->GetSMS()->GetUDH(&UDH);
	               	if (error.Code != GSM_ERR_NONE) return error;
			if (UDH.size()!=0) {
	                	error = SMS2->GetSMS()->DecodeUDH(&UDH2);
		               	if (error.Code != GSM_ERR_NONE) return error;
				for (j=0;j<UDH2.size();j++) {
//					if (Sub2->File.Buffer.size()==0 && ) {
//					}
//	                        	switch (UDH2.data()[j].Type) {
				}
			}
			dest.clear();
			SMS2->GetSMS()->GetDecodedText(buff);		
			UnicodeToUTF8(buff, &dest);
			Sub2->File.Buffer.append(dest);
		}
		Sub2->Text.append(StringToUnicodeReturn("text/plain"));
		Sub2->Text2.append(StringToUnicodeReturn("charset=utf8"));
		Sub2->Type = MSG_MMSSMS_File;
		Add(Sub2);

		SMS2 = NULL;
		List->GetNext(&SMS2);
		Number = NULL;
		while (SMS2->GetSMS()->PhoneNumbers.GetNext(&Number)) {
			error = Number->GetPhoneNumber(buff);
			Sub2 = new GSM_SMSMMSDecodedSubEntry;
			Sub2->Type = MSG_MMSSMS_Address_Phone_Source;
			Sub2->Text.append(buff);
			Add(Sub2);
		}

		return GSM_Return_Error(GSM_ERR_NONE);
	}
	return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

/* http://forum.nokia.com: OTA MMS Settings 1.0, OTA Settings 7.0 */
void GSM_SMSMMSDecodedEntry::AddWAPSMSParameterText(unsigned char ID, unsignedstring *Text, unsignedstring *Dest)
{
	Dest->push_back(0x87); 				//PARM with attributes
	Dest->push_back(ID);
	Dest->push_back(0x11); 				//VALUE
	Dest->push_back(0x03); 				//Inline string
	Dest->append(Text->data(),Text->length()); 	//Text
	Dest->push_back(0x00); 				//END Inline string
	Dest->push_back(0x01); 				//END PARMeter
}

GSM_Error GSM_SMSMMSDecodedEntry::PackContentToSMS(GSM_SMSList *Destination, SMS_UDH_Type UDH1, SMS_UDH_Type UDH2, unsignedstring *src, SMS_Coding_Type Coding, int *CharsLeft)
{
	int 			i,max = 0,UDHNum1,UDHNum2,UDHLen,Pos,len2,len3,used,lenmax;
	GSM_SMSEntry 		SMS;
	unsigned char 		buff[500], ID;
	unsignedstring 		buff2;
	wchart 			Dest;
	BOOLEAN 		many=FALSE;
	GSM_Error 		error;
	GSM_SMSListSubEntry	*SMS2;

	Destination->ClearAll();
	switch(Coding) {
	case SMS_Coding_Default_No_Compression:
		(*CharsLeft) = 160; break;
	case SMS_Coding_Unicode_No_Compression:
		(*CharsLeft) = 70; break;
	case SMS_Coding_8bit:
		(*CharsLeft) = 140; //no break
	default:
		break;
	}
	if (src->size() == 0) return GSM_Return_Error(GSM_ERR_NONE);

	Dest.clear();

	UDHNum1=-1; UDHNum2=-1;
	i = 0;
	while(UDHHeaders[i].Length!=0) {
		if (UDHHeaders[i].Type==UDH1 && UDHNum1==-1) UDHNum1=i;
		if (UDHHeaders[i].Type==UDH2 && UDHNum2==-1) UDHNum2=i;
		i++;
	}

	UDHLen=0;
	if (UDHNum1!=-1) UDHLen=1+UDHHeaders[UDHNum1].Length;

	switch(Coding) {
	case SMS_Coding_Default_No_Compression:
		UTF8ToUnicode(src->data(), &Dest, src->size());
		lenmax = Dest.length(); 
		error = GSM_EncodeSMSText(buff, Dest.data(), &len3, &len2, 140-UDHLen, &used, UDHLen);
		if (error.Code != GSM_ERR_NONE) return error;
		if (len3 != lenmax) many = TRUE;
		break;
	case SMS_Coding_Unicode_No_Compression:
		UTF8ToUnicode(src->data(), &Dest, src->size());
		lenmax = Dest.length(); 
		if (lenmax>(140-UDHLen)/2) many=TRUE;
		break;
	case SMS_Coding_8bit:
		lenmax = src->size();
		if (lenmax>(*CharsLeft)) many=TRUE;
	default:
		break;
	}
	if (many && UDHNum2!=-1) {
		if (UDHLen==0) UDHLen=1;
		UDHLen+=UDHHeaders[UDHNum2].Length; 
	}

	max = 0;
	Pos=0;
	while (Pos<lenmax) {
		buff2.clear();
		SMS.SetCoding(Coding);
		if (SMS.GetCoding()!=Coding) return GSM_Return_Error(GSM_ERR_UNKNOWN);
		switch(Coding) {
		case SMS_Coding_Default_No_Compression:
			error = GSM_EncodeSMSText(buff, Dest.data()+Pos, &len3, &len2, 140-UDHLen, &used, UDHLen);
			if (error.Code != GSM_ERR_NONE) return error;
			buff2.append(buff,used);
			Pos+=len3;
			(*CharsLeft) = (140-UDHLen)*8/7-len2;
			break;
		case SMS_Coding_Unicode_No_Compression:
			len2=0;
			for(i=0;i<((140-UDHLen)/2);i++) {
				buff2.push_back(Dest.data()[Pos]/256);
				buff2.push_back(Dest.data()[Pos]%256);
				Pos++;
				len2++;
				if (Pos==lenmax) break;
			}
			(*CharsLeft) = 70-i;
			break;
		case SMS_Coding_8bit:
			len2=140-UDHLen;
			if (src->size()-Pos<len2) len2=src->size()-Pos;
			for(i=0;i<len2;i++) {
				buff2.push_back(src->data()[Pos]);
				Pos++;
			}
			break;
		}
		error = SMS.SetText(&buff2,len2);
		if (error.Code != GSM_ERR_NONE) return error;
		Destination->Add(&SMS);
		max++;
	}
	if (UDHNum1!=-1 || (many && UDHNum2!=-1)) {
		Pos = 0;
		SMS2 = NULL;
		while (Destination->GetNext(&SMS2)) {
			UDHLen=1;
			if (UDHNum1!=-1) {
				memcpy(buff+UDHLen,UDHHeaders[UDHNum1].Text,UDHHeaders[UDHNum1].Length);
				UDHLen+=UDHHeaders[UDHNum1].Length;
			}
			if (UDHNum2!=-1) {
				if (Pos == 0) ID = SMS2->GetSMS()->MakeSMSIDFromTime();
				memcpy(buff+UDHLen,UDHHeaders[UDHNum2].Text,UDHHeaders[UDHNum2].Length);
				buff[UDHLen+UDHHeaders[UDHNum2].ID8bit] = ID;
				buff[UDHLen+UDHHeaders[UDHNum2].PartNumber8bit] = Pos+1;
				buff[UDHLen+UDHHeaders[UDHNum2].AllParts8bit] = max;
				UDHLen+=UDHHeaders[UDHNum2].Length;
			}
			buff[0] = UDHLen-1;
			buff2.clear();
			buff2.append((unsigned char *)buff,UDHLen);
			SMS2->GetSMS()->SetUDH(&buff2);
			Pos++;
		}
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_SMSMMSDecodedEntry::SaveToSMS(GSM_SMSList *Destination, GSM_SMS_Types Type, int *CharsLeft)
{
	BOOLEAN				many=FALSE;
	GSM_SMSMMSDecodedSubEntry 	*Sub2;
	GSM_SMSEntry			SMS;
	int 				len2,len3,used;
	unsigned int 			i,j;
	unsigned char			buff[500];
	unsignedstring			buff2,buff3;
	GSM_Error			error;
	wchart				Dest;
	SMS_Coding_Type 		Coding;
	GSM_SMSListSubEntry		*SMS2;

	Destination->ClearAll();
	if (Type == SMS_WAP_Bookmark) {
		Sub2=NULL;
		GetNext(&Sub2);
//		if (Sub2->Type != MSG_MMSSMS_File) {
		i = 0;

		/* http://forum.nokia.com: OTA Settings 7.0 */
		buff2.push_back(0x01); 					//Push ID
		buff2.push_back(0x06); 					//PDU Type (push)
		buff2.push_back(0x2D); 					//Headers length (content type + headers)
		buff2.append((unsigned char *)"\x1F\x2B",2);		//Value length
		buff2.append((unsigned char *)"application/x-wap-prov.browser-bookmarks",40); //MIME-Type
		buff2.push_back(0x00); 					//end inline string
		buff2.append((unsigned char *)"\x81\xEA",2);		//charset UTF-8 short integer
	
		buff2.push_back(0x01);			// Version WBXML 1.1
		buff2.push_back(0x01);			// Unknown public identifier
		buff2.push_back(0x6A);			// charset UTF-8
		buff2.push_back(0x00);			// string table length

		buff2.push_back(0x45); 			//CHARACTERISTIC-LIST with content
			/* URL */
			buff2.push_back(0xC6); 		//CHARACTERISTIC with content and attributes
			buff2.push_back(0x7F);          //TYPE = BOOKMARK
			buff2.push_back(0x01); 		//END PARMeter

				/* TITLE */
				UnicodeToUTF8(Sub2->Text.data(), &buff3);
				AddWAPSMSParameterText(0x15, &buff3, &buff2);

				/* URL */
				buff3.clear();
				UnicodeToUTF8(Sub2->Text2.data(), &buff3);
				AddWAPSMSParameterText(0x17, &buff3, &buff2);

			buff2.push_back(0x01);		//END (CHARACTERISTIC)
		buff2.push_back(0x01);			//END (CHARACTERISTIC-LIST)

		PackContentToSMS(Destination, SMS_UDH_NokiaWAP, SMS_UDH_Linked_Short, &buff2, SMS_Coding_8bit, CharsLeft);

		SMS2 = NULL;
		while (Destination->GetNext(&SMS2)) {
			SMS2->GetSMS()->SetClass(1);
		}
		return GSM_Return_Error(GSM_ERR_NONE);
	}
	if (Type == SMS_Indicators) {
		j=1;
		Sub2=NULL;
		while (GetNext(&Sub2)) {
			if (Sub2->Type == MSG_SMS_Fax_Indicator) {
				i = 0;
				while(UDHHeaders[i].Length!=0) {
					if (UDHHeaders[i].Type==SMS_UDH_Fax) {
						memcpy(buff+j,UDHHeaders[i].Text,4);
						buff[j+3]=Sub2->IntVal%256;
						j+=4;
						break;
					}
					i++;
				}
			}
			if (Sub2->Type == MSG_SMS_Voice_Indicator) {
				i = 0;
				while(UDHHeaders[i].Length!=0) {
					if (UDHHeaders[i].Type==SMS_UDH_Voice) {
						memcpy(buff+j,UDHHeaders[i].Text,4);
						buff[j+3]=Sub2->IntVal%256;
						j+=4;
						break;
					}
					i++;
				}
			}
			if (Sub2->Type == MSG_SMS_Email_Indicator) {
				i = 0;
				while(UDHHeaders[i].Length!=0) {
					if (UDHHeaders[i].Type==SMS_UDH_Email) {
						memcpy(buff+j,UDHHeaders[i].Text,4);
						buff[j+3]=Sub2->IntVal%256;
						j+=4;
						break;
					}
					i++;
				}
			}
			if (Sub2->Type == MSG_SMS_Other_Indicator) {
				i = 0;
				while(UDHHeaders[i].Length!=0) {
					if (UDHHeaders[i].Type==SMS_UDH_Other) {
						memcpy(buff+j,UDHHeaders[i].Text,4);
						buff[j+3]=Sub2->IntVal%256;
						j+=4;
						break;
					}
					i++;
				}
			}
		}
		buff[0]=j-1;
		buff2.append(buff,j);
		printf((char *)buff,"g");
		error = GSM_EncodeSMSText(buff, Dest.data(), &len3, &len2, 140-j, &used, j);
		error = SMS.SetText(&buff2,len2);
		SMS.SetUDH(&buff2);
		Destination->Add(&SMS);
		return GSM_Return_Error(GSM_ERR_NONE);
	}
	if (Type == SMS_Text_Short || Type == SMS_Text_Long) {
		Sub2=NULL;
		while (GetNext(&Sub2)) {
			if (Sub2->Type != MSG_MMSSMS_File) {
				return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
			}
			if (strcmp(UnicodeToStringReturn(Sub2->Text.data()),"text/plain")) {
				return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
			}
		}
		Sub2=NULL;
		if (!GetNext(&Sub2)) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);

		Coding=SMS_Coding_Default_No_Compression;
		if (SMSUnicode) Coding=SMS_Coding_Unicode_No_Compression;	

		error = PackContentToSMS(Destination, SMS_UDH_None, SMS_UDH_Linked_Short, &Sub2->File.Buffer, Coding, CharsLeft);
		if (error.Code != GSM_ERR_NONE) return error;	
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}
