/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include "gsmpbk.h"
#include "../misc/coding/coding.h"

wchar_t	*GSM_PBKSubEntry::GetText()
{
	if (Text==NULL) return 0x00;
	return Text;
}

GSM_PBKSubEntry::GSM_PBKSubEntry()
{
	SMSLists.clear();
	BoolValue = false;
	CallLength = -1;
	VoiceTag = -1;
	Type   = PBK_Not_Assigned;
	Text   = NULL;
	Next   = NULL;
}

GSM_PBKSubEntry::~GSM_PBKSubEntry()
{
	delete(Next);
	free(Text);
}

GSM_PBK_SubEntryType GSM_PBKSubEntry::GetType()
{
	return Type;
}

GSM_Error GSM_PBKSubEntry::SetToLong(GSM_PBK_SubEntryType Typ, long long2)
{
	Type = Typ;

	LongValue = long2;

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_PBKSubEntry::SetToBool(GSM_PBK_SubEntryType Typ, bool bool2)
{
	Type = Typ;

	BoolValue = bool2;

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_PBKSubEntry::SetToText(GSM_PBK_SubEntryType Typ, wchar_t *Txt)
{
	int len = (UnicodeLength(Txt)+1)*sizeof(wchar_t);

	if (Typ < PBK_Text_Phone_General || Typ > PBK_Text_Job_Title) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);

	Type = Typ;

	Text = (wchar_t *)realloc(Text,len);
	memcpy(Text,Txt,len);

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_PBKSubEntry *GSM_PBKSubEntry::GetNext()
{
	return Next;
}

void GSM_PBKSubEntry::SetNext(GSM_PBKSubEntry *Nxt)
{
	Next = Nxt;
}

GSM_Error GSM_PBKSubEntry::SetToDateTime(GSM_PBK_SubEntryType Typ, GSM_DateTime DT2)
{
	if (Typ != PBK_DateTime_Call_Length && Typ != PBK_DateTime_Birthday) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
	Type = Typ;

	memcpy(&DT,&DT2,sizeof(GSM_DateTime));
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_DateTime *GSM_PBKSubEntry::GetDateTime()
{
	return &DT;
}

/* ------------------------------------------------------------------------ */

GSM_PBKEntry::GSM_PBKEntry()
{
	Entries = NULL;
}


GSM_PBKEntry::~GSM_PBKEntry()
{
	delete(Entries);
}

BOOLEAN GSM_PBKEntry::GetNext(GSM_PBKSubEntry **En)
{
	if ((*En) == NULL) {
		(*En) = Entries;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

GSM_Error GSM_PBKEntry::AddText(GSM_PBK_SubEntryType Typ, wchar_t *Txt)
{
	GSM_PBKSubEntry *Entry,*Entry2;
	GSM_Error	error;

	Entry = new GSM_PBKSubEntry;
	error = Entry->SetToText(Typ, Txt);
	if (error.Code != GSM_ERR_NONE) {
		delete (Entry);
		return error;
	}

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) {
			Entry2 = Entry2->GetNext();
		}
		Entry2->SetNext(Entry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_PBKEntry::AddLong(GSM_PBK_SubEntryType Typ, long long2)
{
	GSM_PBKSubEntry *Entry,*Entry2;
	GSM_Error	error;

	Entry = new GSM_PBKSubEntry;
	Entry->SetToLong(Typ, long2);

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_PBKEntry::AddBool(GSM_PBK_SubEntryType Typ, bool bool2)
{
	GSM_PBKSubEntry *Entry,*Entry2;
	GSM_Error	error;

	Entry = new GSM_PBKSubEntry;
	Entry->SetToBool(Typ, bool2);

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_PBKEntry::AddDateTime(GSM_PBK_SubEntryType Typ, GSM_DateTime DT2)
{
	GSM_PBKSubEntry *Entry,*Entry2;
	GSM_Error	error;

	Entry = new GSM_PBKSubEntry;
	error = Entry->SetToDateTime(Typ, DT2);
	if (error.Code != GSM_ERR_NONE) {
		delete (Entry);
		return error;
	}

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

void GSM_PBKEntry::ClearAll()
{
	delete(Entries);
	Entries = NULL;
}

GSM_Error GSM_PBKEntry::EncodeToVCARD(unsignedstring *dest, GSM_VCARDType Type)
{
	GSM_PBKSubEntry *SubEntry;
	BOOLEAN		firstnum=FALSE;
	char buff[500];

	dest->clear();
	if (Type == VCARD_10) {
		printf(buff,"BEGIN:VCARD%c%c",13,10); dest->append((unsigned char *)buff);
		SubEntry = NULL;
		while (GetNext(&SubEntry) == TRUE) {
			switch (SubEntry->GetType()) {
			case PBK_Text_Phone_General:
			case PBK_Text_Phone_Mobile:
			case PBK_Text_Phone_Home:
			case PBK_Text_Phone_Work:
			case PBK_Text_Phone_Fax:
			case PBK_Text_Phone_Video:
				if (firstnum) {
					firstnum=FALSE;
				}
				printf("General number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
				printf("Mobile number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
				printf("Home number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
				printf("Work number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
				printf("Video number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal:
				printf("Postal address \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_Street:
				printf("Street \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_City:
				printf("City \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_State:
				printf("State \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_ZIP_Code:
				printf("ZIP \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_Country:
				printf("Country \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Email:
				printf("Email \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_URL:
				printf("URL \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_UserID:
				printf("User ID \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Note:
				printf("Text note \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Name:
				printf("Name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Name_Last:
				printf("Last name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Name_First:
				printf("First name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Name_Formal:
				printf("Formal name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Company_Name:
				printf("Company name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Nick_Name:
				printf("Nickname \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_PTT:
				printf("PTT \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Video_Sharing_SIP:
				printf("Video SIP \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Job_Title:
				printf("Job title \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_DateTime_Call_Length:
				printf("Date & time %02i:%02i:%02i %02i-%02i-%04i",
					SubEntry->GetDateTime()->Hour,
					SubEntry->GetDateTime()->Minute,
					SubEntry->GetDateTime()->Second,
					SubEntry->GetDateTime()->Day,
					SubEntry->GetDateTime()->Month,
					SubEntry->GetDateTime()->Year);
				break;
			case PBK_DateTime_Birthday:
				printf("Birthday %02i-%02i-%04i",
					SubEntry->GetDateTime()->Day,
					SubEntry->GetDateTime()->Month,
					SubEntry->GetDateTime()->Year);
				break;
			case PBK_ID_Caller_Group:
				printf("Caller group \"%i\"",SubEntry->LongValue);
				break;
			case PBK_ID_Picture:
				printf("Picture ID \"%i\"",SubEntry->LongValue);
				break;
			case PBK_ID_Ringtone:
				printf("Ringtone ID \"%i\"",SubEntry->LongValue);
				break;
			case PBK_ID_Video_File:
				printf("Video file ID \"%i\"",SubEntry->LongValue);
				break;
			case PBK_Bool_PTT_Subscribed:
//				printf(" \"%i\"",SubEntry->GetLongValue());
				break;
			}
			if (SubEntry->CallLength != -1) {
				printf(" (length %i:%i:%i)",SubEntry->CallLength/(60*60),SubEntry->CallLength/60,SubEntry->CallLength%60);
			}
			printf("\n");
		}
		printf(buff,"END:VCARD%c%c",13,10); dest->append((unsigned char *)buff);
	}
	if (Type == VCARD_21) {
		printf(buff,"BEGIN:VCARD%c%cVERSION:2.1%c%c",13,10,13,10); dest->append((unsigned char *)buff);
		SubEntry = NULL;
		while (GetNext(&SubEntry) == TRUE) {
			switch (SubEntry->GetType()) {
			case PBK_Text_Phone_General:
				printf("General number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Phone_Mobile:
				printf("Mobile number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Phone_Home:
				printf("Home number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Phone_Work:
				printf("Work number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Phone_Fax:
				printf("Fax number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Phone_Video:
				printf("Video number \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal:
				printf("Postal address \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_Street:
				printf("Street \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_City:
				printf("City \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_State:
				printf("State \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_ZIP_Code:
				printf("ZIP \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Postal_Country:
				printf("Country \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Email:
				printf("Email \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_URL:
				printf("URL \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_UserID:
				printf("User ID \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Note:
				printf("Text note \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Name:
				printf("Name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Name_Last:
				printf("Last name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Name_First:
				printf("First name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Name_Formal:
				printf("Formal name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Company_Name:
				printf("Company name \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Nick_Name:
				printf("Nickname \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_PTT:
				printf("PTT \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Video_Sharing_SIP:
				printf("Video SIP \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_Text_Job_Title:
				printf("Job title \"%s\"",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			case PBK_DateTime_Call_Length:
				printf("Date & time %02i:%02i:%02i %02i-%02i-%04i",
					SubEntry->GetDateTime()->Hour,
					SubEntry->GetDateTime()->Minute,
					SubEntry->GetDateTime()->Second,
					SubEntry->GetDateTime()->Day,
					SubEntry->GetDateTime()->Month,
					SubEntry->GetDateTime()->Year);
				break;
			case PBK_DateTime_Birthday:
				printf("Birthday %02i-%02i-%04i",
					SubEntry->GetDateTime()->Day,
					SubEntry->GetDateTime()->Month,
					SubEntry->GetDateTime()->Year);
				break;
			case PBK_ID_Caller_Group:
				printf("Caller group \"%i\"",SubEntry->LongValue);
				break;
			case PBK_ID_Picture:
				printf("Picture ID \"%i\"",SubEntry->LongValue);
				break;
			case PBK_ID_Ringtone:
				printf("Ringtone ID \"%i\"",SubEntry->LongValue);
				break;
			case PBK_ID_Video_File:
				printf("Video file ID \"%i\"",SubEntry->LongValue);
				break;
			case PBK_Bool_PTT_Subscribed:
//				printf(" \"%i\"",SubEntry->GetLongValue());
				break;
			}
			if (SubEntry->CallLength != -1) {
				printf(" (length %i:%i:%i)",SubEntry->CallLength/(60*60),SubEntry->CallLength/60,SubEntry->CallLength%60);
			}
			printf("\n");
		}
		printf(buff,"END:VCARD%c%c",13,10); dest->append((unsigned char *)buff);
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_PBKEntry::DecodeFromVCARD(unsignedstring *src)
{
	return GSM_Return_Error(GSM_ERR_NONE);
}
