/* (C) 2005-2007 by Marcin Wiacek www.mwiacek.com */

#include <string.h>

#include "../../cfg/config.h"
#include "../misc/coding/coding.h"
#include "gsmfiles.h"
#include "gsmmisc.h"

typedef struct {
        GSM_Error_Code        ErrorNum;
        char                  *ErrorText;
} PrintErrorEntry;

char *GSM_GetErrorInfo(GSM_Error e)
{
        PrintErrorEntry PrintErrorEntries[] = {
		{GSM_ERR_DRIVER_NOT_AVAILABLE,		"Some required driver or operating system part not available."},
		{GSM_ERR_DEVICE_WRITE,			"Error writing device"},
		{GSM_ERR_DEVICE_READ,			"Error reading device"},
		{GSM_ERR_DEVICE_OPEN,			"Error opening device"},
		{GSM_ERR_DEVICE_CLOSE,			"Error closing device"},
                {GSM_ERR_NONE,                          "No error."},
                {GSM_ERR_UNKNOWN,                       "Unknown error. Please report."},
                {GSM_ERR_SOURCE_NOT_COMPILED,           "Some parts of source not compiled."},
                {GSM_ERR_PROTOCOL_STRING_UNKNOWN,       "Protocol specified in config is not known."},
                {GSM_ERR_PHONE_STRING_UNKNOWN,          "Phone model specified in config is not known."},
                {GSM_ERR_OTHER_PROTOCOL,                "Phone model specified in config works with others protocols only."},
		{GSM_ERR_TIMEOUT,			"No response in specified time."},
		{GSM_ERR_EMPTY,				"Empty"},
		{GSM_ERR_NOT_SUPPORTED,			"Not supported by phone"},
		{GSM_ERR_CONVERTED,			"Converted to phone format"},
		{GSM_ERR_TOO_MANY_ENTRIES,		"Entry cut off"},
		{GSM_ERR_INVALID_LOCATION,		"Invalid location"},
		{GSM_ERR_INSIDE_PHONE_MENU,		"Data are edited in phone menu. Leave it before editing from PC."},
		{GSM_ERR_NO_SIM,			"Function requires SIM card"},
		{GSM_ERR_GPLUS_NOT_SUPPORTED,		"Not supported by Gammu+"},
//	GSM_ERR_MEMORY,
//	GSM_ERR_FOLDER_PART,
		{GSM_ERR_FILE_CHECKSUM,			"File checksum error"},
		{GSM_ERR_MUST_BE_FILE,			"%s must be file, not folder"},
		{GSM_ERR_MUST_BE_FOLDER,		"%s must be folder, not file"},
		{GSM_ERR_FILE_EXIST,			"There is already file %s"},
		{GSM_ERR_FOLDER_EXIST,			"There is already folder %s"},
		{GSM_ERR_FOLDER_NOT_EMPTY,		"Folder %s is not empty"},
		{GSM_ERR_FILE_NOT_EXIST,		"File %s doesn't exist (folder with this name too)"},
		{GSM_ERR_FILE_FOLDER_NOT_EXIST,		"File and folder %s doesn't exist"},
		{GSM_ERR_FOLDER_NOT_EXIST,		"Folder %s doesn't exist (file with this name too)"},
		{GSM_ERR_FILE_TOO_SHORT,		"File is too short"},

                {GSM_ERR_NONE,                          ""}
        };
        char   		*def;
	static char 	buff[500];
        int    		i = 0;

        while (1) {
                if (PrintErrorEntries[i].ErrorText[0] == 0x00) {
			def = "Unknown error.";
		        return def;
		} else if (PrintErrorEntries[i].ErrorNum == e.Code) {
                        def = PrintErrorEntries[i].ErrorText;
			if (strstr(def,"%s")!=NULL) {
				sprintf(buff,def,UnicodeToStringReturn(e.Parameter.data()));
				return buff;
			} else {
				return def;
			}
                }
                i++;
        }
}

GSM_Error GSM_Return_Error(GSM_Error_Code Code) 
{
	GSM_Error error;

	error.Code=Code;
	return error;
}

typedef struct {
	char 		*Description;
	GSM_MemoryType	Type;
} GSM_MemoryTypeInfo;

GSM_MemoryTypeInfo GSM_MemoryTypeInfos[] = {
	"ME", 		MEM_PHONE,
	"DC", 		MEM_PHONE_DIALLED,
	"MC", 		MEM_PHONE_MISSED,
	"RC", 		MEM_PHONE_RECEIVED,
	"SM", 		MEM_SIM,
	"ON", 		MEM_SIM_OWN,
	"MT",		MEM_SIM_PHONE,
	"unknown", 	MEM_Unknown
};

GSM_MemoryType GSM_GetMemoryType(char *Buffer)
{
	int i=0;
	
	while(GSM_MemoryTypeInfos[i].Type != MEM_Unknown) {
		if (!strcmp(GSM_MemoryTypeInfos[i].Description,Buffer)) return GSM_MemoryTypeInfos[i].Type;
		i++;
	}
	return MEM_Unknown;
}

char *GSM_GetMemoryName(GSM_MemoryType Type)
{
	int i=0;
	
	while(1) {
		if (GSM_MemoryTypeInfos[i].Type == Type) return GSM_MemoryTypeInfos[i].Description;
		i++;
	}
}

static int GetRSSVersion(char *Buffer)
{
	int retval = 0, pos = 0;

	retval = atoi(Buffer) * 10000;
	while (Buffer[pos] != '.') {
		pos++;
		if (pos == strlen(Buffer)) return retval;
	}
	pos++;
	retval += atoi(Buffer+pos) * 100;
	while (Buffer[pos] != '.') {
		pos++;
		if (pos == strlen(Buffer)) return retval;
	}
	pos++;
	return retval + atoi(Buffer+pos);
}

GSM_Error CheckRSS(unsignedstring *StableStr, unsignedstring *TestStr)
{
	GSM_File 	File;
	GSM_Error	error;
	unsigned int	pos=0,oldpos=0,i;
	char		buff[200];
	unsignedstring	X;
	
	X.push_back(0x00);

	StableStr->clear();
	TestStr->clear();

	if (!File.ReadFromHTTPGet("www.mwiacek.com","gsm/soft/gplus.rss")) return GSM_Return_Error(GSM_ERR_UNKNOWN);
	
	while (pos < File.Buffer.size()) {
		if (File.Buffer.data()[pos] != 10) {
			pos++;
			continue;
		}
		File.Buffer.replace(pos,1,X);
		if (strstr((char *)File.Buffer.data()+oldpos,"<title>") == NULL ||
		    strstr((char *)File.Buffer.data()+oldpos,"</title>")== NULL ||
		    strstr((char *)File.Buffer.data()+oldpos,"win32")   != NULL) {
			pos++;
			oldpos = pos;
			continue;
		}
		if (StableStr->length() == 0 && strstr((char *)File.Buffer.data()+oldpos,"stable version")!=NULL) {
			sprintf(buff,strstr((char *)File.Buffer.data()+oldpos,"stable version")+15);
			for (i=0;i<strlen(buff);i++) {
				if (buff[i] == '<') {
					buff[i] = 0;
					break;
				}
			}
			if (GetRSSVersion(buff)>GetRSSVersion(VERSION)) {
				StableStr->append((const unsigned char *)buff,strlen(buff));				
			}
		}
		if (TestStr->length() == 0 && strstr((char *)File.Buffer.data()+oldpos,"test version")!=NULL) {
			sprintf(buff,strstr((char *)File.Buffer.data()+oldpos,"test version")+13);
			for (i=0;i<strlen(buff);i++) {
				if (buff[i] == '<') {
					buff[i] = 0;
					break;
				}
			}
			if (GetRSSVersion(buff)>GetRSSVersion(VERSION)) {
				TestStr->append((const unsigned char *)buff,strlen(buff));				
			}
		}
		pos++;
		oldpos = pos;
		if (StableStr->length() != 0 && TestStr->length() != 0) break;
	}

	if (StableStr->length() != 0 && TestStr->length() != 0 &&
	    GetRSSVersion((char *)StableStr->data()) > GetRSSVersion((char *)TestStr->data())) {
		TestStr->clear();
	}

        return GSM_Return_Error(GSM_ERR_NONE);
}
