/* (C) 2003 - 2007 by Marcin Wiacek www.mwiacek.com */

#include "../../../cfg/config.h" //msvc2005
#include "../../misc/files.h"
#include "../../misc/coding/coding.h"
#include "../../misc/coding/md5.h"
#include "../gsmpbk.h"
#include "gsmback.h"

void GSM_Backup::SaveXMLFilePart(wchar_t *Text, FILE *file, BOOLEAN LineEnd)
{
	int 		i = 0;
	wchart 	Buffer;
	unsignedstring		Buffer2;

	while(1) {
		if (Text[i] == 0x00) break;
		if (Text[i] == 13) {
			Buffer.push_back('\\');
			Buffer.push_back('r');
		} else if (Text[i] == 10) {
			Buffer.push_back('\\');
			Buffer.push_back('n');
		} else {
			Buffer.push_back(Text[i]);
		}
		i++;
	}
	if (LineEnd) {
		Buffer.push_back(13);
		Buffer.push_back(10);
	}
	UnicodeToUTF8((wchar_t *)Buffer.data(), &Buffer2);

	fwrite(Buffer2.data(),1,Buffer2.size(),file);
}

/**
 * method for saving phonebook entries to backup text file. used internally
 */
GSM_Error GSM_Backup::SavePbkToXMLFile(FILE *file)
{
	GSM_Backup_PBKEntry	*PBKEntry;
	GSM_PBKSubEntry 	*PBKSubEntry;
	char			buff[100],buff2[100];
	int			Num,Num2;
	BOOLEAN			Found,First;

	Num = 1;
	PBKEntry = NULL;
	while (GetNext_PBK(&PBKEntry)) {
		if (PBKEntry->GetEntry()->Memory != MEM_PHONE) continue;

		Found = FALSE;
		Num2 = 1;
		First = TRUE;
		PBKSubEntry = NULL;
		while (PBKEntry->GetEntry()->GetNext(&PBKSubEntry) == TRUE) {
			buff2[0] = 0;
			switch (PBKSubEntry->GetType()) {
			case PBK_Text_Phone_General  : sprintf(buff2,"NumberGeneral"); 	break;
			case PBK_Text_Phone_Mobile   : sprintf(buff2,"NumberMobile"); 	break;
			case PBK_Text_Phone_Home     : sprintf(buff2,"NumberHome"); 	break;
			case PBK_Text_Phone_Work     : sprintf(buff2,"NumberWork"); 	break;
			case PBK_Text_Phone_Fax      : sprintf(buff2,"NumberFax"); 	break;
			case PBK_Text_Phone_Video    : sprintf(buff2,"NumberVideo"); 	break;
			case PBK_Text_Postal	     : sprintf(buff2,"Address"); 	break;
			case PBK_Text_Postal_City    : sprintf(buff2,"City"); 		break;
			case PBK_Text_Postal_State   : sprintf(buff2,"State"); 		break;
			case PBK_Text_Postal_ZIP_Code: sprintf(buff2,"Zip"); 		break;
			case PBK_Text_Postal_Country : sprintf(buff2,"Country"); 	break;
			case PBK_Text_Postal_Street  : sprintf(buff2,"Street"); 	break;
			case PBK_Text_Email          : sprintf(buff2,"Email"); 		break;
			case PBK_Text_URL            : sprintf(buff2,"URL"); 		break;
			case PBK_Text_UserID	     : sprintf(buff2,"UserID"); 	break;
			case PBK_Text_Note	     : sprintf(buff2,"Note"); 		break;
			case PBK_Text_Name	     : sprintf(buff2,"Name"); 		break;
			case PBK_Text_Name_Last	     : sprintf(buff2,"LastName"); 	break;
			case PBK_Text_Name_First     : sprintf(buff2,"FirstName"); 	break;
			case PBK_Text_PTT            : sprintf(buff2,"PTT"); 		break;
			case PBK_Text_Name_Formal    : sprintf(buff2,"FormalName"); 	break;
			case PBK_Text_Video_Sharing_SIP: sprintf(buff2,"VideoSIP"); 	break;
			case PBK_Text_Job_Title      : sprintf(buff2,"JobTitle"); 	break;
			case PBK_Text_Company_Name   : sprintf(buff2,"CompanyName"); 	break;
			case PBK_Text_Nick_Name      : sprintf(buff2,"NickName"); 	break;
			case PBK_Bool_PTT_Subscribed : sprintf(buff2,"PTTSubscribed"); 	break;
			case PBK_ID_Caller_Group     : sprintf(buff2,"CallerGroup");	break;
			case PBK_ID_Picture          : sprintf(buff2,"PictureID");	break;
			case PBK_ID_Video_File       : sprintf(buff2,"VideoFileID");	break;
			case PBK_DateTime_Birthday   : sprintf(buff2,"Birthday");       break;
			default			     : break;
			}
			if (buff2[0] == 0) continue;
			if (!Found) {
				sprintf(buff,"  <PhonePBK ");
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
				sprintf(buff,"Location=\"%03i\">",PBKEntry->GetEntry()->Location);
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
				Num++;
				Found = TRUE;
			}

			sprintf(buff,"    <Entry Number=\"%i\" Type=\"%s\"",Num2,buff2);
			switch (PBKSubEntry->GetType()) {
			case PBK_Text_Phone_General:
			case PBK_Text_Phone_Mobile:
			case PBK_Text_Phone_Home:
			case PBK_Text_Phone_Work:
			case PBK_Text_Phone_Fax:
			case PBK_Text_Phone_Video:
				if (First) sprintf(buff+strlen(buff)," Default=\"yes\"");
				First = FALSE;
			default:
				break;
			}
			sprintf(buff+strlen(buff),">");

			SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);

			switch (PBKSubEntry->GetType()) {
			case PBK_DateTime_Birthday:
				sprintf(buff,"      <Value>");
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
				SaveVCalendarDateTime(PBKSubEntry->GetDateTime(),buff);
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
				sprintf(buff,"</Value>");
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case PBK_Bool_PTT_Subscribed:
				if (PBKSubEntry->BoolValue) {
					sprintf(buff,"      <Value>yes</Value>");
				} else {
					sprintf(buff,"      <Value>no</Value>");
				}
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case PBK_ID_Caller_Group:
			case PBK_ID_Picture:
				sprintf(buff,"      <Value Type=\"Number\">%i</Value>",PBKSubEntry->LongValue);
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			default:
				sprintf(buff,"      <Value Type=\"Text\">");
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
				SaveXMLFilePart(PBKSubEntry->GetText(), file, FALSE);
				sprintf(buff,"</Value>");
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
			}

			switch (PBKSubEntry->GetType()) {
			case PBK_Text_Phone_General:
			case PBK_Text_Phone_Mobile:
			case PBK_Text_Phone_Home:
			case PBK_Text_Phone_Work:
			case PBK_Text_Phone_Fax:
			case PBK_Text_Phone_Video:
				if (PBKSubEntry->VoiceTag!=-1) {
					sprintf(buff,"      <Value Type=\"VoiceTag\">%i</Value>",PBKSubEntry->VoiceTag);
					SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
				}
				break;
			default:
				break;
			}
			sprintf(buff,"    </Entry>");
			SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);

			Num2++;
		}
		sprintf(buff,"  </PhonePBK>");
		SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Backup::SaveCalendarToXMLFile(FILE *file)
{
	GSM_CalendarSubEntry 	*CalSubEntry;
	GSM_Backup_CalEntry	*CalEntry;
	char			buff[100];
	int			Num;

	Num = 1;
	CalEntry = NULL;
	while (GetNext_Cal(&CalEntry)) {		
		sprintf(buff,"  <Calendar Location=\"%03i\"",CalEntry->GetEntry()->Location);
		SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
		Num++;

		switch (CalEntry->GetEntry()->Type) {
		case Calendar_Type_Meeting :SaveXMLFilePart(StringToUnicodeReturn(" Type=\"Meeting\">"), file, TRUE);break;
		case Calendar_Type_Memo	   :SaveXMLFilePart(StringToUnicodeReturn(" Type=\"Memo\">"), file, TRUE);break;
		case Calendar_Type_Call	   :SaveXMLFilePart(StringToUnicodeReturn(" Type=\"Call\">"), file, TRUE);break;
		case Calendar_Type_Birthday:SaveXMLFilePart(StringToUnicodeReturn(" Type=\"Birthday\">"), file, TRUE);break;
		case Calendar_Type_Reminder:SaveXMLFilePart(StringToUnicodeReturn(" Type=\"Reminder\">"), file, TRUE);break;
		}

		CalSubEntry = NULL;
		while (CalEntry->GetEntry()->GetNext(&CalSubEntry) == TRUE) {
			switch (CalSubEntry->GetType()) {
			case Calendar_Text_Text:
				SaveXMLFilePart(StringToUnicodeReturn("    <Text>"), file, FALSE);
				SaveXMLFilePart(CalSubEntry->GetText(), file, FALSE);
				SaveXMLFilePart(StringToUnicodeReturn("</Text>"), file, TRUE);
				break;
			case Calendar_Text_Phone:
				SaveXMLFilePart(StringToUnicodeReturn("    <Phone>"), file, FALSE);
				SaveXMLFilePart(CalSubEntry->GetText(), file, FALSE);
				SaveXMLFilePart(StringToUnicodeReturn("</Phone>"), file, TRUE);
				break;
			case Calendar_Text_Location:
				SaveXMLFilePart(StringToUnicodeReturn("    <EventLocation>"), file, FALSE);
				SaveXMLFilePart(CalSubEntry->GetText(), file, FALSE);
				SaveXMLFilePart(StringToUnicodeReturn("</EventLocation>"), file, TRUE);
				break;
			case Calendar_DateTime_Start:
				sprintf(buff,"    <StartTime>");
				SaveVCalendarDateTime(CalSubEntry->GetDateTime(),buff);
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
				SaveXMLFilePart(StringToUnicodeReturn("</StartTime>"), file, TRUE);
				break;
			case Calendar_DateTime_End:
				sprintf(buff,"    <StopTime>");
				SaveVCalendarDateTime(CalSubEntry->GetDateTime(),buff);
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
				SaveXMLFilePart(StringToUnicodeReturn("</StopTime>"), file, TRUE);
				break;
			case Calendar_DateTime_SilentAlarm:
			case Calendar_DateTime_ToneAlarm:
				sprintf(buff,"    <Alarm Type=\"");
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
				if (CalSubEntry->GetType() == Calendar_DateTime_SilentAlarm) {
					SaveXMLFilePart(StringToUnicodeReturn("Silent\">"), file, FALSE);
				} else {
					SaveXMLFilePart(StringToUnicodeReturn("Tone\">"), file, FALSE);
				}
				buff[0] = 0;
				SaveVCalendarDateTime(CalSubEntry->GetDateTime(),buff);
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
				sprintf(buff,"</Alarm>");
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_DateTime_End_Repeat:
				sprintf(buff,"    <RepeatStopDate>");
				SaveVCalendarDateTime(CalSubEntry->GetDateTime(),buff);
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
				SaveXMLFilePart(StringToUnicodeReturn("</RepeatStopDate>"), file, TRUE);
				break;
			case Calendar_Int_Repeat_Frequency:
				sprintf(buff,"    <RepeatFrequency>%i</RepeatFrequency>",CalSubEntry->GetInt());
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_Int_Repeat_DayOfWeek:
				sprintf(buff,"    <DayOfWeek>%i</DayOfWeek>",CalSubEntry->GetInt());
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;			
			case Calendar_Int_Repeat_Day:
				sprintf(buff,"    <RepeatDay>%i</RepeatDay>",CalSubEntry->GetInt());
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_Int_Repeat_Month:
				sprintf(buff,"    <RepeatMonth>%i</RepeatMonth>",CalSubEntry->GetInt());
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			}
		}

		SaveXMLFilePart(StringToUnicodeReturn("  </Calendar>"), file, TRUE);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Backup::SaveNoteToXMLFile(FILE *file)
{
	GSM_Backup_NoteEntry	*NoteEntry;
	char			buff[100];
	int			Num;
	
	Num = 1;
	NoteEntry = NULL;
	while (GetNext_Note(&NoteEntry)) {
		sprintf(buff,"  <Note Location=\"%03i\">",NoteEntry->GetEntry()->Location);
		SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);

		sprintf(buff,"    <Text>");
		SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
		SaveXMLFilePart((wchar_t *)NoteEntry->GetEntry()->Text.data(), file, FALSE);
		sprintf(buff,"</Text>");
		SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);

		Num++;

		SaveXMLFilePart(StringToUnicodeReturn("  </Note>"), file, TRUE);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Backup::SaveToDoToXMLFile(FILE *file)
{
	GSM_Backup_ToDoEntry	*ToDoEntry;
	GSM_ToDoSubEntry	*SubEntry;
	char			buff[100];
	int			Num;
	
	Num = 1;
	ToDoEntry = NULL;
	while (GetNext_ToDo(&ToDoEntry)) {
		sprintf(buff,"  <TODO Location=\"%03i\">",ToDoEntry->GetEntry()->Location);
		SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);

	        SubEntry = NULL;
	        while (ToDoEntry->GetEntry()->GetNext(&SubEntry)) {
            		switch (SubEntry->Type) {
		        case ToDo_Text_Text:
				sprintf(buff,"    <Text>");
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
				SaveXMLFilePart((wchar_t *)SubEntry->Text.data(), file, FALSE);
				sprintf(buff,"</Text>");
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
		                break;
		        case ToDo_Priority:
		                switch (SubEntry->Priority) {
				case GSM_Priority_High:
					SaveXMLFilePart(StringToUnicodeReturn("    <Priority>High</Priority>"), file, TRUE);
					break;
				case GSM_Priority_Medium:
					SaveXMLFilePart(StringToUnicodeReturn("    <Priority>Medium</Priority>"), file, TRUE);
					break;
				case GSM_Priority_Low:
					SaveXMLFilePart(StringToUnicodeReturn("    <Priority>Low</Priority>"), file, TRUE);
					break;
		                }
		                break;
		        case ToDo_Bool_Completed:
				SaveXMLFilePart(StringToUnicodeReturn("    <Completed>yes</Completed>"), file, TRUE);
				break;
		        case ToDo_DateTime_End:
				sprintf(buff,"    <DueTime>");
				SaveVCalendarDateTime(&SubEntry->DT,buff);
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
				sprintf(buff,"</DueTime>");
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
		                break;
		        case ToDo_DateTime_ToneAlarm:
				sprintf(buff,"    <Alarm Type=\"Tone\">");
				SaveVCalendarDateTime(&SubEntry->DT,buff);
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
				sprintf(buff,"</Alarm>");
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
		                break;
		        case ToDo_DateTime_SilentAlarm:
				sprintf(buff,"    <Alarm Type=\"Silent\">");
				SaveVCalendarDateTime(&SubEntry->DT,buff);
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);
				sprintf(buff,"</Alarm>");
				SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
			}
		}
		Num++;
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Backup::SaveToXMLFile(char *FileName)
{
	INI_File		File;
	FILE			*file;
	char			buff[100];
	GSM_DateTime		DT;

	if (FileName[0] == 0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);
	file = fopen(FileName,"wb");
	if (file == NULL) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	sprintf(buff,"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
	fwrite(buff,1,strlen(buff),file);

	SaveXMLFilePart(StringToUnicodeReturn("<!-- This file datas are compatible with Gammu+"),file,TRUE);
	SaveXMLFilePart(StringToUnicodeReturn("     and some based on them programs. See www.gammu.org for more info"), file, TRUE);
	SaveXMLFilePart(StringToUnicodeReturn("-->"), file, TRUE);

	SaveXMLFilePart(StringToUnicodeReturn("<Backup Format=\"1.05\""), file, FALSE);

	sprintf(buff," Creator=\"Gammu+ %s",VERSION);
	if (strlen(GetOS()) != 0) sprintf(buff+strlen(buff),", %s",GetOS());
	if (strlen(GetCompiler()) != 0) sprintf(buff+strlen(buff),", %s",GetCompiler());
	sprintf(buff+strlen(buff),"\"");
	SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);

	sprintf(buff," DateTime=\"");
	GSM_GetCurrentDateTime(&DT);
	SaveVCalendarDateTime(&DT,buff);
	SaveXMLFilePart(StringToUnicodeReturn(buff), file, FALSE);

	SaveXMLFilePart(StringToUnicodeReturn("\">"), file, TRUE);

	SaveXMLFilePart(StringToUnicodeReturn("  <Device>"), file, TRUE);
		sprintf(buff,"    <IMEI>%s</IMEI>",DeviceIMEI);
		SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
		sprintf(buff,"    <Phone>%s</Phone>",DeviceModel);
		SaveXMLFilePart(StringToUnicodeReturn(buff), file, TRUE);
	SaveXMLFilePart(StringToUnicodeReturn("  </Device>"), file, TRUE);

	SavePbkToXMLFile(file);
	SaveCalendarToXMLFile(file);
        SaveNoteToXMLFile(file);
        SaveToDoToXMLFile(file);

	SaveXMLFilePart(StringToUnicodeReturn("</Backup>"), file, TRUE);

	fclose(file);

	return GSM_Return_Error(GSM_ERR_UNKNOWN);
}
