/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../../device/gsmdev.h"
#include "../../service/gsmmisc.h"
#include "obex.h"

GSM_Error GSM_Protocol_OBEX::Open(char *Prot)
{
        if (!strcmp(Prot,"irdaobex")) return GSM_Return_Error(GSM_ERR_NONE);
        return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Protocol_OBEX::Close()
{
        return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Protocol_OBEX::Write(unsigned char *buffer, int length, unsigned char type)
{
	unsignedstring Buffer;

	Buffer.push_back(type);
	Buffer.push_back((length+3)/256);
	Buffer.push_back((length+3)%256);
	Buffer.append(buffer,length);

//	GSM_Protocol::Write(buffer,length,type);
	GSM_Protocol::Write((unsigned char *)Buffer.data(),Buffer.size(),type);
	return (*Device)->Write(Buffer.data(),Buffer.size());
}

GSM_Error GSM_Protocol_OBEX::Dispatch(unsigned char *buffer, int length, int *position)
{
	int len, i = (*position);

	while (i < length) {
		if (State == MSG_Sync) {
			MsgReceived.Type 	= buffer[i];	
			State 			= MSG_Length1;
		} else if (State == MSG_Length1) {
			MsgReceived.Length 	= buffer[i]*256;
			State 			= MSG_Length2;
		} else if (State == MSG_Length2) {
			MsgReceived.Buffer.clear();
			MsgReceived.Length 	= MsgReceived.Length + buffer[i];
			State 			= MSG_Message;
		} else if (State == MSG_Message) {
			len = length - i;
			if (len > MsgReceived.Length) len = MsgReceived.Length;

			MsgReceived.Buffer.append((const unsigned char *)buffer+i,len);
			i+=len;

			if (MsgReceived.Buffer.size() < (unsigned int)MsgReceived.Length) continue;

			(*position)		= i;
			State 			= MSG_Sync;
			return GSM_Return_Error(GSM_ERR_NEWMESSAGE);
		}
		i++;
	}
	(*position) = i;
	return GSM_Return_Error(GSM_ERR_NONE);
}
