/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdio.h>

#include "../../service/gsmmisc.h"
#include "../../misc/misc.h"
#include "../gsmprot.h"

const unsigned char FBUS2_ACK_TYPE		= 0x7F;
const unsigned char FBUS2_MAX_TRANSMIT_LENGTH 	= 120;

class GSM_Protocol_FBUS2:virtual public GSM_Protocol
{
public:
        GSM_Protocol_FBUS2(GSM_Device **Dev, DebugInfo **Deb):GSM_Protocol(Dev,Deb) {
		Info.push_back(GSM_Protocol_Info("serial", "fbus",     false, true));
		Info.push_back(GSM_Protocol_Info("serial", "dku5fbus", false, false));
		Info.push_back(GSM_Protocol_Info("serial", "dku5",     false, false));
		Info.push_back(GSM_Protocol_Info("serial", "fbusdlr3", false, true));
		Info.push_back(GSM_Protocol_Info("serial", "dlr3",     false, true));
		Pos 			= 0;
		SendSequenceByte 	= 0;
        }
        ~GSM_Protocol_FBUS2() {
        }

        GSM_Error Open		(char *Prot);
        GSM_Error Close		();
        GSM_Error Write		(unsigned char *buffer, int length, unsigned char type);
	GSM_Error Dispatch	(unsigned char *buffer, int length, int *position);
private:
	unsigned char		Frame_ID;
	unsigned char		PC_ID;
	unsigned char		Phone_ID;

	/* Sending */
	unsigned char		SendSequenceByte;

	/* Receiving */
	int			Pos;
	unsigned char		CheckSum[2];
	unsigned char		CurFramesLeft,PrevFramesLeft;
	unsigned char		CurSequenceByte,PrevSequenceByte;
        GSM_Protocol_Message    Msg;

	GSM_Error 		WriteSingle(unsigned char *buffer, int length, unsigned char type);
	GSM_Error 		SendAT(char *command, int length, int timeout);
};
