/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../../service/gsmmisc.h"
#include "../../device/gsmdev.h"
#include "fbus2.h"

GSM_Error GSM_Protocol_FBUS2::SendAT(char *command, int length, int timeout)
{
	GSM_Error error;
	int			w = 0;
	bool			wassomething = false;
        unsigned char           ReceivedBuffer[5000];
        int                     ReceivedLen;

	error = (*Device)->Write((unsigned char *)command,length);
	if (error.Code != GSM_ERR_NONE) return error;

	for (w=0;w<timeout;w++) {
		ReceivedLen = 5000;
		error = (*Device)->Read(ReceivedBuffer,&ReceivedLen);
		if (error.Code != GSM_ERR_NONE) return error;

		if (wassomething) {
			if (ReceivedLen==0) return GSM_Return_Error(GSM_ERR_NONE);
		} else {
			if (ReceivedLen>0) return GSM_Return_Error(GSM_ERR_NONE);
		}
#ifdef WIN32
		Sleep(50);
#else
		usleep(500);
#endif
	}
	return GSM_Return_Error(GSM_ERR_TIMEOUT);
}

GSM_Error GSM_Protocol_FBUS2::Open(char *Prot)
{
	unsigned char	FBUS_Init = 0x55;
	GSM_Error 	error;
	int		i;
	unsignedstring	Prot2,Pho2;

        (*Debug)->Deb("[STATE     : opening protocol fbus2]\n");

	Frame_ID = 0x1E;
	PC_ID 	 = 0x0C;
	Phone_ID = 0x00;

        if (!strcmp(Prot,"dku5fbus") || !strcmp(Prot,"dku5") ||
            !strcmp(Prot,"fbusdlr3") || !strcmp(Prot,"dlr3")) {
		error = (*Device)->SetLines(false,false);
		if (error.Code != GSM_ERR_NONE) return error;

#ifdef WIN32
		Sleep(100);
#else
		usleep(10000);
#endif

		error = (*Device)->SetLines(true,true);
		if (error.Code != GSM_ERR_NONE) return error;

		error = (*Device)->SetParameters(19200, 8, false, 1);
		if (error.Code != GSM_ERR_NONE) return error;

		SendAT("AT\r\n",		 4,10);
		SendAT("AT&F\r\n",	 6,10);
		SendAT("AT*NOKIAFBUS\r\n",14,10);

		error = (*Device)->Close();
		if (error.Code != GSM_ERR_NONE) return error;

#ifdef WIN32
		Sleep(50);
#else
		usleep(5000);
#endif

		//a little tricky, but we need serial only and it doesn't use
		//many parameters
	        error=(*Device)->Open("serial",Prot,NULL,NULL,NULL);
	        if (error.Code != GSM_ERR_NONE) return error;

		error = (*Device)->SetParameters(115200, 8, false, 1);
		if (error.Code != GSM_ERR_NONE) return error;

		error = (*Device)->SetLines(false,false);
		if (error.Code != GSM_ERR_NONE) return error;

		for(i=0;i<50;i++) {
			error = (*Device)->Write(&FBUS_Init,1);
			if (error.Code != GSM_ERR_NONE) return error;
#ifdef WIN32
			Sleep(5);
#else
			usleep(500);
#endif
		}

		return GSM_Return_Error(GSM_ERR_NONE);
	}
        if (!strcmp(Prot,"fbus")) {
		error = (*Device)->SetParameters(115200, 8, false, 1);
		if (error.Code != GSM_ERR_NONE) return error;

		error = (*Device)->SetLines(true,false);
		if (error.Code != GSM_ERR_NONE) return error;

		for(i=0;i<50;i++) {
			error = (*Device)->Write(&FBUS_Init,1);
			if (error.Code != GSM_ERR_NONE) return error;
#ifdef WIN32
			Sleep(5);
#else
			usleep(500);
#endif
		}

		return GSM_Return_Error(GSM_ERR_NONE);
	}
        return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Protocol_FBUS2::Close()
{
        return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Protocol_FBUS2::WriteSingle(unsigned char *buffer, int length, unsigned char type)
{
	unsignedstring 	Buffer;
	unsigned char	CheckSum;
	unsigned int 	j;

	/* Header */
	Buffer.push_back(Frame_ID);
	Buffer.push_back(Phone_ID);
	Buffer.push_back(PC_ID);
	Buffer.push_back(type);
	Buffer.push_back(length/256);
	Buffer.push_back(length%256);
	/* Message */
	Buffer.append((const unsigned char *)buffer,length);
	/* After message */
	if (length%2) Buffer.push_back(0x00);
	CheckSum = 0;
	for (j=0;j<Buffer.size();j+=2) CheckSum^=Buffer.data()[j];
	Buffer.push_back(CheckSum);
	CheckSum = 0;
	for (j=1;j<Buffer.size()-1;j+=2) CheckSum^=Buffer.data()[j];
	Buffer.push_back(CheckSum);

	return (*Device)->Write(Buffer.data(),Buffer.size());
}

GSM_Error GSM_Protocol_FBUS2::Write(unsigned char *buffer, int length, unsigned char type)
{
	unsigned int	FramesNum   = (length+FBUS2_MAX_TRANSMIT_LENGTH-1) / FBUS2_MAX_TRANSMIT_LENGTH;
	unsigned int 	BytesToSend = length;
	unsigned int	i, Bytes;
	unsignedstring  Buffer;
	GSM_Error 	error;

	GSM_Protocol::Write(buffer,length,type);

	for (i=0; i<FramesNum; i++) {
		Bytes = BytesToSend;
		if (Bytes > FBUS2_MAX_TRANSMIT_LENGTH) Bytes = FBUS2_MAX_TRANSMIT_LENGTH;

		Buffer.clear();
		Buffer.append((const unsigned char *)buffer+(length-BytesToSend),Bytes);
		Buffer.push_back(FramesNum-i);
		if (i==0) {
			Buffer.push_back(SendSequenceByte | 0x40);
		} else {
			Buffer.push_back(SendSequenceByte);			
		}

		SendSequenceByte = (SendSequenceByte+1) & 0x07;
		BytesToSend 	 = BytesToSend - Bytes;

		error = WriteSingle((unsigned char *)Buffer.data(),Buffer.size(),type);
		if (error.Code!=GSM_ERR_NONE) return error;
	}

        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Protocol_FBUS2::Dispatch(unsigned char *buffer, int length, int *position)
{
	int 		i = (*position);
	unsigned char 	Buffer[2];
	GSM_Error	error;

	while (i < length) {
		/* Checksum */
		switch(State) {
		case MSG_CheckSum1:
		case MSG_CheckSum2:
			break;
		case MSG_Sync:
			CheckSum[0] = 0;
			CheckSum[1] = 0;
			Pos	    = 0;
			/* No break */
		default:
			CheckSum[Pos%2] ^= buffer[i];
			Pos++;
		}

		/* Frame */
		if (State == MSG_Sync) {
			CheckReadByte(buffer[i], Frame_ID, MSG_Destination);
		} else if (State == MSG_Destination) {
			CheckReadByte(buffer[i], PC_ID, MSG_Source);
		} else if (State == MSG_Source) {
			CheckReadByte(buffer[i], Phone_ID, MSG_Type);
		} else if (State == MSG_Type) {
			MsgReceived.Type 	= buffer[i];	
			State 			= MSG_Length1;
		} else if (State == MSG_Length1) {
			MsgReceived.Length 	= buffer[i]*256;
			State 			= MSG_Length2;
		} else if (State == MSG_Length2) {
			MsgReceived.Buffer.clear();
			MsgReceived.Length 	= MsgReceived.Length+buffer[i]-2;
			State 			= MSG_Message;
			if (MsgReceived.Length == 0) State = MSG_FramesNum;
		} else if (State == MSG_Message) {
			MsgReceived.Buffer.push_back(buffer[i]);
			i++;
			if (MsgReceived.Buffer.size() != MsgReceived.Length) continue;
			State = MSG_FramesNum;
			continue;
		} else if (State == MSG_FramesNum) {
			PrevFramesLeft		= CurFramesLeft;
			CurFramesLeft 		= buffer[i];
			State 			= MSG_Sequence;
		} else if (State == MSG_Sequence) {
			PrevSequenceByte	= CurSequenceByte;
			CurSequenceByte 	= buffer[i];
			State 			= MSG_CheckSum1;
			if ((MsgReceived.Length+2)%2) State = MSG_Padding;
		} else if (State == MSG_Padding) {
			CheckReadByte(buffer[i], 0x00, MSG_CheckSum1);
		} else if (State == MSG_CheckSum1) {
			if (buffer[i] != CheckSum[0]) {
				(*Debug)->Deb("ERROR: Incorrect CheckSum 1\n");
				State = MSG_Sync;
				i++;
				continue;
			}
			State = MSG_CheckSum2;
		} else if (State == MSG_CheckSum2) {
			if (buffer[i] != CheckSum[1]) {
				(*Debug)->Deb("ERROR: Incorrect CheckSum 2\n");
				State = MSG_Sync;
				i++;
				continue;
			}
			if (MsgReceived.Type == FBUS2_ACK_TYPE) {
				(*Debug)->Deb("RECEIVED ACK type %02X/sequence %02X\n",CurFramesLeft,CurSequenceByte);
				State = MSG_Sync;
				i++;
				continue;
			}
			/* first multiframe msg */
			if ((CurSequenceByte&0x40)==0x40) {
				Msg.Buffer.clear();
				Msg.Type = MsgReceived.Type;
			} else {
				if (CurFramesLeft != PrevFramesLeft) {
					(*Debug)->Deb("ERROR: Missed multiframe message\n");
					State = MSG_Sync;
					i++;
					continue;
				}
				if (Msg.Type != MsgReceived.Type) {
					(*Debug)->Deb("ERROR: Multiframe message with other type\n");
					State = MSG_Sync;
					i++;
					continue;
				}
			}

			Msg.Buffer.append(MsgReceived.Buffer.data(),MsgReceived.Buffer.size());
			CurFramesLeft--;

			Buffer[0] = Msg.Type;
			Buffer[1] = CurSequenceByte & 0x0F;
			(*Debug)->Deb("SENDING ACK type %02X/sequence %02X\n",Buffer[0],Buffer[1]);
			error = WriteSingle(Buffer, 2, FBUS2_ACK_TYPE);
			if (error.Code!=GSM_ERR_NONE) return error;

			State = MSG_Sync;

			if (CurFramesLeft == 0) {
				MsgReceived.Buffer.clear();
				MsgReceived.Buffer.append(Msg.Buffer.data(),Msg.Buffer.size());
				MsgReceived.Length = MsgReceived.Buffer.size();
				i++;
				(*position) = i;
				return GSM_Return_Error(GSM_ERR_NEWMESSAGE);
			}
		}
		i++;
	}
	(*position) = i;
	return GSM_Return_Error(GSM_ERR_NONE);
}
