/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../../device/gsmdev.h"
#include "../../service/gsmmisc.h"
#include "at.h"

GSM_Error GSM_Protocol_AT::Open(char *Prot)
{
	//opening device, setting speed
        if (!strcmp(Prot,"irdaat")) return GSM_Return_Error(GSM_ERR_NONE);
        if (!strcmp(Prot,"blueat")) return GSM_Return_Error(GSM_ERR_NONE);
        return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Protocol_AT::Close()
{
        return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Protocol_AT::Write(unsigned char *buffer, int length, unsigned char type)
{
	unsignedstring Buffer;

	Buffer.append(buffer,length);

	GSM_Protocol::Write((unsigned char *)Buffer.data(),Buffer.size(),type);
	return (*Device)->Write(Buffer.data(),Buffer.size());
}

//handles received from device chars
//updates MsgReceived and returns GSM_ERR_NEWMESSAGE
//when have complete message
GSM_Error GSM_Protocol_AT::Dispatch(unsigned char *buffer, int length, int *position)
{
	while ((*position) < length) {
		if (State == MSG_Sync) {
			State = MSG_Message;
			MsgReceived.Length=0;
			MsgReceived.Buffer.clear();
		}
		//we remove 0x10 chars
		if (buffer[(*position)]==10) {
			(*position)++;
			continue;
		}
		MsgReceived.Buffer.push_back(buffer[(*position)]);
		MsgReceived.Length++;
		(*position)++;

		if (strstr((char *)MsgReceived.Buffer.data(),(char *)"OK") != NULL) {
			State = MSG_Sync;
			return GSM_Return_Error(GSM_ERR_NEWMESSAGE);
		}
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}
