/* (C) 2005-2006 by Marcin Wiacek www.mwiacek.com */

#include "../../../../cfg/config.h" //msvc2005
#include "../../../protocol/gsmprot.h"
#include "../../../misc/coding/coding.h"
#include "../ndct34.h"
//#include "../../../misc/misc.h"

/* -------------------------------- series 40 3.0 -------------------------- */

GSM_Error GSM_Phone_N6510::GetSMSMMSFolders2(GSM_SMSMMSFolders *Folders)
{
	GSM_FileFolderInfoList		*List;
	GSM_FileFolderInfoListSubEntry  *SubEntry;
	GSM_Error			error;
	BOOLEAN 			Start = TRUE;
	wchart				ID;
	char				buff[100];
	int				Num = 2;

	error = ReadFolderToCache(StringToUnicodeReturn("d:\\predefmessages"), &List);
	if (error.Code != GSM_ERR_NONE) return error;

	SubEntry = NULL;
	while (List->GetNext(&SubEntry) == TRUE) {		
		if (strstr(UnicodeToStringReturn(SubEntry->Info.Name.data()),"predef")!=NULL) {
			continue;
		} else if (!strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"exchange")) {
			continue;
		}

		ID.clear();
		ID.append(SubEntry->Info.ID.data());

		if (!strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"1")) {
			Folders->Add(StringToUnicodeReturn("Inbox"),TRUE,TRUE,FALSE,MEM_PHONE,&ID,1,2);
			Folders->Add(StringToUnicodeReturn("Inbox"),TRUE,TRUE,TRUE,MEM_PHONE,&ID,2,1);
			continue;
		}
		buff[0] = 0;
		if (!strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"3")) {
			sprintf(buff,"Sent items");
		} else if (!strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"4")) {
			sprintf(buff,"Saved items");
		} else if (!strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"5")) {
			sprintf(buff,"Drafts");
		} else if (!strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"6")) {
			sprintf(buff,"Templates");
		} else if (!strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"20")) {
			sprintf(buff,"First user folder");
		}
		Num++;
		if (buff[0] != 0) {
			Folders->Add(StringToUnicodeReturn(buff),TRUE,FALSE,FALSE,MEM_PHONE,&ID,Num,Num+1);
			Num++;
			Folders->Add(StringToUnicodeReturn(buff),TRUE,FALSE,TRUE,MEM_PHONE,&ID,Num,Num-1);
		} else {
			Folders->Add((wchar_t *)SubEntry->Info.Name.data(),TRUE,FALSE,FALSE,MEM_PHONE,&ID,Num,Num+1);
			Num++;
			Folders->Add((wchar_t *)SubEntry->Info.Name.data(),TRUE,FALSE,TRUE,MEM_PHONE,&ID,Num,Num-1);
		}
	}

        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::GetSMS2(GSM_SMSList *List, GSM_File *File)
{
	unsigned int 	i = 176, start = 176, j;
	GSM_SMSEntry 	*SMS;
	double		g;
	BOOLEAN		first=TRUE;

	SMS = new (GSM_SMSEntry);

	List->ClearAll();

	(*Debug)->Deb("sms file %02x\n",File->Buffer.data()[start]);
	if (UnicodeLength(NokiaGetUnicodeString(File->Buffer.data()+94)) != 0) {
		SMS->PhoneNumbers.Add(NokiaGetUnicodeString(File->Buffer.data()+94));
	}
	switch (File->Buffer.data()[start]) {
	case 0x00:
	case 0x04:
	case 0x11:
	case 0x20:
	case 0x24:
	case 0x60:
		if(File->Buffer.data()[start]==0x11) {
			i+=15;
			SMS->firstbyte = 1; //fixme
			SMS->TPDCS=File->Buffer.data()[i];
			i+=2;
		} else {
			SMS->firstbyte = File->Buffer.data()[i];
			//semioctets to chars in phone number
			j = File->Buffer.data()[i+1];
			if (j % 2) j++;
			i+=(j / 2 + 1);
			SMS->TPDCS=File->Buffer.data()[i+3];
			i+=11;
		}

		j = File->Buffer.data()[i];
		SMS->TPUDL = j;
		if (SMS->GetCoding() == SMS_Coding_Default_No_Compression) {
			//we need to find, if part of byte was used or not
			g = ((double)j*7/8) - (unsigned int)((j*7/8));
			j = j*7/8;
			if (g != 0.0) j++;
		}
		SMS->UserData.append((const unsigned char *)(File->Buffer.data()+i+1),j);
		i+=j;
//		i+=SMS->TPUDL;
		i+=11;
	(*Debug)->Deb("%02x %02x %02x\n",File->Buffer.data()[i],File->Buffer.data()[i+1],File->Buffer.data()[i+2]);
	(*Debug)->Deb("%i %i\n",i,File->Buffer.size());
		if (i<File->Buffer.size()) {
			SMS->SetSMSCNumber(StringToUnicodeReturn((char *)(File->Buffer.data()+i)));
			j=strlen((const char *)(File->Buffer.data()+i));
			i+=j+4;
			SMS->Name.append(NokiaGetUnicodeString(File->Buffer.data()+i),UnicodeLength(NokiaGetUnicodeString(File->Buffer.data()+i)));
		}
		break;
	case 0x31:
	case 0x51:
	case 0x71:
		if(File->Buffer.data()[start]!=0x31) SMS->firstbyte = File->Buffer.data()[i];
		if (UnicodeLength(NokiaGetUnicodeString(File->Buffer.data()+94)) == 0x00) {
			//semioctets to chars in phone number
			j = File->Buffer.data()[i+2];
			if (j % 2) j++;
			i+=(j/2 + 1) + 4;
		} else {
			i+=15;
		}
		if(File->Buffer.data()[start]==0x31) SMS->firstbyte = 1; //fixme
		SMS->SetType(SMS_Deliver);

		SMS->TPDCS=File->Buffer.data()[i];
		i+=2;

		j = File->Buffer.data()[i];
		SMS->TPUDL = j;
		if (SMS->GetCoding() == SMS_Coding_Default_No_Compression) {
			//we need to find, if part of byte was used or not
			g = ((double)j*7/8) - (unsigned int)((j*7/8));
			j = j*7/8;
			if (g != 0.0) j++;
		}
		SMS->UserData.append((const unsigned char *)File->Buffer.data()+i+1,j);
		i+=j;
		i+=11;
		SMS->Name.append(NokiaGetUnicodeString(File->Buffer.data()+i),UnicodeLength(NokiaGetUnicodeString(File->Buffer.data()+i)));
		if (UnicodeLength(NokiaGetUnicodeString(File->Buffer.data()+94)) != 0x00) {
			break;
		}
		i+=SMS->Name.length()*2+5;
		while (true) {
			if (File->Buffer.data()[i+1]!=0x00) {
				SMS->PhoneNumbers.Add(NokiaGetUnicodeString(File->Buffer.data()+i));
				i+=UnicodeLength(NokiaGetUnicodeString(File->Buffer.data()+i))*2+13;
				continue;
			}
			break;
		}
		break;
	case 0x44:
	case 0x40://40 without name
	case 0x64://64 without name
		SMS->firstbyte = File->Buffer.data()[i];

		//semioctets to chars in phone number
		j = File->Buffer.data()[i+1];
		if (j % 2) j++;
		i+=(j / 2 + 1);

		SMS->TPDCS=File->Buffer.data()[i+3];

		j = File->Buffer.data()[i+11];
		SMS->TPUDL = j;
		if (SMS->GetCoding() == SMS_Coding_Default_No_Compression) {
			//we need to find, if part of byte was used or not
			g = ((double)j*7/8) - (unsigned int)((j*7/8));
			j = j*7/8;
			if (g != 0.0) j++;
		}
		i+=12;
		SMS->UserData.append((const unsigned char *)File->Buffer.data()+i,j);
//		i+=j;
		if (File->Buffer.data()[start]!=0x64) {
			i+=SMS->TPUDL-12;
			(*Debug)->Deb("%02x %02x %02x\n",File->Buffer.data()[i+2],File->Buffer.data()[i+3],File->Buffer.data()[i+4]);
			(*Debug)->Deb("%i %i\n",i,File->Buffer.size());
			if (i<File->Buffer.size()-10) {
				SMS->SetSMSCNumber(StringToUnicodeReturn((char *)(File->Buffer.data()+i+2)));
			}
		}
		break;
	default:
	        return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}

	SMS->SetDateTime(&File->Info.ModificationDateTime);

	SMS->ID.clear();
	SMS->ID.append((const wchar_t *)File->Info.ID.data(),UnicodeLength(File->Info.ID.data()));
	SMS->Memory 	= MEM_PHONE;
	SMS->Icon 	= SMS_Read;
	List->Add(SMS);

        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::GetNextSMSMMSIDFromFolder2(BOOLEAN start, GSM_SMSMMSFoldersSubEntry *SMSFolder, GSM_SMSList *SMS, GSM_MMSEntry *MMS, int *Current, int *MaxInFolder)
{
	GSM_Error	error;
	GSM_File 	File;
	BOOLEAN		Found;

	if (start) {
		SMSListMax = 0;

		Found = FALSE;
		if (FoldersCacheSubEntry!=NULL) delete(FoldersCacheSubEntry);
		FoldersCacheSubEntry = NULL;
		while (FoldersCache.GetNext(&FoldersCacheSubEntry)) {
			if (!wcscmp(FoldersCacheSubEntry->Info.Info.ID.data(),(wchar_t *)SMSFolder->ID.data())) {
				Found = TRUE;
				break;
			}
		}

		if (Found) {
			SMSCache2 = FoldersCacheSubEntry;
			FoldersCacheSubEntry = NULL;
			GetNextSMSFolder2.Code = GSM_ERR_NONE;
			SMSSubEntry = NULL;
			while (SMSCache2->Info.GetNext(&SMSSubEntry)) SMSListMax++;
		} else {
			FoldersCacheSubEntry = new GSM_FileFolderInfoListsSubEntry;			
			GetNextSMSFolder2.Code = GSM_ERR_FOLDER_MORE;
			FoldersCacheSubEntry->Info.Info.SetID((wchar_t *)SMSFolder->ID.data());
		}

		SMSListPos = 0;
		SMSSubEntry = NULL;
	}
	if (GetNextSMSFolder2.Code == GSM_ERR_FOLDER_MORE) {
		GetNextSMSFolder2 = GetFolderInfoList(&FoldersCacheSubEntry->Info,start);
		switch (GetNextSMSFolder2.Code) {
		case GSM_ERR_NONE:
			FoldersCache.AddSubEntry(FoldersCacheSubEntry);
			SMSCache2 = FoldersCacheSubEntry;
			FoldersCacheSubEntry = NULL;
			break;
		case GSM_ERR_FOLDER_PART:
			FoldersCache.AddSubEntry(FoldersCacheSubEntry);
			SMSCache2 = FoldersCacheSubEntry;
			FoldersCacheSubEntry = NULL;
			//no break
		case GSM_ERR_FOLDER_MORE:
			SMSListMax++;
			//no break;
		default:
			return GetNextSMSFolder2;
		}
	}

	*MaxInFolder = SMSListMax;
	while (1) {
		//getting next file from folder
		SMSListPos++;
		if (SMSCache2->Info.GetNext(&SMSSubEntry)) {
			File.Info.SetID((wchar_t *)SMSSubEntry->Info.ID.data());
			File.Buffer.clear();

			while (true) {
				error = GetFilePart2(&File);				
				if (error.Code != GSM_ERR_NONE) return error;

				//MMS file
				if (File.Buffer.size()>5 && File.Buffer.data()[6] != 0x00) {
					if (File.Info.Size != File.Buffer.size()) {
						error = CloseFile2(&File);
						if (error.Code != GSM_ERR_NONE) return error;
					}
					SMS->Folder = 0;
					if (SMSFolder->MMS) {
						MMS->Folder = SMSFolder->Number;
					} else {
						MMS->Folder = SMSFolder->Number+1;
					}
					MMS->File.Info.SetID((wchar_t *)SMSSubEntry->Info.ID.data());
					*Current = SMSListPos;
					return GSM_Return_Error(GSM_ERR_NONE);
				}
	
				//full SMS file
				if (SMSSubEntry->Info.Size == File.Buffer.size()) {
					memcpy(&File.Info.ModificationDateTime,&SMSSubEntry->Info.ModificationDateTime,sizeof(GSM_DateTime));
					MMS->Folder	= 0;
					if (SMSFolder->MMS) {
						SMS->Folder	= SMSFolder->Number-1;
					} else {
						SMS->Folder	= SMSFolder->Number;
					}
					*Current 	= SMSListPos;
					return GetSMS2(SMS,&File);
				}
			}
			continue;
		}
		return GSM_Return_Error(GSM_ERR_EMPTY);
	}
}

GSM_Error GSM_Phone_N6510::DeleteSMS2(GSM_SMSList *List)
{
	GSM_SMSListSubEntry 	*SubEntry;
	GSM_Error		error;

	SubEntry = NULL;
	while (List->GetNext(&SubEntry) == TRUE) {
		error = DeleteFile((wchar_t *)SubEntry->GetSMS()->ID.data());
		if (error.Code != GSM_ERR_NONE) return error;
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

/* -------------------------------- series 40 1.0 & 2.0 -------------------- */

GSM_Error GSM_Phone_N6510::ReplyGetSMSFolders1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSMMSFolders 		*Folders = (GSM_SMSMMSFolders *)S;
	unsigned int			i, current = 6, num = 0;
	GSM_SMSMMSFoldersSubEntry  	*SubFolder;
	wchart				ID;
	char				buff[10];

	(*Debug)->Deb("RECEIVED: SMS folders\n");
	for (i=0;i<msg->Buffer.data()[5];i++) {
		while (true) {
			if (msg->Buffer.data()[current]   == msg->Buffer.data()[6] &&
			    msg->Buffer.data()[current+1] == msg->Buffer.data()[7]) break;
			if (current+4 > msg->Buffer.size()) return GSM_Return_Error(GSM_ERR_UNKNOWN);
			current++;
		}
		current+=4;
		sprintf(buff,"%i",num+1);
		ID.clear();
		ID.append(StringToUnicodeReturn(buff));
		switch (num) {
		case 0x00:
			num++;
			Folders->Add(NokiaGetUnicodeString(msg->Buffer.data()+current),FALSE,TRUE,FALSE,MEM_SIM,&ID,num,-1);
			break;
		case 0x01:
			num++;
			Folders->Add(NokiaGetUnicodeString(msg->Buffer.data()+current),FALSE,FALSE,FALSE,MEM_SIM,&ID,num,-1);
			SubFolder = NULL;
			Folders->GetNext(&SubFolder);
			sprintf(buff,"%i",num+1);
			ID.clear();
			ID.append(StringToUnicodeReturn(buff));
			num++;
			Folders->Add(SubFolder->GetName(),FALSE,TRUE,FALSE,MEM_PHONE,&ID,num,-1);
			sprintf(buff,"%i",num+1);
			ID.clear();
			ID.append(StringToUnicodeReturn(buff));
			num++;
			Folders->Add(NokiaGetUnicodeString(msg->Buffer.data()+current),FALSE,FALSE,FALSE,MEM_PHONE,&ID,num,-1);
			break;
		default:
			num++;
			Folders->Add(NokiaGetUnicodeString(msg->Buffer.data()+current),FALSE,FALSE,FALSE,MEM_PHONE,&ID,num,-1);
		}
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::GetSMSMMSFolders1(GSM_SMSMMSFolders *Folders)
{
	unsigned char 			Buff[] = {NOKIA_FRAME1, 0x12, 0x00, 0x00};
	GSM_Error			error;
	GSM_FileFolderInfoList		*List;
	GSM_FileFolderInfoListSubEntry  *SubEntry;
	int 				Num=0;//fixme
	char 				buff[200];
	BOOLEAN 			Inbox;
	wchart 				ID2;
	GSM_SMSMMSFoldersSubEntry  	*SubEntry2;

	if ((*Phones)->Feature("s40_30") && (*Phones)->Feature("sms1")) {
		ID2.clear(); ID2.push_back('1');
		Folders->Add(StringToUnicodeReturn("SIM"),FALSE,FALSE,FALSE,MEM_SIM,&ID2,1,-1);
		ID2.clear(); ID2.push_back('2');
		Folders->Add(StringToUnicodeReturn("Inbox"),FALSE,TRUE,FALSE,MEM_SIM,&ID2,2,-1);
		ID2.clear(); ID2.push_back('3');
		Folders->Add(StringToUnicodeReturn("Sent items"),FALSE,FALSE,FALSE,MEM_SIM,&ID2,3,-1);
		ID2.clear(); ID2.push_back('4');
		Folders->Add(StringToUnicodeReturn("Saved items"),FALSE,FALSE,FALSE,MEM_SIM,&ID2,4,-1);
	} else {
		(*Debug)->Deb("SENT: getting SMS folders\n");
		error = Write(Buff, sizeof(Buff), 0x14, 4, ID_GetSMSFolders+ID, Folders);
		if (error.Code != GSM_ERR_NONE) return error;
	}

	if ((*Phones)->Feature("nofilesystem")) return error;

	SubEntry2 = NULL;
	while (Folders->GetNext(&SubEntry2)) Num++;
	Num++;

	while (1) {
		error = ReadFolderToCache(StringToUnicodeReturn("c:\\1"), &List);
		if (error.Code == GSM_ERR_FILE_FOLDER_NOT_EXIST) break;
		if (error.Code != GSM_ERR_NONE) return error;

		SubEntry = NULL;
		while (List->GetNext(&SubEntry)) {
			if (!List->SubEntryFullData) {
				error = GetFileFolderInfo(&SubEntry->Info);
				if (error.Code != GSM_ERR_NONE) return error;
			}
			if (strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"Messages")) {
				continue;
			}
	
			error = ReadFolderToCache((wchar_t *)SubEntry->Info.ID.data(), &List);
			if (error.Code != GSM_ERR_NONE) return error;
	
			SubEntry = NULL;
			while (List->GetNext(&SubEntry)) {
				if (!List->SubEntryFullData) {
					error = GetFileFolderInfo(&SubEntry->Info);
					if (error.Code != GSM_ERR_NONE) return error;
				}
				ID2.clear();
				ID2.append(SubEntry->Info.ID.data());
				Inbox = FALSE;
				if (!strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"Inbox")) {
					Inbox = TRUE;
				}
				Folders->Add((wchar_t *)SubEntry->Info.Name.data(),TRUE,Inbox,TRUE,MEM_PHONE,&ID2,Num,-1);
				Num++;			
			}
			break;
		}
		break;
	}

	//6230i
	if (!(*Phones)->Feature("nofilesystem") && !(*Phones)->Feature("filesystem1only")) {
		error = ReadFolderToCache(StringToUnicodeReturn("d:\\predefmessages"), &List);
		if (error.Code == GSM_ERR_FILE_FOLDER_NOT_EXIST) return GSM_Return_Error(GSM_ERR_NONE);
		if (error.Code != GSM_ERR_NONE) return error;

		SubEntry = NULL;
		while (List->GetNext(&SubEntry)) {
			Inbox = FALSE;
			buff[0] = 0;
			if (!strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"predefinbox")) {
				sprintf(buff,"Inbox");
				Inbox = TRUE;
			} else if (!strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"predefoutbox")) {
				sprintf(buff,"Outbox");
			} else if (!strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"predefsent")) {
				sprintf(buff,"Sent items");
			} else if (!strcmp(UnicodeToStringReturn(SubEntry->Info.Name.data()),"predefdrafts")) {
				sprintf(buff,"Drafts");
			} else {
				sprintf(buff,"%s",UnicodeToStringReturn(SubEntry->Info.Name.data()));
			}
			ID2.clear();
			ID2.append(SubEntry->Info.ID.data());
			Folders->Add(StringToUnicodeReturn(buff),TRUE,Inbox,TRUE,MEM_PHONE,&ID2,Num,-1);
			Num++;
		}
	}

	return error;
}

GSM_Error GSM_Phone_N6510::ReplyGetSMSStatus1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSStatus *Status = (GSM_SMSStatus *)S;

	(*Debug)->Deb("RECEIVED: SMS status\n");

	switch (msg->Buffer.data()[3]) {
	case 0x09:
		(*Debug)->Deb("  Phone size   : %i\n",msg->Buffer.data()[10]*256+msg->Buffer.data()[11]);
		(*Debug)->Deb("  Phone used   : %i\n",msg->Buffer.data()[12]*256+msg->Buffer.data()[13]);
		(*Debug)->Deb("  Phone unRead : %i\n",msg->Buffer.data()[14]*256+msg->Buffer.data()[15]);
		(*Debug)->Deb("  SIM size   : %i\n",msg->Buffer.data()[22]*256+msg->Buffer.data()[23]);
		(*Debug)->Deb("  SIM used   : %i\n",msg->Buffer.data()[24]*256+msg->Buffer.data()[25]);
		(*Debug)->Deb("  SIM unRead : %i\n",msg->Buffer.data()[26]*256+msg->Buffer.data()[27]);

		if (Status->Memory==MEM_SIM) {
			Status->SMSUnRead = msg->Buffer.data()[26]*256+msg->Buffer.data()[27];
			Status->SMSFree   = msg->Buffer.data()[22]*256+msg->Buffer.data()[23]-(msg->Buffer.data()[24]*256+msg->Buffer.data()[25]);
			Status->SMSRead   = msg->Buffer.data()[22]*256+msg->Buffer.data()[23]-Status->SMSFree-Status->SMSUnRead;
		} else {
			Status->SMSUnRead = msg->Buffer.data()[14]*256+msg->Buffer.data()[15];
			Status->SMSFree   = msg->Buffer.data()[10]*256+msg->Buffer.data()[11]-(msg->Buffer.data()[12]*256+msg->Buffer.data()[13]);
			Status->SMSRead   = msg->Buffer.data()[10]*256+msg->Buffer.data()[11]-Status->SMSFree-Status->SMSUnRead;
		}
	
		return GSM_Return_Error(GSM_ERR_NONE);
	default:
	        return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}
}

GSM_Error GSM_Phone_N6510::GetSMSStatus1(GSM_SMSStatus *Status)
{
	GSM_Error	error;
	unsigned char 	Buff[] = {NOKIA_FRAME1, 0x08, 0x00, 0x00};
	GSM_SMS_Loc 	SMSLocations;

	if (Status->Memory!=MEM_SIM && Status->Memory!=MEM_PHONE) {
		return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
	}

	(*Debug)->Deb("SENT: getting status for SMS\n");
	error = Write(Buff, sizeof(Buff), 0x14, 4, ID_GetSMSStatus+ID, Status);
	if (error.Code != GSM_ERR_NONE || Status->Memory==MEM_SIM) return error;

	//status of Templates folder
	SMSLocations.FolderID = 0x06;
	error = GetSMSFolderStatus1(&SMSLocations);
	if (error.Code != GSM_ERR_NONE) return error;

	Status->SMSTemplates = SMSLocations.Locations.size();

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::ReplyGetSMSFolderStatus1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	int		i, last = 0;
	GSM_SMS_Loc 	*SMSLocations = (GSM_SMS_Loc *)S;
	unsignedint	s2;

	(*Debug)->Deb("RECEIVED: SMS folder status received\n");

	(*Debug)->Deb("  locations ");
	for (i=0;i<msg->Buffer.data()[6]*256+msg->Buffer.data()[7];i++) {
		(*Debug)->Deb("%i ",msg->Buffer.data()[8+(i*2)]*256+msg->Buffer.data()[(i*2)+9]);
		if (msg->Buffer.data()[8+(i*2)]*256+msg->Buffer.data()[(i*2)+9] < last) {
			//pushing int on front
			s2.clear();
			SMSLocations->Locations.swap(s2);
			SMSLocations->Locations.push_back(msg->Buffer.data()[8+(i*2)]*256+msg->Buffer.data()[(i*2)+9]);
			SMSLocations->Locations.append(s2);
		} else {
			SMSLocations->Locations.push_back(msg->Buffer.data()[8+(i*2)]*256+msg->Buffer.data()[(i*2)+9]);
		}
		last = msg->Buffer.data()[8+(i*2)]*256+msg->Buffer.data()[(i*2)+9];
	}
	(*Debug)->Deb("\n");

	(*Debug)->Deb("  locations ");
	for (i=0;i<msg->Buffer.data()[6]*256+msg->Buffer.data()[7];i++) {
		(*Debug)->Deb("%i ",SMSLocations->Locations.data()[i]);
	}
	(*Debug)->Deb("\n");

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::GetSMSFolderStatus1(GSM_SMS_Loc *SMSLocations)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x0C,
				0x01,		// 0x01=SIM, 0x02=ME
				0x00,		// folder ID
				0x0F, 0x55, 0x55, 0x55};

	switch (SMSLocations->FolderID) {
	case 0x01: // SIM Inbox
		Buff[5] = 0x02;
		break;
	case 0x02: // SIM Outbox
		Buff[5] = 0x03;
		break;
	default: // ME
		Buff[4] = 0x02;
		Buff[5] = SMSLocations->FolderID - 1;
	}

	(*Debug)->Deb("SENT: getting SMS folder status\n");
	return Write(Buff, sizeof(Buff), 0x14, 4, ID_GetSMSFolderStatus+ID, SMSLocations);
}

GSM_Error GSM_Phone_N6510::ReplyGetSMS1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSList 		*List = (GSM_SMSList *)S;
	GSM_SMSListSubEntry	*SubEntry = NULL;
	GSM_SMSEntry 		SMS;
	GSM_Error		error;

	switch (msg->Buffer.data()[3]) {
	case 0x03:
		(*Debug)->Deb("RECEIVED: SMS message\n");
		switch (msg->Buffer.data()[5]) {
			case  1 : SMS.Icon = SMS_Read;   break;
			case  3 : SMS.Icon = SMS_UnRead; break;
			case  5 : SMS.Icon = SMS_Sent;   break;
			case  7 : SMS.Icon = SMS_UnSent; break;
			default : return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
		}
		SMS.SaveDateTimeAvailable = FALSE;
		switch (msg->Buffer.data()[14]) {
		case 0x00:
		case 0x01:
		case 0x02:
			SMS.SaveDateTime.Year = 0;
			error = DecodeSMSFrame1(&SMS,msg->Buffer.data()+16,msg->Buffer.size()-16,&SMS.SaveDateTime);
			if (error.Code == GSM_ERR_NONE) {
				if (SMS.SaveDateTime.Year != 0) SMS.SaveDateTimeAvailable = TRUE;
				List->ClearAll();
				List->Add(&SMS);
			}
			return error;
		case 0xA0: // Picture message
			List->ClearAll();
		        return GSM_Return_Error(GSM_ERR_NONE);
		}
		return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
	case 0x0F:
		(*Debug)->Deb("RECEIVED: name for SMS message\n");
		while (List->GetNext(&SubEntry) == TRUE) {
			SubEntry->GetSMS()->Name.append(NokiaGetUnicodeString(msg->Buffer.data()+52),UnicodeLength(NokiaGetUnicodeString(msg->Buffer.data()+52)));
		}
	        return GSM_Return_Error(GSM_ERR_NONE);
	}
	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N6510::GetSMS1(GSM_SMSList *List, wchart SMS_ID)
{
	GSM_Error		error;
	GSM_SMSListSubEntry	*SubEntry = NULL;
	unsigned char		FolderID;
	int			Location;
	unsigned char 		Buff[] = {NOKIA_FRAME1, 0x02,
					  0x01,		// 0x01=SIM, 0x02=ME
					  0x00,		// folder ID
					  0x00, 0x00,	// location
					  0x01, 0x00};

	error = GetSMSLocation(SMS_ID, &FolderID, &Location);
	if (error.Code != GSM_ERR_NONE) return error;

	switch (FolderID) {
	case 0x01: // SIM Inbox
		Buff[5] = 0x02;
		break;
	case 0x02: // SIM Outbox
		Buff[5] = 0x03;
		break;
	default: // ME
		Buff[4] = 0x02;
		Buff[5] = FolderID - 1;
	}

	Buff[6]=Location / 256;
	Buff[7]=Location % 256;

	(*Debug)->Deb("SENT: getting SMS message\n");
	error = Write(Buff, sizeof(Buff), 0x14, 4, ID_GetSMS+ID, List);
	if (error.Code!=GSM_ERR_NONE) return error;

	SetSMSLocations(List, FolderID, Location);

	List->Folder = FolderID;
	while (List->GetNext(&SubEntry) == TRUE) {
		switch (FolderID) {
		case 0x01: // SIM Inbox
		case 0x02: // SIM Outbox
			SubEntry->GetSMS()->Memory = MEM_SIM;
			break;
		default: // ME
			SubEntry->GetSMS()->Memory = MEM_PHONE;
		}
	}

	Buff[3] = 0x0e; Buff[8] = 0x55; Buff[9] = 0x55;
	(*Debug)->Deb("SENT: getting SMS message name\n");
	return Write(Buff, sizeof(Buff), 0x14, 4, ID_GetSMS+ID, List);
}

GSM_Error GSM_Phone_N6510::GetNextSMSMMSIDFromFolder1(BOOLEAN start, GSM_SMSMMSFoldersSubEntry *SMSFolder, GSM_SMSList *SMS, GSM_MMSEntry *MMS, int *Current, int *MaxInFolder)
{
	GSM_Error	error;
	wchart		SMSID;
	BOOLEAN		Found;

	if (!SMSFolder->MMS) {
		if (start == TRUE) {
			SMSLocations.Locations.clear();
			SMSLocations.FolderID = atoi(UnicodeToStringReturn(SMSFolder->ID.data()));
			error = GetSMSFolderStatus1(&SMSLocations);
			if (error.Code != GSM_ERR_NONE) return error;

			SMSLocation = 0;
		}

		if (SMSLocation == SMSLocations.Locations.length()) return GSM_Return_Error(GSM_ERR_EMPTY);

		SetSMSLocation(&SMSID, atoi(UnicodeToStringReturn(SMSFolder->ID.data())),SMSLocations.Locations.data()[SMSLocation]);

		SMSLocation++;
		MMS->Folder     = 0;
		*Current 	= SMSLocation;
		*MaxInFolder	= SMSLocations.Locations.length();
		return GetSMS1(SMS,SMSID);
	} else {
		if (start) {
			SMSListMax = 0;

			Found = FALSE;
			if (FoldersCacheSubEntry!=NULL) delete(FoldersCacheSubEntry);
			FoldersCacheSubEntry = NULL;
			while (FoldersCache.GetNext(&FoldersCacheSubEntry)) {
				if (!wcscmp(FoldersCacheSubEntry->Info.Info.ID.data(),(wchar_t *)SMSFolder->ID.data())) {
					Found = TRUE;
					break;
				}
			}
	
			if (!Found) {
				FoldersCacheSubEntry = new GSM_FileFolderInfoListsSubEntry;			
			}
	
			SMSSubEntry = NULL;
			if (FoldersCacheSubEntry->Info.GetNext(&SMSSubEntry)) {
				GetNextSMSFolder2.Code = GSM_ERR_NONE;
				SMSSubEntry = NULL;
				while (FoldersCacheSubEntry->Info.GetNext(&SMSSubEntry)) SMSListMax++;
			} else {
				GetNextSMSFolder2.Code = GSM_ERR_FOLDER_MORE;
				FoldersCacheSubEntry->Info.Info.SetID((wchar_t *)SMSFolder->ID.data());
			}
			SMSListPos = 0;
			SMSSubEntry = NULL;
		}
		if (GetNextSMSFolder2.Code == GSM_ERR_FOLDER_MORE) {
			GetNextSMSFolder2 = GetFolderInfoList(&FoldersCacheSubEntry->Info,start);
			switch (GetNextSMSFolder2.Code) {
			case GSM_ERR_NONE:
				FoldersCache.AddSubEntry(FoldersCacheSubEntry);
				SMSCache2 = FoldersCacheSubEntry;
				SMSSubEntry = NULL;
				while (FoldersCacheSubEntry->Info.GetNext(&SMSSubEntry)) SMSListMax++;
				FoldersCacheSubEntry = NULL;
				break;
			case GSM_ERR_FOLDER_PART:
				FoldersCache.AddSubEntry(FoldersCacheSubEntry);
				SMSCache2 = FoldersCacheSubEntry;
				FoldersCacheSubEntry = NULL;
				//no break
			default:
				return GetNextSMSFolder2;
			}
		}

		*MaxInFolder = SMSListMax;
		//getting next file from folder
		SMSListPos++;
		if (SMSCache2->Info.GetNext(&SMSSubEntry)) {
			SMS->Folder = 0;
			MMS->Folder = SMSFolder->Number;
			MMS->File.Info.SetID((wchar_t *)SMSSubEntry->Info.ID.data());
			*Current = SMSListPos;
			return GSM_Return_Error(GSM_ERR_NONE);
		}
		return GSM_Return_Error(GSM_ERR_EMPTY);
	}
}

GSM_Error GSM_Phone_N6510::DecodeSMSFrame1(GSM_SMSEntry *SMS, const unsigned char *buffer, int len, GSM_DateTime *SaveDateTime)
{
	int 		current,num,i;
	BOOLEAN 	WasPhoneNum = FALSE;
	
	SMS->PhoneNumbers.ClearAll();
	SMS->SMSCNumber.clear();
	SMS->UserData.clear();

	SMS->firstbyte = buffer[0];

	switch (SMS->GetType()) {
	case SMS_Deliver:
		SMS->TPPID   = buffer[1];
		SMS->TPDCS   = buffer[2];
		memcpy(SMS->DateTime,buffer+3,7);
		current = 14;
		break;
	case SMS_Submit:
		SMS->TPMR    = buffer[1];
		SMS->TPPID   = buffer[2];
		SMS->TPDCS   = buffer[3];
		//no TPVP
		current = 6;
		break;
	case SMS_Report:
		SMS->TPMR     = buffer[1];
		SMS->TPStatus = buffer[2];
		memcpy(SMS->DateTime,buffer+3,7);
		memcpy(SMS->SMSCTime,buffer+10,7);
		current = 18;
	}

	num = buffer[current-1];
	for (i=0;i<num;i++) {
		switch (buffer[current]) {
		case 0x80:
			(*Debug)->Deb("SMS text\n");
			if (buffer[current + 2] > buffer[current + 3]) {
				SMS->TPUDL = buffer[current+2];
			} else {
				SMS->TPUDL = buffer[current+3];
			}
			SMS->UserData.append(buffer+current+4,buffer[current+1]-4);
			break;
		case 0x82:
			switch (buffer[current+2]) {
			case 0x01:
				(*Debug)->Deb("phone number\n");
				SMS->PhoneNumbers.Add(buffer+current+4,buffer[current+4]+1);
				WasPhoneNum = TRUE;
				break;
			case 0x02:
				(*Debug)->Deb("SMSC number\n");
				SMS->SMSCNumber.append(buffer+current+4,buffer[current+4]+1);
				break;
			default:
				(*Debug)->Deb("unknown number\n");
				break;
			}
			break;
		case 0x84:
			(*Debug)->Deb("Date and time of saving for SMS template\n");
			if (SaveDateTime!=NULL) {
				if (WasPhoneNum || SMS->SMSCNumber.size()>1) {
					SMS->SetType(SMS_Deliver);
					SMS->SetDateTime(NokiaGetDT(buffer+current+2));
				} else {
					memcpy(SaveDateTime,NokiaGetDT(buffer+current+2),sizeof(GSM_DateTime));
				}
			} else {
				return GSM_Return_Error(GSM_ERR_UNKNOWN);
			}
			break;
		default:
			(*Debug)->Deb("unknown block\n");
		}
		current += buffer[current+1];
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::EncodeSMSFrameToBuffer1(GSM_SMSEntry *SMS, unsignedstring *Buffer)
{
	unsignedstring 		Temp,Temp2;
	int 			num=0,num2=0;
	unsigned char 		type,subtype;
	GSM_SMSNumbersSubEntry 	*Number;

	switch (SMS->GetType()) {
	case SMS_Deliver:
		Temp.push_back(SMS->TPPID);
		Temp.push_back(SMS->TPDCS);
		Temp.append(SMS->DateTime,7);
		Temp.push_back(0x55);
		Temp.push_back(0x55);
		Temp.push_back(0x55);
		Temp.push_back(0x03);//blocks number
		break;
	case SMS_Submit:
		Temp.push_back(SMS->TPMR);
		Temp.push_back(SMS->TPPID);
		Temp.push_back(SMS->TPDCS);
		Temp.push_back(0x00);
		Temp.push_back(0x04);//blocks number
		break;
	case SMS_Report:
		return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
	}

	//phone numbers, validity
	while (true) {
		Temp2.clear();
		switch (num) {
		case 0x01:
			type = 0x82;
			subtype = 0x02;
			Temp2.push_back(SMS->SMSCNumber.size());
			Temp2.append(SMS->SMSCNumber.data(),SMS->SMSCNumber.size());
			break;
		case 0x00:
			type = 0x82;
			subtype = 0x01;
			Number = NULL;
			while (SMS->PhoneNumbers.GetNext(&Number)) {
				if (Number->PhoneNumber.size() > 12) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
				num2++;
				if (num2 == 1) {
					Temp2.push_back(Number->PhoneNumber.size());
					Temp2.append(Number->PhoneNumber.data(),Number->PhoneNumber.size());
				}
			}
			if (num2>1) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
			break;
		case 0x02:
			if (SMS->GetType()==SMS_Submit) {
				type = 0x08;
				subtype = 0x01;
				Temp2.push_back(SMS->TPVP);
			}
		}
		if (Temp2.size()!=0) {
			Temp.push_back(type);
			Temp.push_back(Temp2.size()+3);
			Temp.push_back(subtype);
			Temp.append(Temp2.data(),Temp2.size());
		}
		if (num == 0x02) break;
		num++;
	}

	//text
	Temp2.clear();
	Temp2.push_back(SMS->UserData.size());
	Temp2.push_back(SMS->TPUDL);
	Temp2.append(SMS->UserData.data(),SMS->UserData.size());
	Temp.push_back(0x80);
	Temp.push_back(Temp2.size()+4);
	Temp.append(Temp2.data(),Temp2.size());

	Buffer->push_back(0x01);
	switch (SMS->GetType()) {
		case SMS_Deliver: Buffer->push_back(0x00); break;
		case SMS_Submit : Buffer->push_back(0x02); break;
		case SMS_Report : 			   break;
	}
	Buffer->push_back(Temp.size()+3);
	Buffer->push_back(SMS->firstbyte);
	Buffer->append(Temp.data(),Temp.size());

	return GSM_Return_Error(GSM_ERR_NONE);	
}

GSM_Error GSM_Phone_N6510::ReplySetSMS1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	unsigned char 		folder;
	GSM_SMSList 		*List = (GSM_SMSList *)S;
	GSM_SMSListSubEntry	*SubEntry = NULL;

	switch (msg->Buffer.data()[3]) {
	case 0x01:
		if (msg->Buffer.data()[4]!=0x00) return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);

		folder = msg->Buffer.data()[8] + 1;

		while (List->GetNext(&SubEntry) == TRUE) {
			SubEntry->GetSMS()->Memory = MEM_PHONE;
			//inbox,outbox
			if (msg->Buffer.data()[8] == 0x02 || msg->Buffer.data()[8] == 0x03) {
				if (msg->Buffer.data()[5] == 0x01) {
					folder = msg->Buffer.data()[8] - 1;
					SubEntry->GetSMS()->Memory = MEM_SIM;
				}
			}
		}

		//it's required to fill our structures after adding
		SetSMSLocations(List, folder, msg->Buffer.data()[6]*256+msg->Buffer.data()[7]);
		List->Folder = folder;
		return GSM_Return_Error(GSM_ERR_NONE);
	}
	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N6510::SetSMS1(GSM_SMSList *List)
{
	GSM_Error 		error;
	unsignedstring  	Buffer;
	GSM_SMSListSubEntry 	*SMS0 = NULL;
	GSM_SMSEntry		*SMS;
	BOOLEAN 		result;
	unsigned char		FolderID;
	int			Location;

	//1 sms only
	result = List->GetNext(&SMS0);
	if (result == FALSE) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	SMS = SMS0->GetSMS();

	if (SMS->GetType()==SMS_Report) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);
	Buffer.push_back(0x00);

	if (SMS->ID.length()==0) {
		//for adding sms to folder
		FolderID = List->Folder;
		Location = 0;
	} else {
		error = GetSMSLocations(List, &FolderID, &Location);
		if (error.Code != GSM_ERR_NONE) return error;
	}
	switch (FolderID) {
	case 0x01: // SIM Inbox
	case 0x02: // SIM Outbox
		Buffer.push_back(0x01); //SIM
		Buffer.push_back(FolderID + 1); //folder ID
		break;
	default:
		Buffer.push_back(0x02); //ME
		Buffer.push_back(FolderID - 1); //folder ID
	}
	Buffer.push_back(Location/256);
	Buffer.push_back(Location%256);

	switch (SMS->GetType()) {
	case SMS_Deliver:
		switch (SMS->Icon) {
			case SMS_Sent	: // we use GSM_Read, because phone return error
			case SMS_Read	: Buffer.push_back(0x01); break;
			case SMS_UnSent	: // we use GSM_UnRead, because phone return error
			case SMS_UnRead	: Buffer.push_back(0x03); break;
		}
		break;
	case SMS_Submit:
		switch (SMS->Icon) {
			case SMS_Sent	: // we use GSM_Sent, because phone change folder
			case SMS_Read	: Buffer.push_back(0x05); break;
			case SMS_UnSent	: // we use GSM_UnSent, because phone change folder
			case SMS_UnRead	: Buffer.push_back(0x07); break;
		}
	default:
		break;
	}

	error = EncodeSMSFrameToBuffer1(SMS, &Buffer);
	if (error.Code != GSM_ERR_NONE) return error;

	(*Debug)->Deb("SENT: Adding SMS\n");
	error = Write((unsigned char *)Buffer.data(), Buffer.size(), 0x14, 4, ID_SetSMS+ID,List);
	if (error.Code != GSM_ERR_NONE) return error;

	if (FolderID<3 || SMS->Name.length() == 0) return GSM_Return_Error(GSM_ERR_NONE);

	error = GetSMSLocations(List, &FolderID, &Location);
	if (error.Code != GSM_ERR_NONE) return error;

	Buffer.clear();
	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);
	Buffer.push_back(0x16);
	switch (FolderID) {
	case 0x01: // SIM Inbox
	case 0x02: // SIM Outbox
		Buffer.push_back(0x01); //SIM
		Buffer.push_back(FolderID + 1); //folder ID
		break;
	default:
		Buffer.push_back(0x02); //ME
		Buffer.push_back(FolderID - 1); //folder ID
	}
	Buffer.push_back(Location/256);
	Buffer.push_back(Location%256);
	NokiaSetUnicodeString(SMS->Name.data(),&Buffer);
	Buffer.push_back(0x00);
	Buffer.push_back(0x00);

	(*Debug)->Deb("SENT: Setting SMS name\n");
	return Write((unsigned char *)Buffer.data(), Buffer.size(), 0x14, 4, ID_SetSMSName+ID,List);
}

GSM_Error GSM_Phone_N6510::ReplyDeleteSMS1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	switch (msg->Buffer.data()[3]) {
	case 0x05:
		(*Debug)->Deb("SMS deleted\n");
		return GSM_Return_Error(GSM_ERR_NONE);
	case 0x06:
		(*Debug)->Deb("SMS not deleted\n");
	}
	return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Phone_N6510::DeleteSMS1(GSM_SMSList *List)
{
	unsignedstring  	Buffer;
	GSM_SMSListSubEntry 	*SMS = NULL;
	unsigned char		FolderID;
	int			Location;
	GSM_Error		error;

	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);
	Buffer.push_back(0x04);

	error = GetSMSLocations(List, &FolderID, &Location);
	if (error.Code != GSM_ERR_NONE) return error;

	switch (FolderID) {
	case 0x01: // SIM Inbox
	case 0x02: // SIM Outbox
		Buffer.push_back(0x01); //SIM
		Buffer.push_back(FolderID + 1); //folder ID
		break;
	default:
		Buffer.push_back(0x02); //ME
		Buffer.push_back(FolderID - 1); //folder ID
	}
	Buffer.push_back(Location/256);
	Buffer.push_back(Location%256);

	Buffer.push_back(0x0F);
	Buffer.push_back(0x55);

	(*Debug)->Deb("SENT: deleting SMS\n");
	return Write((unsigned char *)Buffer.data(), Buffer.size(), 0x14, 4, ID_DelSMS+ID,List);
}

/* -------------------------------- shared --------------------------------- */

GSM_Error GSM_Phone_N6510::ReplyGetSMSC(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSC 	*SMSC = (GSM_SMSC *)S;
	int		i, current = 14;
	wchar_t		Buff[50];
	GSM_Error	error;

	(*Debug)->Deb("RECEIVED: SMSC\n");

	switch (msg->Buffer.data()[4]) {
		case 0x00:	break;
		case 0x02:	return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
		default  :	return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}

	switch (msg->Buffer.data()[10]) {
		case 0x00: SMSC->Format = SMS_Text; 	break;
		case 0x22: SMSC->Format = SMS_Fax; 	break;
		case 0x26: SMSC->Format = SMS_Pager;	break;
		case 0x32: SMSC->Format = SMS_Email;	break;
		default  : SMSC->Format = SMS_Text;
	}

	SMSC->RelativeValidity = msg->Buffer.data()[12];
	if (msg->Buffer.data()[12] == 0x00) SMSC->RelativeValidity = SMS_RelativeValidity_Max_Time;

	Buff[0] = 0;
	SMSC->SetDefaultNumber(Buff);
	SMSC->SetSMSCNumber(Buff);
	SMSC->SetName(Buff);

	for (i=0;i<msg->Buffer.data()[13];i++) {
		switch (msg->Buffer.data()[current]) {
		case 0x81:
			SMSC->SetName(NokiaGetUnicodeString(msg->Buffer.data()+current+4));
			(*Debug)->Deb("  Name %s\n",UnicodeToStringReturn(SMSC->GetName()));
			break;
		case 0x82:
			switch (msg->Buffer.data()[current+2]) {
			case 0x01:
				error = GSM_DecodeSMSNumber(Buff, msg->Buffer.data()+current+4, msg->Buffer.data()[current+3], TRUE);
				if (error.Code != GSM_ERR_NONE) return error;
				SMSC->SetDefaultNumber(Buff);
				(*Debug)->Deb("  Default number %s\n",UnicodeToStringReturn(SMSC->GetDefaultNumber()));
				break;
			case 0x02:
				error = GSM_DecodeSMSNumber(Buff, msg->Buffer.data()+current+4, msg->Buffer.data()[current+3], FALSE);
				if (error.Code != GSM_ERR_NONE) return error;
				SMSC->SetSMSCNumber(Buff);
				(*Debug)->Deb("  Number %s\n",UnicodeToStringReturn(SMSC->GetSMSCNumber()));
				break;
			default:
				(*Debug)->Deb("RECEIVED: unknown number\n");
				return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
			}
			break;
		default:
			(*Debug)->Deb("RECEIVED: unknown block\n");
			return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
		}
		current += msg->Buffer.data()[current+1];
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6510::GetSMSC(GSM_SMSC *SMSC)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x14,
				0x00,			// location
				0x00};

	if (SMSC->Location == 0 || SMSC->Location > 255) {
		return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
	}
	
	Buff[4] = SMSC->Location;
	
	(*Debug)->Deb("SENT: getting SMSC\n");
	return Write(Buff, sizeof(Buff), 0x02, 4, ID_GetSMSC+ID, SMSC); 
}

GSM_Error GSM_Phone_N6510::ReplySendSMS(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	switch (msg->Buffer.data()[8]) {
	case 0x00:
		if (SMSSendReply != NULL) SMSSendReply(msg->Buffer.data()[10]);
		return GSM_Return_Error(GSM_ERR_NONE);
	default:
		if (SMSSendReply != NULL) SMSSendReply(-1);
		return GSM_Return_Error(GSM_ERR_NONE);
	}
}

GSM_Error GSM_Phone_N6510::SendSMS(GSM_SMSEntry *SMS)
{
	GSM_Error 		error;
	unsignedstring  	Buffer;

	if (SMS->GetType()!=SMS_Submit) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);
	Buffer.push_back(0x02);
	Buffer.push_back(0x00);
	Buffer.push_back(0x00);
	Buffer.push_back(0x00);
	Buffer.push_back(0x55);
	Buffer.push_back(0x55);

	error = EncodeSMSFrameToBuffer1(SMS, &Buffer);
	if (error.Code != GSM_ERR_NONE) return error;

	(*Debug)->Deb("SENT: Sending SMS\n");
	return (*Protocols)->Current->Write((unsigned char *)Buffer.data(), Buffer.size(), 0x02);
}

GSM_Error GSM_Phone_N6510::GetSMSStatus(GSM_SMSStatus *Status)
{
	if ((*Phones)->Feature("s40_30")==TRUE && !(*Phones)->Feature("sms1")) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
	return GetSMSStatus1(Status);
}

GSM_Error GSM_Phone_N6510::GetSMSMMSFolders(GSM_SMSMMSFolders *Folders)
{
	if ((*Phones)->Feature("s40_30")==TRUE && !(*Phones)->Feature("sms1")) return GetSMSMMSFolders2(Folders);
	return GetSMSMMSFolders1(Folders);
}

GSM_Error GSM_Phone_N6510::SetSMS(GSM_SMSList *List)
{
	if ((*Phones)->Feature("s40_30")==TRUE && !(*Phones)->Feature("sms1")) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
	return SetSMS1(List);
}

GSM_Error GSM_Phone_N6510::DeleteSMS(GSM_SMSList *List)
{
	if ((*Phones)->Feature("s40_30")==TRUE && !(*Phones)->Feature("sms1")) return DeleteSMS2(List);
	return DeleteSMS1(List);
}

GSM_Error GSM_Phone_N6510::GetNextSMSMMSIDFromFolder(BOOLEAN start, GSM_SMSMMSFoldersSubEntry *SMSFolder, GSM_SMSList *SMS, GSM_MMSEntry *MMS, int *Current, int *MaxInFolder)
{
	if ((*Phones)->Feature("s40_30")==TRUE && !(*Phones)->Feature("sms1")) return GetNextSMSMMSIDFromFolder2(start, SMSFolder, SMS,MMS,Current, MaxInFolder);
	return GetNextSMSMMSIDFromFolder1(start, SMSFolder, SMS,MMS,Current, MaxInFolder);
}
