/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdio.h>

#include "../../../service/gsmmisc.h"
#include "../../../protocol/gsmprot.h"

#ifndef __ndct3
#define __ndct3

const int ID_SetSecurity = 1 + ID_Start;

class GSM_Phone_NDCT3
{
public:
	GSM_Phone_NDCT3(int id,DebugInfo **Debug2, GSM_Phone **Pho2, GSM_Protocol **Prot2);

	GSM_Error 	SetSecurity	(unsigned char status);
	GSM_Error 	GetIMEI		(unsigned char *IMEI);
	GSM_Error 	GetDateTime	(GSM_DateTime *DT, unsigned char msgtype);
	GSM_Error 	GetSMSC		(GSM_SMSC *SMSC);
	GSM_Error 	GetSMSStatus	(GSM_SMSStatus *Status);
	GSM_Error 	SendSMS		(GSM_SMSEntry *SMS);

	GSM_Error 	ReplySetSecurity(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *Ident);
	GSM_Error 	ReplyGetIMEI	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *IMEI);
	GSM_Error 	ReplyGetDateTime(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error 	ReplyGetSMSC	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error 	ReplySendSMS	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S,void (*SMSSendReply)(int TPMR));

	GSM_Error 	DecodeSMSFrame	(GSM_SMSEntry *SMS, const unsigned char *buffer, int len);
	GSM_Error 	EncodeSMSFrameToBuffer(GSM_SMSEntry *SMS, unsignedstring *Buffer);
	int		GetID		();
private:
	int 		ID;
	DebugInfo 	**Debug;
	GSM_Phone 	**Pho;
	GSM_Protocol 	**Prot;
};

#endif
