/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include "../../../../cfg/config.h" //msvc2005
#include "../../../misc/coding/coding.h"
#include "../../../protocol/gsmprot.h"
#include "../ndct34.h"
#include "n7110.h"
#include "ndct3.h"

GSM_Error GSM_Phone_N7110::Dispatch(GSM_Protocol_Message *msg, void *Struct, int RequestID)
{
	int	     ID2 = DCT3->GetID(), ID3 = DCT34->GetID();
	AnsStruct       AS;

	AS.RequestID  = RequestID;
	AS.FrameFound = false;

if(Ans("\x02",0x03,0x02,ID_IncomingFrame,&AS))	  	return DCT3->ReplySendSMS	       	(msg,Debug,(unsigned char *)Struct,SMSSendReply);
if(Ans("\x02",0x03,0x03,ID_IncomingFrame,&AS))	  	return DCT3->ReplySendSMS	       	(msg,Debug,(unsigned char *)Struct,SMSSendReply);
if(Ans("\x02",0x03,0x34,ID_GetSMSC+ID2,&AS))	    	return DCT3->ReplyGetSMSC	       	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x02",0x03,0x35,ID_GetSMSC+ID2,&AS))	    	return DCT3->ReplyGetSMSC	       	(msg,Debug,(unsigned char *)Struct);

if(Ans("\x03",0x03,0x04,ID_GetPBKStatus+ID,&AS))	return ReplyGetPBKStatus		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x03",0x03,0x08,ID_GetPBK+ID, &AS))	     	return ReplyGetPBK		      	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x03",0x03,0x0C,ID_SetPBK+ID, &AS))	     	return DCT34->ReplySetPBK	       	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x03",0x03,0x10,ID_DelPBK+ID, &AS))	     	return DCT34->ReplyDelPBK	       	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x03",0x03,0x26,ID_GetPBK+ID3, &AS))     	return ReplyGetPBKFeatures 		(msg,Debug,(unsigned char *)Struct);

if(Ans("\x13",0x03,0x02,ID_AddCalendar+ID3,&AS))	return DCT34->ReplyAddCalendar1	 	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x04,ID_AddCalendar+ID3,&AS))	return DCT34->ReplyAddCalendar1	 	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x06,ID_AddCalendar+ID3,&AS))	return DCT34->ReplyAddCalendar1	 	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x08,ID_AddCalendar+ID3,&AS))	return DCT34->ReplyAddCalendar1	 	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x0C,ID_DelCalendar+ID3,&AS))	return DCT34->ReplyDelCalendar	  	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x1A,ID_GetCalendar+ID3,&AS))	return DCT34->ReplyGetNextCalendar1     (msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x32,ID_GetFirstCalendarPos+ID3,&AS))return DCT34->ReplyGetFirstCalPos1      (msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x3B,ID_GetCalendarInfo+ID3,&AS))    return DCT34->ReplyGetCalendarInfo1     (msg,Debug,(unsigned char *)Struct);

if(Ans("\x14",0x03,0x05,ID_SetSMS+ID,&AS))	      	return ReplySetSMS		      	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x06,ID_SetSMS+ID,&AS))	      	return ReplySetSMS		      	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x08,ID_GetSMS+ID,&AS))	      	return ReplyGetSMS		      	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x37,ID_GetSMSStatus+ID,&AS))	return ReplyGetSMSStatus		(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x6C,ID_GetSMSFolderStatus+ID,&AS))  return ReplyGetSMSFolderStatus	  	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x6F,ID_GetSMS+ID,&AS))	      	return ReplyGetSMS		      	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x7B,ID_GetSMSFolders+ID,&AS))       return ReplyGetSMSFolders	       	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x84,ID_SetSMSName+ID,&AS))	  	return ReplySetSMS		      	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x85,ID_SetSMSName+ID,&AS))	  	return ReplySetSMS		      	(msg,Debug,(unsigned char *)Struct);

if(Ans("\x19",0x03,0x63,ID_GetDateTime+ID2,&AS))	return DCT3->ReplyGetDateTime	   	(msg,Debug,(unsigned char *)Struct);

if(Ans("\x40",0x02,0x64,ID_SetSecurity+ID2,&AS))	return DCT3->ReplySetSecurity	   	(msg,Debug,(unsigned char *)Struct);
if(Ans("\x40",0x02,0x66,ID_GetIMEI+ID2    ,&AS))	return DCT3->ReplyGetIMEI	       	(msg,Debug,(unsigned char *)Struct);

if(Ans("\xD2",0x02,0x00,ID_GetID+ID3,      &AS))	return DCT34->ReplyGetID		(msg,Debug,(unsigned char *)Struct);

	if (AS.FrameFound) return GSM_Return_Error(GSM_ERR_FRAME_NOT_REQUESTED);
	return GSM_Return_Error(GSM_ERR_FRAME_TYPE_UNKNOWN);
}

GSM_Error GSM_Phone_N7110::GetIMEI(unsigned char *IMEI)
{
	return DCT3->GetIMEI(IMEI);
}

GSM_Error GSM_Phone_N7110::GetCodeNameModel(unsigned char *Model)
{
	return DCT34->GetCodeNameModel(Model);
}

GSM_Error GSM_Phone_N7110::GetFirmwareVersion(unsigned char *Firm)
{
	return DCT34->GetFirmwareVersion(Firm);
}

GSM_Error GSM_Phone_N7110::GetManufacturer(unsigned char *Manufacturer)
{
	strcpy((char *)Manufacturer,"Nokia");
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N7110::ReplyGetPBKStatus(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_PBKStatus *Status = (GSM_PBKStatus *)S;

	(*Debug)->Deb("RECEIVED: PBK memory status\n");

	if (msg->Buffer.data()[10] == 0x10) {
		Status->Free = msg->Buffer.data()[14] * 256 + msg->Buffer.data()[15];
	} else {
		Status->Free = msg->Buffer.data()[18];
	}
	(*Debug)->Deb("Size - %i\n",Status->Free);

	Status->Used = msg->Buffer.data()[16] * 256 + msg->Buffer.data()[17];
	Status->Free -= Status->Used;
	(*Debug)->Deb("Used - %i\n",Status->Used);
	(*Debug)->Deb("Free - %i\n",Status->Free);

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N7110::GetPBKStatus(GSM_PBKStatus *Status)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x03, 0x02, 0x00};

	Buff[5] = DCT34->Get7110DCT4MemoryType(Status->Memory);
	if (Buff[5] == 0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	(*Debug)->Deb("SENT: getting status for %s memory\n",GSM_GetMemoryName(Status->Memory));
	return Write(Buff, sizeof(Buff), 0x03, 4, ID_GetPBKStatus+ID, Status);
}

GSM_Error GSM_Phone_N7110::Open(char *FrameID)
{
	GSM_Phone::Open(FrameID);

	if (FrameID[0] != 0) DCT34->SetFrameID(FrameID);

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N7110::ReplyGetPBK(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_PBKEntry *Entry = (GSM_PBKEntry *)S;

	if (msg->Buffer.data()[6] == 0x0F) {
		return GSM_Return_Error(GSM_ERR_EMPTY);

		(*Debug)->Deb("RECEIVED: error %i receiving PBK entry\n",0);
		return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}

	(*Debug)->Deb("RECEIVED: PBK entry received\n");
	DCT34->DecodePBKToEntry(msg->Buffer.data()+17, Entry);
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N7110::GetPBK(GSM_PBKEntry *Entry)
{
	unsigned char Buff[] = {
		NOKIA_FRAME1, 0x07, 0x01, 0x01, 0x00, 0x01, 0x02,
		0x00,		   // memory type
		0x00, 0x00,	     // memory location
		0x00, 0x00};

	Buff[9] = DCT34->Get7110DCT4MemoryType(Entry->Memory);
	if (Buff[9] == 0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	if (Entry->Location==0x00) return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
	Buff[10] = Entry->Location / 256;
	Buff[11] = Entry->Location % 256;

	(*Debug)->Deb("SENT: getting entry %i in memory %s\n",Entry->Location,GSM_GetMemoryName(Entry->Memory));
	return Write(Buff, sizeof(Buff), 0x03, 4, ID_GetPBK+ID, Entry);
}

GSM_Error GSM_Phone_N7110::SetPBK(GSM_PBKEntry *Entry)
{
	unsignedstring	  Buffer, Buffer2;
	GSM_Error	       error;
	int		     Number;
	unsigned char	   Buff[] = {
		NOKIA_FRAME1, 0x0b, 0x00, 0x01, 0x01, 0x00, 0x00, 0x0c, 0x00, 
		0x00,		   // memory type
		0x00, 0x00,	     // location
		0x00, 0x00, 0x00};

	if (Entry->Memory == MEM_PHONE && PhonePBKFeatures.Types.size() == 0) {
		PhonePBKFeatures.Memory = MEM_PHONE;
		error = DCT34->GetPBKFeatures(&PhonePBKFeatures);
		if (error.Code != GSM_ERR_NONE) return error;
	}

	Buff[11] = DCT34->Get7110DCT4MemoryType(Entry->Memory);
	if (Buff[11] == 0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	if (Entry->Location==0x00) return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
	Buff[12] = Entry->Location / 256;
	Buff[13] = Entry->Location % 256;

	while (true) {
		if (Entry->Memory == MEM_PHONE) {
			error = DCT34->EncodeEntryToPBK(&Buffer, Entry, &Number, &PhonePBKFeatures);
		} else {
			error = DCT34->EncodeEntryToPBK(&Buffer, Entry, &Number, NULL);
		}
		if (error.Code != GSM_ERR_NONE) return error;

		Buffer2.append((const unsigned char*)Buff,sizeof(Buff));
		Buffer2.push_back(Number);
		Buffer2.append((const unsigned char*)Buffer.data(),Buffer.size());

		(*Debug)->Deb("SENT: setting entry %i in memory %s\n",Entry->Location,GSM_GetMemoryName(Entry->Memory));
		error = Write((unsigned char *)Buffer2.data(), Buffer2.size(), 0x03, 4, ID_SetPBK+ID, Entry);
		if (error.Code == GSM_ERR_TOO_MANY_ENTRIES) {
			Buffer.clear();
			Buffer2.clear();
			Number--;
			continue;
		}
		if (error.Code == GSM_ERR_FILE_EXIST) {
			error.Code = GSM_ERR_NONE;
		}

		return error;
	}
}

GSM_Error GSM_Phone_N7110::DeletePBK(GSM_PBKEntry *Entry)
{
	unsigned char Buff[] = {
		NOKIA_FRAME1, 0x0f, 0x00, 0x01, 0x04, 0x00, 0x00, 0x0c, 0x01, 0xff,
		0x00, 0x00,	     // location
		0x00,		   // memory type
		0x00, 0x00, 0x00};

	if (Entry->Location==0x00) return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
	Buff[12] = Entry->Location / 256;
	Buff[13] = Entry->Location % 256;

	Buff[14] = DCT34->Get7110DCT4MemoryType(Entry->Memory);
	if (Buff[14] == 0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	(*Debug)->Deb("SENT: deleting entry %i in memory %s\n",Entry->Location,GSM_GetMemoryName(Entry->Memory));
	return Write(Buff, sizeof(Buff), 0x03, 4, ID_DelPBK+ID, Entry);
}

GSM_Error GSM_Phone_N7110::GetFirmwareDate(unsigned char *Dat)
{
	return DCT34->GetFirmwareDate(Dat);
}

GSM_Error GSM_Phone_N7110::GetNextCalendar(GSM_CalendarEntry *Entry, BOOLEAN start, int *Current, int *Max)
{
	return DCT34->GetNextCalendar1(Entry,start,Current,Max);
}

GSM_Error GSM_Phone_N7110::AddCalendar(GSM_CalendarEntry *Entry)
{
	GSM_Calendar_Type       Type = Entry->Type;
	GSM_Error	       error;

	Entry->TypeSetError = GSM_Return_Error(GSM_ERR_NONE);
	if (Type == Calendar_Type_Reminder) {
		Entry->Type = Calendar_Type_Meeting;
		Entry->TypeSetError = GSM_Return_Error(GSM_ERR_CONVERTED);
	}
	error = DCT34->AddCalendar1(Entry);
	Entry->Type = Type;
	return error;
}

GSM_Error GSM_Phone_N7110::DeleteCalendar(GSM_CalendarEntry *Entry)
{
	return DCT34->DeleteCalendar(Entry);
}

GSM_Error GSM_Phone_N7110::GetDateTime(GSM_DateTime *DT)
{
	return DCT3->GetDateTime(DT,0x19);
}

GSM_Error GSM_Phone_N7110::ReplyGetSMSStatus(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSStatus *Status = (GSM_SMSStatus *)S;

	(*Debug)->Deb("RECEIVED: SMS status\n");

	switch (msg->Buffer.data()[3]) {
	case 0x37:
		(*Debug)->Deb("  Phone used   : %i\n",msg->Buffer.data()[10]*256+msg->Buffer.data()[11]);
		(*Debug)->Deb("  Phone unRead : %i\n",msg->Buffer.data()[12]*256+msg->Buffer.data()[13]);
		(*Debug)->Deb("  SIM size   : %i\n",msg->Buffer.data()[8]*256+msg->Buffer.data()[9]);
		(*Debug)->Deb("  SIM used   : %i\n",msg->Buffer.data()[14]*256+msg->Buffer.data()[15]);
		(*Debug)->Deb("  SIM unRead : %i\n",msg->Buffer.data()[16]*256+msg->Buffer.data()[17]);

		if (Status->Memory==MEM_SIM) {
			Status->SMSUnRead = msg->Buffer.data()[16]*256+msg->Buffer.data()[17];
			Status->SMSFree   = msg->Buffer.data()[8]*256+msg->Buffer.data()[9]-(msg->Buffer.data()[14]*256+msg->Buffer.data()[15]);
			Status->SMSRead   = msg->Buffer.data()[14]*256+msg->Buffer.data()[15]-Status->SMSFree-Status->SMSUnRead;
		} else {
			Status->SMSUnRead = msg->Buffer.data()[12]*256+msg->Buffer.data()[13];
			Status->SMSFree   = 150-(msg->Buffer.data()[10]*256+msg->Buffer.data()[11]);
			Status->SMSRead   = msg->Buffer.data()[10]*256+msg->Buffer.data()[11]-Status->SMSFree-Status->SMSUnRead;
		}
	
		return GSM_Return_Error(GSM_ERR_NONE);
	default:
		return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}
}

GSM_Error GSM_Phone_N7110::GetSMSStatus(GSM_SMSStatus *Status)
{
	GSM_Error       error;
	GSM_SMS_Loc     SMSLocations;

	if (Status->Memory!=MEM_SIM && Status->Memory!=MEM_PHONE) {
		return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
	}
	error = DCT3->GetSMSStatus(Status);
	if (error.Code != GSM_ERR_NONE || Status->Memory==MEM_SIM) return error;

	//status of Templates folder
	SMSLocations.FolderID = 0x20;
	error = GetSMSFolderStatus(&SMSLocations);
	if (error.Code != GSM_ERR_NONE) return error;

	Status->SMSTemplates = SMSLocations.Locations.size();

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N7110::ReplyGetSMS(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSList	     	*List = (GSM_SMSList *)S;
	GSM_SMSListSubEntry     *SubEntry = NULL;
	GSM_SMSEntry	    	SMS;
	GSM_Error	       	error;

	switch (msg->Buffer.data()[3]) {
	case 0x08:
		(*Debug)->Deb("RECEIVED: SMS message\n");
		switch (msg->Buffer.data()[4]) {
			case  1 : SMS.Icon = SMS_Read;   break;
			case  3 : SMS.Icon = SMS_UnRead; break;
			case  5 : SMS.Icon = SMS_Sent;   break;
			case  7 : SMS.Icon = SMS_UnSent; break;
			default : return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
		}
		switch (msg->Buffer.data()[8]) {
		case 0x00:
		case 0x01:
		case 0x02:
			error = DCT3->DecodeSMSFrame(&SMS,msg->Buffer.data()+9,msg->Buffer.size()-9);
			if (error.Code == GSM_ERR_NONE) {
				List->ClearAll();
				List->Add(&SMS);
			}
			return error;
		case 0x07: // Picture message
			List->ClearAll();
			return GSM_Return_Error(GSM_ERR_NONE);
		}
		return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
	case 0x6F:
		(*Debug)->Deb("RECEIVED: name for SMS message\n");
		if (msg->Buffer.size() != 43) {
			while (List->GetNext(&SubEntry) == TRUE) {
				SubEntry->GetSMS()->Name.clear();
				SubEntry->GetSMS()->Name.append(NokiaGetUnicodeString(msg->Buffer.data()+43),UnicodeLength(NokiaGetUnicodeString(msg->Buffer.data()+43)));
			}
		}
		return GSM_Return_Error(GSM_ERR_NONE);
	}
	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N7110::GetSMS(GSM_SMSList *List, wchart SMS_ID)
{
	GSM_SMSListSubEntry     *SubEntry;
	GSM_Error	       	error;
	unsigned char	   	FolderID;
	int		     	Location;
	unsigned char	   	Buff[] = {NOKIA_FRAME1, 0x07,
					  0x00,	 // folder ID
					  0x00, 0x00,   // location
					  0x01, 0x65, 0x01};

	error = GetSMSLocation(SMS_ID, &FolderID, &Location);
	if (error.Code != GSM_ERR_NONE) return error;

	Buff[4] = FolderID;
	Buff[5] = Location / 256;
	Buff[6] = Location % 256;

	(*Debug)->Deb("SENT: getting SMS message\n");
	error = Write(Buff, sizeof(Buff), 0x14, 4, ID_GetSMS+ID, List);
	if (error.Code!=GSM_ERR_NONE) return error;

	SetSMSLocations(List, FolderID, Location);

	Buff[3] = 0x6E;
	(*Debug)->Deb("SENT: getting SMS message name\n");
	error = Write(Buff, 7, 0x14, 4, ID_GetSMS+ID, List);
	if (error.Code!=GSM_ERR_NONE) return error;

	List->Folder = FolderID/8;
	SubEntry = NULL;
	while (List->GetNext(&SubEntry) == TRUE) {
		SubEntry->GetSMS()->Memory  = MEM_PHONE;
		if (FolderID == 0x01*8) { // Inbox
			if (SubEntry->GetSMS()->Icon == SMS_Read || SubEntry->GetSMS()->Icon == SMS_UnRead) {
				SubEntry->GetSMS()->Memory = MEM_SIM;
			}
		}
		if (FolderID == 0x02*8) { // Outbox
			if (SubEntry->GetSMS()->Icon == SMS_Sent || SubEntry->GetSMS()->Icon == SMS_UnSent) {
				SubEntry->GetSMS()->Memory = MEM_SIM;
			}
		}
	}

	return error;
}

GSM_Error GSM_Phone_N7110::GetNextSMSMMSIDFromFolder(BOOLEAN start, GSM_SMSMMSFoldersSubEntry *SMSFolder, GSM_SMSList *SMS, GSM_MMSEntry *MMS, int *Current, int *MaxInFolder)
{
	GSM_Error	error;
	wchart		SMSID;

	if (start == TRUE) {
		SMSLocations.Locations.clear();
		SMSLocations.FolderID = atoi(UnicodeToStringReturn(SMSFolder->ID.data()));
		error = GetSMSFolderStatus(&SMSLocations);
		if (error.Code != GSM_ERR_NONE) return error;

		SMSLocation = 0;
	}

	if (SMSLocation == SMSLocations.Locations.length()) return GSM_Return_Error(GSM_ERR_EMPTY);

	SetSMSLocation(&SMSID, atoi(UnicodeToStringReturn(SMSFolder->ID.data())),SMSLocations.Locations.data()[SMSLocation]);

	SMSLocation++;
	MMS->Folder     = 0;
	*Current 	= SMSLocation;
	*MaxInFolder	= SMSLocations.Locations.length();
	return GetSMS(SMS,SMSID);
}

GSM_Error GSM_Phone_N7110::ReplyGetSMSFolders(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSMMSFolders	*Folders = (GSM_SMSMMSFolders *)S;
	unsigned int	    	i, current = 5;
	BOOLEAN		 	Inbox;
	GSM_MemoryType	  	Memory;
	wchart			ID;
	char			buff[10];

	(*Debug)->Deb("RECEIVED: SMS folders\n");
	switch (msg->Buffer.data()[3]) {
	case 0x7B:
		break;
	default:
		return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}

	Inbox = true;
	Memory = MEM_SIM_PHONE;
	for (i=0;i<msg->Buffer.data()[4];i++) {
		current++;
		if (i > 1) Memory = MEM_PHONE;
		sprintf(buff,"%i",(i+1)*8);
		ID.clear();
		ID.append(StringToUnicodeReturn(buff));
		Folders->Add(NokiaGetUnicodeString(msg->Buffer.data()+current),FALSE,Inbox,FALSE,Memory,&ID,i+1,-1);
		Inbox = false;
		while (true) {
			current+=2;
			if (msg->Buffer.data()[current] == 0 && msg->Buffer.data()[current+1] == 0) break;
		}
		current+=2;
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N7110::GetSMSMMSFolders(GSM_SMSMMSFolders *Folders)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x7A, 0x00, 0x00};

	(*Debug)->Deb("SENT: getting SMS folders\n");
	return Write(Buff, sizeof(Buff), 0x14, 4, ID_GetSMSFolders+ID, Folders);
}

GSM_Error GSM_Phone_N7110::GetSMSC(GSM_SMSC *SMSC)
{
	return DCT3->GetSMSC(SMSC);
}

GSM_Error GSM_Phone_N7110::ReplyGetSMSFolderStatus(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	int	     	i, last = 0;
	GSM_SMS_Loc     *SMSLocations = (GSM_SMS_Loc *)S;
	unsignedint     s2;

	(*Debug)->Deb("RECEIVED: SMS folder status received\n");

	(*Debug)->Deb("  locations ");
	for (i=0;i<msg->Buffer.data()[4]*256+msg->Buffer.data()[5];i++) {
		(*Debug)->Deb("%i ",msg->Buffer.data()[6+(i*2)]*256+msg->Buffer.data()[7+(i*2)]);
		if (msg->Buffer.data()[6+(i*2)]*256+msg->Buffer.data()[7+(i*2)] < last) {
			//pushing int on front
			s2.clear();
			SMSLocations->Locations.swap(s2);
			SMSLocations->Locations.push_back(msg->Buffer.data()[6+(i*2)]*256+msg->Buffer.data()[7+(i*2)]);
			SMSLocations->Locations.append(s2);
		} else {
			SMSLocations->Locations.push_back(msg->Buffer.data()[6+(i*2)]*256+msg->Buffer.data()[7+(i*2)]);
		}
		last = msg->Buffer.data()[6+(i*2)]*256+msg->Buffer.data()[7+(i*2)];
	}
	(*Debug)->Deb("\n");

	(*Debug)->Deb("  locations ");
	for (i=0;i<msg->Buffer.data()[4]*256+msg->Buffer.data()[5];i++) {
		(*Debug)->Deb("%i ",SMSLocations->Locations.data()[i]);
	}
	(*Debug)->Deb("\n");

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N7110::GetSMSFolderStatus(GSM_SMS_Loc *SMSLocations)
{
	GSM_Error       error;
	unsigned char   Buff[] = {NOKIA_FRAME1, 0x6B,
				  0x00,	 // folder ID
				  0x0F, 0x01};

	Buff[4] = SMSLocations->FolderID;
	(*Debug)->Deb("SENT: getting SMS folder status\n");
	error = Write(Buff, sizeof(Buff), 0x14, 4, ID_GetSMSFolderStatus+ID, SMSLocations);

	if (SMSLocations->FolderID == 0x08 && error.Code == GSM_ERR_NONE) {
		// user asked for read Inbox (0x08)
		// we give unread Inbox (0xF8) too
		Buff[4] = 0xF8;
		(*Debug)->Deb("SENT: getting SMS folder status\n");
		return Write(Buff, sizeof(Buff), 0x14, 4, ID_GetSMSFolderStatus+ID, SMSLocations);
	}

	return error;
}

GSM_Error GSM_Phone_N7110::ReplySetSMS(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSList	     *List = (GSM_SMSList *)S;
	GSM_SMSListSubEntry     *SubEntry = NULL;

	switch (msg->Buffer.data()[3]) {
	case 0x05:
		(*Debug)->Deb("RECEIVED: SMS message saved, folder %i, location %i\n",msg->Buffer.data()[4],msg->Buffer.data()[5]*256+msg->Buffer.data()[6]);
		//it's required to fill our structures after adding
		if (msg->Buffer.data()[4] == 0xF8) {
			SetSMSLocations(List, 0x08, msg->Buffer.data()[5]*256+msg->Buffer.data()[6]);
			List->Folder = 0x01;
		} else {
			SetSMSLocations(List, msg->Buffer.data()[4], msg->Buffer.data()[5]*256+msg->Buffer.data()[6]);
			List->Folder = msg->Buffer.data()[4]/0x08;
		}
		return GSM_Return_Error(GSM_ERR_NONE);
	case 0x06:
		return GSM_Return_Error(GSM_ERR_UNKNOWN);
	case 0x84:
		(*Debug)->Deb("RECEIVED: changed name for SMS message\n");
		return GSM_Return_Error(GSM_ERR_NONE);
	case 0x85:
		return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}
	return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Phone_N7110::SetSMS(GSM_SMSList *List)
{
	GSM_Error	       	error;
	unsignedstring	  	Buffer;
	GSM_SMSListSubEntry     *SMS0 = NULL;
	GSM_SMSEntry	    	*SMS;
	BOOLEAN		 	result;
	unsigned char	   	FolderID;
	int		     	Location;

	//1 sms only
	result = List->GetNext(&SMS0);
	if (result == FALSE) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	SMS = SMS0->GetSMS();

	if (SMS->GetType()==SMS_Report) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);
	Buffer.push_back(0x04);

	switch (SMS->Icon) {
		case SMS_Read   : Buffer.push_back(0x01); break;
		case SMS_UnRead : Buffer.push_back(0x03); break;
		case SMS_Sent   : Buffer.push_back(0x05); break;
		case SMS_UnSent : Buffer.push_back(0x07); break;
	}

	if (SMS->ID.length()==0) {
		//for adding sms to folder
		FolderID = List->Folder;
		Location = 0;
	} else {
		error = GetSMSLocations(List, &FolderID, &Location);
		if (error.Code != GSM_ERR_NONE) return error;
	}

	SMS->Memory = MEM_PHONE;
	/* Outbox */
	if (FolderID == 2*0x08 && (SMS->Icon == SMS_Sent || SMS->Icon == SMS_UnSent)) {
		/* We have to have Submit to use SIM Outbox */
		if (SMS->GetType()==SMS_Deliver) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		SMS->Memory = MEM_SIM;
	}
	//Inbox
	if (FolderID == 1*0x08 && (SMS->Icon == SMS_UnRead || SMS->Icon == SMS_Read)) {
		SMS->Memory = MEM_SIM;
	}
	if (FolderID == 1*0x08 && SMS->Icon == SMS_UnRead) {
		/* We will use SIM Inbox */
		Buffer.push_back(0xF8);
	} else {
		Buffer.push_back(FolderID);
	}
	Buffer.push_back(Location/256);
	Buffer.push_back(Location%256);
	Buffer.push_back(0x00);
	
	error = DCT3->EncodeSMSFrameToBuffer(SMS, &Buffer);
	if (error.Code != GSM_ERR_NONE) return error;

	(*Debug)->Deb("SENT: Adding SMS\n");
	error = Write((unsigned char *)Buffer.data(), Buffer.size(), 0x14, 4, ID_SetSMS+ID,List);
	if (error.Code != GSM_ERR_NONE) return error;

	if (SMS->Memory == MEM_SIM || SMS->Name.length() == 0) {
		return GSM_Return_Error(GSM_ERR_NONE);
	}

	error = GetSMSLocations(List, &FolderID, &Location);
	if (error.Code != GSM_ERR_NONE) return error;

	Buffer.clear();
	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);
	Buffer.push_back(0x83);
	Buffer.push_back(FolderID);
	Buffer.push_back(Location/256);
	Buffer.push_back(Location%256);
	NokiaSetUnicodeString(SMS->Name.data(),&Buffer);
	Buffer.push_back(0x00);
	Buffer.push_back(0x00);

	(*Debug)->Deb("SENT: Setting SMS name\n");
	return Write((unsigned char *)Buffer.data(), Buffer.size(), 0x14, 4, ID_SetSMSName+ID,List);
}

GSM_Error GSM_Phone_N7110::SendSMS(GSM_SMSEntry *SMS)
{
	return DCT3->SendSMS(SMS);
}

//todo
GSM_Error GSM_Phone_N7110::ReplyDeleteSMS(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSList *List = (GSM_SMSList *)S;

	switch (msg->Buffer.data()[3]) {
	case 0x05:
		(*Debug)->Deb("SMS deleted\n");
		return GSM_Return_Error(GSM_ERR_NONE);
	case 0x06:
		(*Debug)->Deb("SMS not deleted\n");
	}
	return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

//todo
GSM_Error GSM_Phone_N7110::DeleteSMS(GSM_SMSList *List)
{
	unsignedstring	  Buffer;
	GSM_SMSListSubEntry     *SMS = NULL;
	unsigned char	   FolderID;
	int		     Location;
	GSM_Error	       error;

	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);
	Buffer.push_back(0x04);

	error = GetSMSLocations(List, &FolderID, &Location);
	if (error.Code != GSM_ERR_NONE) return error;

	switch (FolderID) {
	case 0x01: // SIM Inbox
	case 0x02: // SIM Outbox
		Buffer.push_back(0x01); //SIM
		Buffer.push_back(FolderID + 1); //folder ID
		break;
	default:
		Buffer.push_back(0x02); //ME
		Buffer.push_back(FolderID - 1); //folder ID
	}
	Buffer.push_back(Location/256);
	Buffer.push_back(Location%256);

	Buffer.push_back(0x0F);
	Buffer.push_back(0x55);

	(*Debug)->Deb("SENT: deleting SMS\n");
	return Write((unsigned char *)Buffer.data(), Buffer.size(), 0x14, 4, ID_DelSMS+ID,List);
}

GSM_Error GSM_Phone_N7110::ReplyGetPBKFeatures(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_PBK_Features *Entry = (GSM_PBK_Features *)S;
	int 		 i,pos=6;

	(*Debug)->Deb("  Features: ");
	Entry->Types.clear();
	for (i=0;i<msg->Buffer.data()[5];i++) {
		(*Debug)->Deb("%02x ",msg->Buffer.data()[pos+4]);
		Entry->Types.push_back(msg->Buffer.data()[pos+4]);
		pos+=msg->Buffer.data()[pos+3];
	}
	(*Debug)->Deb("\n");

	Entry->Numbers.clear();
	Entry->Numbers.push_back(NPBK_NUMBER_HOME);
	Entry->Numbers.push_back(NPBK_NUMBER_MOBILE);
	Entry->Numbers.push_back(NPBK_NUMBER_FAX);
	Entry->Numbers.push_back(NPBK_NUMBER_WORK);
	Entry->Numbers.push_back(NPBK_NUMBER_GENERAL);

	return GSM_Return_Error(GSM_ERR_NONE);
}
