/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include "../../protocol/gsmprot.h"
#include "atgen.h"

//when receive complete message response, direct it to correct method
//(where it will be decoded)
GSM_Error GSM_Phone_ATGEN::Dispatch(GSM_Protocol_Message *msg, void *Struct, int RequestID)
{
	AnsStruct 	AS;

	AS.RequestID  = RequestID;
	AS.FrameFound = false;

if(Ans("AT+CGSN",0,0,ID_GetIMEI+ID,&AS))return ReplyGetIMEI(msg,Debug,(unsigned char *)Struct);

	if (AS.FrameFound) return GSM_Return_Error(GSM_ERR_FRAME_NOT_REQUESTED);
        return GSM_Return_Error(GSM_ERR_FRAME_TYPE_UNKNOWN);
}

GSM_Error GSM_Phone_ATGEN::Open(char *FrameID)
{
        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_ATGEN::ReplyGetIMEI(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *IMEI)
{
	//we should here function, which will split msg->Buffer.data() into
	//lines and will get exactly second line
	memcpy(IMEI,msg->Buffer.data()+9, 16);
	(*Debug)->Deb("IMEI %s\n",IMEI);
        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_ATGEN::GetIMEI(unsigned char *IMEI)
{
	(*Debug)->Deb("SENT: getting IMEI\n");
	return Write((unsigned char *)"AT+CGSN\r", 8, 0, 2, ID_GetIMEI+ID, IMEI);
}
