/* (C) 2003 - 2006 by Marcin Wiacek www.mwiacek.com */

#ifdef WIN32
#  include <windows.h>
#endif

#include "../misc.h"

#ifndef coding_h
#define coding_h

char 		*StringCaseStr			(const char *a, const char *b);
BOOLEAN 	StringCaseCmp			(const char *a, const char *b, int num);

unsigned int 	UnicodeCharToChar		(wchar_t src, char *dest);
int 		CharToUnicodeChar		(const char *src, wchar_t *dest);
void 		StringToUnicode			(char *src, wchar_t *dst);
char 		*UnicodeToStringReturn		(const wchar_t *src);
wchar_t 	*StringToUnicodeReturn		(char *src);
int 		UnicodeLength			(const wchar_t *text);
void 		CopyUnicode			(const wchar_t *src, wchar_t *dest);
wchar_t 	*UnicodeCaseStr			(const wchar_t *a, const wchar_t *b);
BOOLEAN 	UnicodeCaseCmp			(const wchar_t *a, const wchar_t *b, int num);

unsigned char 	BCDCharToChar			(unsigned char value);
void 		BCDToUnicode 			(const unsigned char *src, wchar_t *dest, int len);
unsigned char 	CharToBCD			(unsigned char value);
int 		StringToBCD 			(const unsigned char *src, unsigned char *dest, int len);

int 		UTF8CharToUnicode		(const unsigned char *src, wchar_t *dest, int len);
int 		UnicodeCharToUTF8		(wchar_t src, unsigned char *dest);
void 		UTF8ToUnicode			(const unsigned char *src, wchart *dest, int len);
bool 		UnicodeToUTF8			(const wchar_t *src, unsignedstring *dest);
bool 		UnicodeToUTF8QuotedPrintable	(wchar_t *src, unsignedstring *dest);
void 		UTF8QuotedPrintableToUnicode	(const unsigned char *src, wchar_t *dest, int len);

int 		HexBinCharToNumber		(unsigned char mychar);
unsigned char 	NumberToHexBinChar		(int digit);

#endif
