/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#ifdef WIN32
#  include <windows.h>
#else
#  include <sys/socket.h>
#endif
#include <stdio.h>

#ifndef irda_h
#define irda_h

#include "../../misc/misc.h"
#include "../../service/gsmmisc.h"
#include "../gsmdev.h"

#ifdef WIN32
#  define IRLMP_9WIRE_MODE     22
#  define AF_IRDA              26
#  define IRLMP_ENUMDEVICES    16
#  define SOL_IRLMP            255
#else
#  define LSAP                 255
#  define IRLMP_ENUMDEVICES    1
#  define SOL_IRLMP            266
#endif

typedef struct {
#ifdef WIN32
        unsigned short         AddressFamily;
        char                   Address[4];
#else
	sa_family_t	       AddressFamily;
	char		       LSAP2;
	u_int32_t	       Address;
#endif
        char                   ServiceName[25];
} Irda_Socket;

typedef struct {
#ifdef WIN32
        char                   RemoteAddress[4];
#else
	u_int32_t	       LocalAddress;
	u_int32_t	       RemoteAddress;
#endif
        char                   Name[22];
#ifdef WIN32
        char                   Hints[2];
        char                   CharSet;
#else
        char                   CharSet;
        char                   Hints[2];
#endif
} Irda_Info;

typedef struct {
        unsigned long          Number;
        Irda_Info              Devices[10];
} Irda_Info_List;

class GSM_Device_Infrared:virtual public GSM_Device
{
public:
        GSM_Device_Infrared(DebugInfo **Deb):GSM_Device(Deb) {
		Info.push_back(GSM_Device_Info(Deb,"infrared"));
		Sock = new(GSM_Socket);
        }
	~GSM_Device_Infrared() {
		delete Sock;
	}

        GSM_Error       Open            (char *Dev, char *Prot, char *Pho, char **DeviceModel, GSM_AllPhones *Phones);
        GSM_Error       Close           ();
        GSM_Error       Read            (unsigned char *buf, int *len);
        GSM_Error       Write           (const unsigned char *buf, int len);
private:
	int		Device;
	GSM_Socket	*Sock;
};

#endif
