/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include "../../cfg/config.h" //msvc2005
#include <string.h>
#ifdef WIN32
#  include <windows.h>
#else
#  include <sys/socket.h>
#endif

#include "gsmdev.h"
#include "../protocol/gsmprot.h"

GSM_Device::GSM_Device(DebugInfo **Deb)
{
        Next            = NULL;
        Debug           = Deb;
	Opened		= false;
}

GSM_Device::~GSM_Device()
{
}

GSM_Error GSM_Device::SetParameters(int speed, int bits, bool parity, int stopbits)
{
        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Device::SetLines(bool dtr, bool rts)
{
        return GSM_Return_Error(GSM_ERR_NONE);
}

/* ------------------------------------------------------------------------- */

GSM_Device_Info::GSM_Device_Info(DebugInfo **Deb, char *Dev)
{
        Device  = Dev;
        Debug   = Deb;
}

GSM_Device_Info::~GSM_Device_Info()
{
}

/* ------------------------------------------------------------------------- */

GSM_AllDevices::GSM_AllDevices(DebugInfo **Deb)
{
        AllDevices      = NULL;
        Current         = NULL;
        Debug           = Deb;
}

int GSM_AllDevices::GetNext(GSM_Device **Dev)
{
        if ((*Dev) == NULL) {
                (*Dev) = AllDevices;
        } else {
                if ((*Dev)->Next == NULL) return 0;
                (*Dev) = ((*Dev)->Next);
        }
        return 1;
}

GSM_AllDevices::~GSM_AllDevices()
{
        GSM_Device *dev,*dev2;

        dev=AllDevices;
        while(1) {
                if (dev == NULL) break;
                dev2 = dev->Next;
                delete(dev);
                dev = dev2;
        }
}

void GSM_AllDevices::Add(GSM_Device *Device)
{
        GSM_Device *Dev;

        if (AllDevices == NULL) {
                AllDevices = Device;
        } else {
                Dev = AllDevices;
                while (Dev->Next != NULL) Dev = Dev->Next;
                Dev->Next = Device;
        }
}

GSM_Error GSM_AllDevices::Switch(char *Pro, GSM_AllProtocols *AllProt, GSM_AllPhones *AllPhon, char *Dev)
{
        GSM_Device              		*dev;
        GSM_Protocol            		*Prot = NULL;
        GSM_Error               		error;
	list<GSM_Device_Info>::iterator 	devinfo;
	list<GSM_Protocol_Info>::iterator 	proinfo;

	(*Debug)->Deb("[STATE     : switching to device]\n");

        /* First search for protocol in protocols */
        error = AllProt->Find(Pro, &Prot, AllPhon);
        if (error.Code != GSM_ERR_NONE) return error;

	for (proinfo=Prot->Info.begin(); proinfo!=Prot->Info.end(); ++proinfo) {
		if (!strcmp(Pro,(*proinfo).Protocol)) break;
        }

        /* Searching for device driver connected with protocol */
        dev=AllDevices;
        while(1) {
		for (devinfo=dev->Info.begin(); devinfo!=dev->Info.end(); ++devinfo) {
                        if (!strcmp((*proinfo).Device,(*devinfo).Device)) {
//				(*Debug)->Deb("[STATE     : switched to %s %s]\n",proinfo->Device,devinfo->Device);
				strcpy(CurrentName,Dev);
                                if (Current != NULL) {
                                        //disable old device
                                }
                                Current = dev;
                                return GSM_Return_Error(GSM_ERR_NONE);
                        }			
		}
                if (dev->Next == NULL) break;
                dev = dev->Next;
        }

        /* No device driver. Not compiled ? */
        return GSM_Return_Error(GSM_ERR_SOURCE_NOT_COMPILED);
}

/* ------------------------------------------------------------------------- */

GSM_Error GSM_Socket::Init(DebugInfo **Deb)
{
	Debug = Deb;
#ifdef WIN32
        WSADATA WSAData;

        if (WSAStartup(MAKEWORD(1,1), &WSAData) != 0) {
	        Error("WSAStartup");
		return GSM_Return_Error(GSM_ERR_DRIVER_NOT_AVAILABLE);
        }

        if (LOBYTE(WSAData.wVersion) != 1 || HIBYTE(WSAData.wVersion) != 1) {
                WSACleanup();
		return GSM_Return_Error(GSM_ERR_DRIVER_NOT_AVAILABLE);
        }
#endif
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Socket::Write(SOCKET Device, const unsigned char *buf, int len)
{
	int SentAll = 0, Sent;
	
	while(1) {
		Sent = send(Device,(const char *)(buf+SentAll),len-SentAll,0);
#ifdef WIN32
		if (Sent == SOCKET_ERROR) {
#else
		if (Sent < 0) {
#endif
		        Error("send");
			return GSM_Return_Error(GSM_ERR_DEVICE_WRITE);
		}
		SentAll += Sent;
		if (SentAll = len) return GSM_Return_Error(GSM_ERR_NONE);
	}
        return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Socket::Read(SOCKET Device, unsigned char *buf, int *len)
{
	int 		Rec;
	fd_set 		readfds;
	struct timeval 	timer;

	FD_ZERO(&readfds);
	FD_SET(Device, &readfds);

	memset(&timer,0,sizeof(timer));
	//in win32 first parameter is ignored
	Rec = select(Device+1, &readfds, NULL, NULL, &timer);
#ifdef WIN32
 	if (Rec == SOCKET_ERROR) {
#else
	if (Rec < 0) {
#endif
		*len = 0;
	        Error("select");
		return GSM_Return_Error(GSM_ERR_DEVICE_READ);
	}
	if (Rec == 0) {
		*len = 0;
		return GSM_Return_Error(GSM_ERR_NONE);
	}

        Rec = recv(Device,(char *)(buf),*len,0);
#ifdef WIN32
 	if (Rec == SOCKET_ERROR) {
#else
	if (Rec < 0) {
#endif
//		printf("%i\n",WSAGetLastError());
		*len = 0;
	        Error("recv");
		return GSM_Return_Error(GSM_ERR_DEVICE_READ);
	}
	*len = Rec;

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Socket::Close(SOCKET Device)
{
#ifdef WIN32
	if (closesocket(Device) == SOCKET_ERROR) {
	        Error("closesocket");
		return GSM_Return_Error(GSM_ERR_DEVICE_CLOSE);
	}
        WSACleanup();
#else
	close(Device);
#endif
        return GSM_Return_Error(GSM_ERR_NONE);
}

void GSM_Socket::Error(char *Description)
{
	(*Debug)->Deb("SOCKET ERROR: %s\n",Description);
}
