//---------------------------------------------------------------------------
//
// Name:        MainFrm.cpp
// Author:      Marcinello
// Created:     2007-01-25 18:04:29
// Description: MainFrm class implementation
//
//---------------------------------------------------------------------------

#include "MainFrm.h"
#include "PhoneFrm.h"
#include "MMSFrm.h"
#include "CfgDlg.h"
#include "AboutDlg.h"
#include "shared.h"

//Do not add custom headers between
//Header Include Start and Header Include End
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// MainFrm
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(MainFrm,wxMDIParentFrame)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(MainFrm::OnClose)
	EVT_MENU(ID_MNU_NEWPHONE_1003, MainFrm::Mnunewphone1003Click)
	EVT_MENU(ID_MNU_OPENBACKUPFILE_1010, MainFrm::Mnuopenbackupfile1010Click)
	EVT_MENU(ID_MNU_VIEWMMSFILE_1008, MainFrm::Mnuviewmmsfile1008Click)
	EVT_MENU(ID_MNU_EXIT_1007, MainFrm::Mnuexit1007Click)
	EVT_MENU(ID_MNU_CHECKFORUPDATE____1011, MainFrm::Mnucheckforupdate1011Click)
	EVT_MENU(ID_MNU_ABOUT____1005, MainFrm::Mnuabout1005Click)
END_EVENT_TABLE()
////Event Table End

MainFrm::MainFrm(wxWindow *parent, wxWindowID id, const wxString& title, const wxPoint& pos, const wxSize& size, long style, const wxString& name)
: wxMDIParentFrame(parent, id, title, pos, size, style, name)
{
	CreateGUIControls();
}

MainFrm::~MainFrm()
{
}

void MainFrm::CreateGUIControls()
{
    char buff[200];
    
	//Do not add custom code between
        //GUI Items Creation Start and GUI Items Creation End
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	WxStatusBar1 = new wxStatusBar(this, ID_WXSTATUSBAR1);

	WxOpenFileDialog1 =  new wxFileDialog(this, wxT("Choose a file"), wxT(""), wxT(""), wxT("*.*"), wxOPEN | wxFILE_MUST_EXIST);

	WxMenuBar1 = new wxMenuBar();
	wxMenu *ID_MNU_FILE_1002_Mnu_Obj = new wxMenu(0);
	ID_MNU_FILE_1002_Mnu_Obj->Append(ID_MNU_NEWPHONE_1003, wxT("Open phone connection"), wxT(""), wxITEM_NORMAL);
	ID_MNU_FILE_1002_Mnu_Obj->AppendSeparator();
	ID_MNU_FILE_1002_Mnu_Obj->Append(ID_MNU_OPENBACKUPFILE_1010, wxT("Open backup file"), wxT(""), wxITEM_NORMAL);
	ID_MNU_FILE_1002_Mnu_Obj->Append(ID_MNU_VIEWMMSFILE_1008, wxT("Open MMS file"), wxT(""), wxITEM_NORMAL);
	ID_MNU_FILE_1002_Mnu_Obj->AppendSeparator();
	ID_MNU_FILE_1002_Mnu_Obj->Append(ID_MNU_EXIT_1007, wxT("Exit"), wxT(""), wxITEM_NORMAL);
	WxMenuBar1->Append(ID_MNU_FILE_1002_Mnu_Obj, wxT("&File"));
	
	wxMenu *ID_MNU_HELP_1004_Mnu_Obj = new wxMenu(0);
	ID_MNU_HELP_1004_Mnu_Obj->Append(ID_MNU_CHECKFORUPDATE____1011, wxT("Check for updates..."), wxT(""), wxITEM_NORMAL);
	ID_MNU_HELP_1004_Mnu_Obj->AppendSeparator();
	ID_MNU_HELP_1004_Mnu_Obj->Append(ID_MNU_ABOUT____1005, wxT("About..."), wxT(""), wxITEM_NORMAL);
	WxMenuBar1->Append(ID_MNU_HELP_1004_Mnu_Obj, wxT("Help"));
	SetMenuBar(WxMenuBar1);

	WxSaveFileDialog1 =  new wxFileDialog(this, wxT("Choose a file"), wxT(""), wxT(""), wxT("*.*"), wxSAVE | wxOVERWRITE_PROMPT);

	SetStatusBar(WxStatusBar1);
	SetTitle(wxT("gui"));
	SetIcon(wxNullIcon);
	SetSize(8,8,627,571);
	Center();
	
	////GUI Items Creation End
	
        sprintf(buff, "Gammu+ %s",VERSION);
    	SetTitle(wxT(buff));
	
}

void MainFrm::OnClose(wxCloseEvent& event)
{
	Destroy();
}

/*
 * Mnunewphone1003Click
 */
void MainFrm::Mnunewphone1003Click(wxCommandEvent& event)
{
    GSM_Backup          *Backup;
    GSM_Error           error;
    GSM_StateMachine    *s;
    CfgDlg              *dialog;
    PhoneFrm            *subframe;
    char                buff[200];
    unsigned char       Model[50];
    unsigned char       Firm[50];
    unsigned char       Man[50];
    GSM_GPlusConfig     CFG;
    GSM_DateTime        DT;

    s = new GSM_StateMachine(NULL,"",false);

    dialog = new CfgDlg(&CFG,s,this,-1,"About...",wxDefaultPosition,wxDefaultSize,CfgDlg_STYLE);

    while (true) {
        if (dialog->ShowModal()!= wxID_OK) {
            delete(s);
            dialog->Destroy();
            return;
        }
        
        delete (s);
        if (!strcmp(CFG.LogLevel,"nothing")) {
            s = new GSM_StateMachine(NULL,"",false);
        } else {
            s = new GSM_StateMachine(NULL,CFG.LogFile,true);
        }
        
        error = s->Open(&CFG);
        if (error.Code == GSM_ERR_NONE) break;
        PrintError (error);
    }
    
    dialog->Destroy();

	error = s->Phones->Current->GetManufacturer(Man);
    PrintError(error);

	error = s->Phones->Current->GetModel(Model);
	PrintError(error);

	error = s->Phones->Current->GetFirmwareVersion(Firm);
	PrintError(error);

    if (!strcmp(CFG.SyncTime,"yes")) {
        GSM_GetCurrentDateTime(&DT);
    	error = s->Phones->Current->SetDateTime(&DT);
    	PrintError(error);
    }

    sprintf(buff, "Phone %s %s %s",Man,Model,Firm);

    Backup = new GSM_Backup;
    
    subframe = new PhoneFrm(TRUE, Backup,this, wxID_ANY, buff,
                             wxPoint(-1, -1), wxSize(-1, -1),
                             wxDEFAULT_FRAME_STYLE |
                             wxNO_FULL_REPAINT_ON_RESIZE,"ala",s,Man,Model,Firm);                            
    if (!strcmp(CFG.GetOnlineInfo,"yes")) {
         subframe->GetOnlineInfo();
    }

    subframe->Maximize();
}

/*
 * Mnuabout1005Click
 */
void MainFrm::Mnuabout1005Click(wxCommandEvent& event)
{
    AboutDlg *dialog = new AboutDlg(this,-1,"About...",wxDefaultPosition,wxDefaultSize,AboutDlg_STYLE);

    dialog->ShowModal();

    dialog->Destroy();
}

/*
 * Mnuexit1007Click
 */
void MainFrm::Mnuexit1007Click(wxCommandEvent& event)
{
	exit(0);
}

/*
 * Mnuviewmmsfile1008Click
 */
void MainFrm::Mnuviewmmsfile1008Click(wxCommandEvent& event)
{
    MMSFrm              *subframe;
    char                buff[5000];
    GSM_File            *File;
	GSM_SMSMMSDecodedEntry  *Decoded;    
	GSM_Error           error;

    WxOpenFileDialog1->SetMessage("Please select MMS file for open");
    if (WxOpenFileDialog1->ShowModal()!=wxID_OK) return;

    sprintf(buff, "MMS file %s",(char *)WxOpenFileDialog1->GetPath().c_str());

    File = new GSM_File;
    File->ReadFromDisk(StringToUnicodeReturn((char *)WxOpenFileDialog1->GetPath().c_str()));
    
    Decoded = new GSM_SMSMMSDecodedEntry;
    error = Decoded->ReadFromMMS(File);
    if (PrintError(error)) {
        delete File;
        delete Decoded;
        return;
    }
        
    subframe = new MMSFrm(this, wxID_ANY, buff,
                             wxPoint(-1, -1), wxSize(-1, -1),
                             wxDEFAULT_FRAME_STYLE |
                             wxNO_FULL_REPAINT_ON_RESIZE,"ala",File,Decoded);
    subframe->Maximize();
}

/*
 * Mnuopenbackupfile1010Click
 */
void MainFrm::Mnuopenbackupfile1010Click(wxCommandEvent& event)
{
    GSM_Backup *Backup;
    GSM_Error  error;
    PhoneFrm    *subframe;
    char        buff[5000];

    WxOpenFileDialog1->SetMessage("Please select backup file for open");
    if (WxOpenFileDialog1->ShowModal()!=wxID_OK) return;

    sprintf(buff, "Backup file %s",(char *)WxOpenFileDialog1->GetPath().c_str());
    
    Backup = new GSM_Backup;
    
	error = Backup->ReadFromFile((char *)WxOpenFileDialog1->GetPath().c_str());
	if (error.Code != GSM_ERR_NONE) {
        delete Backup;
    	PrintError(error);
    	return;
    }
                               
    subframe = new PhoneFrm(FALSE, Backup,this, wxID_ANY, buff,
                             wxPoint(-1, -1), wxSize(-1, -1),
                             wxDEFAULT_FRAME_STYLE |
                             wxNO_FULL_REPAINT_ON_RESIZE,"ala",NULL,NULL,NULL,NULL);
    subframe->Maximize();    
}

/*
 * Mnucheckforupdate1011Click
 */
void MainFrm::Mnucheckforupdate1011Click(wxCommandEvent& event)
{
	unsignedstring Stable,Test;
	char           buff[200],buffer[200];
	GSM_Error      error;

    error = CheckRSS(&Stable, &Test);
    if (error.Code != GSM_ERR_NONE) {
        wxMessageBox(wxT("Getting info not possible now"),"Error",
               wxICON_WARNING | wxOK);
        return;
    }

    buff[0] = 0;
    if (Test.length()!=0) {
        sprintf(buff+strlen(buff),"Available test version: %s",Test.data());
    }
    if (Stable.length()!=0) {
        if (strlen(buff)!=0) sprintf(buff+strlen(buff),"\n");
        sprintf(buff+strlen(buff),"Available stable version: %s",Stable.data());
    }
    if (strlen(buff)!=0) {
        sprintf(buffer,"Currently used version: %s\n\n%s",VERSION,buff);
        wxMessageBox(buffer,"Update available",
               wxICON_INFORMATION | wxOK);
    } else {
        wxMessageBox(wxT("You're using latest version"),"No update available",
               wxICON_INFORMATION | wxOK);
    }
}
