/* (C) 2003 - 2006 by Marcin Wiacek www.mwiacek.com */

void GetSMSStatus(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_SMSStatus		Status;
	GSM_Error		error;

	error = s->Open(CFG);
	PrintError(error);

	Status.Memory = MEM_SIM;
	error = s->Phones->Current->GetSMSStatus(&Status);
	PrintError(error);

	printf("SIM card : %i SMS read, %i SMS unread, %i SMS free\n",
		Status.SMSRead,Status.SMSUnRead,Status.SMSFree);

	Status.Memory = MEM_PHONE;
	error = s->Phones->Current->GetSMSStatus(&Status);
	if (error.Code == GSM_ERR_NOT_SUPPORTED) {
		printf("Phone memory : not supported\n");
	} else {
		PrintError(error);

		printf("Phone memory : %i SMS read, %i SMS unread, %i SMS free\n",
			Status.SMSRead,Status.SMSUnRead,Status.SMSFree);
	}
}

int SMSSendTPMR = -2;

void SMSSendReply(int TPMR)
{
	SMSSendTPMR = TPMR;
}

void SendSMS(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_SMSList		Entry;
	GSM_SMSEntry		SMS;
	GSM_Error		error;
	GSM_SMSC		SMSC;

	error = s->Open(CFG);
	PrintError(error);

	SMSC.Location = 1;
	error = s->Phones->Current->GetSMSC(&SMSC);
	PrintError(error);

	SMS.SetType(SMS_Submit);
	SMS.SetCoding(SMS_Coding_Default_No_Compression);
	error = SMS.SetDecodedText(StringToUnicodeReturn(argv[1]));
	PrintError(error);
	SMS.PhoneNumbers.Add(StringToUnicodeReturn(argv[0]));
	SMS.SetSMSCNumber(SMSC.GetSMSCNumber());

	//we set handler
	s->SetSMSSendReply(SMSSendReply);

	error = s->Phones->Current->SendSMS(&SMS);
	PrintError(error);

	while (true) {
#ifdef WIN32
		Sleep(5);
#else
		usleep(500);
#endif
		s->Phones->Current->Read(-1,NULL);

		if (SMSSendTPMR != -2) break;
	}

	if (SMSSendTPMR == -1) {
		printf("Sending error\n");
	} else {
		printf("Sent OK\n");
	}

	//we set handler
	s->SetSMSSendReply(NULL);
}

void AddSMS(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_SMSList		Entry;
	GSM_SMSEntry		SMS;
	GSM_Error		error;
	GSM_DateTime		DT;

	error = s->Open(CFG);
	PrintError(error);

	SMS.SetType(SMS_Deliver);
//	SMS.SetCoding(SMS_Coding_Unicode_No_Compression);
	SMS.SetCoding(SMS_Coding_Default_No_Compression);
	SMS.SetDecodedText(StringToUnicodeReturn("bzyk"));
	SMS.PhoneNumbers.Add(StringToUnicodeReturn("+48601602602"));
	SMS.SetSMSCNumber(StringToUnicodeReturn("+48602602602"));

	DT.Year = 2000; DT.Month = 10; DT.Day = 2;
	DT.Hour=14; DT.Minute=5; DT.Second = 3;
	SMS.SetDateTime(&DT);
	SMS.Icon = SMS_UnRead;
	SMS.Name.append(StringToUnicodeReturn("cos"),3);
	
	Entry.Add(&SMS);
	Entry.Folder=1;

	error = s->Phones->Current->AddSMS(&Entry);
	PrintError(error);
}

void DeleteSMS(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_SMSList		Entry;
	GSM_SMSEntry		SMS;
	GSM_Error		error;

	error = s->Open(CFG);
	PrintError(error);

	SMS.ID.append((const wchar_t *)StringToUnicodeReturn(argv[0]),strlen(argv[0]));
	Entry.Add(&SMS);

	error = s->Phones->Current->DeleteSMS(&Entry);
	PrintError(error);
}

void GetAllPbkForSMS(GSM_StateMachine *s, GSM_Backup *Backup)
{
	GSM_PBKEntry	*PBKEntry;
	GSM_PBKStatus	Status;
	int		Pos=1,i=0;
	GSM_Error	error;

	Status.Memory=MEM_PHONE;
	error = s->Phones->Current->GetPBKStatus(&Status);
	PrintError(error);
	while (i!=Status.Used) {
		PBKEntry 		= new GSM_PBKEntry;
		PBKEntry->Memory	= MEM_PHONE;
		PBKEntry->Location 	= Pos;
		error = s->Phones->Current->GetPBK(PBKEntry);
		if (error.Code != GSM_ERR_EMPTY) {
			if (error.Code != GSM_ERR_NONE) delete(PBKEntry);
			PrintError(error);
			i++;
			Backup->Add_PBK(PBKEntry);
		} else {
			delete(PBKEntry);
		}
		Pos++;		
	}
}

void DisplaySMSNumber(wchar_t *Number, GSM_Backup *Backup)
{
	GSM_Backup_PBKEntry 	*Entry = NULL;
	GSM_PBKSubEntry 	*SubEntry;
	BOOLEAN			Found=FALSE, Found2=FALSE, Found3=FALSE;

	printf("\"%s\"",UnicodeToStringReturn(Number));
	if (Backup == NULL) {
		printf("\n");
		return;
	}
	while (Backup->GetNext_PBK(&Entry)) {
		SubEntry = NULL;
		while (Entry->GetEntry()->GetNext(&SubEntry) == TRUE) {
			switch (SubEntry->GetType()) {
			case PBK_Text_Phone_General:
			case PBK_Text_Phone_Mobile:
			case PBK_Text_Phone_Home:
			case PBK_Text_Phone_Work:
			case PBK_Text_Phone_Fax:
				if (!UnicodeCaseCmp(Number,SubEntry->GetText(),-1)) break;
				printf(" (");
				Found = TRUE;
				Found2 = TRUE;
				switch (SubEntry->GetType()) {
				case PBK_Text_Phone_Mobile: printf("mobile"); break;
				case PBK_Text_Phone_Home  : printf("home");   break;
				case PBK_Text_Phone_Work  : printf("work");   break;
				case PBK_Text_Phone_Fax   : printf("fax");    break;
				default			  : Found2 = FALSE;   break;					
				}
				break;
			default:
				break;
			}
			if (Found) break;
		}
		if (!Found) continue;
		SubEntry = NULL;
		while (Entry->GetEntry()->GetNext(&SubEntry) == TRUE) {
			switch (SubEntry->GetType()) {
			case PBK_Text_Name_Last:
			case PBK_Text_Name_First:
				if (Found2) printf(",");
				if (Found3) printf(" ");
				printf("%s",UnicodeToStringReturn(SubEntry->GetText()));
				Found2 = TRUE;
				Found3 = TRUE;
				break;
			default:
				break;
			}
		}
		SubEntry = NULL;
		while (Entry->GetEntry()->GetNext(&SubEntry) == TRUE) {
			switch (SubEntry->GetType()) {
			case PBK_Text_Name:
				if (Found2) printf(", ");
				printf("%s",UnicodeToStringReturn(SubEntry->GetText()));
				break;
			default:
				break;
			}
		}
		printf(")\n");
		if (Found) break;
	}
	if (!Found) printf("\n");
}

int DisplaySingleSMS(GSM_SMSEntry *SMS, GSM_Backup *Backup)
{
	GSM_DateTime		DT;
	unsignedstring		Buffer2, UDH;
	UDHList 		UDH2;
	wchar_t			Buffer[500];
	GSM_Error		error,error2;
	GSM_SMSList		Entry;
	GSM_SMSMMSFolders	Folders;
	BOOLEAN 		start = TRUE;
	unsigned int		j=0, smsnum=0, smsparts=0, z=0, lastfolder=0,num=0;
	GSM_SMSNumbersSubEntry  *Number;

	switch (SMS->GetType()) {
	case SMS_Deliver:
		printf("  SMS Deliver\n");
		error = SMS->GetSMSCNumber(Buffer);
	    	PrintError(error);
		printf("    SMSC Number         : \"%s\"\n",UnicodeToStringReturn(Buffer));
		SMS->GetDateTime(&DT);
		printf("    Sending date & time : %02i:%02i:%02i %02i-%02i-%04i %s\n",
			DT.Hour,DT.Minute,DT.Second,DT.Day,DT.Month,DT.Year,
			DayOfWeekStr(DT.Year,DT.Month,DT.Day));
		/* no break */
	case SMS_Submit:
		if (SMS->GetType() == SMS_Submit)   printf("    SMS Submit\n");
		Number = NULL;
		while (SMS->PhoneNumbers.GetNext(&Number)) {
			error = Number->GetPhoneNumber(Buffer);
	   		PrintError(error);
			if (UnicodeLength(Buffer)!=0) {
				printf("    Phone Number        : ");
				DisplaySMSNumber(Buffer, Backup);
				num++;
			}			
		}
		if (SMS->GetClass() != -1) 	    printf("    SMS Class                   : %i\n",SMS->GetClass());
		if (SMS->GetSenderSMSCReply() == TRUE) printf("    SMSC reply                  : yes\n");

		error = SMS->GetUDH(&UDH);
		PrintError(error);
		if (UDH.size()!=0) {
			error = SMS->DecodeUDH(&UDH2);
			printf("    UDH                 : ");
			if (error.Code == GSM_ERR_NONE) {
				for (j=0;j<UDH2.size();j++) {
					switch (UDH2.data()[j].Type) {
					case SMS_UDH_Linked_Short:
						printf("linked (short, ID %i, part %i/%i)",UDH2.data()[j].ID8bit,UDH2.data()[j].PartNumber8bit,UDH2.data()[j].AllParts8bit);
						break;
					case SMS_UDH_Linked_Long:
						printf("linked (long, ID %i, part %i/%i)",UDH2.data()[j].ID16bit,UDH2.data()[j].PartNumber8bit,UDH2.data()[j].AllParts8bit);
						break;
					}
				}
			}
			printf("\n");
		}

		printf("    Coding              : ");
		switch (SMS->GetCoding()) {
	    	case SMS_Coding_Unicode_No_Compression:
			error = SMS->GetDecodedText(Buffer);
		  	PrintError(error);
			printf("Unicode, no compression\n%s\n",UnicodeToStringReturn(Buffer));
			break;
		case SMS_Coding_Unicode_Compression:
			printf("Unicode, compression, no support from Gammu+ now\n");
			break;
		case SMS_Coding_Default_No_Compression:
			error = SMS->GetDecodedText(Buffer);
			PrintError(error);
			printf("Default, no compression\n%s\n",UnicodeToStringReturn(Buffer));
			break;
		case SMS_Coding_Default_Compression:
			printf("Default, compression, no support from Gammu+ now\n");
			break;
		case SMS_Coding_8bit:
			printf("8 bit\n");
			break;
		}
		break;
	case SMS_Report:
		printf("  SMS report\n");
		error = SMS->GetSMSCNumber(Buffer);
		PrintError(error);
		printf("    SMSC Number \"%s\"\n",UnicodeToStringReturn(Buffer));

		Number = NULL;
		while (SMS->PhoneNumbers.GetNext(&Number)) {
			error = Number->GetPhoneNumber(Buffer);
	   		PrintError(error);
			if (UnicodeLength(Buffer)!=0) {
				printf("    Phone Number        : ");
				DisplaySMSNumber(Buffer, Backup);
				num++;
			}			
		}

		SMS->GetDateTime(&DT);
		printf("    Sending date & time %02i:%02i:%02i %02i-%02i-%04i %s\n",
			DT.Hour,DT.Minute,DT.Second,DT.Day,DT.Month,DT.Year,
			DayOfWeekStr(DT.Year,DT.Month,DT.Day));
		SMS->GetSMSCTime(&DT);
		printf("    Receiving date & time %02i:%02i:%02i %02i-%02i-%04i %s\n",
			DT.Hour,DT.Minute,DT.Second,DT.Day,DT.Month,DT.Year,
			DayOfWeekStr(DT.Year,DT.Month,DT.Day));
		switch (SMS->GetReportStatus()) {
		case SMS_Status_Delivered:
			printf("Delivered - ");
			switch ((SMS->TPStatus & 0x7F)) {
				case 0x00:printf("SMS received by recipient\n");					break;
				case 0x01:printf("SMS forwarded to recipient by SMSC, SMSC can't confirm delivery\n");	break;
				case 0x02:printf("SMS replaced by SMSC\n");						break;
			}
			break;
		case SMS_Status_Unknown:
			printf("Unknown");
			if ((SMS->TPStatus & 0x80) == 0x80) break;
			if ((SMS->TPStatus & 0x7F)>=0x03 &&
			    (SMS->TPStatus & 0x7F)<=0x0F) {
				printf(" - error 'reserved' in specification\n");
			}
			if ((SMS->TPStatus & 0x7F)>=0x10 &&
			    (SMS->TPStatus & 0x7F)<=0x1F) {
				printf(" - error specific to SMSC\n");
			}
			break;					
		case SMS_Status_Pending:
			printf("Pending - temporary error, SMSC still trying to transfer SMS, ");
			switch ((SMS->TPStatus & 0x7F)) {
				case 0x20: printf("congestion\n");			break;
				case 0x21: printf("recipient busy\n");			break;
				case 0x22: printf("no response from recipient\n");	break;
				case 0x23: printf("service rejected\n");		break;
				case 0x24: printf("quality of service not available\n");break;
				case 0x25: printf("error in recipient\n");		break;
			}
			if ((SMS->TPStatus & 0x7F)>=0x26 &&
			    (SMS->TPStatus & 0x7F)<=0x2F) {
				printf("error 'reserved' in specification\n");
			}
			if ((SMS->TPStatus & 0x7F)>=0x30 &&
			    (SMS->TPStatus & 0x7F)<=0x3F) {
				printf("error specific to SMSC\n");
			}
			break;
		case SMS_Status_Failed:				
			printf("Failed - ");
			if ((SMS->TPStatus & 0x7F)>=0x40 &&
			    (SMS->TPStatus & 0x7F)<=0x5F) {
				printf("permanent error, no more SMS transfer attempts from SMSC, ");
				switch ((SMS->TPStatus & 0x7F)) {
				        case 0x40: printf("remote procedure error\n");			break;
				        case 0x41: printf("incompatibile destination\n");		break;
				        case 0x42: printf("connection rejected by recipient\n");	break;
				        case 0x43: printf("not obtainable\n");				break;
				        case 0x44: printf("quality of service not available\n");	break;
				        case 0x45: printf("no internetworking available\n");		break;
				        case 0x46: printf("SMS validity period expired\n");		break;
				        case 0x47: printf("SMS deleted by originating recipient\n");	break;
				        case 0x48: printf("SMS deleted by SMSC administration\n");	break;
				        case 0x49: printf("SMS does not exist\n");			break;
				}
				if ((SMS->TPStatus & 0x7F)>=0x4A &&
				    (SMS->TPStatus & 0x7F)<=0x4F) {
					printf("error 'reserved' in specification\n");
				}
				if ((SMS->TPStatus & 0x7F)>=0x50 &&
				    (SMS->TPStatus & 0x7F)<=0x5F) {
					printf("error specific to SMSC\n");
				}
			}
			if ((SMS->TPStatus & 0x7F)>=0x60) {
				printf("temporary error, no more SMS transfer attempts from SMSC, ");
				switch ((SMS->TPStatus & 0x7F)) {
					case 0x60: printf("congestion\n");			break;
					case 0x61: printf("recipient busy\n");			break;
					case 0x62: printf("no response from recipient\n");	break;
					case 0x63: printf("service rejected\n");		break;
					case 0x64: printf("quality of service not available\n");break;
					case 0x65: printf("error in recipient\n");		break;
				}
				if ((SMS->TPStatus & 0x7F)>=0x66 &&
				    (SMS->TPStatus & 0x7F)<=0x6F) {
					printf("error 'reserved' in specification\n");
				}
				if ((SMS->TPStatus & 0x7F)>=0x70) {
					printf("error specific to SMSC\n");
				}
			}
		}
	}
	return num;
}

void GetAllSMS(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	unsignedstring			Buffer2, UDH;
	GSM_Error			error,error2;
	GSM_SMSList			Entry;
	GSM_MMSEntry		 	Entry2;
	GSM_SMSListSubEntry		*SubEntry;
	GSM_SMSMMSFolders		Folders;
	GSM_SMSMMSFoldersSubEntry  	*SubFolder2;
	GSM_SMSEntry			*SMS;
	BOOLEAN 			start = TRUE;
	int				j=0, smsnum=0, smsparts=0, z=0,num;
	int 				Current, MaxInFolder;
	int				FolderMax=0, CurrentFolder = 0, CurrentFolder2 = 0;
	GSM_Backup 			Backup;
	wchart				PrevID,buff;
	GSM_FileFolderInfoList 		Folder;

	error = s->Open(CFG);
	PrintError(error);

	error2 = s->Phones->Current->GetSMSMMSFolders(&Folders);
	PrintError(error2);
	FolderMax = 0;
	SubFolder2 = NULL;
	while (Folders.GetNext(&SubFolder2) == TRUE) {
		if (SubFolder2->MMS) continue;
		FolderMax ++;
	}

	GetAllPbkForSMS(s, &Backup);

	error.Code = GSM_ERR_EMPTY;
	SubFolder2 = NULL;
	while (true) {
		if (error.Code == GSM_ERR_EMPTY) {
			start = FALSE;
			while (Folders.GetNext(&SubFolder2) == TRUE) {
				CurrentFolder++;
				if (SubFolder2->MMS) continue;
				CurrentFolder2++;
				buff.clear();
				buff.push_back('-');
				buff.append(SubFolder2->ID);
				buff.push_back('-');
				if (wcsstr(PrevID.data(),buff.data())!=NULL) continue;
				start = TRUE;
				Folder.ClearAll();
				break;
			}
			
			if (!start) break;
			
			PrevID.push_back('-');
			PrevID.append(SubFolder2->ID);
			PrevID.push_back('-');
			start = TRUE;
		}
		error = s->Phones->Current->GetNextSMSMMSIDFromFolder(start, SubFolder2, &Entry,&Entry2, &Current, &MaxInFolder);
		if (error.Code == GSM_ERR_EMPTY) continue;
		if (error.Code == GSM_ERR_FOLDER_MORE) {
			if (start) {
				j=0;
			}
			j++;
			PrintStdErr("Reading content of '%s' (folder %i/%i): %i",UnicodeToStringReturn(SubFolder2->GetName()),CurrentFolder2,FolderMax,j);
			PrintTimeLeftReset();
			start = FALSE;
			continue;
		}
		start = FALSE;
		if (error.Code == GSM_ERR_FOLDER_PART) {
			PrintStdErr("");
			printf("\nThere is available only part of SMS folder %s\n",UnicodeToStringReturn(SubFolder2->GetName()));
			continue;
		}
		PrintStdErr("");
		PrintError(error);

		//mms
		if (Entry.Folder == 0) continue;


		if (CurrentFolder != Entry.Folder) continue;

		smsnum++;

		SubEntry = NULL;
		while (Entry.GetNext(&SubEntry) == TRUE) {
			smsparts++;

			SMS = SubEntry->GetSMS();

			printf("\nMemory %s, ",GSM_GetMemoryName(SMS->Memory));
			printf("folder %s, ",UnicodeToStringReturn(SubFolder2->GetName()));

			switch (SMS->Icon) {
				case SMS_Read	: printf("read"); 	break;
				case SMS_UnRead	: printf("unread"); 	break;
				case SMS_Sent	: printf("sent"); 	break;
				case SMS_UnSent	: printf("unsent"); 	break;
			}

			Buffer2.clear();
			UnicodeToUTF8QuotedPrintable((wchar_t *)SMS->ID.data(), &Buffer2);
			printf(", ID \"%s\"",Buffer2.data());

			printf("\n");
			if (SMS->Name.length()!=0) {
//				printf("  Name %s\n",UnicodeToStringReturn(SMS->GetName()));
			}
			if (SMS->SaveDateTimeAvailable == TRUE) {
				printf("  Saved %02i:%02i:%02i %02i-%02i-%04i %s\n",
					SMS->SaveDateTime.Hour,
					SMS->SaveDateTime.Minute,
					SMS->SaveDateTime.Second,
					SMS->SaveDateTime.Day,
					SMS->SaveDateTime.Month,
					SMS->SaveDateTime.Year,
					DayOfWeekStr(
						SMS->SaveDateTime.Year,
						SMS->SaveDateTime.Month,
						SMS->SaveDateTime.Day));
			}

			num = DisplaySingleSMS(SMS,&Backup);
			if (num > 1) {
				smsnum+=num-1;
				smsparts+=num-1;
			}
		}		
	}

	PrintStdErr("");

	printf("\n%i SMS parts in %i SMS sequences\n",smsparts,smsnum);
}

void GetEachSMS(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	unsignedstring			Buffer2, UDH;
	GSM_Error			error,error2;
	GSM_SMSList			*Entry;
	GSM_MMSEntry 		Entry2;
	GSM_SMSListSubEntry		*SubEntry;
	GSM_SMSMMSFolders		Folders;
	GSM_SMSMMSFoldersSubEntry  	*SubFolder2;
	GSM_SMSEntry			*SMS;
	BOOLEAN 			start = TRUE, first = TRUE;
	int				i, j=0, smsnum=0, smsparts=0, z=0,num;
	int 				CurrentFolder=0, CurrentFolder2 = 0, FolderMax=0;
	int				Current, MaxInFolder;
	GSM_Backup 			Backup;
	GSM_Backup_SMSEntry 		*En;
	char 				buff[100];
	wchart				PrevID,buff2;
	GSM_FileFolderInfoList 		Folder;

	error = s->Open(CFG);
	PrintError(error);

	error2 = s->Phones->Current->GetSMSMMSFolders(&Folders);
	PrintError(error2);
	FolderMax = 0;
	SubFolder2 = NULL;
	while (Folders.GetNext(&SubFolder2) == TRUE) {
		if (SubFolder2->MMS) continue;
		FolderMax ++;
	}

	GetAllPbkForSMS(s, &Backup);

	error.Code = GSM_ERR_EMPTY;
	SubFolder2 = NULL;
	Entry = new GSM_SMSList;
	while (true) {
		if (error.Code == GSM_ERR_EMPTY) {
			start = FALSE;
			while (Folders.GetNext(&SubFolder2) == TRUE) {
				CurrentFolder++;
				if (SubFolder2->MMS) continue;
				CurrentFolder2++;
				buff2.clear();
				buff2.push_back('-');
				buff2.append(SubFolder2->ID);
				buff2.push_back('-');
				if (wcsstr(PrevID.data(),buff2.data())!=NULL) continue;
				start = TRUE;
				first = TRUE;
				Folder.ClearAll();
				break;
			}
			
			if (!start) break;
			
			PrevID.push_back('-');
			PrevID.append(SubFolder2->ID);
			PrevID.push_back('-');
			start = TRUE;
		}
		error = s->Phones->Current->GetNextSMSMMSIDFromFolder(start, SubFolder2, Entry,&Entry2, &Current, &MaxInFolder);
		if (error.Code == GSM_ERR_EMPTY) continue;
		if (error.Code == GSM_ERR_FOLDER_MORE) {
			if (start) {
				j=0;
			}
			j++;
			PrintStdErr("Reading content of '%s' (folder %i/%i): %i",UnicodeToStringReturn(SubFolder2->GetName()),CurrentFolder2,FolderMax,j);
			PrintTimeLeftReset();
			start = FALSE;
			continue;
		}
		start = FALSE;
		if (error.Code == GSM_ERR_FOLDER_PART) {
			PrintStdErr("");
			printf("\nThere is available only part of SMS folder %s\n",UnicodeToStringReturn(SubFolder2->GetName()));
			continue;
		}
		if (error.Code != GSM_ERR_NONE) {
			PrintStdErr("");
			PrintError(error);
		} else {
			if (first) PrintTimeLeftReset();
			first = FALSE;
		}

		sprintf(buff,"Reading SMS");
		sprintf(buff+strlen(buff)," from '%s' (%i/%i)",UnicodeToStringReturn(SubFolder2->GetName()),CurrentFolder2,FolderMax);
		sprintf(buff+strlen(buff)," : ");
		PrintTimeLeft(buff,Current,MaxInFolder);

		//mms
		if (Entry->Folder == 0) continue;

		if (CurrentFolder != Entry->Folder) continue;

		Backup.Add_SMS(Entry);

		Entry = new GSM_SMSList;
	}
	PrintStdErr("");
	delete (Entry);

	Backup.LinkSMS();
	Backup.SortSMSByFolderDT();

	En = NULL;
	while (Backup.GetNext_SMS(&En)) {
		SubEntry = NULL;
		printf("\nSMS list\n");
		smsnum++;
		while (En->GetEntry()->GetNext(&SubEntry) == TRUE) {
			smsparts++;

			SMS = SubEntry->GetSMS();

			SubFolder2 = NULL;
			for (i=0;i<En->GetEntry()->Folder;i++) Folders.GetNext(&SubFolder2);

			printf("  Memory %s, ",GSM_GetMemoryName(SMS->Memory));
			printf("folder %s, ",UnicodeToStringReturn(SubFolder2->GetName()));

			switch (SMS->Icon) {
				case SMS_Read	: printf("read"); 	break;
				case SMS_UnRead	: printf("unread"); 	break;
				case SMS_Sent	: printf("sent"); 	break;
				case SMS_UnSent	: printf("unsent"); 	break;
			}

			Buffer2.clear();
			UnicodeToUTF8QuotedPrintable((wchar_t *)SMS->ID.data(), &Buffer2);
			printf(", ID \"%s\"",Buffer2.data());

			printf("\n");
			if (SMS->Name.length()!=0) {
//				printf("    Name %s\n",UnicodeToStringReturn(SMS->GetName()));
			}
			if (SMS->SaveDateTimeAvailable == TRUE) {
				printf("    Saved %02i:%02i:%02i %02i-%02i-%04i %s\n",
					SMS->SaveDateTime.Hour,
					SMS->SaveDateTime.Minute,
					SMS->SaveDateTime.Second,
					SMS->SaveDateTime.Day,
					SMS->SaveDateTime.Month,
					SMS->SaveDateTime.Year,
					DayOfWeekStr(
						SMS->SaveDateTime.Year,
						SMS->SaveDateTime.Month,
						SMS->SaveDateTime.Day));
			}

			num = DisplaySingleSMS(SMS,&Backup);
			if (num > 1) {
				smsnum+=num-1;
				smsparts+=num-1;
			}
		}		
	}

	PrintStdErr("");

	printf("\n%i SMS parts in %i SMS sequences\n",smsparts,smsnum);
}

void GetSMSFolders(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_Error			error;
	GSM_SMSMMSFolders		Folders;
	GSM_SMSMMSFoldersSubEntry  	*SubEntry;
	int				i=1;
	
	error = s->Open(CFG);
	PrintError(error);

	error = s->Phones->Current->GetSMSMMSFolders(&Folders);
	PrintError(error);

	SubEntry = NULL;
	while (Folders.GetNext(&SubEntry) == TRUE) {
		if (SubEntry->MMS) continue;
		printf("%i. %s - memory %s\n",i++,UnicodeToStringReturn(SubEntry->GetName()),GSM_GetMemoryName(SubEntry->Memory));
	}
}

void GetSMSC(GSM_StateMachine *s, GSM_GPlusConfig *CFG, int argc, char *argv[])
{
	GSM_Error		error;
	GSM_SMSC		SMSC;
	
	error = s->Open(CFG);
	PrintError(error);

	SMSC.Location = atoi(argv[0]);
	
	error = s->Phones->Current->GetSMSC(&SMSC);
	PrintError(error);

	printf("Name %s\n",UnicodeToStringReturn(SMSC.GetName()));
	printf("SMSC number %s\n",UnicodeToStringReturn(SMSC.GetSMSCNumber()));
	printf("Default recipient number %s\n",UnicodeToStringReturn(SMSC.GetDefaultNumber()));
	printf("Relative validity %02x\n",SMSC.RelativeValidity);	
}
