/* (C) 2007 by Marcin Wiacek www.mwiacek.com */

#ifndef gsm_data_h
#define gsm_data_h

#include "../gsmfiles.h"
#include "gsmsms.h"

class GSM_SMSMMSFoldersSubEntry
{
public:
	GSM_SMSMMSFoldersSubEntry();
	~GSM_SMSMMSFoldersSubEntry();

	int				Number;
	int				OtherNumber;
	BOOLEAN				FileSystem;
	BOOLEAN				Inbox;
	BOOLEAN				MMS;
	GSM_MemoryType			Memory;
	wchart				ID;

	void				SetName(wchar_t *N);
	wchar_t 			*GetName();
	void				SetNext(GSM_SMSMMSFoldersSubEntry *Nxt);
	GSM_SMSMMSFoldersSubEntry	*GetNext();
private:
	GSM_SMSMMSFoldersSubEntry	*Next;
	wchar_t				*Name;
};

class GSM_SMSMMSFolders
{
public:
	GSM_SMSMMSFolders();
	~GSM_SMSMMSFolders();

	BOOLEAN 			GetNext(GSM_SMSMMSFoldersSubEntry **En);
	GSM_Error	 		Add(wchar_t *Name, BOOLEAN FF, BOOLEAN Inbox, BOOLEAN MMS, GSM_MemoryType mem, wchart *ID, int Num, int OtherNum);
	void 				ClearAll();	
private:
	GSM_SMSMMSFoldersSubEntry	*Entries;
};

class GSM_MMSEntry
{
public:
	int		Folder;
	GSM_File	File;
};

typedef enum {
	MMS_Address_Phone_Source = 1,
	MMS_Address_Unknown_Source,
	MMS_Address_Phone_Destination,
	MMS_Address_Unknown_Destination,
	MMS_Address_Phone_CC,
	MMS_Address_Unknown_CC,
	MMS_Address_Phone_BCC,
	MMS_Address_Unknown_BCC,
	MMS_Text_TransactionID,
	MMS_Text_Subject,
	MMS_Text_ContentLocation,
	MMS_Text_ContentType,
	MMS_Text_MessageType,
	MMS_Text_MessageID,
	MMS_Text_MessageClass,
	MMS_Text_Priority,
	MMS_Text_Version,
	MMS_Text_Response_Status,
	MMS_Text_Status,
	MMS_DT_DateTime,
	MMS_DT_Expiry,
	MMS_Bool_Report,
	MMS_Bool_Read_Reply,
	MMS_Bool_Report_Allowed,
	MMS_File,
	MMS_Unknown
} GSM_MMS_Types;

typedef enum {
	SMS_Text_Short = 1,
	SMS_Text_Long,
	SMS_EMS
} GSM_SMS_Types;

class GSM_SMSMMSDecodedSubEntry
{
	friend class GSM_SMSMMSDecodedEntry;
public:
	GSM_SMSMMSDecodedSubEntry();
	~GSM_SMSMMSDecodedSubEntry();

	GSM_MMS_Types			Type;
	GSM_File			File;

	wchart				Text;
	wchart				Text2;
	wchart				Header;
	BOOLEAN				Bool;
	GSM_DateTime			DT;

	GSM_SMSMMSDecodedSubEntry	*GetNext();
private:
	void 				SetNext(GSM_SMSMMSDecodedSubEntry *Nxt);

	GSM_SMSMMSDecodedSubEntry	*Next;
};

class GSM_SMSMMSDecodedEntry
{
public:
	GSM_SMSMMSDecodedEntry();
	~GSM_SMSMMSDecodedEntry();

	//specific to SMS
	BOOLEAN				SMSUnicode;

	void 				ClearAll();	
	BOOLEAN 			GetNext(GSM_SMSMMSDecodedSubEntry **En);
	GSM_Error	 		Add(GSM_SMSMMSDecodedSubEntry *En);

	GSM_Error			ReadFromMMS(GSM_File *File);
	GSM_Error 			ReadFromSMS(GSM_SMSList *List);
	GSM_Error			SaveToSMS(GSM_SMSList *List, GSM_SMS_Types Type, int *CharsLeft);
private:
	GSM_SMSMMSDecodedSubEntry	*Entries;

	void 				DecodeAddress(unsignedstring *buffer, GSM_MMS_Types *Type);
	void 				DecodeVersion(unsignedstring *Buff, long *Pos, unsignedstring *Dest, float *Version);
	int 				DecodeContentType(unsignedstring *Buff, long *Pos, unsignedstring *Dest, unsignedstring *Dest2, wchart *Name, float Version);

	int 				DecodeValuelength(unsignedstring *Buff, long *Pos);
	int 				DecodeShortinteger(unsignedstring *Buff, long *Pos);
	long 				DecodeUintvar(unsignedstring *Buff, long *Pos);
	long 				DecodeLonginteger(unsignedstring *Buff, long *Pos);
	void 				DecodeText(unsignedstring *Buff, long *Pos, unsignedstring *Dest);
	void 				DecodeEncodedString(unsignedstring *Buff, long *Pos, unsignedstring *Dest);
	long 				DecodeInteger(unsignedstring *Buff, long *Pos);
};

#endif
