
GSM_Error GSM_SMSMMSDecodedEntry::ReadFromSMS(GSM_SMSList *List)
{
	GSM_SMSListSubEntry 		*SMS2;
	GSM_SMSMMSDecodedSubEntry 	*Sub2 = new GSM_SMSMMSDecodedSubEntry;
	wchar_t 			buff[400];
	unsignedstring 			dest;
    	unsignedstring              	UDH;
    	UDHList                     	UDH2;
	GSM_Error			error;
	unsigned int				found=0,j;
	GSM_SMSNumbersSubEntry  *Number;

	ClearAll();

	SMS2 = NULL;
	while (List->GetNext(&SMS2)) {
		error = SMS2->GetSMS()->GetUDH(&UDH);
               	if (error.Code != GSM_ERR_NONE) return error;
            	if (UDH.size()!=0) {
                	error = SMS2->GetSMS()->DecodeUDH(&UDH2);
	               	if (error.Code != GSM_ERR_NONE) return error;
			for (j=0;j<UDH2.size();j++) {
	                        switch (UDH2.data()[j].Type) {
	                        case SMS_UDH_Linked_Short:
					if (found!=0 && found!=1) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
					found = 1;
					break;
	                        case SMS_UDH_Linked_Long:
					if (found!=0 && found!=2) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
					found = 2;
					break;
	                        default:
					break;
				}
			}
		}
//		SMS2->GetSMS()->GetDecodedText(buff);		
//		UnicodeToUTF8(buff, &dest);		
	}
	//text sms
	if (found == 0 || found == 1 || found == 2) {
		SMS2 = NULL;
		while (List->GetNext(&SMS2)) {
			error = SMS2->GetSMS()->GetUDH(&UDH);
	               	if (error.Code != GSM_ERR_NONE) return error;
			if (UDH.size()!=0) {
	                	error = SMS2->GetSMS()->DecodeUDH(&UDH2);
		               	if (error.Code != GSM_ERR_NONE) return error;
				for (j=0;j<UDH2.size();j++) {
//					if (Sub2->File.Buffer.size()==0 && ) {
//					}
//	                        	switch (UDH2.data()[j].Type) {
				}
			}
			dest.clear();
			SMS2->GetSMS()->GetDecodedText(buff);		
			UnicodeToUTF8(buff, &dest);
			Sub2->File.Buffer.append(dest);
		}
		Sub2->Text.append(StringToUnicodeReturn("text/plain"));
		Sub2->Type = MMS_File;
		Add(Sub2);

		SMS2 = NULL;
		List->GetNext(&SMS2);
		Number = NULL;
		while (SMS2->GetSMS()->PhoneNumbers.GetNext(&Number)) {
			error = Number->GetPhoneNumber(buff);
			Sub2 = new GSM_SMSMMSDecodedSubEntry;
			Sub2->Type = MMS_Address_Phone_Source;
			Sub2->Text.append(buff);
			Add(Sub2);
		}

		return GSM_Return_Error(GSM_ERR_NONE);
	}
	return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_SMSMMSDecodedEntry::SaveToSMS(GSM_SMSList *Destination, GSM_SMS_Types Type, int *CharsLeft)
{
	BOOLEAN				many=FALSE;
	GSM_SMSMMSDecodedSubEntry 	*Sub2;
	GSM_SMSEntry			SMS;
	GSM_SMSListSubEntry		*SMS2;
	int 				Pos,len2,max,lenmax,len3,used;
	unsigned int i;
	unsigned char			buff[200],ID;
	unsignedstring			buff2;
	GSM_Error			error;
	wchart				Dest;

	Destination->ClearAll();
	if (Type == SMS_Text_Short || Type == SMS_Text_Long) {
		Sub2=NULL;
		while (GetNext(&Sub2)) {
			if (Sub2->Type != MMS_File) {
				return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
			}
			if (strcmp(UnicodeToStringReturn(Sub2->Text.data()),"text/plain")) {
				return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
			}
		}
		Sub2=NULL;
		if (!GetNext(&Sub2)) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);

		Destination->ClearAll();
		if (SMSUnicode) {
			(*CharsLeft) = 70;
		} else {
			(*CharsLeft) = 160;
		}
		if (Sub2->File.Buffer.size() == 0) return GSM_Return_Error(GSM_ERR_NONE);
		Dest.clear();
		UTF8ToUnicode(Sub2->File.Buffer.data(), &Dest, Sub2->File.Buffer.size());
		lenmax = Dest.length(); 
		if (SMSUnicode) {
			if (lenmax>70) many=TRUE;
		} else {
			error = GSM_EncodeSMSText(buff, Dest.data(), &len3, &len2, 140, &used, 0);
			if (error.Code != GSM_ERR_NONE) return error;
			if (len3 != lenmax) many = TRUE;				
		}
		if (many) {
			//many sms
			max = 0;
			Pos=0;
			while (Pos<lenmax) {
				buff2.clear();
				if (SMSUnicode) {
					for(i=0;i<((140-6)/2);i++) {
						buff2.push_back(Dest.data()[Pos]/256);
						buff2.push_back(Dest.data()[Pos]%256);
						Pos++;
						if (Pos==lenmax) break;
					}
					(*CharsLeft) = 70-i;
					SMS.SetCoding(SMS_Coding_Unicode_No_Compression);
				} else {
					error = GSM_EncodeSMSText(buff, Dest.data()+Pos, &len3, &len2, 140-6, &used, 6);
					if (error.Code != GSM_ERR_NONE) return error;
					buff2.append(buff,used);
					Pos+=len3;
					(*CharsLeft) = 153 - len2;
					SMS.SetCoding(SMS_Coding_Default_No_Compression);
				}
				error = SMS.SetText(&buff2);
				if (error.Code != GSM_ERR_NONE) return error;
				Destination->Add(&SMS);
				max++;
			}
			i = 0;
			while(UDHHeaders[i].Length!=0) {
				if (UDHHeaders[i].Type==SMS_UDH_Linked_Short) {
					break;
				}
				i++;
			}
			Pos = 0;
			SMS2 = NULL;
			while (Destination->GetNext(&SMS2)) {
				if (Pos == 0) ID = SMS2->GetSMS()->MakeSMSIDFromTime();
				memcpy(buff,UDHHeaders[i].Text,6);
				buff[UDHHeaders[i].ID8bit] = ID;
				buff[UDHHeaders[i].PartNumber8bit] = Pos+1;
				buff[UDHHeaders[i].AllParts8bit] = max;
				buff2.clear();
				buff2.append((unsigned char *)buff,6);
				SMS2->GetSMS()->SetUDH(&buff2);
				Pos++;
			}
		} else {
			//single SMS
			buff2.clear();
			if (SMSUnicode) {
				for(i=0;i<Dest.size();i++) {
					buff2.push_back(Dest.data()[i]/256);
					buff2.push_back(Dest.data()[i]%256);
				}
				(*CharsLeft) = 70 - i;
				SMS.SetCoding(SMS_Coding_Unicode_No_Compression);
			} else {
				error = GSM_EncodeSMSText(buff, Dest.data(), &len3, &len2, 140, &used, 0);
				if (error.Code != GSM_ERR_NONE) return error;
				buff2.append(buff,used);
				(*CharsLeft) = 160 - len2;
				SMS.SetCoding(SMS_Coding_Default_No_Compression);
			}
			error = SMS.SetText(&buff2);
			if (error.Code != GSM_ERR_NONE) return error;
			Destination->Add(&SMS);
		}
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}
