
long GSM_SMSMMSDecodedEntry::DecodeLonginteger(unsignedstring *Buff, long *Pos)
{
	int i, len = Buff->data()[(*Pos)++];
	long ret=0;

	for (i=0;i<len;i++) {
		ret = ret << 8;
		ret += Buff->data()[(*Pos)++];
	}

	return ret;
}

int GSM_SMSMMSDecodedEntry::DecodeShortinteger(unsignedstring *Buff, long *Pos)
{
	return Buff->data()[(*Pos)++] & 0x7f;
}

long GSM_SMSMMSDecodedEntry::DecodeInteger(unsignedstring *Buff, long *Pos)
{
	if (Buff->data()[(*Pos)] < 31) return DecodeLonginteger(Buff,Pos);
	if (Buff->data()[(*Pos)] > 127) return DecodeShortinteger(Buff,Pos);
	return 0;
}

long GSM_SMSMMSDecodedEntry::DecodeUintvar(unsignedstring *Buff, long *Pos)
{
	long ret=0;
	BOOLEAN found = FALSE;

	while (1) {
		if (!(Buff->data()[(*Pos)] & 0x80)) found = TRUE;
		ret = ret << 7;
		ret |= Buff->data()[(*Pos)++] & 0x7F;
		if (found) break;
	}
	return ret;
}

int GSM_SMSMMSDecodedEntry::DecodeValuelength(unsignedstring *Buff, long *Pos)
{
	if (Buff->data()[(*Pos)] < 31) return Buff->data()[(*Pos)++];
	if (Buff->data()[(*Pos)] == 31) {
		(*Pos)++;
		return DecodeUintvar(Buff,Pos);
	}
	return 0;
}

void GSM_SMSMMSDecodedEntry::DecodeText(unsignedstring *Buff, long *Pos, unsignedstring *Dest)
{
	Dest->clear();
	if (Buff->data()[(*Pos)] == 127) (*Pos)++;
	for (;;) {
		Dest->push_back(Buff->data()[(*Pos)]);
		if (Buff->data()[(*Pos)]==0) break;
		(*Pos)++;
	}	
	(*Pos)++;
}

void GSM_SMSMMSDecodedEntry::DecodeEncodedString(unsignedstring *Buff, long *Pos, unsignedstring *Dest)
{
	int len,i;

	Dest->clear();
	if (Buff->data()[(*Pos)] < 32) {
		len = DecodeValuelength(Buff,Pos);
		(*Pos)++;//charset?
		for (i=1;i<len;i++) {
			Dest->push_back(Buff->data()[(*Pos)++]);
		}
		return;
	}
	DecodeText(Buff, Pos, Dest);
}

void GSM_SMSMMSDecodedEntry::DecodeVersion(unsignedstring *Buff, long *Pos, unsignedstring *Dest, float *Version)
{
	long value;
	char buff[20];

	value = Buff->data()[(*Pos)] & 0x7F;
	(*Version) = ((value & 0x70) >> 4) + (value & 0x0f) / 10;
	sprintf(buff,"%i.%i", (value & 0x70) >> 4, value & 0x0f);
	Dest->clear();
	Dest->append((unsigned char *)buff,strlen(buff));
	
	(*Pos)++;
}

void GSM_AddWAPMIMEType(int type, char *buffer)
{
	switch (type) {
	case  1:sprintf(buffer,"%stext/*",buffer);					break;
	case  2:sprintf(buffer,"%stext/html",buffer);					break;
	case  3:sprintf(buffer,"%stext/plain",buffer);					break;
	case  4:sprintf(buffer,"%stext/x-hdml",buffer);					break;
	case  5:sprintf(buffer,"%stext/x-ttml",buffer);					break;
	case  6:sprintf(buffer,"%stext/x-vCalendar",buffer);				break;
	case  7:sprintf(buffer,"%stext/x-vCard",buffer);				break;
	case  8:sprintf(buffer,"%stext/vnd.wap.wml",buffer);				break;
	case  9:sprintf(buffer,"%stext/vnd.wap.wmlscript",buffer);			break;
	case 10:sprintf(buffer,"%stext/vnd.wap.wta-event",buffer);			break;
	case 11:sprintf(buffer,"%smultipart/*",buffer);					break;
	case 12:sprintf(buffer,"%smultipart/mixed",buffer);				break;
	case 13:sprintf(buffer,"%smultipart/form-data",buffer);				break;
	case 14:sprintf(buffer,"%smultipart/byterantes",buffer);			break;
	case 15:sprintf(buffer,"%smultipart/alternative",buffer);			break;
	case 16:sprintf(buffer,"%sapplication/*",buffer);				break;
	case 17:sprintf(buffer,"%sapplication/java-vm",buffer);				break;
	case 18:sprintf(buffer,"%sapplication/x-www-form-urlencoded",buffer);		break;
	case 19:sprintf(buffer,"%sapplication/x-hdmlc",buffer);				break;
	case 20:sprintf(buffer,"%sapplication/vnd.wap.wmlc",buffer);			break;
	case 21:sprintf(buffer,"%sapplication/vnd.wap.wmlscriptc",buffer);		break;
	case 22:sprintf(buffer,"%sapplication/vnd.wap.wta-eventc",buffer);		break;
	case 23:sprintf(buffer,"%sapplication/vnd.wap.uaprof",buffer);			break;
	case 24:sprintf(buffer,"%sapplication/vnd.wap.wtls-ca-certificate",buffer);	break;
	case 25:sprintf(buffer,"%sapplication/vnd.wap.wtls-user-certificate",buffer);	break;
	case 26:sprintf(buffer,"%sapplication/x-x509-ca-cert",buffer);			break;
	case 27:sprintf(buffer,"%sapplication/x-x509-user-cert",buffer);		break;
	case 28:sprintf(buffer,"%simage/*",buffer);					break;
	case 29:sprintf(buffer,"%simage/gif",buffer);					break;
	case 30:sprintf(buffer,"%simage/jpeg",buffer);					break;
	case 31:sprintf(buffer,"%simage/tiff",buffer);					break;
	case 32:sprintf(buffer,"%simage/png",buffer);					break;
	case 33:sprintf(buffer,"%simage/vnd.wap.wbmp",buffer);				break;
	case 34:sprintf(buffer,"%sapplication/vnd.wap.multipart.*",buffer);		break;
	case 35:sprintf(buffer,"%sapplication/vnd.wap.multipart.mixed",buffer);		break;
	case 36:sprintf(buffer,"%sapplication/vnd.wap.multipart.form-data",buffer);	break;
	case 37:sprintf(buffer,"%sapplication/vnd.wap.multipart.byteranges",buffer);	break;
	case 38:sprintf(buffer,"%sapplication/vnd.wap.multipart.alternative",buffer);	break;
	case 39:sprintf(buffer,"%sapplication/xml",buffer);				break;
	case 40:sprintf(buffer,"%stext/xml",buffer);					break;
	case 41:sprintf(buffer,"%sapplication/vnd.wap.wbxml",buffer);			break;
	case 42:sprintf(buffer,"%sapplication/x-x968-cross-cert",buffer);		break;
	case 43:sprintf(buffer,"%sapplication/x-x968-ca-cert",buffer);			break;
	case 44:sprintf(buffer,"%sapplication/x-x968-user-cert",buffer);		break;
	case 45:sprintf(buffer,"%stext/vnd.wap.si",buffer);				break;
	case 46:sprintf(buffer,"%sapplication/vnd.wap.sic",buffer);			break;
	case 47:sprintf(buffer,"%stext/vnd.wap.sl",buffer);				break;
	case 48:sprintf(buffer,"%sapplication/vnd.wap.slc",buffer);			break;
	case 49:sprintf(buffer,"%stext/vnd.wap.co",buffer);				break;
	case 50:sprintf(buffer,"%sapplication/vnd.wap.coc",buffer);			break;
	case 51:sprintf(buffer,"%sapplication/vnd.wap.multipart.related",buffer); 	break;
	case 52:sprintf(buffer,"%sapplication/vnd.wap.sia",buffer); 			break;
	case 53:sprintf(buffer,"%stext/vnd.wap.connectivity-xml",buffer); 		break;
	case 54:sprintf(buffer,"%sapplication/vnd.wap.connectivity-wbxml",buffer); 	break;
	case 55:sprintf(buffer,"%sapplication/pkcs7-mime",buffer); 			break;
	case 56:sprintf(buffer,"%sapplication/vnd.wap.hashed-certificate",buffer); 	break;
	case 57:sprintf(buffer,"%sapplication/vnd.wap.signed-certificate",buffer); 	break;
	case 58:sprintf(buffer,"%sapplication/vnd.wap.cert-response",buffer); 		break;
	case 59:sprintf(buffer,"%sapplication/xhtml+xml",buffer); 			break;
	case 60:sprintf(buffer,"%sapplication/wml+xml",buffer); 			break;
	case 61:sprintf(buffer,"%stext/css",buffer); 					break;
	case 62:sprintf(buffer,"%sapplication/vnd.wap.mms-message",buffer); 		break;
	case 63:sprintf(buffer,"%sapplication/vnd.wap.rollover-certificate",buffer); 	break;
	case 64:sprintf(buffer,"%sapplication/vnd.wap.locc+wbxml",buffer); 		break;
	case 65:sprintf(buffer,"%sapplication/vnd.wap.loc+xml",buffer); 		break;
	case 66:sprintf(buffer,"%sapplication/vnd.syncml.dm+wbxml",buffer); 		break;
	case 67:sprintf(buffer,"%sapplication/vnd.syncml.dm+xml",buffer); 		break;
	case 68:sprintf(buffer,"%sapplication/vnd.syncml.notification",buffer); 	break;
	case 69:sprintf(buffer,"%sapplication/vnd.wap.xhtml+xml",buffer); 		break;
	case 70:sprintf(buffer,"%sapplication/vnd.wv.csp.cir",buffer); 			break;
	case 71:sprintf(buffer,"%sapplication/vnd.oma.dd+xml",buffer); 			break;
	case 72:sprintf(buffer,"%sapplication/vnd.oma.drm.message",buffer); 		break;
	case 73:sprintf(buffer,"%sapplication/vnd.oma.drm.content",buffer); 		break;
	case 74:sprintf(buffer,"%sapplication/vnd.oma.drm.rights+xml",buffer); 		break;
	case 75:sprintf(buffer,"%sapplication/vnd.oma.drm.rights+wbxml",buffer); 	break;
	default:sprintf(buffer,"%sMIME %i",buffer,type);				break;
	}
}

int GSM_SMSMMSDecodedEntry::DecodeContentType(unsignedstring *Buff, long *Pos, unsignedstring *Dest, unsignedstring *Dest2, wchart *Name, float Version)
{
	unsignedstring		buff3;
	char 			buff[20000],buff2[1000];
	long			type=0,val2;
	BOOLEAN			Found = TRUE;

	Dest->clear();
	Dest2->clear();
	Name->clear();

	buff[0] = 0;
	if (Buff->data()[(*Pos)] <= 31) {
		type = DecodeValuelength(Buff, Pos);
		if (Buff->data()[(*Pos)] > 31 && Buff->data()[(*Pos)] < 128) {
			DecodeText(Buff, Pos, &buff3);
			sprintf(buff,"%s",buff3.data());
		} else {
			type = DecodeInteger(Buff,Pos);
			GSM_AddWAPMIMEType(type, buff);
		}
	} else if (Buff->data()[(*Pos)] <= 128) {
		DecodeText(Buff, Pos, &buff3);
		sprintf(buff,"%s",buff3.data());				
	} else {
		type = DecodeShortinteger(Buff, Pos);
		GSM_AddWAPMIMEType(type, buff);
	}
	Dest->append((unsigned char *)buff,strlen(buff));

	buff[0] = 0;
	while (1) {
		if (!(Buff->data()[(*Pos)] & 0x80)) break;
		//WAP-230-WSP-20010705-a
		//Table 38. Well-Known Parameter Assignments
		switch (Buff->data()[(*Pos)++] & 0x7F) {
		case 0x00:
			sprintf(buff,"%s; <unknown>",buff);
			break;
		case 0x01:
			//charset
			if (Buff->data()[(*Pos)]==128) {//any charset
				(*Pos)++;
			} else {
				val2 = DecodeInteger(Buff,Pos);
				switch (val2) {
				case 0x03:
					sprintf(buff,"%s; charset=us-ascii",buff);
					break;
				case 0x04:
				case 0x05:
				case 0x06:
				case 0x07:
				case 0x08:
				case 0x09:
				case 0x0A:
				case 0x0B:
				case 0x0C:
					sprintf(buff,"%s; charset=iso-8859-%i",buff,val2-3);
					break;
				case 0x11:
					sprintf(buff,"%s; charset=shift_JIS",buff);
					break;
				case 0x6A:
					sprintf(buff,"%s; charset=utf8",buff);
					break;
				default:
					sprintf(buff,"%s; charset=unknown",buff);
					break;
				}
			}
			break;
		case 0x02:
			sprintf(buff,"%s; <unknown>",buff);
			break;
		case 0x03:
			sprintf(buff,"%s; <unknown>",buff);
			break;
		case 0x05:
			DecodeText(Buff, Pos, &buff3);
			sprintf(buff2,"%s",buff3.data());
			Name->append(StringToUnicodeReturn(buff2),UnicodeLength(StringToUnicodeReturn(buff2)));
			sprintf(buff,"%s; name=%s",buff,buff3.data());
			break;
		case 0x06:
			DecodeText(Buff, Pos, &buff3);
			sprintf(buff,"%s; filename=%s",buff,buff3.data());
			break;
		case 0x07:
		case 0x08:
			sprintf(buff,"%s; <unknown>",buff);
			break;
		case 0x09:
			sprintf(buff,"%s; type=",buff);
			if (Buff->data()[(*Pos)]<128) {
				DecodeText(Buff, Pos, &buff3);
				sprintf(buff,"%s%s",buff,buff3.data());
			} else {
				type = DecodeShortinteger(Buff, Pos);
				GSM_AddWAPMIMEType(type, buff);
			}
			break;
		case 0x0A:
			DecodeText(Buff, Pos, &buff3);
			sprintf(buff,"%s; start=%s",buff,buff3.data());
			break;
		case 0x0B:
			DecodeText(Buff, Pos, &buff3);
			sprintf(buff,"%s; start-info=%s",buff,buff3.data());
			break;
		default:
			Found = FALSE;
		}
		if (!Found) {
			(*Pos)--;
			break;
		}
	}
	Dest2->append((unsigned char *)buff,strlen(buff));

	return type;
}

void GSM_SMSMMSDecodedEntry::DecodeAddress(unsignedstring *buffer, GSM_MMS_Types *Type)
{
	unsignedstring buff2;

	if (strstr((char *)buffer->data(),"/TYPE=PLMN")!=NULL) {
		buff2.append(buffer->data(),strlen((char *)buffer->data())-10);
		buffer->clear();
		buffer->append(buff2.data(),strlen((char *)buff2.data()));
	} else {
		Type++;
	}
}

GSM_Error GSM_SMSMMSDecodedEntry::ReadFromMMS(GSM_File *File)
{
	long 				type=0,headlen,datalen,oldpos,z,pos=0,value;
	int 				parts,j;
	float 				version=1.0;
	time_t 				timet;
	GSM_DateTime 			Date;
	char				buff[20000];
	unsignedstring			buff2,buff3;
	wchart					name;
	GSM_SMSMMSDecodedSubEntry 	*SubEntry;

	ClearAll();

	//header
	while(1) {
		if (pos > (long)File->Buffer.size()) break;
		if (!(File->Buffer.data()[pos] & 0x80)) break;
		SubEntry=new GSM_SMSMMSDecodedSubEntry;
		switch (File->Buffer.data()[pos++] & 0x7F) {
		case 0x01:
			SubEntry->Type = MMS_Address_Phone_BCC;
			DecodeEncodedString(&File->Buffer, &pos, &buff3);
			DecodeAddress(&buff3, &SubEntry->Type);
			SubEntry->Text.append(StringToUnicodeReturn((char *)buff3.data()),UnicodeLength(StringToUnicodeReturn((char *)buff3.data())));
			break;
		case 0x02:
			SubEntry->Type = MMS_Address_Phone_CC;
			DecodeEncodedString(&File->Buffer, &pos, &buff3);
			DecodeAddress(&buff3, &SubEntry->Type);
			SubEntry->Text.append(StringToUnicodeReturn((char *)buff3.data()),UnicodeLength(StringToUnicodeReturn((char *)buff3.data())));
			break;
		case 0x03:
			SubEntry->Type = MMS_Text_ContentLocation;
			DecodeText(&File->Buffer, &pos, &buff3);
			SubEntry->Text.append(StringToUnicodeReturn((char *)buff3.data()),UnicodeLength(StringToUnicodeReturn((char *)buff3.data())));
			break;
		case 0x04:
			SubEntry->Type = MMS_Text_ContentType;
			type = DecodeContentType(&File->Buffer, &pos, &buff3, &buff2, &name, version);
			if (type == -1) return GSM_Return_Error(GSM_ERR_UNKNOWN);
			SubEntry->Text.append(StringToUnicodeReturn((char *)buff3.data()),UnicodeLength(StringToUnicodeReturn((char *)buff3.data())));
			break;
		case 0x05:
			SubEntry->Type = MMS_DT_DateTime;
			timet = DecodeLonginteger(&File->Buffer, &pos);
			Date=TimeT2GSMDateTime(&timet);
			memcpy(&SubEntry->DT,&Date,sizeof(GSM_DateTime));
			break;
		case 0x06:
			SubEntry->Type = MMS_Bool_Report;
			switch(File->Buffer.data()[pos++]) {
				case 0x80: SubEntry->Bool = TRUE;  break;
				case 0x81: SubEntry->Bool = FALSE; break;
				default  : return GSM_Return_Error(GSM_ERR_UNKNOWN);
			}
			break;
		case 0x08:			
			SubEntry->Type = MMS_DT_Expiry;
			z = DecodeLonginteger(&File->Buffer, &pos);
			sprintf(buff,"%i",z);
			SubEntry->Text.append(StringToUnicodeReturn(buff),UnicodeLength(StringToUnicodeReturn(buff)));
			break;
		case 0x09:
			SubEntry->Type = MMS_Address_Phone_Source;
			DecodeEncodedString(&File->Buffer, &pos, &buff3);
			DecodeAddress(&buff3, &SubEntry->Type);
			SubEntry->Text.append(StringToUnicodeReturn((char *)buff3.data()),UnicodeLength(StringToUnicodeReturn((char *)buff3.data())));
			break;
		case 0x0A:
			SubEntry->Type = MMS_Text_MessageClass;
			switch (File->Buffer.data()[pos++]) {
				case 0x80: sprintf(buff,"personal");  	   	break;
				case 0x81: sprintf(buff,"advertisement"); 	break;
				case 0x82: sprintf(buff,"informational"); 	break;
				case 0x83: sprintf(buff,"auto");   		break;
				default  : return GSM_Return_Error(GSM_ERR_UNKNOWN);
			}
			SubEntry->Text.append(StringToUnicodeReturn(buff),UnicodeLength(StringToUnicodeReturn(buff)));
			break;
		case 0x0B:
			SubEntry->Type = MMS_Text_MessageID;
			DecodeText(&File->Buffer, &pos, &buff3);
			SubEntry->Text.append(StringToUnicodeReturn((char *)buff3.data()),UnicodeLength(StringToUnicodeReturn((char *)buff3.data())));
			break;
		case 0x0C:
			SubEntry->Type=MMS_Text_MessageType;
			switch (File->Buffer.data()[pos++]) {
				case 0x80: sprintf(buff,"m-send-req");  	   	break;
				case 0x81: sprintf(buff,"m-send-conf"); 	   	break;
				case 0x82: sprintf(buff,"m-notification-ind"); 		break;
				case 0x83: sprintf(buff,"m-notifyresp-ind");   		break;
				case 0x84: sprintf(buff,"m-retrieve-conf");		break;
				case 0x85: sprintf(buff,"m-acknowledge-ind");  		break;
				case 0x86: sprintf(buff,"m-delivery-ind");		break;
				default  : return GSM_Return_Error(GSM_ERR_UNKNOWN);
			}
			SubEntry->Text.append(StringToUnicodeReturn(buff),UnicodeLength(StringToUnicodeReturn(buff)));
			break;
		case 0x0D:
			SubEntry->Type = MMS_Text_Version;
			DecodeVersion(&File->Buffer, &pos, &buff3, &version);
			SubEntry->Text.append(StringToUnicodeReturn((char *)buff3.data()),UnicodeLength(StringToUnicodeReturn((char *)buff3.data())));
			break;			
		case 0x0E:
			printf("  Message size      : not done yet\n");
			return GSM_Return_Error(GSM_ERR_UNKNOWN);
		case 0x0F:
			SubEntry->Type=MMS_Text_Priority;
			switch (File->Buffer.data()[pos++]) {
				case 0x80: sprintf(buff,"low");  	   	break;
				case 0x81: sprintf(buff,"normal"); 	   	break;
				case 0x82: sprintf(buff,"high"); 		break;
				default  : return GSM_Return_Error(GSM_ERR_UNKNOWN);
			}
			SubEntry->Text.append(StringToUnicodeReturn(buff),UnicodeLength(StringToUnicodeReturn(buff)));
			break;
		case 0x10:
			SubEntry->Type = MMS_Bool_Read_Reply;
			switch(File->Buffer.data()[pos++]) {
				case 0x80: SubEntry->Bool = TRUE;  break;
				case 0x81: SubEntry->Bool = FALSE; break;
				default  : return GSM_Return_Error(GSM_ERR_UNKNOWN);
			}
			break;
		case 0x11:
			SubEntry->Type = MMS_Bool_Report_Allowed;
			switch(File->Buffer.data()[pos++]) {
				case 0x80: SubEntry->Bool = TRUE;  break;
				case 0x81: SubEntry->Bool = FALSE; break;
				default  : return GSM_Return_Error(GSM_ERR_UNKNOWN);
			}
			break;
		case 0x12:
			switch (File->Buffer.data()[pos++]) {
				case 128:sprintf(buff,"OK");  	   				break;
				case 129:sprintf(buff,"error unspecified"); 	   		break;
				case 130:sprintf(buff,"error service denied"); 			break;
				case 131:sprintf(buff,"error message format corrupt");   	break;
				case 132:sprintf(buff,"error sending address unresolved");	break;
				case 133:sprintf(buff,"error message not found");  		break;
				case 134:sprintf(buff,"error network problem");			break;
				case 135:sprintf(buff,"error content not accepted");		break;
				case 136:sprintf(buff,"error unsupported message");		break;
				default :return GSM_Return_Error(GSM_ERR_UNKNOWN);
			}
			SubEntry->Text.append(StringToUnicodeReturn(buff),UnicodeLength(StringToUnicodeReturn(buff)));
			break;
		case 0x13:
			printf("  Response text     : not done yet\n");
			return GSM_Return_Error(GSM_ERR_UNKNOWN);
		case 0x14:
			printf("  Sender visibility : not done yet\n");
			return GSM_Return_Error(GSM_ERR_UNKNOWN);
		case 0x15:
			SubEntry->Type=MMS_Text_Status;
			switch (File->Buffer.data()[pos++]) {
				case 0x80: sprintf(buff,"expired");  	   	break;
				case 0x81: sprintf(buff,"retrieved"); 	   	break;
				case 0x82: sprintf(buff,"rejected"); 		break;
				case 0x83: sprintf(buff,"deferred");   		break;
				case 0x84: sprintf(buff,"unrecognised");		break;
				default  : return GSM_Return_Error(GSM_ERR_UNKNOWN);
			}
			SubEntry->Text.append(StringToUnicodeReturn(buff),UnicodeLength(StringToUnicodeReturn(buff)));
			break;
		case 0x16:
			SubEntry->Type=	MMS_Text_Subject;
			DecodeEncodedString(&File->Buffer, &pos, &buff3);
			SubEntry->Text.append(StringToUnicodeReturn((char *)buff3.data()),UnicodeLength(StringToUnicodeReturn((char *)buff3.data())));
			break;
		case 0x17:
			SubEntry->Type = MMS_Address_Phone_Destination;
			DecodeEncodedString(&File->Buffer, &pos, &buff3);
			DecodeAddress(&buff3, &SubEntry->Type);
			SubEntry->Text.append(StringToUnicodeReturn((char *)buff3.data()),UnicodeLength(StringToUnicodeReturn((char *)buff3.data())));
			break;
		case 0x18:
			DecodeText(&File->Buffer, &pos, &buff3);
			SubEntry->Type = MMS_Text_TransactionID;
			SubEntry->Text.append(StringToUnicodeReturn((char *)buff3.data()),UnicodeLength(StringToUnicodeReturn((char *)buff3.data())));
			break;
		default:
			delete(SubEntry);
			return GSM_Return_Error(GSM_ERR_UNKNOWN);
		}
		Add(SubEntry);
	}

	//if we don't have any parts, we exit
	if (type != 35 && type != 51) return GSM_Return_Error(GSM_ERR_NONE);

	parts = DecodeUintvar(&File->Buffer, &pos);

	for (j=0;j<parts;j++) {
		SubEntry=new GSM_SMSMMSDecodedSubEntry;
		SubEntry->Type=MMS_File;

		headlen = DecodeUintvar(&File->Buffer, &pos);
		datalen = DecodeUintvar(&File->Buffer, &pos);
		oldpos = pos;

		//header
		type = DecodeContentType(&File->Buffer, &pos, &buff3, &buff2, &name, version);
		if (name.length()!=0) {
			SubEntry->File.Info.Name.clear();
			SubEntry->File.Info.Name.append((wchar_t *)name.data(),UnicodeLength((wchar_t *)name.data()));
		}
		SubEntry->Text.append(StringToUnicodeReturn((char *)buff3.data()),UnicodeLength(StringToUnicodeReturn((char *)buff3.data())));
		SubEntry->Text2.append(StringToUnicodeReturn((char *)buff2.data()),UnicodeLength(StringToUnicodeReturn((char *)buff2.data())));
//		if (type == -1) return GSM_Return_Error(GSM_ERR_UNKNOWN);
		while (1) {
			if (pos >= oldpos+headlen) break;
			//WAP-230-WSP-20010705-a
			//Table 39. Header Field Name Assignments
			switch (File->Buffer.data()[pos++] & 0x7F) {
			case 0x0D:
				value = DecodeUintvar(&File->Buffer, &pos);
				sprintf(buff,"content-length=%i; ",value);
				SubEntry->Header.append(StringToUnicodeReturn(buff),UnicodeLength(StringToUnicodeReturn(buff)));
				break;
			case 0x0E://0x8E - content-location
				DecodeText(&File->Buffer, &pos, &buff3);
				if (SubEntry->File.Info.Name.size()==0) {
					SubEntry->File.Info.Name.append(StringToUnicodeReturn((char *)buff3.data()));
				}
				sprintf(buff,"content-location=%s; ",buff3.data());
				SubEntry->Header.append(StringToUnicodeReturn(buff),UnicodeLength(StringToUnicodeReturn(buff)));
				break;
			case 0x2E://0xAE - content-disposition
				DecodeEncodedString(&File->Buffer, &pos, &buff3);
				sprintf(buff,"content-disposition=%s; ",buff3.data()+1);
				SubEntry->Header.append(StringToUnicodeReturn(buff),UnicodeLength(StringToUnicodeReturn(buff)));
				break;
			case 0x40://0xC0 - content-id (smil cid)
				DecodeText(&File->Buffer, &pos, &buff3);
				sprintf(buff,"content-id=%s; ",buff3.data()+1);
				SubEntry->Header.append(StringToUnicodeReturn(buff),UnicodeLength(StringToUnicodeReturn(buff)));
				break;
			default:
				sprintf(buff,"<unknown>");
				SubEntry->Header.append(StringToUnicodeReturn(buff),UnicodeLength(StringToUnicodeReturn(buff)));
			}
		}
		pos = oldpos+headlen;

		//data
		SubEntry->File.Buffer.append(File->Buffer.data()+pos,datalen);
		SubEntry->File.Info.Size=datalen;
		Add(SubEntry);
		pos+=datalen;
	}
	if (pos>(long)File->Buffer.size()) return GSM_Return_Error(GSM_ERR_FILE_TOO_SHORT);
	if (pos<(long)File->Buffer.size()) {
		SubEntry=new GSM_SMSMMSDecodedSubEntry;
		SubEntry->Type=MMS_Unknown;
		SubEntry->File.Buffer.append(File->Buffer.data()+pos,File->Buffer.size()-pos);
		SubEntry->File.Info.Size=File->Buffer.size()-pos;
		Add(SubEntry);
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}
