/* (C) 2005 by Marcin Wiacek www.mwiacek.com */

#ifndef gsm_misc_h
#define gsm_misc_h

#include <ctype.h>
#include <string.h>
#include <time.h>
#include <stdio.h>

#include "../misc/misc.h"

typedef enum {
	/* Device layer errors not returned to user */
	GSM_ERR_DRIVER_NOT_AVAILABLE = 1,
        /* Internal errors not returned to user */
        GSM_ERR_NEWMESSAGE,

        /* Internal errors returned to user */
        GSM_ERR_FRAME_NOT_REQUESTED,
	GSM_ERR_FRAME_TYPE_UNKNOWN,
	GSM_ERR_FRAME_CONTENT_UNKNOWN,
        /* Other errors returned to user */
	GSM_ERR_DEVICE_WRITE,
	GSM_ERR_DEVICE_READ,
	GSM_ERR_DEVICE_OPEN,
	GSM_ERR_DEVICE_CLOSE,
        GSM_ERR_NONE,
        GSM_ERR_UNKNOWN,
        GSM_ERR_SOURCE_NOT_COMPILED,
        GSM_ERR_PROTOCOL_STRING_UNKNOWN,
        GSM_ERR_PHONE_STRING_UNKNOWN,
        GSM_ERR_OTHER_PROTOCOL,
        GSM_ERR_TIMEOUT,
        GSM_ERR_EMPTY,
	GSM_ERR_NOT_SUPPORTED,
	GSM_ERR_CONVERTED,
	GSM_ERR_TOO_MANY_ENTRIES,
	GSM_ERR_INVALID_LOCATION,
	GSM_ERR_INSIDE_PHONE_MENU,
	GSM_ERR_NO_SIM,
	GSM_ERR_GPLUS_NOT_SUPPORTED,
	GSM_ERR_MEMORY,
	GSM_ERR_FOLDER_PART,
	GSM_ERR_FOLDER_MORE,
	GSM_ERR_FILE_CHECKSUM,
	GSM_ERR_MUST_BE_FILE,
	GSM_ERR_MUST_BE_FOLDER,
	GSM_ERR_FILE_EXIST,
	GSM_ERR_FOLDER_EXIST,
	GSM_ERR_FOLDER_NOT_EMPTY,
	GSM_ERR_FILE_FOLDER_NOT_EXIST,
	GSM_ERR_FILE_NOT_EXIST,
	GSM_ERR_FOLDER_NOT_EXIST,
	GSM_ERR_FILE_TOO_SHORT
} GSM_Error_Code;

typedef struct {
	GSM_Error_Code			Code;
	wchart				Parameter;
} GSM_Error;

char *GSM_GetErrorInfo(GSM_Error e);
GSM_Error GSM_Return_Error(GSM_Error_Code Code);

typedef enum {
	MEM_Unknown,
	MEM_SIM,		// SIM card
	MEM_SIM_OWN,		// Own numbers
	MEM_PHONE,		// Device/phone memory
	MEM_PHONE_DIALLED,	// Dialled
	MEM_PHONE_MISSED,	// Missed
	MEM_PHONE_RECEIVED,	// Received
	MEM_SIM_PHONE,		// SIM card or Phone
	MEM_MEMORY_CARD,
	MEM_PHONE_SMS_LOGS
} GSM_MemoryType;

GSM_MemoryType 	GSM_GetMemoryType(char *Buffer);
char 		*GSM_GetMemoryName(GSM_MemoryType Type);

GSM_Error CheckRSS (unsignedstring *StableStr, unsignedstring *TestStr);

#endif
