/* (C) 2005-2007 by Marcin Wiacek www.mwiacek.com */

#ifndef gsm_cal_h
#define gsm_cal_h

#ifdef WIN32
#  include <windows.h>
#endif

#include "gsmmisc.h"
#include "../misc/misc.h"

typedef enum {
	Calendar_Not_Assigned = 1,

	Calendar_Text_Text,
	Calendar_Text_Location,
	Calendar_Text_Phone,

	Calendar_DateTime_Start,
	Calendar_DateTime_End,
	Calendar_DateTime_End_Repeat,
	Calendar_DateTime_ToneAlarm,
	Calendar_DateTime_SilentAlarm,

	Calendar_Int_Repeat_Frequency,
	Calendar_Int_Repeat_DayOfWeek,
	Calendar_Int_Repeat_Day,
	Calendar_Int_Repeat_Month
} GSM_Calendar_SubEntryType;

typedef enum {
	Calendar_Type_Not_Assigned = 1,

	Calendar_Type_Meeting,
	Calendar_Type_Memo,
	Calendar_Type_Call,
	Calendar_Type_Birthday,
	Calendar_Type_Reminder
} GSM_Calendar_Type;

class GSM_CalendarSubEntry
{
	friend class GSM_CalendarEntry;
public:
	GSM_CalendarSubEntry();
	~GSM_CalendarSubEntry();

	GSM_Calendar_SubEntryType 	GetType();
	GSM_Error 			SetToText(GSM_Calendar_SubEntryType Typ, wchar_t *Txt);
	wchar_t				*GetText();
	GSM_Error 			SetToDateTime(GSM_Calendar_SubEntryType Typ, GSM_DateTime DT2);
	GSM_DateTime			*GetDateTime();
	GSM_Error 			SetToInt(GSM_Calendar_SubEntryType Typ, int Value);
	int				GetInt();
	GSM_Error			SetError;

	GSM_CalendarSubEntry		*GetNext();
private:
	void 				SetNext(GSM_CalendarSubEntry *Nxt);

	int				IntValue;
	GSM_DateTime			DT;
	GSM_CalendarSubEntry		*Next;
	wchar_t				*Text;
	GSM_Calendar_SubEntryType	Type;
};

class GSM_CalendarEntry
{
public:
	GSM_CalendarEntry();
	~GSM_CalendarEntry();

	GSM_Calendar_Type		Type;
	GSM_Error			TypeSetError;
	int				Location;

	void 				ClearAll();	
	BOOLEAN 			IsNoteInDay(GSM_DateTime DT);
	BOOLEAN 			GetNext(GSM_CalendarSubEntry **En);
	GSM_Error	 		AddText(GSM_Calendar_SubEntryType Typ, wchar_t *Txt);
	GSM_Error	 		AddDateTime(GSM_Calendar_SubEntryType Typ, GSM_DateTime DT2);
	GSM_Error	 		AddInt(GSM_Calendar_SubEntryType Typ, int Value);
private:
	GSM_CalendarSubEntry		*Entries;
};

//-----------------------------------------------------------------------------

class GSM_NoteEntry
{
public:
	int		  Location;
	wchart		  Text;
};

//-----------------------------------------------------------------------------

typedef enum {
	GSM_Priority_Not_Assigned = 1,
	GSM_Priority_High,
	GSM_Priority_Medium,
	GSM_Priority_Low
} GSM_ToDo_Priority;

typedef enum {
	ToDo_Not_Assigned = 1,

	ToDo_Text_Text,
	ToDo_Priority,
	ToDo_Bool_Completed,

	ToDo_DateTime_End,
	ToDo_DateTime_ToneAlarm,
	ToDo_DateTime_SilentAlarm
} GSM_ToDo_SubEntryType;

class GSM_ToDoSubEntry
{
	friend class GSM_ToDoEntry;
public:
	GSM_ToDoSubEntry();
	~GSM_ToDoSubEntry();

	GSM_ToDo_SubEntryType		Type;
	GSM_DateTime			DT;
	wchart				Text;
	BOOLEAN				BoolValue;	
	GSM_ToDo_Priority		Priority;
	GSM_Error			SetError;

	GSM_ToDoSubEntry		*GetNext();
private:
	void 				SetNext(GSM_ToDoSubEntry *Nxt);

	GSM_ToDoSubEntry		*Next;
};

class GSM_ToDoEntry
{
public:
	GSM_ToDoEntry();
	~GSM_ToDoEntry();

	int				Location;

	void 				ClearAll();
	BOOLEAN 			GetNext(GSM_ToDoSubEntry **En);
	GSM_Error	 		AddSubEntry(GSM_ToDoSubEntry *En);
private:
	GSM_ToDoSubEntry		*Entries;
};

#endif
