/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdio.h>

#include "../../service/gsmmisc.h"
#include "../../misc/misc.h"
#include "../gsmprot.h"

class GSM_Protocol_PHONET:virtual public GSM_Protocol
{
public:
        GSM_Protocol_PHONET(GSM_Device **Dev, DebugInfo **Deb):GSM_Protocol(Dev,Deb) {
#ifdef WIN32
		Info.push_back(GSM_Protocol_Info("serial",   "dku2phonet",  false, true));
		Info.push_back(GSM_Protocol_Info("serial",   "dku2", 	    false, false));
		Info.push_back(GSM_Protocol_Info("serial",   "phonetblue",  false, true));
		Info.push_back(GSM_Protocol_Info("bluetooth","bluephonet",  false, true));
		Info.push_back(GSM_Protocol_Info("bluetooth","bluerfphonet",false, true));
		Info.push_back(GSM_Protocol_Info("infrared", "irdaphonet",  true,  false));
#else
#ifdef BLUEZ
		Info.push_back(GSM_Protocol_Info("bluetooth","bluerfphonet",true, true));
#endif
		Info.push_back(GSM_Protocol_Info("infrared", "irdaphonet",  true,  true));
#endif
        }
        ~GSM_Protocol_PHONET() {
        }

        GSM_Error Open		(char *Prot);
        GSM_Error Close		();
        GSM_Error Write		(unsigned char *buffer, int length, unsigned char type);
	GSM_Error Dispatch	(unsigned char *buffer, int length, int *position);

private:
	unsigned char		Frame_ID;
	unsigned char		PC_ID;
	unsigned char		Phone_ID;
};
