/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include "../../protocol/gsmprot.h"
#include "obexgen.h"

GSM_Error GSM_Phone_OBEXGEN::Dispatch(GSM_Protocol_Message *msg, void *Struct, int RequestID)
{
	AnsStruct 	AS;

	AS.RequestID  = RequestID;
	AS.FrameFound = false;

//if(Ans("\xD2",0x02,0x00,ID_GetID+ID3,&AS))return DCT34->ReplyGetID (msg,Debug,(unsigned char *)Struct);

	if (AS.FrameFound) return GSM_Return_Error(GSM_ERR_FRAME_NOT_REQUESTED);
        return GSM_Return_Error(GSM_ERR_FRAME_TYPE_UNKNOWN);
}

void GSM_Phone_OBEXGEN::AddBlock(char *Buffer, int *Pos, unsigned char ID, char *AddBuffer, int AddLength)
{	
	Buffer[(*Pos)++] = ID;
	Buffer[(*Pos)++] = (AddLength+3)/256;
	Buffer[(*Pos)++] = (AddLength+3)%256;
	if (AddBuffer != NULL) {
		memcpy(Buffer+(*Pos),AddBuffer,AddLength);
		(*Pos) += AddLength;
	}
}

GSM_Error GSM_Phone_OBEXGEN::ReplyOpen(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_OBEXGEN::Open(char *FrameID)
{
	int Current=4;
	unsigned char req2[200];
	unsigned char req[200] = {
		0x10,		// version 1.0
		0x00,		// no flags
		0x04,0x00};	// max size of packet = 4*256 
	
	/* Folder Browsing Service UUID */
	req2[0] = 0xF9; req2[1] = 0xEC; req2[2] = 0x7B;
	req2[3] = 0xC4; req2[4] = 0x95; req2[5] = 0x3C;
	req2[6] = 0x11; req2[7] = 0xD2; req2[8] = 0x98;
	req2[9] = 0x4E; req2[10]= 0x52; req2[11]= 0x54;
	req2[12]= 0x00; req2[13]= 0xDC; req2[14]= 0x9E;
	req2[15]= 0x09;
	AddBlock((char *)req, &Current, 0x46, (char *)req2, 16);

	return Write((unsigned char *)req, Current, 0x80, 2, ID_GetIMEI+ID, req);
}

