/* (C) 2003 - 2007 by Marcin Wiacek www.mwiacek.com */

#include "../../../../cfg/config.h" //msvc2005
#include "../../../misc/coding/coding.h"
#include "../../../protocol/gsmprot.h"
#include "../ndct34.h"
#include "n6110.h"
#include "ndct3.h"

GSM_Error GSM_Phone_N6110::Dispatch(GSM_Protocol_Message *msg, void *Struct, int RequestID)
{
	int	     ID2 = DCT3->GetID(), ID3 = DCT34->GetID();
	AnsStruct       AS;

	AS.RequestID  = RequestID;
	AS.FrameFound = false;

if(Ans("\x02",0x03,0x02,ID_IncomingFrame,&AS))    return DCT3->ReplySendSMS	   (msg,Debug,(unsigned char *)Struct,SMSSendReply);
if(Ans("\x02",0x03,0x03,ID_IncomingFrame,&AS))    return DCT3->ReplySendSMS	   (msg,Debug,(unsigned char *)Struct,SMSSendReply);
if(Ans("\x02",0x03,0x34,ID_GetSMSC+ID2,&AS))	  return DCT3->ReplyGetSMSC	   (msg,Debug,(unsigned char *)Struct);
if(Ans("\x02",0x03,0x35,ID_GetSMSC+ID2,&AS))	  return DCT3->ReplyGetSMSC	   (msg,Debug,(unsigned char *)Struct);

if(Ans("\x03",0x03,0x02,ID_GetPBK+ID,&AS))	  return ReplyGetPBK		   (msg,Debug,(unsigned char *)Struct);
if(Ans("\x03",0x03,0x05,ID_SetPBK+ID,&AS))	  return ReplySetPBK		   (msg,Debug,(unsigned char *)Struct);
if(Ans("\x03",0x03,0x06,ID_SetPBK+ID,&AS))	  return ReplySetPBK		   (msg,Debug,(unsigned char *)Struct);
if(Ans("\x03",0x03,0x08,ID_GetPBKStatus+ID,&AS))  return ReplyGetPBKStatus	   (msg,Debug,(unsigned char *)Struct);
if(Ans("\x03",0x03,0x09,ID_GetPBKStatus+ID,&AS))  return ReplyGetPBKStatus	   (msg,Debug,(unsigned char *)Struct);

if(Ans("\x0A",0x03,0x71,ID_IncomingFrame,&AS))    return ReplyNetworkInfo	   (msg,Debug,(unsigned char *)Struct);

if(Ans("\x11",0x03,0x63,ID_GetDateTime+ID2,&AS))  return DCT3->ReplyGetDateTime    (msg,Debug,(unsigned char *)Struct);

if(Ans("\x13",0x03,0x65,ID_AddCalendar+ID,&AS))   return ReplyAddCalendar	   (msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x67,ID_GetCalendar+ID,&AS))   return ReplyGetNextCalendar	   (msg,Debug,(unsigned char *)Struct);
if(Ans("\x13",0x03,0x69,ID_DelCalendar+ID,&AS))   return ReplyDeleteCalendar	   (msg,Debug,(unsigned char *)Struct);

if(Ans("\x14",0x03,0x05,ID_SetSMS+ID,&AS))	  return ReplySetSMS		   (msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x06,ID_SetSMS+ID,&AS))	  return ReplySetSMS		   (msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x08,ID_GetSMS+ID,&AS))	  return ReplyGetSMS		   (msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x09,ID_GetSMS+ID,&AS))	  return ReplyGetSMS		   (msg,Debug,(unsigned char *)Struct);
if(Ans("\x14",0x03,0x37,ID_GetSMSStatus+ID,&AS))  return ReplyGetSMSStatus	   (msg,Debug,(unsigned char *)Struct);

if(Ans("\x40",0x02,0x64,ID_SetSecurity+ID2,&AS))  return DCT3->ReplySetSecurity    (msg,Debug,(unsigned char *)Struct);
if(Ans("\x40",0x02,0x66,ID_GetIMEI+ID2    ,&AS))  return DCT3->ReplyGetIMEI	   (msg,Debug,(unsigned char *)Struct);

if(Ans("\xD2",0x02,0x00,ID_GetID+ID3,      &AS))  return DCT34->ReplyGetID	   (msg,Debug,(unsigned char *)Struct);

	if (AS.FrameFound) return GSM_Return_Error(GSM_ERR_FRAME_NOT_REQUESTED);
	return GSM_Return_Error(GSM_ERR_FRAME_TYPE_UNKNOWN);
}

GSM_Error GSM_Phone_N6110::GetIMEI(unsigned char *IMEI)
{
	return DCT3->GetIMEI(IMEI);
}

GSM_Error GSM_Phone_N6110::GetCodeNameModel(unsigned char *Model)
{
	return DCT34->GetCodeNameModel(Model);
}

GSM_Error GSM_Phone_N6110::GetFirmwareVersion(unsigned char *Firm)
{
	return DCT34->GetFirmwareVersion(Firm);
}

GSM_Error GSM_Phone_N6110::GetFirmwareDate(unsigned char *Dat)
{
	return DCT34->GetFirmwareDate(Dat);
}

GSM_Error GSM_Phone_N6110::GetManufacturer(unsigned char *Manufacturer)
{
	strcpy((char *)Manufacturer,"Nokia");
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6110::ReplyGetPBKStatus(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_PBKStatus *Status = (GSM_PBKStatus *)S;

	(*Debug)->Deb("RECEIVED: PBK memory status\n");

	if (msg->Buffer.data()[3] == 0x08) {
		Status->Used = msg->Buffer.data()[6];
		Status->Free = msg->Buffer.data()[5];
		(*Debug)->Deb("Used - %i\n",Status->Used);
		(*Debug)->Deb("Free - %i\n",Status->Free);

		return GSM_Return_Error(GSM_ERR_NONE);
	} else if (msg->Buffer.data()[3] == 0x09) {
		(*Debug)->Deb("Error %i\n",msg->Buffer.data()[4]);
		return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
	}
	return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Phone_N6110::GetPBKStatus(GSM_PBKStatus *Status)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x07, 0x00};

	Buff[4] = GetMemoryType(Status->Memory);
	if (Buff[4] == 0x00) return GSM_Return_Error(GSM_ERR_MEMORY);

	(*Debug)->Deb("SENT: getting status for %s memory\n",GSM_GetMemoryName(Status->Memory));
	return Write(Buff, sizeof(Buff), 0x03, 4, ID_GetPBKStatus+ID, Status);
}

unsigned char GSM_Phone_N6110::GetMemoryType(GSM_MemoryType Type)
{
	switch (Type) {
		case MEM_SIM	    	: return 0x03;
		case MEM_SIM_OWN	: return 0x05;
		case MEM_PHONE	  	: return 0x02;
		case MEM_PHONE_DIALLED  : return 0x07;
		case MEM_PHONE_RECEIVED : return 0x08;
		case MEM_PHONE_MISSED   : return 0x09;
		default		 	: return 0x00;
	}
}

GSM_Error GSM_Phone_N6110::Open(char *FrameID)
{
	GSM_Phone::Open(FrameID);

	if (FrameID[0] != 0) DCT34->SetFrameID(FrameID);

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6110::ReplyGetPBK(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_DateTime    *DT;
	char	    	Buff[400];
	int	     	Pos = 5, len;
	GSM_PBKEntry    *Entry = (GSM_PBKEntry *)S;

	len = msg->Buffer.data()[Pos];
	Pos++;
	if (len != 0) {
		memcpy(Buff,msg->Buffer.data()+Pos,len);
		Buff[len] = 0;
		Entry->AddText(PBK_Text_Name,StringToUnicodeReturn(Buff));
		Pos+=len;
	}

	len = msg->Buffer.data()[Pos];
	Pos++;
	if (len != 0) {
		memcpy(Buff,msg->Buffer.data()+Pos,len);
		Buff[len] = 0;
		Entry->AddText(PBK_Text_Phone_General,StringToUnicodeReturn(Buff));
		Pos+=len;
	}

	if (Entry->Memory==MEM_PHONE_MISSED || Entry->Memory==MEM_PHONE_RECEIVED || 
	    Entry->Memory==MEM_PHONE_DIALLED) {
		DT = NokiaGetDT(msg->Buffer.data()+Pos+2);
		if (DT->Day!=20 || DT->Month !=1 || DT->Year !=2118 ||
		    DT->Hour !=3 || DT->Minute!=14 || DT->Second!=7) {
			Entry->AddDateTime(PBK_DateTime_Call_Length, (*DT));
		}
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6110::GetPBK(GSM_PBKEntry *Entry)
{
	unsigned char Buff[] = {
		NOKIA_FRAME1, 0x01,
		0x00,	   //memory type
		0x00,	   //location
		0x00};

	Buff[4] = GetMemoryType(Entry->Memory);
	if (Buff[4] == 0x00) return GSM_Return_Error(GSM_ERR_MEMORY);

	if (Entry->Location > 255 || Entry->Location==0x00) {
		return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
	}
	Buff[5] = Entry->Location;
	if (Entry->Memory==MEM_PHONE_MISSED || Entry->Memory==MEM_PHONE_DIALLED || 
	    Entry->Memory==MEM_PHONE_RECEIVED) Buff[5]--;

	(*Debug)->Deb("SENT: getting entry %i in memory %s\n",Entry->Location,GSM_GetMemoryName(Entry->Memory));
	return Write(Buff, sizeof(Buff), 0x03, 4, ID_GetPBK+ID, Entry);
}

GSM_Error GSM_Phone_N6110::ReplySetPBK(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	(*Debug)->Deb("RECEIVED: status for setting PBK memory");

	if (msg->Buffer.data()[3] == 0x05) {
		(*Debug)->Deb(" - OK\n");
		return GSM_Return_Error(GSM_ERR_NONE);
	} else if (msg->Buffer.data()[3] == 0x06) {
		switch (msg->Buffer.data()[4]) {
		case 0x7D:
			(*Debug)->Deb(" - too high location ?\n");
			return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
		case 0x90:
			(*Debug)->Deb(" - too long..or other\n");
			return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		default:
			(*Debug)->Deb(" - unknown %02X error\n",msg->Buffer.data()[4]);
		}
	}

	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N6110::SetPBK(GSM_PBKEntry *Entry)
{
	char		    	c;
	int		     	i;
	GSM_PBKSubEntry	 	*SubEntry;
	wchar_t		 	*Name = NULL, *Phone = NULL;
	unsignedstring	  	Buffer;
	unsigned char	   	Buff[] = {
		NOKIA_FRAME1, 0x04,
		0x00,	   // memory type
		0x00};	  // location

	Buff[4] = GetMemoryType(Entry->Memory);
	if (Buff[4] == 0x00) return GSM_Return_Error(GSM_ERR_MEMORY);

	if (Entry->Location > 255 || Entry->Location==0x00) {
		return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
	}
	Buff[5] = Entry->Location;

	Buffer.append((const unsigned char*)Buff,sizeof(Buff));

	SubEntry  = NULL;
	while (Entry->GetNext(&SubEntry)) {
		switch (SubEntry->GetType()) {
		case PBK_Text_Name:
			if (Name == NULL) Name = SubEntry->GetText();
			break;
		case PBK_Text_Phone_General:
			if (Phone == NULL) Phone = SubEntry->GetText();
			break;
		default:
			break;
		}
	}
	if (Phone == NULL) {
		SubEntry  = NULL;
		while (Entry->GetNext(&SubEntry)) {
			switch (SubEntry->GetType()) {
			case PBK_Text_Name:
				if (Name == NULL) Name = SubEntry->GetText();
				break;
			case PBK_Text_Phone_General:
			case PBK_Text_Phone_Mobile:
			case PBK_Text_Phone_Home:
			case PBK_Text_Phone_Work:
			case PBK_Text_Phone_Fax:
				if (Phone == NULL) Phone = SubEntry->GetText();
				break;
			default:
				break;
			}
		}
	}

	i = 0;
	if (i>256) i = 256;
	if (Name != NULL) i = strlen(UnicodeToStringReturn(Name));
	c = i;
	Buffer.push_back(c);
	if (i!=0) Buffer.append((const unsigned char *)UnicodeToStringReturn(Name),i);

	i = 0;
	if (i>256) i = 256;
	if (Phone != NULL) i = strlen(UnicodeToStringReturn(Phone));
	c = i;
	Buffer.push_back(c);
	if (i!=0) Buffer.append((const unsigned char *)UnicodeToStringReturn(Phone),i);
	
	Buffer.push_back(0xff);

	(*Debug)->Deb("SENT: setting entry %i in memory %s\n",Entry->Location,GSM_GetMemoryName(Entry->Memory));
	return Write((unsigned char *)Buffer.data(), Buffer.size(), 0x03, 4, ID_SetPBK+ID, Entry);
}

GSM_Error GSM_Phone_N6110::DeletePBK(GSM_PBKEntry *Entry)
{
	GSM_PBKEntry Entry2;

	Entry2.Location = Entry->Location;
	Entry2.Memory   = Entry->Memory;

	return SetPBK(&Entry2);
}

GSM_Error GSM_Phone_N6110::ReplyNetworkInfo(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	return GSM_Return_Error(GSM_ERR_TIMEOUT);
}

GSM_Error GSM_Phone_N6110::GetDateTime(GSM_DateTime *DT)
{
	return DCT3->GetDateTime(DT,0x11);
}

GSM_Error GSM_Phone_N6110::ReplyGetNextCalendar(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_DateTime	    DT;
	GSM_CalendarEntry       *Calendar = (GSM_CalendarEntry *)S;
	char		    buffer[300];
	wchar_t		 buffer2[600];

	if (msg->Buffer.data()[4] == 0x93) return GSM_Return_Error(GSM_ERR_EMPTY);

	if (msg->Buffer.data()[4] != 0x01) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	(*Debug)->Deb("RECEIVED: calendar entry\n");

	switch(msg->Buffer.data()[8]) {
	case 0x01:
		(*Debug)->Deb("   reminder\n");
		Calendar->Type = Calendar_Type_Reminder;
		break;
	case 0x02:
		(*Debug)->Deb("   call\n");
		Calendar->Type = Calendar_Type_Call;
		break;
	case 0x03:
		(*Debug)->Deb("   meeting\n");
		Calendar->Type = Calendar_Type_Meeting;
		break;
	case 0x04:
		(*Debug)->Deb("   birthday\n");
		break;
	default:
		return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}
	
	memcpy(&DT,NokiaGetDT(msg->Buffer.data()+9),sizeof(GSM_DateTime));
	(*Debug)->Deb("   Start date time: %02i-%02i-%04i %02i:%02i:%02i\n",
			DT.Day,DT.Month,DT.Year,DT.Hour,DT.Minute,DT.Second);
	Calendar->AddDateTime(Calendar_DateTime_Start, DT);

	if (Calendar->Type == Calendar_Type_Birthday) {
		Calendar->AddInt(Calendar_Int_Repeat_Frequency, 1);
		Calendar->AddInt(Calendar_Int_Repeat_Day, DT.Day);
		Calendar->AddInt(Calendar_Int_Repeat_Month, DT.Month);
	}

	memcpy(&DT,NokiaGetDT(msg->Buffer.data()+16),sizeof(GSM_DateTime));
	if (DT.Year != 0) {
		(*Debug)->Deb("   Alarm: %02i-%02i-%04i %02i:%02i:%02i\n",
				DT.Day,DT.Month,DT.Year,DT.Hour,DT.Minute,DT.Second);
		Calendar->AddDateTime(Calendar_DateTime_ToneAlarm, DT); 
	}

	if (msg->Buffer.data()[23] != 0) {
		memcpy(buffer,msg->Buffer.data()+24,msg->Buffer.data()[23]);
		buffer[msg->Buffer.data()[23]] = 0;
		StringToUnicode(buffer,buffer2);
		Calendar->AddText(Calendar_Text_Text, buffer2);
	}

	if (Calendar->Type == Calendar_Type_Call && msg->Buffer.data()[24+msg->Buffer.data()[23]] != 0) {
		memcpy(buffer,msg->Buffer.data()+24+msg->Buffer.data()[23]+1,msg->Buffer.data()[24+msg->Buffer.data()[23]]);
		buffer[msg->Buffer.data()[24+msg->Buffer.data()[23]]] = 0;
		StringToUnicode(buffer,buffer2);
		Calendar->AddText(Calendar_Text_Phone, buffer2);
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_N6110::GetNextCalendar(GSM_CalendarEntry *Entry, BOOLEAN start, int *Current, int *Max)
{
	unsigned char Buff[] = {
		NOKIA_FRAME1, 0x66, 
		0x00};		  // location

	*Max = -1;

	if (start == TRUE) {
		CalendarLocation = 1;
	} else {
		CalendarLocation++;
	}

	Entry->ClearAll();

	Buff[4]	 = CalendarLocation;
	Entry->Location = CalendarLocation;

	(*Debug)->Deb("SENT: getting calendar location\n");
	return Write(Buff, sizeof(Buff), 0x13, 4, ID_GetCalendar+ID, Entry);
}

GSM_Error GSM_Phone_N6110::ReplyAddCalendar(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	(*Debug)->Deb("RECEIVED: status for adding calendar entry - ");
	switch (msg->Buffer.data()[4]) {
	case 0x01:
		(*Debug)->Deb("OK\n");
		return GSM_Return_Error(GSM_ERR_NONE);
	case 0x02:
		(*Debug)->Deb("OK, but notes texts were shortened\n");
		return GSM_Return_Error(GSM_ERR_NONE);
	case 0x73:
	case 0x7d:
		(*Debug)->Deb("error\n");
		return GSM_Return_Error(GSM_ERR_UNKNOWN);
	case 0x81:
		(*Debug)->Deb("during editing notes in phone menu\n");
		return GSM_Return_Error(GSM_ERR_INSIDE_PHONE_MENU);
	}
	(*Debug)->Deb("ERROR %i\n",msg->Buffer.data()[4]);
	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N6110::AddCalendar(GSM_CalendarEntry *Entry)
{
	unsignedstring	  	Buffer,Buffer2;
	GSM_CalendarSubEntry    *SubEntry, *Text = NULL, *Phone = NULL;
	GSM_CalendarSubEntry    *DateStart = NULL, *Alarm = NULL;
	int		     	i;

	SubEntry = NULL;
	while (Entry->GetNext(&SubEntry) == TRUE) {
		switch (SubEntry->GetType()) {
		case Calendar_Text_Text:
			Text = SubEntry;
			break;
		case Calendar_Text_Phone:
			Phone = SubEntry;
			break;
		case Calendar_DateTime_Start:
			DateStart = SubEntry;
			break;
		case Calendar_DateTime_ToneAlarm:
			Alarm = SubEntry;
			break;
		}
	}

	if (DateStart == NULL) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);

	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);
	Buffer.push_back(0x64);
	Buffer.push_back(0x01);
	Buffer.push_back(0x10);

	Buffer.push_back(0x10); //frame length - 7

	switch(Entry->Type) {
		case Calendar_Type_Reminder : Buffer.push_back(0x01); break;
		case Calendar_Type_Call     : Buffer.push_back(0x02); break;
		case Calendar_Type_Meeting  : Buffer.push_back(0x03); break;
		case Calendar_Type_Birthday : Buffer.push_back(0x04); break;
		default		     : return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
	}

	Buffer.push_back(DateStart->GetDateTime()->Year / 256);
	Buffer.push_back(DateStart->GetDateTime()->Year % 256);
	Buffer.push_back(DateStart->GetDateTime()->Month);
	Buffer.push_back(DateStart->GetDateTime()->Day);
	Buffer.push_back(DateStart->GetDateTime()->Hour);
	Buffer.push_back(DateStart->GetDateTime()->Minute);
	Buffer.push_back(DateStart->GetDateTime()->Second);

	if (Alarm != NULL) {
		Buffer.push_back(Alarm->GetDateTime()->Year / 256);
		Buffer.push_back(Alarm->GetDateTime()->Year % 256);
		Buffer.push_back(Alarm->GetDateTime()->Month);
		Buffer.push_back(Alarm->GetDateTime()->Day);
		Buffer.push_back(Alarm->GetDateTime()->Hour);
		Buffer.push_back(Alarm->GetDateTime()->Minute);
		Buffer.push_back(Alarm->GetDateTime()->Second);
	} else {
		for (i=0;i<7;i++) Buffer.push_back(0x00);
	}

	if (Text != NULL) {
		Buffer.push_back(UnicodeLength(Text->GetText()));
		Buffer.append((unsigned char *)UnicodeToStringReturn(Text->GetText()),UnicodeLength(Text->GetText()));
	}

	if (Entry->Type == Calendar_Type_Call) {
		if (Phone != NULL) {
			Buffer.push_back(UnicodeLength(Phone->GetText()));
			Buffer.append((unsigned char *)UnicodeToStringReturn(Phone->GetText()),UnicodeLength(Phone->GetText()));
		} else {
			Buffer.push_back(0x00);
		}
	}

	Buffer2.push_back(Buffer.size()-8);
	Buffer.replace(6,1,Buffer2);

	(*Debug)->Deb("SENT: Adding calendar note\n");
	return Write((unsigned char *)Buffer.data(), Buffer.size(), 0x13, 4, ID_AddCalendar+ID,Entry);
}

GSM_Error GSM_Phone_N6110::ReplyDeleteCalendar(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	(*Debug)->Deb("RECEIVED: status for deleting calendar entry - ");

	switch(msg->Buffer.data()[4]) {
	case 0x01:
		(*Debug)->Deb("OK\n");
		return GSM_Return_Error(GSM_ERR_NONE);
	case 0x81:
		(*Debug)->Deb("during editing notes in phone menu\n");
		return GSM_Return_Error(GSM_ERR_INSIDE_PHONE_MENU);
	case 0x93:
		(*Debug)->Deb("invalid location\n");
		return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
	}
	(*Debug)->Deb("ERROR %i\n",msg->Buffer.data()[4]);
	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N6110::DeleteCalendar(GSM_CalendarEntry *Entry)
{
	unsigned char Buff[] = {
		NOKIA_FRAME1, 0x68,
		0x00};		  // memory location

	Buff[4] = Entry->Location % 256;

	(*Debug)->Deb("SENT: deleting calendar note\n");
	return Write(Buff, sizeof(Buff), 0x13, 4, ID_DelCalendar+ID, Entry);
}

GSM_Error GSM_Phone_N6110::ReplyGetSMSStatus(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSStatus *Status = (GSM_SMSStatus *)S;

	(*Debug)->Deb("RECEIVED: SMS status\n");

	switch (msg->Buffer.data()[3]) {
	case 0x37:
		(*Debug)->Deb("  Free   : %i\n",msg->Buffer.data()[7]-msg->Buffer.data()[10]);
		(*Debug)->Deb("  UnRead : %i\n",msg->Buffer.data()[11]);
		(*Debug)->Deb("  Read   : %i\n",msg->Buffer.data()[10]-msg->Buffer.data()[11]);
	
		Status->SMSFree	 = msg->Buffer.data()[7]-msg->Buffer.data()[10];
		Status->SMSUnRead       = msg->Buffer.data()[11];
		Status->SMSRead	 = msg->Buffer.data()[10]-msg->Buffer.data()[11];
		Status->SMSTemplates    = 0;

		return GSM_Return_Error(GSM_ERR_NONE);
	case 0x38:
		return GSM_Return_Error(GSM_ERR_UNKNOWN);
	default:
		return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}
}

GSM_Error GSM_Phone_N6110::GetSMSStatus(GSM_SMSStatus *Status)
{
	if (Status->Memory!=MEM_SIM) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	return DCT3->GetSMSStatus(Status);
}

GSM_Error GSM_Phone_N6110::ReplyGetSMS(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSList     *List = (GSM_SMSList *)S;
	GSM_SMSEntry    SMS;
	GSM_Error       error;

	(*Debug)->Deb("RECEIVED: SMS message from SIM\n");
	switch (msg->Buffer.data()[3]) {
	case 0x08:
		SMS.SaveDateTimeAvailable = FALSE;
		SMS.Memory		= MEM_SIM;
		if (msg->Buffer.data()[7] < 2) {
			List->Folder = 1; //Inbox
		} else {
			List->Folder = 2; //Outbox
		}
		switch (msg->Buffer.data()[4]) {
			case  1 : SMS.Icon = SMS_Read;   break;
			case  3 : SMS.Icon = SMS_UnRead; break;
			case  5 : SMS.Icon = SMS_Sent;   break;
			case  7 : SMS.Icon = SMS_UnSent; break;
			default : return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
		}
		error = DCT3->DecodeSMSFrame(&SMS,msg->Buffer.data()+8,msg->Buffer.size()-8);
		if (error.Code == GSM_ERR_NONE) {
			List->ClearAll();
			List->Add(&SMS);
		}
		return error;
	case 0x09:
		return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}
	return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Phone_N6110::GetNextSMSMMSIDFromFolder(BOOLEAN start, GSM_SMSMMSFoldersSubEntry *SMSFolder, GSM_SMSList *SMS, GSM_MMSEntry *MMS, int *Current, int *MaxInFolder)
{
	wchart		SMSID;
	GSM_Error	error;
	unsigned char	Buff[] = {NOKIA_FRAME1, 0x07, 0x02,
				  0x00,		 // SMS location
				  0x01, 0x64};

	if (start == TRUE) {
		SMSStatus.Memory = MEM_SIM;
		error = GetSMSStatus(&SMSStatus);
		if (error.Code != GSM_ERR_NONE) return error;
		SMSLocation = 0;
	}

	SMSLocation++;
	if (SMSLocation > SMSStatus.SMSFree + SMSStatus.SMSRead + SMSStatus.SMSUnRead) return GSM_Return_Error(GSM_ERR_EMPTY);

	Buff[5] = SMSLocation;

	(*Debug)->Deb("SENT: getting SMS\n");
	error = Write(Buff, sizeof(Buff), 0x14, 4, ID_GetSMS+ID, SMS); 
	if (error.Code!=GSM_ERR_NONE) return error;

	MMS->Folder     = 0;
	*Current	= SMSLocation;
	*MaxInFolder    = SMSStatus.SMSFree + SMSStatus.SMSRead + SMSStatus.SMSUnRead;

	SetSMSLocations(SMS, SMS->Folder, SMSLocation);

	return error;
}

GSM_Error GSM_Phone_N6110::GetSMSC(GSM_SMSC *SMSC)
{
	return DCT3->GetSMSC(SMSC);
}

GSM_Error GSM_Phone_N6110::ReplySetSMS(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSList 		*List = (GSM_SMSList *)S;
	GSM_SMSListSubEntry     *SubEntry = NULL;

	switch (msg->Buffer.data()[3]) {
	case 0x05:
		while (List->GetNext(&SubEntry) == TRUE) {
			SetSMSLocations(List, List->Folder, msg->Buffer.data()[5]);
		}
		return GSM_Return_Error(GSM_ERR_NONE);
	case 0x06:
		break;
	}
	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N6110::SetSMS(GSM_SMSList *List)
{
	GSM_Error	       	error;
	unsignedstring	  	Buffer;
	GSM_SMSListSubEntry     *SMS0 = NULL;
	GSM_SMSEntry		*SMS;
	BOOLEAN		 	result;
	int		     	Location;
	unsigned char 		FolderID;

	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);
	Buffer.push_back(0x07);
	Buffer.push_back(0x04);

	//1 sms only
	result = List->GetNext(&SMS0);
	if (result == FALSE) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	SMS = SMS0->GetSMS();

	SMS->Memory = MEM_SIM;
	if (SMS->ID.length()==0) {
		//for adding sms to folder
		Location = 0;
		FolderID = List->Folder;
	} else {
		error = GetSMSLocations(List, &FolderID, &Location);
		if (error.Code != GSM_ERR_NONE) return error;
	}
	List->Folder = FolderID;

	switch (FolderID) {
	case 0x01:
		switch (SMS->Icon) {
			case SMS_Read   : Buffer.push_back(0x01); break;
			case SMS_UnRead : Buffer.push_back(0x03); break;
			default	 : return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		}
		Buffer.push_back(0x02);
		Buffer.push_back(Location);
		if (SMS->GetType()!=SMS_Deliver) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		Buffer.push_back(0x00); //deliver
		break;
	case 0x02:
		switch (SMS->Icon) {
			case SMS_Sent   : Buffer.push_back(0x05); break;
			case SMS_UnSent : Buffer.push_back(0x07); break;
			default	 : return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		}
		Buffer.push_back(0x02);
		Buffer.push_back(Location);
		if (SMS->GetType()!=SMS_Submit) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		Buffer.push_back(0x02); //submit
	default:
		return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
	}

	error = DCT3->EncodeSMSFrameToBuffer(SMS, &Buffer);
	if (error.Code != GSM_ERR_NONE) return error;

	(*Debug)->Deb("SENT: setting SMS in SIM\n");
	return Write((unsigned char *)Buffer.data(), Buffer.size(), 0x14, 4, ID_SetSMS+ID,List);
}

GSM_Error GSM_Phone_N6110::SendSMS(GSM_SMSEntry *SMS)
{
	return DCT3->SendSMS(SMS);
}

//todo
GSM_Error GSM_Phone_N6110::ReplyDeleteSMS(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSList *List = (GSM_SMSList *)S;

	switch (msg->Buffer.data()[3]) {
	case 0x05:
		(*Debug)->Deb("SMS deleted\n");
		return GSM_Return_Error(GSM_ERR_NONE);
	case 0x06:
		(*Debug)->Deb("SMS not deleted\n");
	}
	return GSM_Return_Error(GSM_ERR_FRAME_CONTENT_UNKNOWN);
}

GSM_Error GSM_Phone_N6110::DeleteSMS(GSM_SMSList *List)
{
	unsigned char	   	FolderID;
	int		     	Location;
	unsigned char	   	Buff[] = {NOKIA_FRAME1, 0x0A, 0x02,
					  0x00};		// SMS location

	GetSMSLocations(List, &FolderID, &Location);
	Buff[5] = Location;

	(*Debug)->Deb("SENT: deleting SMS\n");
	return Write(Buff, sizeof(Buff), 0x14, 4, ID_DelSMS+ID, List); 
}

GSM_Error GSM_Phone_N6110::GetSMSMMSFolders(GSM_SMSMMSFolders *Folders)
{
	wchart ID;

	ID.clear(); ID.push_back('1');
	Folders->Add(StringToUnicodeReturn("Inbox"),FALSE,TRUE,FALSE,MEM_SIM,&ID,1,-1);
	ID.clear(); ID.push_back('2');
	Folders->Add(StringToUnicodeReturn("Outbox"),FALSE,FALSE,FALSE,MEM_SIM,&ID,2,-1);

        return GSM_Return_Error(GSM_ERR_NONE);
}
