/* Martin Strigl */

#ifndef WIN32
#ifndef DJGPP
#ifndef unixserial_h
#define unixserial_h

#include <fcntl.h>
#include <sys/ioctl.h>
#include <termios.h>

#endif
#endif
#endif

#include "../../misc/misc.h"
#include "../../service/gsmmisc.h"
#include "../gsmdev.h"


class GSM_Device_Serial:virtual public GSM_Device
{
public:
        GSM_Device_Serial(DebugInfo **Deb):GSM_Device(Deb) {
		Info.push_back(GSM_Device_Info(Deb,"serial"));
        }
	~GSM_Device_Serial() {
	}

        GSM_Error       Open            (char *Dev, char *Prot, char *Pho, char **DeviceModel, GSM_AllPhones *Phones);
        GSM_Error       Close           ();
        GSM_Error 	Read            (unsigned char *buf, int *len);
        GSM_Error 	Write           (const unsigned char *buf, int len);
	GSM_Error 	SetParameters	(int speed, int bits, bool parity, int stopbits);
	GSM_Error	SetLines	(bool dtr, bool rts);
private:
	int 	SetSpeed	(int speed);
	int 	SetBits		(int bits);
	int 	SetParity	(bool parity);
	int 	SetStopBits	(int stopbits);

	int 		Device;
	struct termios 	old_settings;
};
