//---------------------------------------------------------------------------
//
// Name:        SMSEditorDlg.cpp
// Author:      Marcinello
// Created:     2007-02-06 23:39:09
// Description: SMSEditorDlg class implementation
//
//---------------------------------------------------------------------------

#include "../cfg/config.h"
#include "../common/service/gsmdata.h"
#include "../common/service/gsmmisc.h"
#include "../common/service/backup/gsmback.h"
#include "../common/gsmstate.h"

#include "SMSEditorDlg.h"

//Do not add custom headers
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// SMSEditorDlg
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(SMSEditorDlg,wxDialog)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(SMSEditorDlg::OnClose)
	EVT_BUTTON(ID_SENDWXBUTTON,SMSEditorDlg::SendWxButtonClick)
	EVT_BUTTON(ID_CANCELWXBUTTON,SMSEditorDlg::CancelWxButtonClick)
	EVT_BUTTON(ID_RECIPIENTDELETEWXBUTTON,SMSEditorDlg::RecipientDeleteWxButtonClick)
	
	EVT_TEXT(ID_NEWRECIPIENTWXEDIT,SMSEditorDlg::NewRecipientWxEditUpdated)
	EVT_BUTTON(ID_NEWRECIPIENTADDWXBUTTON,SMSEditorDlg::NewRecipientAddWxButtonClick)
	
	EVT_TEXT(ID_TEXTSMSWXMEMO,SMSEditorDlg::TextSMSWxMemoUpdated)
	EVT_CHECKBOX(ID_TEXTSMSUNICODEWXCHECKBOX,SMSEditorDlg::TextSMSUnicodeWxCheckBoxClick)
END_EVENT_TABLE()
////Event Table End

SMSEditorDlg::SMSEditorDlg(GSM_StateMachine *s2, GSM_SMSList *List2, wxWindow *parent, wxWindowID id, const wxString &title, const wxPoint &position, const wxSize& size, long style)
: wxDialog(parent, id, title, position, size, style)
{
    GSM_SMSC    SMSC;
    int         Num=1;
    GSM_Error   error;
    char        buff[200];

	num = 0;
    s=s2;
    List = List2;

	CreateGUIControls();
    
    SetTitle(title);
    
    while (true) {
    	SMSC.Location = Num;
    	error = s->Phones->Current->GetSMSC(&SMSC);
    	if (error.Code != GSM_ERR_NONE) break;
     	sprintf(buff,"%s",UnicodeToStringReturn(SMSC.GetSMSCNumber()));
    //    	if (UnicodeLength(SMSC.GetName())!=0) {
    //        	sprintf(buff+strlen(buff)," (%s)",UnicodeToStringReturn(SMSC.GetName()));
    //        }
        if (strlen(buff)!=0) SMSCWxComboBox->Append(buff);
        Num++;
    }
    SMSCWxComboBox->Select(0);    

//    WxMemo1->SetFocus();
}

SMSEditorDlg::~SMSEditorDlg()
{
} 

void SMSEditorDlg::CreateGUIControls()
{
	//Do not add custom code between
        //GUI Items Creation Start and GUI Items Creation End.
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	WxPanel1 = new wxPanel(this, ID_WXPANEL1, wxPoint(0,0), wxSize(543,476));

	WxNotebook2 = new wxNotebook(WxPanel1, ID_WXNOTEBOOK2, wxPoint(5,5),wxSize(417,378));

	WxNoteBookPage2 = new wxPanel(WxNotebook2, ID_WXNOTEBOOKPAGE2, wxPoint(4,24), wxSize(409,350));
	WxNotebook2->AddPage(WxNoteBookPage2, wxT("Content"));

	WxNotebook1 = new wxNotebook(WxNoteBookPage2, ID_WXNOTEBOOK1, wxPoint(3,3),wxSize(400,343));

	WxNoteBookPage1 = new wxPanel(WxNotebook1, ID_WXNOTEBOOKPAGE1, wxPoint(4,24), wxSize(392,315));
	WxNotebook1->AddPage(WxNoteBookPage1, wxT("Text SMS"));

	WxStaticBox1 = new wxStaticBox(WxNoteBookPage1, ID_WXSTATICBOX1, wxT("Text"), wxPoint(4,3), wxSize(381,124));

	WxStaticBox2 = new wxStaticBox(WxNoteBookPage1, ID_WXSTATICBOX2, wxT("Text preview in recipients' phone(s)"), wxPoint(3,129), wxSize(383,122));

	WxStaticBox3 = new wxStaticBox(WxNoteBookPage1, ID_WXSTATICBOX3, wxT("Options"), wxPoint(3,252), wxSize(382,59));

	TextSMSUnicodeWxCheckBox = new wxCheckBox(WxNoteBookPage1, ID_TEXTSMSUNICODEWXCHECKBOX, wxT("Use Unicode alphabet (less chars in single SMS, all national supported)"), wxPoint(10,265), wxSize(369,17), 0, wxDefaultValidator, wxT("TextSMSUnicodeWxCheckBox"));

	TextSMSClassWxCheckBox = new wxCheckBox(WxNoteBookPage1, ID_TEXTSMSCLASSWXCHECKBOX, wxT("Send in class 0 (displayed immedietaly)"), wxPoint(10,282), wxSize(332,24), 0, wxDefaultValidator, wxT("TextSMSClassWxCheckBox"));

	TextSMSWxMemo = new wxTextCtrl(WxNoteBookPage1, ID_TEXTSMSWXMEMO, wxT(""), wxPoint(13,21), wxSize(366,98), wxTE_MULTILINE, wxDefaultValidator, wxT("TextSMSWxMemo"));
	TextSMSWxMemo->SetMaxLength(0);
	TextSMSWxMemo->SetFocus();
	TextSMSWxMemo->SetInsertionPointEnd();

	TextSMSPreviewWxMemo = new wxTextCtrl(WxNoteBookPage1, ID_TEXTSMSPREVIEWWXMEMO, wxT(""), wxPoint(13,147), wxSize(365,96), wxTE_READONLY | wxTE_WORDWRAP | wxTE_MULTILINE, wxDefaultValidator, wxT("TextSMSPreviewWxMemo"));
	TextSMSPreviewWxMemo->SetMaxLength(0);
	TextSMSPreviewWxMemo->SetFocus();
	TextSMSPreviewWxMemo->SetInsertionPointEnd();
	TextSMSPreviewWxMemo->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_BTNFACE));

	WxNoteBookPage3 = new wxPanel(WxNotebook2, ID_WXNOTEBOOKPAGE3, wxPoint(4,24), wxSize(409,350));
	WxNotebook2->AddPage(WxNoteBookPage3, wxT("Sending options"));

	WxStaticBox5 = new wxStaticBox(WxNoteBookPage3, ID_WXSTATICBOX5, wxT("New recipient"), wxPoint(4,9), wxSize(398,74));

	NewRecipientAddWxButton = new wxButton(WxNoteBookPage3, ID_NEWRECIPIENTADDWXBUTTON, wxT("Add"), wxPoint(287,27), wxSize(107,23), 0, wxDefaultValidator, wxT("NewRecipientAddWxButton"));
	NewRecipientAddWxButton->Enable(false);

	NewRecipientWxEdit = new wxTextCtrl(WxNoteBookPage3, ID_NEWRECIPIENTWXEDIT, wxT(""), wxPoint(15,27), wxSize(263,23), 0, wxDefaultValidator, wxT("NewRecipientWxEdit"));

	WxStaticBox6 = new wxStaticBox(WxNoteBookPage3, ID_WXSTATICBOX6, wxT("Current recipients"), wxPoint(3,85), wxSize(400,164));

	RecipientsWxListCtrl = new wxListCtrl(WxNoteBookPage3, ID_RECIPIENTSWXLISTCTRL, wxPoint(13,106), wxSize(263,135), wxLC_REPORT | wxLC_NO_HEADER);
	RecipientsWxListCtrl->InsertColumn(0,wxT("Name"),wxLIST_FORMAT_LEFT,200 );
	RecipientsWxListCtrl->InsertColumn(0,wxT("Number"),wxLIST_FORMAT_LEFT,100 );

	WxButton6 = new wxButton(WxNoteBookPage3, ID_WXBUTTON6, wxT("Add from phonebook"), wxPoint(287,52), wxSize(107,22), 0, wxDefaultValidator, wxT("WxButton6"));
	WxButton6->Show(false);

	RecipientDeleteWxButton = new wxButton(WxNoteBookPage3, ID_RECIPIENTDELETEWXBUTTON, wxT("Delete"), wxPoint(287,106), wxSize(106,21), 0, wxDefaultValidator, wxT("RecipientDeleteWxButton"));
	RecipientDeleteWxButton->Enable(false);

	WxStaticBox7 = new wxStaticBox(WxNoteBookPage3, ID_WXSTATICBOX7, wxT("Other"), wxPoint(2,250), wxSize(399,98));

	WxStaticText2 = new wxStaticText(WxNoteBookPage3, ID_WXSTATICTEXT2, wxT("SMS center"), wxPoint(11,264), wxDefaultSize, 0, wxT("WxStaticText2"));

	wxArrayString arrayStringFor_SMSCWxComboBox;
	SMSCWxComboBox = new wxComboBox(WxNoteBookPage3, ID_SMSCWXCOMBOBOX, wxT("SMSCWxComboBox"), wxPoint(74,260), wxSize(202,21), arrayStringFor_SMSCWxComboBox, wxCB_DROPDOWN | wxCB_READONLY | wxTE_READONLY, wxDefaultValidator, wxT("SMSCWxComboBox"));

	DeliveryWxCheckBox = new wxCheckBox(WxNoteBookPage3, ID_DELIVERYWXCHECKBOX, wxT("Delivery reports (no extra costs)"), wxPoint(10,305), wxSize(314,19), 0, wxDefaultValidator, wxT("DeliveryWxCheckBox"));

	CancelWxButton = new wxButton(WxPanel1, ID_CANCELWXBUTTON, wxT("Cancel"), wxPoint(431,115), wxSize(104,26), 0, wxDefaultValidator, wxT("CancelWxButton"));

	SendWxButton = new wxButton(WxPanel1, ID_SENDWXBUTTON, wxT("Send"), wxPoint(431,26), wxSize(104,25), 0, wxDefaultValidator, wxT("SendWxButton"));
	SendWxButton->Enable(false);

	WxStaticBox4 = new wxStaticBox(WxPanel1, ID_WXSTATICBOX4, wxT("Original SMS"), wxPoint(6,385), wxSize(417,86));
	WxStaticBox4->Enable(false);

	WxMemo3 = new wxTextCtrl(WxPanel1, ID_WXMEMO3, wxT(""), wxPoint(15,403), wxSize(330,62), wxTE_READONLY | wxTE_MULTILINE, wxDefaultValidator, wxT("WxMemo3"));
	WxMemo3->SetMaxLength(0);
	WxMemo3->Enable(false);
	WxMemo3->SetFocus();
	WxMemo3->SetInsertionPointEnd();

	AddOriginalWxButton = new wxButton(WxPanel1, ID_ADDORIGINALWXBUTTON, wxT("Add"), wxPoint(351,402), wxSize(66,22), 0, wxDefaultValidator, wxT("AddOriginalWxButton"));
	AddOriginalWxButton->Enable(false);

	WxStaticText1 = new wxStaticText(WxNoteBookPage3, ID_WXSTATICTEXT1, wxT("Validity"), wxPoint(11,285), wxDefaultSize, 0, wxT("WxStaticText1"));

	wxArrayString arrayStringFor_WxComboBox1;
	WxComboBox1 = new wxComboBox(WxNoteBookPage3, ID_WXCOMBOBOX1, wxT("WxComboBox1"), wxPoint(74,283), wxSize(203,21), arrayStringFor_WxComboBox1, 0, wxDefaultValidator, wxT("WxComboBox1"));

	WxCheckBox1 = new wxCheckBox(WxNoteBookPage3, ID_WXCHECKBOX1, wxT("Allow reply for your cost"), wxPoint(10,325), wxSize(268,18), 0, wxDefaultValidator, wxT("WxCheckBox1"));

	SetTitle(wxT("Untitled1"));
	SetIcon(wxNullIcon);
	SetSize(8,8,551,503);
	Center();
	
	////GUI Items Creation End
}

void SMSEditorDlg::OnClose(wxCloseEvent& /*event*/)
{
	Destroy();
}

void SMSEditorDlg::SetInfo()
{
    char                   buff[200];
	GSM_SMSListSubEntry    *SubEntry;
	int                    Parts=0;

	RecipientDeleteWxButton->Enable((RecipientsWxListCtrl->GetItemCount()!=0));

    SubEntry = NULL;
    while (List->GetNext(&SubEntry)) Parts++;

    if (RecipientsWxListCtrl->GetItemCount()!=0 && Parts!=0) {
    	SendWxButton->Enable(TRUE);
        sprintf(buff,"Send (%i parts)",Parts*RecipientsWxListCtrl->GetItemCount());        
    } else {
    	SendWxButton->Enable(FALSE);
        sprintf(buff,"Send");
    }
    SendWxButton->SetLabel(buff);
}

/*
 * CancelWxButtonClick
 */
void SMSEditorDlg::CancelWxButtonClick(wxCommandEvent& event)
{
	EndModal(wxID_CANCEL);
}

/*
 * TextSMSWxMemoUpdated
 */
void SMSEditorDlg::TextSMSWxMemoUpdated(wxCommandEvent& event)
{
    GSM_Error       error;
    unsigned char   buff[500];
    char            buff2[500];
    int             len;
    GSM_SMSEntry    SMS;
    wchar_t         Buffer[200],Destination[500];

    TextSMSPreviewWxMemo->Clear();
    List->ClearAll();
    
    if (!TextSMSUnicodeWxCheckBox->GetValue()) {
        error = GSM_EncodeSMSText(buff, (const wchar_t *)TextSMSWxMemo->GetValue().wc_str(wxConvLibc), &len, 160, 0);
		GSM_DecodeSMSText(Destination, buff, len,len, 0);
        TextSMSPreviewWxMemo->AppendText(Destination);
        sprintf(buff2,"Text (%i chars left)",160-len);
    } else {
        TextSMSPreviewWxMemo->AppendText((const wchar_t *)TextSMSWxMemo->GetValue().wc_str(wxConvLibc));
        sprintf(buff2,"Text (%i chars left)",80-UnicodeLength((const wchar_t *)TextSMSWxMemo->GetValue().wc_str(wxConvLibc)));
    }
    WxStaticBox1->SetLabel(buff2);

    if (UnicodeLength((const wchar_t *)TextSMSWxMemo->GetValue().wc_str(wxConvLibc))==0) {
        SetInfo();
        return;
    }
    
	SMS.SetType(SMS_Submit);
    if (!TextSMSUnicodeWxCheckBox->GetValue()) {
    	SMS.SetCoding(SMS_Coding_Default_No_Compression);

        GSM_EncodeSMSText(buff, (const wchar_t *)TextSMSWxMemo->GetValue().wc_str(wxConvLibc), &len, 160, 0);
		GSM_DecodeSMSText(Destination, buff, len,len, 0);
    } else {
    	SMS.SetCoding(SMS_Coding_Unicode_No_Compression);

    	CopyUnicode((const wchar_t *)TextSMSWxMemo->GetValue().wc_str(wxConvLibc),Destination);
    	Destination[70] = 0;
    }
	SMS.SetDecodedText(Destination);
    if (TextSMSClassWxCheckBox->GetValue()) SMS.SetClass(0);
    List->Add(&SMS);    

    SetInfo();
}

/*
 * RecipientDeleteWxButtonClick
 */
void SMSEditorDlg::RecipientDeleteWxButtonClick(wxCommandEvent& event)
{
    long item=-1;

    for (;;) {
        item = RecipientsWxListCtrl->GetNextItem(item,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
        if (item==-1) break;
        RecipientsWxListCtrl->DeleteItem(item);
        item=-1;
    }
    SetInfo();
}

/*
 * SendWxButtonClick
 */
void SMSEditorDlg::SendWxButtonClick(wxCommandEvent& event)
{
	GSM_SMSListSubEntry *SubEntry;
    
	SubEntry = NULL;
	while (List->GetNext(&SubEntry) == TRUE) {
        SubEntry->GetSMS()->SetSMSCNumber((wchar_t *)((const wchar_t *)SMSCWxComboBox->GetValue().wc_str(wxConvLibc)));
    }        
	EndModal(wxID_OK);
}

/*
 * TextSMSUnicodeWxCheckBoxClick
 */
void SMSEditorDlg::TextSMSUnicodeWxCheckBoxClick(wxCommandEvent& event)
{
    TextSMSWxMemoUpdated(event);
}

/*
 * NewRecipientAddWxButtonClick
 */
void SMSEditorDlg::NewRecipientAddWxButtonClick(wxCommandEvent& event)
{
    long tmp;

    tmp = RecipientsWxListCtrl->InsertItem((num)++, NewRecipientWxEdit->GetValue(), 0);
    SetInfo();
}

/*
 * NewRecipientWxEditUpdated
 */
void SMSEditorDlg::NewRecipientWxEditUpdated(wxCommandEvent& event)
{
	NewRecipientAddWxButton->Enable((NewRecipientWxEdit->GetValue()!=""));
}
