/* (C) 2005 by Marcin Wiacek www.mwiacek.com */

#include "gsmsms.h"
#include "smsmulti.h"
#include "../gsmmisc.h"
#include "../../misc/coding/coding.h"

GSM_SMSListSubEntry::GSM_SMSListSubEntry()
{
	Next = NULL;
}

GSM_SMSListSubEntry::~GSM_SMSListSubEntry()
{
	delete(Next);
}

void GSM_SMSListSubEntry::SetSMS(GSM_SMSEntry *SMS2)
{
	GSM_SMSNumbersSubEntry *Number;

	SMS.PhoneNumbers.ClearAll();
	Number = NULL;
	while (SMS2->PhoneNumbers.GetNext(&Number)) {
		SMS.PhoneNumbers.Add(Number->PhoneNumber.data(),Number->PhoneNumber.size());
	}

	SMS.UserData.clear();
	SMS.UserData.append(SMS2->UserData.data(),SMS2->UserData.size());

	SMS.SMSCNumber.clear();
	SMS.SMSCNumber.append(SMS2->SMSCNumber.data(),SMS2->SMSCNumber.size());

	SMS.TPDCS 	  = SMS2->TPDCS;
	memcpy(SMS.DateTime,SMS2->DateTime,7);
	memcpy(SMS.SMSCTime,SMS2->SMSCTime,7);
	SMS.TPStatus  	  = SMS2->TPStatus;
	SMS.TPUDL	  = SMS2->TPUDL;
	SMS.TPVP 	  = SMS2->TPVP;
	SMS.firstbyte 	  = SMS2->firstbyte;
	SMS.TPMR 	  = SMS2->TPMR;
	SMS.TPPID 	  = SMS2->TPPID;

	SMS.ID 		= SMS2->ID;
	SMS.Memory 	  = SMS2->Memory;
	SMS.Icon 	  = SMS2->Icon;
	SMS.SaveDateTimeAvailable = SMS2->SaveDateTimeAvailable;
	if (SMS.SaveDateTimeAvailable) memcpy(&SMS.SaveDateTime,&SMS2->SaveDateTime,sizeof(GSM_DateTime));
	SMS.Name.clear();
	SMS.Name.append(SMS2->Name.data(),SMS2->Name.length());
}

GSM_SMSEntry *GSM_SMSListSubEntry::GetSMS()
{
	return &SMS;
}

void GSM_SMSListSubEntry::SetNext(GSM_SMSListSubEntry *Nxt)
{
	Next = Nxt;
}

GSM_SMSListSubEntry *GSM_SMSListSubEntry::GetNext()
{
	return Next;
}

/* ------------------------------------------------------------------------ */

GSM_SMSList::GSM_SMSList()
{
	Entries = NULL;
}

GSM_SMSList::~GSM_SMSList()
{
	delete(Entries);
}

BOOLEAN GSM_SMSList::GetNext(GSM_SMSListSubEntry **En)
{
	if ((*En) == NULL) {
		(*En) = Entries;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

GSM_Error GSM_SMSList::Add(GSM_SMSEntry *SMS)
{
	GSM_SMSListSubEntry *Entry,*Entry2;

	Entry = new GSM_SMSListSubEntry;
	Entry->SetSMS(SMS);

	if (Entries == NULL) {
		Entries = Entry;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

void GSM_SMSList::ClearAll()
{
	delete(Entries);
	Entries = NULL;
}

//----------------------------------- SMSDecoded ------------------------------------

GSM_SMSDecodedSubEntry::GSM_SMSDecodedSubEntry()
{
	Next = NULL;
}

GSM_SMSDecodedSubEntry::~GSM_SMSDecodedSubEntry()
{
	delete(Next);
}

GSM_SMSDecodedSubEntry *GSM_SMSDecodedSubEntry::GetNext()
{
	return Next;
}

void GSM_SMSDecodedSubEntry::SetNext(GSM_SMSDecodedSubEntry *Nxt)
{
	Next = Nxt;
}

/* ------------------------------------------------------------------------ */

GSM_SMSDecodedEntry::GSM_SMSDecodedEntry()
{
	Entries = NULL;
}


GSM_SMSDecodedEntry::~GSM_SMSDecodedEntry()
{
	delete(Entries);
}

BOOLEAN GSM_SMSDecodedEntry::GetNext(GSM_SMSDecodedSubEntry **En)
{
	if ((*En) == NULL) {
		(*En) = Entries;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}


void GSM_SMSDecodedEntry::ClearAll()
{
	delete(Entries);
	Entries = NULL;
}

GSM_Error GSM_SMSDecodedEntry::AddSubEntry(GSM_SMSDecodedSubEntry *En)
{
	GSM_SMSDecodedSubEntry *Entry2;

	if (Entries == NULL) {
		Entries = En;
	} else {
		Entry2 = Entries;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(En);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

//-----------------------------------------------------------------------------

GSM_Error EncodeSMSToSMSList(GSM_SMSDecodedEntry *Source, GSM_SMSEncoded_Type Type, GSM_SMSList *Destination)
{
	GSM_SMSDecodedSubEntry 	*SubEntry;
	GSM_SMSEntry		SMS;

	Destination->ClearAll();
	if (Type == SMSEncoded_Linked_Short || Type == SMSEncoded_Linked_Long) {
		SubEntry = NULL;
		while (Source->GetNext(&SubEntry)) {
			if (SubEntry->Type != SMSDecoded_Text) {
				return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
			}
			if (SubEntry->TextCoding != SMS_Coding_Unicode_No_Compression &&
			    SubEntry->TextCoding != SMS_Coding_Default_No_Compression) {
				return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
			}
		}
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}
