/* (C) 2006 by Marcin Wiacek www.mwiacek.com */

#ifndef gsm_files_h
#define gsm_files_h

#include "gsmmisc.h"
#include "../misc/misc.h"
#include "../misc/files.h"

class GSM_FileFolderInfoListSubEntry
{
	friend class GSM_FileFolderInfoList;
public:
	GSM_FileFolderInfoListSubEntry();
	~GSM_FileFolderInfoListSubEntry();

	FileFolderInfo			Info;
	GSM_FileFolderInfoListSubEntry	*GetNext();	
private:
	void				SetNext(GSM_FileFolderInfoListSubEntry *Nxt);

	GSM_FileFolderInfoListSubEntry	*Next;
};

class GSM_FileFolderInfoList
{
public:
	GSM_FileFolderInfoList();
	~GSM_FileFolderInfoList();

	FileFolderInfo		Info;
	BOOLEAN				SubEntryFullData;

	GSM_Error	 		AddSubEntry(FileFolderInfo *FInfo);
	BOOLEAN 			GetNext(GSM_FileFolderInfoListSubEntry **En);
	void 				ClearAll();
private:
	GSM_FileFolderInfoListSubEntry	*Entries;
};

class GSM_FileFolderInfoListsSubEntry
{
	friend class GSM_FileFolderInfoLists;
public:
	GSM_FileFolderInfoListsSubEntry();
	~GSM_FileFolderInfoListsSubEntry();

	GSM_FileFolderInfoList		Info;
	GSM_FileFolderInfoListsSubEntry	*GetNext();	
private:
	void				SetNext(GSM_FileFolderInfoListsSubEntry *Nxt);

	GSM_FileFolderInfoListsSubEntry	*Next;
};

class GSM_FileFolderInfoLists
{
public:
	GSM_FileFolderInfoLists();
	~GSM_FileFolderInfoLists();

	GSM_Error	 		AddSubEntry(GSM_FileFolderInfoListsSubEntry *FInfo);
	BOOLEAN 			GetNext(GSM_FileFolderInfoListsSubEntry **En);
	void 				ClearAll();
private:
	GSM_FileFolderInfoListsSubEntry	*Entries;
};

class GSM_File:virtual public Gen_File
{
	friend class GSM_Phone_N6510;
public:
	GSM_File();
	~GSM_File();

	void 				JAD_Find_Data(unsignedstring *Vendor, unsignedstring *Name, unsignedstring *JAR, unsignedstring *Version, int *Size);
	void 				SetWin32EndLines();
private:
	int				Handle;

	void 				JAD_Find_Line(char *Name, unsignedstring *Value);
};

#endif
