/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <list>

#include "../service/gsmmisc.h"
#include "../misc/misc.h"

using namespace std;

#ifndef gsmprot_h
#define gsmprot_h

class GSM_Device;
class GSM_Phone;
class GSM_AllPhones;

const int MSG_Sync 		= 1;
const int MSG_Destination 	= 2;
const int MSG_Source 		= 3;
const int MSG_Type 		= 4;
const int MSG_Length1 		= 5;
const int MSG_Length2 		= 6;
const int MSG_Message 		= 7;
const int MSG_Sequence 		= 8;
const int MSG_FramesNum 	= 9;
const int MSG_Padding 		= 10;
const int MSG_CheckSum1 	= 11;
const int MSG_CheckSum2 	= 12;

class GSM_Protocol_Message
{
public:
        int                             Length;
        unsigned char                   Type;
        unsigned char                   Source;
        unsigned char                   Destination;
	unsignedstring 			Buffer;

        GSM_Protocol_Message		();
        ~GSM_Protocol_Message		();
};

class GSM_Protocol_Info
{
public:
        char                            *Protocol;
        char                            *Device;
	bool				CanUseDeviceName;
	BOOLEAN				NeedPort;

        GSM_Protocol_Info		(char *Dev, char *Prot, bool UseDevName, bool Need);
};

class GSM_Protocol
{
        friend class                    GSM_AllProtocols;
public:
        list <GSM_Protocol_Info>   	Info;
        GSM_Protocol_Message            MsgReceived;
        GSM_Protocol_Message            MsgSent;

        GSM_Protocol			(GSM_Device **Dev, DebugInfo **Deb);
        virtual 			~GSM_Protocol();

        virtual GSM_Error               Open	(char *Prot) = 0;
        virtual GSM_Error               Close	() = 0;
	virtual GSM_Error		Dispatch(unsigned char *buffer, int length, int *position) = 0;
        virtual GSM_Error               Write	(unsigned char *buffer, int length, unsigned char type);
protected:
        GSM_Protocol                    *Next;
        GSM_Device                      **Device;
        DebugInfo                       **Debug;
        char                            *Protocol;

	int				State;	
	bool				Opened;

	GSM_Error 			CheckReadByte(unsigned char Current, unsigned char Expected, int NewState);
};

class GSM_AllProtocols
{
public:
	char				CurrentName[50];
        GSM_Protocol            	*Current;

        GSM_AllProtocols		(DebugInfo **Deb);
        ~GSM_AllProtocols		();

        void                    	Add     	(GSM_Protocol *Protocol);
        GSM_Error               	Switch  	(char *Pro, GSM_AllPhones *Pho);
        int                     	GetNext 	(GSM_Protocol **Pro);
        GSM_Error               	Find		(char *Pro, GSM_Protocol **Prot, GSM_AllPhones *Pho);
private:
        GSM_Protocol            	*AllProtocols;
        DebugInfo               	**Debug;
};

#endif
