/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include "../../protocol/gsmprot.h"
#include "nauto.h"

GSM_Error GSM_Phone_NAUTO::Dispatch(GSM_Protocol_Message *msg, void *Struct, int RequestID)
{
	int		ID3 = DCT34->GetID();
	AnsStruct 	AS;

	AS.RequestID  = RequestID;
	AS.FrameFound = false;

if(Ans("\xD2",0x02,0x00,ID_GetID+ID3,&AS))return DCT34->ReplyGetID (msg,Debug,(unsigned char *)Struct);

if ((*Protocols)->Current->MsgReceived.Type==0xD0) {
	return GSM_Return_Error(GSM_ERR_TIMEOUT);
}

	if (AS.FrameFound) return GSM_Return_Error(GSM_ERR_FRAME_NOT_REQUESTED);
        return GSM_Return_Error(GSM_ERR_FRAME_TYPE_UNKNOWN);
}

//GSM_Error GSM_Phone_NAUTO::GetIMEI(unsigned char *IMEI)
//{
//	(*Debug)->Deb("Getting IMEI in NAUTO\n");
//        return GSM_ERR_NONE;
//}

GSM_Error GSM_Phone_NAUTO::Open(char *ID)
{
	bool				PhoneFound = false;
	unsigned char 			Model[50];
	GSM_Error 			error;
        GSM_Phone       		*pho;
 	list<GSM_Phone_Info>::iterator 	phoinfo;

	GSM_Phone::Open(ID);

	error = DCT34->GetCodeNameModel(Model);
	if (error.Code != GSM_ERR_NONE) return error;

        /* Do we have phone model in phone modules ? If yes, switch */
        pho=NULL;
        while(1) {
                if (!(*Phones)->GetNext(&pho)) break;

		for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
                        if (strcmp((*phoinfo).CodeNameModel,(char *)Model)) continue; else PhoneFound=true;
			
			if ((*phoinfo).CompareProtocol((*Protocols)->CurrentName)) {
				(*Phones)->Switch((*phoinfo).Model,(*Protocols)->CurrentName,(*Phones)->CFGCompatibility);

			        error=(*Phones)->Current->Open(DCT34->GetFrameID());
			        if (error.Code != GSM_ERR_NONE) return error;

				return GSM_Return_Error(GSM_ERR_NONE);
			}
	        }
        }

        /* We had phone, but with other protocol */
        if (PhoneFound) return GSM_Return_Error(GSM_ERR_OTHER_PROTOCOL);

        /* Unknown phone model */
        return GSM_Return_Error(GSM_ERR_PHONE_STRING_UNKNOWN);
}

