/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <stdio.h>
#include <wctype.h>

#include "../../../cfg/config.h" //msvc2005
#include "coding.h"

int UnicodeLength(const wchar_t *text)
{
	int l = 0;

	if (text == NULL) return 0;

	while (text[l]!=0) l++;

	return l;
}

void CopyUnicode(const wchar_t *src, wchar_t *dest)
{
	int pos = 0;

	while (src[pos] != 0x00) {
		dest[pos] = src[pos];
		pos++;
	}

	dest[pos] = 0;
}

unsigned int UnicodeCharToChar(wchar_t src, char *dest)
{
	int r = wctomb(dest, src);

	if (r == -1) {
		r = 1;
		*dest = '?';
	}
	return r;
}

int CharToUnicodeChar(const char *src, wchar_t *dest)
{
	int i = mbtowc(dest, src, MB_CUR_MAX);

	if (i<1) i=0;
	return i;
}

char *UnicodeToStringReturn(const wchar_t *src)
{
	int 		pos = 0, pos2 = 0;
	static char 	dst[1000];

	while (src[pos] != 0) {
		pos2+=UnicodeCharToChar(src[pos], dst+pos2);
		if (pos2 >= 990) break;
		pos++;
	}
	dst[pos2] = 0;
	return dst;
}

wchar_t *StringToUnicodeReturn(char *src)
{
	static wchar_t 	dst[500];
	int 		srcpos=0,dstpos=0;

	while (src[srcpos] != 0) {
		srcpos+=CharToUnicodeChar(src+srcpos, &dst[dstpos]);
		dstpos++;
		if (dstpos == 499) break;
	}
	dst[dstpos] = 0;
	return dst;
}

void StringToUnicode(char *src, wchar_t *dst)
{
	int srcpos=0,dstpos=0;

	while (src[srcpos] != 0) {
		srcpos+=CharToUnicodeChar(src+srcpos, &dst[dstpos]);
		dstpos++;
	}
	dst[dstpos] = 0;
}

unsigned char BCDCharToChar(unsigned char value)
{
        return 10*(value & 0x0f)+(value >> 4);
}

void BCDToUnicode(const unsigned char *src, wchar_t *dest, int len)
{
        int i,current=0,digit;
	
	for (i = 0; i < len; i++) {
		digit=src[i] & 0x0f;
		if (digit<10) dest[current++]=digit + '0';
		digit=src[i] >> 4;
		if (digit<10) dest[current++]=digit + '0';
	}
	dest[current++]=0;
}

unsigned char CharToBCD(unsigned char value)
{
	div_t division;

	division=div(value,10);
	return (((value-division.quot*10) & 0x0f) << 4) | (division.quot & 0xf);
}

int StringToBCD (const unsigned char *src, unsigned char *dest, int len)
{
	int i,current=0;

	for (i = 0; i < len; i++) {
        	if (i & 0x01) {
			dest[current]=dest[current] | ((src[i]-'0') << 4);
			current++;
		} else {
			dest[current]=src[i]-'0';
		}
	}
       	if (len & 0x01) {
		dest[current]=dest[current] | 0xf0;
	}
       	if (!(i & 0x01)) current--;
	return current+1;
}

int UTF8CharToUnicode(const unsigned char *src, wchar_t *dest, int len)
{
	if (len < 1) return 0;
	if (src[0] < 128) {
		(*dest) = src[0];
		return 1;
	}
	if (src[0] < 194) return 0;
	if (src[0] < 224) {
		if (len < 2) return 0;
		(*dest) = (src[0]-192)*64 + (src[1]-128);
		return 2;
	}
	if (src[0] < 240) {
		if (len < 3) return 0;
		(*dest) = (src[0]-224)*4096 + (src[1]-128)*64 + (src[2]-128);
		return 3;
	}
	return 0;
}

void UTF8ToUnicode(const unsigned char *src, wchart *dest, int len)
{
	int 		pos = 0,x;
	wchar_t		ret;
	
	dest->clear();
	while (pos<len) {
		x=UTF8CharToUnicode(src+pos, &ret, len-pos);
		if (pos == 0 && (ret == 0xff*256+0xfe || ret == 0xfe*256+0xff)) {
			pos+=x;
			continue;
		}
		pos+=x;
		dest->push_back(ret);
	}
}

int UnicodeCharToUTF8(wchar_t src, unsigned char *dest)
{
	//Unicode 0080-07FF -> UTF8 110xxxxx 10xxxxxx
	if (src >=128 && src <=2047) {
		dest[0] = 192 + (src / 64);
		dest[1] = 128 + (src % 64);
		return 2;
	}
	//Unicode 0800-FFFF -> UTF8 1110xxxx 10xxxxxx 10xxxxxx
	if (src >2047) {
		dest[0] = 224 + (src / 4096);
		dest[1] = 128 + ((src / 64) % 64);
		dest[2] = 128 + (src % 64);
		return 3;
	}
	//Unicode 0000-007F -> UTF8 0xxxxxxx
	dest[0] = src / 256;
	return 1;
}

bool UnicodeToUTF8QuotedPrintable(wchar_t *src, unsignedstring *dest)
{
	int		i,j,z,w;
	unsigned char	mychar[3];
	bool		retval = false;
	unsigned char	buff[10];

	for (i = 0; i < (int)(UnicodeLength(src)); i++) {
		z = UnicodeCharToUTF8(src[i],mychar);
		if (z>1) {
			for (w=0;w<z;w++) sprintf((char *)buff, "=%02X",mychar[w]);
			retval = true;
		} else {
			j = UnicodeCharToChar(src[i], (char *)buff);
			buff[j]=0;
	    	}
		dest->append((const unsigned char *)buff,strlen((const char *)buff));		
	}
	return retval;
}

void UTF8QuotedPrintableToUnicode(const unsigned char *src, wchar_t *dest, int len)
{
	int 		i=0,j=0,z;
	unsigned char	mychar[10];
	wchar_t		ret;

	while (i<len) {
		z=0;
		while (true) {
			if (src[z*3+i] != '=' || z*3+i+3>len ||
			    HexBinCharToNumber(src[z*3+i+1])==-1 ||
			    HexBinCharToNumber(src[z*3+i+2])==-1) {
				break;
			}
			mychar[z] = 16*HexBinCharToNumber(src[z*3+i+1])+HexBinCharToNumber(src[z*3+i+2]);
			if (z==0 && mychar[0]<194) break;
			z++;
		}
		if (z>0) {
			i+=z*3;
			// we ignore wrong sequence
			if (UTF8CharToUnicode(mychar,&ret,z)==0) continue;
		} else {
			i+=CharToUnicodeChar((const char *)src+i, &ret);
		}
		dest[j++] = ret;
	}
	dest[j] = 0;
}

int HexBinCharToNumber(unsigned char mychar)
{
	if (mychar>='A' && mychar<='F') return mychar-'A'+10;
	if (mychar>='a' && mychar<='f') return mychar-'a'+10;
	if (mychar>='0' && mychar<='9') return mychar-'0';
	return -1;
}

unsigned char NumberToHexBinChar(int digit)
{
	if (digit >= 0 && digit <= 9) return '0'+(digit);
	if (digit >=10 && digit <=15) return 'A'+(digit-10);
	return 0;
}

char *StringCaseStr(const char *a, const char *b)
{
	unsignedstring	A,B;
	int 		i;

	for (i=0;i<(int)strlen(a);i++) A.push_back(tolower(a[i]));
	for (i=0;i<(int)strlen(b);i++) B.push_back(tolower(b[i]));

	return strstr((char *)A.data(),(const char *)B.data());
}

BOOLEAN StringCaseCmp(const char *a, const char *b, int num)
{
	int i=0;

	while (1) {
		if (tolower(a[i]) != tolower(b[i])) return FALSE;
		if (a[i] == 0x00 && a[i] == 0x00) return TRUE;
		i++;
		if (num == i) return TRUE;
	}
}

BOOLEAN UnicodeCaseCmp(const wchar_t *a, const wchar_t *b, int num)
{
	int i=0;

	while (1) {
		if (towlower(a[i]) != towlower(b[i])) return FALSE;
		if (a[i] == 0x00 && a[i] == 0x00) return TRUE;
		i++;
		if (num == i) return TRUE;
	}
}

wchar_t *UnicodeCaseStr(const wchar_t *a, const wchar_t *b)
{
	wchart	A,B;
	int 	i;

	for (i=0;i<UnicodeLength(a);i++) A.push_back(towlower(a[i]));
	for (i=0;i<UnicodeLength(b);i++) B.push_back(towlower(b[i]));

	return wcsstr((wchar_t *)A.data(),(wchar_t *)B.data());
}
