/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#ifdef WIN32
#  include <windows.h>
#  include <io.h>
#else
#  include <sys/socket.h>
#endif
#include <string.h>
#include <stdio.h>
#include <memory.h>

#include "../../../cfg/config.h" //msvc2005
#include "irda.h"
#include "../../phone/gsmphone.h"

#ifdef WIN32
#  ifndef BORLANDC
#    pragma comment(lib, "wsock32")
#  endif
#endif

GSM_Error GSM_Device_Infrared::Open(char *Dev, char *Prot, char *Pho, char **DeviceModel, GSM_AllPhones *Phones)
{
	GSM_Error			error;
        GSM_Phone               	*pho;
	list<GSM_Phone_Info>::iterator 	phoinfo;
	Irda_Info_List   		List;
	Irda_Socket 			Dest;
        bool				found = false;
	int 				i,j,l = sizeof(List);

        (*Debug)->Deb("[STATE     : opening device irda]\n");

	error = Sock->Init(Debug);
	if (error.Code != GSM_ERR_NONE) return error;

	Device = socket(AF_IRDA, SOCK_STREAM, 0);
#ifdef WIN32
	if (Device == INVALID_SOCKET) {
		return GSM_Return_Error(GSM_ERR_DRIVER_NOT_AVAILABLE);
	}
#endif

	List.Number = 0;
	for (i=0;i<6;i++) {
#ifdef WIN32
		if (getsockopt(Device, SOL_IRLMP, IRLMP_ENUMDEVICES, (char *)&List, &l) == SOCKET_ERROR) {
		        Sock->Error("getsockopt");
			return GSM_Return_Error(GSM_ERR_DEVICE_OPEN);
		}
		if (List.Number == 0) continue;
#else
		if (getsockopt(Device, SOL_IRLMP, IRLMP_ENUMDEVICES, (char *)&List, (socklen_t *)&l) != 0) continue;
#endif

		for (j=0; j<(int)List.Number; j++) {
			(*Debug)->Deb("[DEVICE    : found \"%s\"]\n",List.Devices[j].Name);
		        pho = NULL;
		        while(1) {
		                if (!Phones->GetNext(&pho)) break;
				for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
					if ((*phoinfo).CompareProtocol(Prot) && !strcmp(List.Devices[j].Name,(*phoinfo).DeviceModel)) {
						if (Pho[0] == 0x00) found = true;
						if (Pho[0] != 0x00 && !strcmp((*phoinfo).Model,Pho)) found = true;
					}
					if (found) break;
				}
				if (found) break;
		        }
			if (found) break;
		}
		if (found) break;
#ifdef WIN32
	        Sleep(20);
#else
		for (int mw=0;mw<10000;mw++) {
			usleep(20000);
		}
#endif
	}
	if (!found) return GSM_Return_Error(GSM_ERR_TIMEOUT);

	Dest.AddressFamily = AF_IRDA;
#ifdef WIN32
	memcpy(Dest.Address,List.Devices[j].RemoteAddress,4);
#else
	Dest.Address = List.Devices[j].RemoteAddress;
	Dest.LSAP2   = LSAP;
#endif
	strcpy(Dest.ServiceName,"IrDA:IrCOMM");
	if (!strcmp(Prot,"irdaphonet")) strcpy(Dest.ServiceName, "Nokia:PhoNet");

#ifdef WIN32
	if (connect(Device, (struct sockaddr *) &Dest, sizeof(Dest)) == SOCKET_ERROR) {
#else
	if (connect(Device, (struct sockaddr *) &Dest, sizeof(Dest))) {
#endif
	        Sock->Error("connect");
		return GSM_Return_Error(GSM_ERR_DEVICE_OPEN);
	}

	*DeviceModel = (char *)malloc(strlen(List.Devices[j].Name)+1);
	strcpy(*DeviceModel,List.Devices[j].Name);

	Opened = true;

        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Device_Infrared::Close()
{
        (*Debug)->Deb("[STATE     : closing device]\n");

	if (!Opened) return GSM_Return_Error(GSM_ERR_NONE);
	return Sock->Close(Device);
}

GSM_Error GSM_Device_Infrared::Read(unsigned char *buf, int *len)
{
	return Sock->Read(Device,buf,len);
}

GSM_Error GSM_Device_Infrared::Write(const unsigned char *buf, int len)
{
	return Sock->Write(Device,buf,len);
}
