/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#ifndef gsm_dev_h
#define gsm_dev_h

#include <list>

#ifdef WIN32
#  include <windows.h>
#endif

#include "../service/gsmmisc.h"
#include "../misc/misc.h"

#ifndef SOCKET
#  define SOCKET int
#endif

using namespace std;

class GSM_Device_Info
{
public:
        char                    *Device;

        GSM_Device_Info		(DebugInfo **Deb, char *Dev);
        ~GSM_Device_Info	();
private:
        DebugInfo               **Debug;
};

typedef enum {
	FLOW_None,
	FLOW_XonXoff,
	FLOW_Hardware
} GSM_Flow_Control;

class GSM_AllDevices;
class GSM_AllProtocols;
class GSM_AllPhones;

class GSM_Device
{
        friend class GSM_AllDevices;
public:
        list <GSM_Device_Info>  Info;

        GSM_Device		(DebugInfo **Deb);
        virtual ~GSM_Device	();

        virtual GSM_Error       Open            (char *Dev, char *Prot, char *Pho, char **DeviceModel, GSM_AllPhones *Phones) = 0;
        virtual GSM_Error       Close           () = 0;
	virtual GSM_Error 	SetParameters	(int speed, int bits, bool parity, int stopbits);
	virtual GSM_Error 	SetLines	(bool dtr, bool rts);
        virtual GSM_Error 	Read            (unsigned char *buf, int *len) = 0;
        virtual GSM_Error 	Write           (const unsigned char *buf, int len) = 0;
private:
        GSM_Device              *Next;
protected:
	char			ProtocolName[50];
        DebugInfo               **Debug;
	bool			Opened;
};

class GSM_AllDevices
{
public:
        GSM_Device              *Current;
	char			CurrentName[50];

        GSM_AllDevices		(DebugInfo **Deb);
        ~GSM_AllDevices		();

        void                    Add             (GSM_Device *Device);
        GSM_Error               Switch          (char *Pro, GSM_AllProtocols *AllProt, GSM_AllPhones *AllPhon, char *Dev);
        int                     GetNext         (GSM_Device **Dev);
private:
        GSM_Device              *AllDevices;
        DebugInfo               **Debug;
};

class GSM_Socket
{
public:
	GSM_Error 		Init		(DebugInfo **Deb);
	GSM_Error		Write		(SOCKET Device, const unsigned char *buf, int len);
	GSM_Error		Read		(SOCKET Device, unsigned char *buf, int *len);
	GSM_Error 		Close		(SOCKET Device);
	void 			Error		(char *Description);
private:
	DebugInfo 		**Debug;
};

#endif
