//---------------------------------------------------------------------------
//
// Name:        CfgDlg.cpp
// Author:      Marcinello
// Created:     2007-01-25 22:01:44
// Description: CfgDlg class implementation
//
//---------------------------------------------------------------------------

#include "CfgDlg.h"

//Do not add custom headers
//wxDev-C++ designer will remove them
////Header Include Start
////Header Include End

//----------------------------------------------------------------------------
// CfgDlg
//----------------------------------------------------------------------------
//Add Custom Events only in the appropriate block.
//Code added in other places will be removed by wxDev-C++
////Event Table Start
BEGIN_EVENT_TABLE(CfgDlg,wxDialog)
	////Manual Code Start
	////Manual Code End
	
	EVT_CLOSE(CfgDlg::OnClose)
	EVT_BUTTON(ID_WXBUTTON1,CfgDlg::WxButton1Click)
	
	EVT_TEXT(ID_WXEDIT2,CfgDlg::WxEdit2Updated)
	EVT_COMBOBOX(ID_WXCOMBOBOX3,CfgDlg::WxComboBox3Selected)
	EVT_COMBOBOX(ID_WXCOMBOBOX1,CfgDlg::WxComboBox1Selected)
	EVT_COMBOBOX(ID_WXCOMBOBOX2,CfgDlg::WxComboBox2Selected)
	EVT_BUTTON(ID_WXBUTTON2,CfgDlg::WxButton2Click)
	EVT_BUTTON(ID_WXBUTTON3,CfgDlg::WxButton3Click)
END_EVENT_TABLE()
////Event Table End

CfgDlg::CfgDlg(GSM_GPlusConfig *CFG2, GSM_StateMachine *s2, wxWindow *parent, wxWindowID id, const wxString &title, const wxPoint &position, const wxSize& size, long style)
: wxDialog(parent, id, title, position, size, style)
{
    int i;

    EditMode = false;
    s        = s2;
    CFG      = CFG2;
    Number   = 0;
    
	CreateGUIControls();
	
    for (i=1;i<10;i++) {
        s->ReadCfg(i,CFG);
        WxComboBox3->Append(CFG->Name);
    }
    WxStaticText6->SetLabel(CFG->FileName);
    if (CFG->FileName[0] == 0) {
        WxButton1->SetLabel("View set");
    	EditMode = true;
    }
    WxComboBox3->SetSelection(0);
    SelectSet();
}

CfgDlg::~CfgDlg()
{
} 

void CfgDlg::CreateGUIControls()
{
	//Do not add custom code between
        //GUI Items Creation Start and GUI Items Creation End.
	//wxDev-C++ designer will remove them.
	//Add the custom code before or after the blocks
	////GUI Items Creation Start

	SetTitle(wxT("Configuration for phone connection"));
	SetIcon(wxNullIcon);
	SetSize(8,8,446,285);
	Center();
	

	WxStaticText7 = new wxStaticText(this, ID_WXSTATICTEXT7, wxT("Set name"), wxPoint(12,70), wxDefaultSize, 0, wxT("WxStaticText7"));

	WxStaticText6 = new wxStaticText(this, ID_WXSTATICTEXT6, wxT("WxStaticText6"), wxPoint(101,6), wxDefaultSize, 0, wxT("WxStaticText6"));

	WxStaticText5 = new wxStaticText(this, ID_WXSTATICTEXT5, wxT("Config file"), wxPoint(12,8), wxDefaultSize, 0, wxT("WxStaticText5"));

	WxEdit3 = new wxTextCtrl(this, ID_WXEDIT3, wxT("WxEdit3"), wxPoint(197,197), wxSize(229,20), 0, wxDefaultValidator, wxT("WxEdit3"));

	WxButton1 = new wxButton(this, ID_WXBUTTON1, wxT("Edit set"), wxPoint(368,26), wxSize(62,20), 0, wxDefaultValidator, wxT("WxButton1"));

	WxEdit2 = new wxTextCtrl(this, ID_WXEDIT2, wxT("WxEdit2"), wxPoint(99,65), wxSize(329,19), 0, wxDefaultValidator, wxT("WxEdit2"));

	wxArrayString arrayStringFor_WxComboBox3;
	WxComboBox3 = new wxComboBox(this, ID_WXCOMBOBOX3, wxT("WxComboBox3"), wxPoint(99,26), wxSize(263,21), arrayStringFor_WxComboBox3, wxCB_DROPDOWN | wxCB_READONLY, wxDefaultValidator, wxT("WxComboBox3"));

	WxStaticText4 = new wxStaticText(this, ID_WXSTATICTEXT4, wxT("Selected set"), wxPoint(12,31), wxDefaultSize, 0, wxT("WxStaticText4"));

	WxCheckBox3 = new wxCheckBox(this, ID_WXCHECKBOX3, wxT("check online info on startup (send codename and product code)"), wxPoint(12,173), wxSize(357,18), 0, wxDefaultValidator, wxT("WxCheckBox3"));

	WxCheckBox2 = new wxCheckBox(this, ID_WXCHECKBOX2, wxT("add log from communication to file"), wxPoint(12,199), wxSize(182,18), 0, wxDefaultValidator, wxT("WxCheckBox2"));

	wxArrayString arrayStringFor_WxComboBox1;
	WxComboBox1 = new wxComboBox(this, ID_WXCOMBOBOX1, wxT("WxComboBox1"), wxPoint(99,87), wxSize(330,21), arrayStringFor_WxComboBox1, wxCB_DROPDOWN | wxCB_READONLY | wxCB_SORT, wxDefaultValidator, wxT("WxComboBox1"));

	WxEdit1 = new wxTextCtrl(this, ID_WXEDIT1, wxT("WxEdit1"), wxPoint(99,111), wxSize(329,21), 0, wxDefaultValidator, wxT("WxEdit1"));

	wxArrayString arrayStringFor_WxComboBox2;
	WxComboBox2 = new wxComboBox(this, ID_WXCOMBOBOX2, wxT("WxComboBox2"), wxPoint(99,135), wxSize(329,21), arrayStringFor_WxComboBox2, wxCB_DROPDOWN | wxCB_READONLY | wxCB_SORT, wxDefaultValidator, wxT("WxComboBox2"));

	WxCheckBox1 = new wxCheckBox(this, ID_WXCHECKBOX1, wxT("set phone clock from your computer"), wxPoint(12,156), wxSize(296,18), 0, wxDefaultValidator, wxT("WxCheckBox1"));

	WxButton2 = new wxButton(this, ID_WXBUTTON2, wxT("&OK"), wxPoint(40,230), wxSize(82,23), 0, wxDefaultValidator, wxT("WxButton2"));

	WxButton3 = new wxButton(this, ID_WXBUTTON3, wxT("&Cancel"), wxPoint(312,232), wxSize(81,23), 0, wxDefaultValidator, wxT("WxButton3"));

	WxStaticText3 = new wxStaticText(this, ID_WXSTATICTEXT3, wxT("Phone model"), wxPoint(13,134), wxDefaultSize, 0, wxT("WxStaticText3"));

	WxStaticText2 = new wxStaticText(this, ID_WXSTATICTEXT2, wxT("Device"), wxPoint(13,112), wxDefaultSize, 0, wxT("WxStaticText2"));

	WxStaticText1 = new wxStaticText(this, ID_WXSTATICTEXT1, wxT("Connection type"), wxPoint(12,90), wxDefaultSize, 0, wxT("WxStaticText1"));

	WxStaticBox1 = new wxStaticBox(this, ID_WXSTATICBOX1, wxT("Set parameters"), wxPoint(2,48), wxSize(432,179));
	////GUI Items Creation End
}

void CfgDlg::OnClose(wxCloseEvent& /*event*/)
{
	Destroy();
}

void CfgDlg::SelectSet()
{
	list<GSM_Protocol_Info>::iterator 	proinfo;
	list<GSM_Phone_Info>::iterator 		phoinfo;
    GSM_Protocol            		    *pro;
    GSM_Phone               		    *pho;
    int                                 Num=0;
    char                                buff[200];
    bool                                EditMode2;

    s->ReadCfg(WxComboBox3->GetCurrentSelection()+1,CFG);
    
    EditMode2 = EditMode;
    EditMode = false;
    WxEdit2->SetValue(CFG->Name);
    EditMode = EditMode2;
    WxEdit3->SetValue(CFG->LogFile);
    
    WxCheckBox1->SetValue(false);
    WxCheckBox2->SetValue(false);
    WxCheckBox3->SetValue(false);
    if (!strcmp(CFG->SyncTime,"yes")) WxCheckBox1->SetValue(true);
    if (strcmp(CFG->LogLevel,"nothing")) WxCheckBox2->SetValue(true);
    if (!strcmp(CFG->GetOnlineInfo,"yes")) WxCheckBox3->SetValue(true);

    //device
    WxEdit1->SetValue(StringToUnicodeReturn(CFG->Device));

    //phone model
    WxComboBox2->Clear();
    WxComboBox2->Append("(selected automatic)");
    WxComboBox2->SetSelection(0);
    Num=0;
    pho = NULL;
    while(1) {
        if (!s->Phones->GetNext(&pho)) break;
    	for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
            if ((*phoinfo).Model[0]==0) continue;
            sprintf(buff,"%s (%s)",(*phoinfo).Model,(*phoinfo).CodeNameModel);
            WxComboBox2->Append(buff);
            Num++;
            if (!strcmp(CFG->Phone,(*phoinfo).Model)) WxComboBox2->SetSelection(Num);
        }
    }

    //connection
    SelectChoice2();
    
    WxStaticText1->Enable(EditMode);
    WxStaticText2->Enable(EditMode);
    WxStaticText3->Enable(EditMode);
    WxStaticText7->Enable(EditMode);
    WxStaticBox1->Enable(EditMode);    
    WxEdit1->Enable(EditMode);
    WxEdit2->Enable(EditMode);
    WxEdit3->Enable(EditMode);
    WxComboBox1->Enable(EditMode);
    WxComboBox2->Enable(EditMode);
    WxCheckBox1->Enable(EditMode);
    WxCheckBox2->Enable(EditMode);
    WxCheckBox3->Enable(EditMode);
}

typedef struct {
 	char		*Connection;
	char		*Description;
	char        *Device;
} X;

X   X2[] = {
    "bluerfphonet", "Nokia - bluetooth for old models (with Microsoft stack)", "Phone address",
    "bluephonet", "Nokia - bluetooth for new models (with Microsoft stack)", "Phone address",
    "phonetblue", "Nokia - bluetooth over 'Nokia PC Suite' service (with any stack)", "Serial port",
    "irdaphonet", "Nokia - infrared", "Device",
    "dku2", "Nokia - DKU2 USB cable for PopPort (with Nokia driver)", "Device",
    "fbus", "Nokia - FBUS cable","Serial port",
    "","",""};

//connection
void CfgDlg::SelectChoice1()
{
    char                                buff[200];
	list<GSM_Protocol_Info>::iterator 	proinfo;
	list<GSM_Phone_Info>::iterator 		phoinfo;
    GSM_Protocol            		    *pro;
    GSM_Phone               		    *pho;
	int                                 Num,i;

    i = 0;
    while (X2[i].Connection[0] != 0) {
        if (strcmp(WxComboBox1->GetStringSelection(),X2[i].Description)) {
            i++;
            continue;
        }
        pro = NULL;
        while(1) {
            if (!s->Protocols->GetNext(&pro)) break;
            for (proinfo=pro->Info.begin(); proinfo!=pro->Info.end(); ++proinfo) {
                if (!strcmp((*proinfo).Protocol,X2[i].Connection)) {
                    sprintf(CFG->Protocol,"%s",X2[i].Connection);
                    WxEdit1->Show((*proinfo).NeedPort);
                    WxStaticText2->Show((*proinfo).NeedPort);
                    WxStaticText2->SetLabel(X2[i].Device);
                }
            }
        }
        break;
    }
}

//phone model
void CfgDlg::SelectChoice2()
{
    char                                buff[200];
	list<GSM_Protocol_Info>::iterator 	proinfo;
	list<GSM_Phone_Info>::iterator 		phoinfo;
    GSM_Protocol            		    *pro;
    GSM_Phone               		    *pho;
	int                                 i,j;

    WxComboBox1->Clear();
    if (WxComboBox2->GetValue()=="(selected automatic)") {
        sprintf(CFG->Phone,"");
        pro = NULL;
        while(1) {
            if (!s->Protocols->GetNext(&pro)) break;
            for (proinfo=pro->Info.begin(); proinfo!=pro->Info.end(); ++proinfo) {
                i = 0;
                while (X2[i].Connection[0] != 0) {
                    if (!strcmp((*proinfo).Protocol,X2[i].Connection)) {
                        WxComboBox1->Append(X2[i].Description);
                    }
                    i++;
                }
            }
        }
    } else {
        pho = NULL;
        while(1) {
            if (!s->Phones->GetNext(&pho)) break;
        	for (phoinfo=pho->Info.begin(); phoinfo!=pho->Info.end(); ++phoinfo) {
                if ((*phoinfo).Model[0]==0) continue;
                sprintf(buff,"%s (%s)",(*phoinfo).Model,(*phoinfo).CodeNameModel);
                if (strcmp(buff,WxComboBox2->GetStringSelection())) continue;
                sprintf(CFG->Phone,"%s",(*phoinfo).Model);

                pro = NULL;
                while(1) {
                    if (!s->Protocols->GetNext(&pro)) break;
                    for (proinfo=pro->Info.begin(); proinfo!=pro->Info.end(); ++proinfo) {
                        i = 0;
                        while (X2[i].Connection[0] != 0) {
                            if (!strcmp((*proinfo).Protocol,X2[i].Connection) &&
                                strstr((*phoinfo).Protocol,X2[i].Connection)!=NULL) {
                                WxComboBox1->Append(X2[i].Description);
                            }
                            i++;
                        }
                    }
                }
            }
        }
    }
    
    for (i=0;i<WxComboBox1->GetCount();i++) {
        if (i==0) WxComboBox1->SetSelection(0);
        j = 0;
        while (X2[j].Connection[0] != 0) {
            if (!strcmp(WxComboBox1->GetString(i),X2[j].Description)) {
                if (!strcmp(CFG->Protocol,X2[j].Connection)) {
                    WxComboBox1->SetSelection(i);
                }                
            }
            j++;
        }
    }
    SelectChoice1();
}


/*
 * WxButton2Click
 */
void CfgDlg::WxButton2Click(wxCommandEvent& event)
{
    SaveSet();
    EndModal(wxID_OK);
}

void CfgDlg::SaveSet()
{
    if (!EditMode) return;
    
    sprintf(CFG->Device,"%s",UnicodeToStringReturn((wchar_t *)((const wchar_t *)WxEdit1->GetValue().wc_str(wxConvLibc))));
    sprintf(CFG->Name,"%s",UnicodeToStringReturn((wchar_t *)((const wchar_t *)WxEdit2->GetValue().wc_str(wxConvLibc))));
    sprintf(CFG->LogFile,"%s",UnicodeToStringReturn((wchar_t *)((const wchar_t *)WxEdit3->GetValue().wc_str(wxConvLibc))));

    if (WxCheckBox1->GetValue()) {
        sprintf(CFG->SyncTime,"yes");
    } else {
        sprintf(CFG->SyncTime,"no");
    }

    if (WxCheckBox2->GetValue()) {
        sprintf(CFG->LogLevel,"textall");
    } else {
        sprintf(CFG->LogLevel,"nothing");
    }
    if (WxCheckBox3->GetValue()) {
        sprintf(CFG->GetOnlineInfo,"yes");
    } else {
        sprintf(CFG->GetOnlineInfo,"no");
    }
    s->SaveCfg(Number+1,CFG);
    Number = WxComboBox3->GetCurrentSelection();
    WxStaticText6->SetLabel(CFG->FileName);
}

/*
 * WxButton3Click
 */
void CfgDlg::WxButton3Click(wxCommandEvent& event)
{
    EndModal(wxID_CANCEL);
}

/*
 * WxComboBox1Selected
 */
void CfgDlg::WxComboBox1Selected(wxCommandEvent& event )
{
	SelectChoice1();
}

/*
 * WxComboBox2Selected
 */
void CfgDlg::WxComboBox2Selected(wxCommandEvent& event )
{
	SelectChoice2();
}

/*
 * WxButton1Click
 */
void CfgDlg::WxButton1Click(wxCommandEvent& event)
{
	if (!EditMode) {
        WxButton1->SetLabel("View set");
    } else {
        SaveSet();
        WxButton1->SetLabel("Edit set");
    }
	EditMode = !EditMode;
    SelectSet();
}

/*
 * WxComboBox3Selected
 */
void CfgDlg::WxComboBox3Selected(wxCommandEvent& event )
{
    SaveSet();
    SelectSet();
    Number = WxComboBox3->GetCurrentSelection();
}

/*
 * WxEdit2Updated
 */
void CfgDlg::WxEdit2Updated(wxCommandEvent& event)
{
    int                 i,num2;
    GSM_GPlusConfig     CFG2;

    if (!EditMode) return;
    
    num2=WxComboBox3->GetCurrentSelection();

    WxComboBox3->Clear();
    for (i=1;i<10;i++) {
        if (i-1==num2) {
            WxComboBox3->Append(WxEdit2->GetValue());
        } else {
            s->ReadCfg(i,&CFG2);
            WxComboBox3->Append(CFG2.Name);
        }
    }
    WxComboBox3->SetSelection(num2);
}
