/* (C) 2005 by Marcin Wiacek www.mwiacek.com */

#ifndef gsm_sms_multi_h
#define gsm_sms_multi_h

#ifdef WIN32
#  include <windows.h>
#endif

#include "gsmsms.h"
#include "../gsmmisc.h"
#include "../../misc/misc.h"

class GSM_SMSListSubEntry
{
public:
	GSM_SMSListSubEntry();
	~GSM_SMSListSubEntry();

	void			SetSMS(GSM_SMSEntry *SMS2);
	GSM_SMSEntry 		*GetSMS();
	void			SetNext(GSM_SMSListSubEntry *Nxt);
	GSM_SMSListSubEntry	*GetNext();
private:
	GSM_SMSListSubEntry	*Next;
	GSM_SMSEntry		SMS;
};

class GSM_SMSList
{
public:
	GSM_SMSList();
	~GSM_SMSList();

	//---------------------------------------------------------------------
	//part of parameters connected with SMS in phone
	//---------------------------------------------------------------------
	int 			Folder;

	BOOLEAN 		GetNext(GSM_SMSListSubEntry **En);
	GSM_Error	 	Add(GSM_SMSEntry *SMS);
	void 			ClearAll();
private:
	GSM_SMSListSubEntry	*Entries;
};

typedef enum {
	SMSDecoded_Not_Assigned = 1,

	SMSDecoded_Text
} GSM_SMSDecoded_SubEntryType;

class GSM_SMSDecodedSubEntry
{
	friend class GSM_SMSDecodedEntry;
public:
	GSM_SMSDecodedSubEntry();
	~GSM_SMSDecodedSubEntry();

	GSM_SMSDecoded_SubEntryType	Type;
	wchart				Text;
	SMS_Coding_Type			TextCoding;

	GSM_SMSDecodedSubEntry		*GetNext();
private:
	void 				SetNext(GSM_SMSDecodedSubEntry *Nxt);

	GSM_SMSDecodedSubEntry		*Next;
};

class GSM_SMSDecodedEntry
{
public:
	GSM_SMSDecodedEntry();
	~GSM_SMSDecodedEntry();

	void 				ClearAll();
	BOOLEAN 			GetNext(GSM_SMSDecodedSubEntry **En);
	GSM_Error	 		AddSubEntry(GSM_SMSDecodedSubEntry *En);
private:
	GSM_SMSDecodedSubEntry		*Entries;
};

typedef enum {
	SMSEncoded_Linked_Short = 1,
	SMSEncoded_Linked_Long
} GSM_SMSEncoded_Type;

GSM_Error EncodeSMSToSMSList(GSM_SMSDecodedEntry *Source, GSM_SMSEncoded_Type Type, GSM_SMSList *Destination);

#endif
