/* (C) 2003 - 2007 by Marcin Wiacek www.mwiacek.com */

#include "backtext.cpp"
#include "gsmback.h"

void GSM_Backup::GetFileFunctions(GSM_Backup_FileFormatNum Num, GSM_Backup_FileFormatFunctions *Func)
{
	if (Num == Backup_Gammu) {
		Func->PhonePBKCallers = TRUE;
		Func->PhonePBKPointers = TRUE;
		Func->PhonePBK 	= TRUE;
		Func->SIMPBK 	= TRUE;
		Func->Calendar 	= TRUE;
		Func->ToDo 	= TRUE;
		Func->Notes 	= TRUE;
	}
}

typedef basic_string<BOOLEAN> boollist;
typedef basic_string<GSM_DateTime> DTlist;

//sort SMS by folders and (inside folders) DateTime
void GSM_Backup::SortSMSByFolderDT()
{
	boollist		List;
	GSM_Backup_SMSEntry     *SMS2 = NULL;
	UDHList		 	UDH,FirstSMSUDH;
	GSM_Backup_SMSEntry     *Entry;
	GSM_SMSEntry	    	*EntrySMS;
	GSM_Error	       	error;
	GSM_SMSList	     	*SMSList;
	unsigned int	    	j;
	int		     	i,maxfolder=0,z;
	GSM_SMSListSubEntry     *En;
	boollist		X;
	GSM_DateTime	    	DT,DT2;
	DTlist		  	DTList,DTList2,DTList3;
	BOOLEAN		 	First;
	
	X.push_back(TRUE);

	//find folder num
	Entry = NULL;
	while (GetNext_SMS(&Entry)) {
		En = NULL;
		while (Entry->GetEntry()->GetNext(&En)) {
			EntrySMS = En->GetSMS();
			if (Entry->GetEntry()->Folder>maxfolder) maxfolder = Entry->GetEntry()->Folder;
		}
	}
	for (i=1;i<=maxfolder;i++) {
		DTList.clear();
		//find DT for all SMS inside folder
		Entry = NULL;
		while (GetNext_SMS(&Entry)) {
			First = TRUE;
			En = NULL;
			while (Entry->GetEntry()->GetNext(&En)) {
				EntrySMS = En->GetSMS();
				if (Entry->GetEntry()->Folder!=i) continue;
				if (EntrySMS->GetType()==SMS_Submit) continue;
				error = EntrySMS->GetDateTime(&DT);
				if (First || GSMDateTime2TimeT(&DT)<GSMDateTime2TimeT(&DT2)) {
					memcpy(&DT2,&DT,sizeof(GSM_DateTime));
					First = FALSE;
				}
			}
			if (!First) {
				if (DTList.length()!=0) {
					First = FALSE;
					for (j=0;j<DTList.length();j++) {
						if (GSMDateTime2TimeT(&DTList.data()[j])==GSMDateTime2TimeT(&DT2)) {
							First = TRUE;
							break;
						}
					}
				}
			}
			if (!First) {
				DTList.push_back(DT2);
			}
		}
		//bubble sort DTList
		if (DTList.length() != 0) {
			z = 0;
			while (z < (int)DTList.length()-1) {
				if (GSMDateTime2TimeT(&DTList.data()[z])>GSMDateTime2TimeT(&DTList.data()[z+1])) {
					DTList2.clear();
					DTList2.push_back(DTList.data()[z]);
					DTList3.clear();
					DTList3.push_back(DTList.data()[z+1]);
					DTList.replace(z,1,DTList3);
					DTList.replace(z+1,1,DTList2);
					z = 0;
					continue;
				}
				z++;
			}
		}
		//add Submit
		//we assume, that all SMS in sequence are Submit
		Entry = NULL;
		while (GetNext_SMS(&Entry)) {
			First = TRUE;
			En = NULL;
			while (Entry->GetEntry()->GetNext(&En)) {
				EntrySMS = En->GetSMS();
				if (Entry->GetEntry()->Folder!=i) continue;
				if (EntrySMS->GetType()!=SMS_Submit) continue;
				if (First) {
					SMSList = new GSM_SMSList;
					SMSList->Folder = Entry->GetEntry()->Folder;
					First = FALSE;
				}
				SMSList->Add(EntrySMS);
			}
			if (!First) Add_SMS0(&SMS2, SMSList);
		}
		//add Deliver & Report
		for(j=0;j<DTList.length();j++) {
			Entry = NULL;
			while (GetNext_SMS(&Entry)) {
				First = TRUE;
				En = NULL;
				while (Entry->GetEntry()->GetNext(&En)) {
					EntrySMS = En->GetSMS();
					if (Entry->GetEntry()->Folder!=i) continue;
					if (EntrySMS->GetType()==SMS_Submit) continue;
					error = EntrySMS->GetDateTime(&DT);
					memcpy(&DT2,&DTList.data()[j],sizeof(GSM_DateTime));
					if (GSMDateTime2TimeT(&DT)==GSMDateTime2TimeT(&DT2)) {
						First = FALSE;
						break;
					}
				}
				if (First) continue;
				//add add SMS from sequence
				//we should add sorting here
				First = TRUE;
				En = NULL;
				while (Entry->GetEntry()->GetNext(&En)) {
					EntrySMS = En->GetSMS();
					if (First) {
						SMSList = new GSM_SMSList;
						SMSList->Folder = Entry->GetEntry()->Folder;
						First = FALSE;
					}
					SMSList->Add(EntrySMS);
				}
				Add_SMS0(&SMS2, SMSList);
			}
		}
	}

	delete(SMS);
	SMS = SMS2;
}

void GSM_Backup::LinkSMS()
{
	boollist		List;
	GSM_Backup_SMSEntry     *SMS2 = NULL;
	UDHList		 	UDH,FirstSMSUDH;
	GSM_Backup_SMSEntry     *Entry;
	GSM_SMSEntry	    	*EntrySMS,*FirstSMS;
	GSM_Error	       	error;
	GSM_SMSList	     	*SMSList;
	int		     	i,num,j,z;
	GSM_SMSListSubEntry     *En;
	boollist		X;
	GSM_SMSNumbersSubEntry 	*Number,*Number2;
	unsignedint 		NumberNum;
	int			NumberNum1,NumberNum2;
	BOOLEAN			Found;

	X.push_back(TRUE);

	//add SMS without UDH or with unknown UDH or with multiple UDH
	Entry = NULL;
	while (GetNext_SMS(&Entry)) {
		En = NULL;
		while (Entry->GetEntry()->GetNext(&En)) {
			EntrySMS = En->GetSMS();
			error = EntrySMS->DecodeUDH(&UDH);
			//add SMS without UDH or with unknown UDH or with multiple UDH
			if (error.Code != GSM_ERR_NONE || 
			    UDH.length()==0 || 
			    UDH.length()>1) {
				List.push_back(TRUE);
				SMSList = new GSM_SMSList;
				SMSList->Folder = Entry->GetEntry()->Folder;
				SMSList->Add(EntrySMS);
				Add_SMS0(&SMS2, SMSList);
			} else {
				List.push_back(FALSE);
			}
		}
	}
	//add sms from sequence
	while (true) {
		i = 0;
		num = -1;
		Entry = NULL;
		while (GetNext_SMS(&Entry)) {
			En = NULL;
			while (Entry->GetEntry()->GetNext(&En)) {
				EntrySMS = En->GetSMS();
				if (List.data()[i]==TRUE) {
					i++;
					continue;
				}
				error = EntrySMS->DecodeUDH(&UDH);
				if (error.Code != GSM_ERR_NONE || 
				    UDH.length()!=1 ||
				    UDH.data()[0].PartNumber8bit!=1) {
					i++;
					continue;
				}
				//if first SMS from sequence
				List.replace(i,1,X);
				num	     = i;
				FirstSMS	= EntrySMS;
				error = EntrySMS->DecodeUDH(&FirstSMSUDH);

				SMSList = new GSM_SMSList;
				SMSList->Folder = Entry->GetEntry()->Folder;
				SMSList->Add(EntrySMS);
				break;
			}
			if (num!=-1) break;
		}
		if (num==-1) break;
		for (j=2;j<=FirstSMSUDH.data()[0].AllParts8bit;j++) {
			num = -1;
			i = 0;
			Entry = NULL;
			while (GetNext_SMS(&Entry)) {
				En = NULL;
				while (Entry->GetEntry()->GetNext(&En)) {
					EntrySMS = En->GetSMS();
					if (List.data()[i]==TRUE) {
						i++;
						continue;
					}
					error = EntrySMS->DecodeUDH(&UDH);
					if (error.Code != GSM_ERR_NONE ||
					    UDH.length()!=1 ||
					    UDH.data()[0].PartNumber8bit!=j ||
					    UDH.data()[0].ID8bit!=FirstSMSUDH.data()[0].ID8bit ||
					    UDH.data()[0].ID16bit!=FirstSMSUDH.data()[0].ID16bit ||
					    FirstSMS->SMSCNumber!=EntrySMS->SMSCNumber ||
					    SMSList->Folder != Entry->GetEntry()->Folder) {
						//sms type
						i++;
						continue;
					}
					NumberNum1 = 0;
					Number = NULL;
					while (FirstSMS->PhoneNumbers.GetNext(&Number)) NumberNum1++;
					NumberNum2 = 0;
					Number = NULL;
					while (EntrySMS->PhoneNumbers.GetNext(&Number)) NumberNum2++;
					if (NumberNum1!=NumberNum2) {
						i++;
						continue;
					}
					Number = NULL;
					NumberNum2 = 0;
					NumberNum.clear();
					Found = TRUE;
					while (FirstSMS->PhoneNumbers.GetNext(&Number)) {
						Found = FALSE;
						Number2 = NULL;
						while (EntrySMS->PhoneNumbers.GetNext(&Number2)) {
							NumberNum2++;
							if (Number->PhoneNumber!=Number2->PhoneNumber) continue;
							Found = TRUE;
							for (z=0;z<(int)NumberNum.length();z++) {
								if (NumberNum.data()[z] == NumberNum2++) {
									Found = FALSE;
									break;
								}
							}
							if (Found) {
								NumberNum.push_back(NumberNum2);
								break;
							}
						}
						if (!Found) break;
					}
					if (!Found) {
						i++;
						continue;
					}

					//if next SMS from sequence
					num = i;
					List.replace(i,1,X);
					SMSList->Add(EntrySMS);
					break;
				}
				if (num!=-1) break;
			}
			if (num==-1) break;
		}
		Add_SMS0(&SMS2, SMSList);
	}
	//add all other SMS
	i = 0;
	Entry = NULL;
	while (GetNext_SMS(&Entry)) {
		En = NULL;
		while (Entry->GetEntry()->GetNext(&En)) {
			EntrySMS = En->GetSMS();
			if (List.data()[i]==TRUE) {
				i++;
				continue;
			}
			SMSList = new GSM_SMSList;
			SMSList->Folder = Entry->GetEntry()->Folder;
			SMSList->Add(EntrySMS);
			Add_SMS0(&SMS2, SMSList);
			i++;
		}
	}
	delete(SMS);
	SMS = SMS2;
}

GSM_Backup::GSM_Backup()
{
	PBK = NULL;
	Cal = NULL;
	SMS = NULL;
	MMS = NULL;
	JAD = NULL;
	ToDo = NULL;
	Notes = NULL;

	DeviceIMEI[0]=0;
	DeviceModel[0]=0;
	FileCreator[0]=0;
    	FileDateTimeAvailable=FALSE;
}

void GSM_Backup::Delete_PBK()
{
	delete(PBK);
	PBK = NULL;
}

void GSM_Backup::Delete_SMS()
{
	delete(SMS);
	SMS = NULL;
}

void GSM_Backup::Delete_MMS()
{
	delete(MMS);
	MMS = NULL;
}

void GSM_Backup::Delete_JAD()
{
	delete(JAD);
	JAD = NULL;
}

void GSM_Backup::Delete_Calendar()
{
	delete(Cal);
	Cal = NULL;
}

void GSM_Backup::Delete_ToDo()
{
	delete(ToDo);
	ToDo = NULL;
}

void GSM_Backup::Delete_Notes()
{
	delete(Notes);
	Notes = NULL;
}

GSM_Backup::~GSM_Backup()
{
	Delete_PBK();
	Delete_Calendar();
	Delete_SMS();
	Delete_MMS();
	Delete_JAD();
	Delete_Notes();
	Delete_ToDo();
}

GSM_Error GSM_Backup::ReadFromFile(char *FileName)
{
	return ReadFromTextFile(FileName);
}

GSM_Error GSM_Backup::SaveToFile(char *FileName)
{
	return SaveToTextFile(FileName);
}

BOOLEAN GSM_Backup::GetNext_SMS(GSM_Backup_SMSEntry **En)
{
	if ((*En) == NULL) {
		(*En) = SMS;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

BOOLEAN GSM_Backup::GetNext_MMS(GSM_Backup_MMSEntry **En)
{
	if ((*En) == NULL) {
		(*En) = MMS;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

BOOLEAN GSM_Backup::GetNext_JAD(GSM_Backup_JADEntry **En)
{
	if ((*En) == NULL) {
		(*En) = JAD;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

BOOLEAN GSM_Backup::GetNext_Cal(GSM_Backup_CalEntry **En)
{
	if ((*En) == NULL) {
		(*En) = Cal;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

BOOLEAN GSM_Backup::GetNext_PBK(GSM_Backup_PBKEntry **En)
{
	if ((*En) == NULL) {
		(*En) = PBK;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

BOOLEAN GSM_Backup::GetNext_Note(GSM_Backup_NoteEntry **En)
{
	if ((*En) == NULL) {
		(*En) = Notes;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

BOOLEAN GSM_Backup::GetNext_ToDo(GSM_Backup_ToDoEntry **En)
{
	if ((*En) == NULL) {
		(*En) = ToDo;
	} else {
		(*En) = (*En)->GetNext();
	}
	if ((*En) == NULL) return FALSE;
	return TRUE;
}

void GSM_Backup::Add_PBK(GSM_PBKEntry *En)
{
	GSM_Backup_PBKEntry *Entry,*Entry2;

	Entry = new GSM_Backup_PBKEntry;
	Entry->SetEntry(En);

	if (PBK == NULL) {
		PBK = Entry;
	} else {
		Entry2 = PBK;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
}

void GSM_Backup::Add_Cal(GSM_CalendarEntry *En)
{
	GSM_Backup_CalEntry *Entry,*Entry2;

	Entry = new GSM_Backup_CalEntry;
	Entry->SetEntry(En);

	if (Cal == NULL) {
		Cal = Entry;
	} else {
		Entry2 = Cal;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
}

void GSM_Backup::Add_Note(GSM_NoteEntry *En)
{
	GSM_Backup_NoteEntry *Entry,*Entry2;

	Entry = new GSM_Backup_NoteEntry;
	Entry->SetEntry(En);

	if (Notes == NULL) {
		Notes = Entry;
	} else {
		Entry2 = Notes;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
}

void GSM_Backup::Add_ToDo(GSM_ToDoEntry *En)
{
	GSM_Backup_ToDoEntry *Entry,*Entry2;

	Entry = new GSM_Backup_ToDoEntry;
	Entry->SetEntry(En);

	if (ToDo == NULL) {
		ToDo = Entry;
	} else {
		Entry2 = ToDo;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
}

void GSM_Backup::Add_MMS(GSM_MMSFile *En)
{
	GSM_Backup_MMSEntry *Entry,*Entry2;

	Entry = new GSM_Backup_MMSEntry;
	Entry->SetEntry(En);

	if (MMS == NULL) {
		MMS = Entry;
	} else {
		Entry2 = MMS;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
}

void GSM_Backup::Add_JAD(GSM_File *En)
{
	GSM_Backup_JADEntry *Entry,*Entry2;

	Entry = new GSM_Backup_JADEntry;
	Entry->SetEntry(En);

	if (JAD == NULL) {
		JAD = Entry;
	} else {
		Entry2 = JAD;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
}

void GSM_Backup::Add_SMS(GSM_SMSList *En)
{
	Add_SMS0(&SMS,En);
}

void GSM_Backup::Add_SMS0(GSM_Backup_SMSEntry **Start, GSM_SMSList *En)
{
	GSM_Backup_SMSEntry *Entry,*Entry2;

	Entry = new GSM_Backup_SMSEntry;
	Entry->SetEntry(En);

	if (*Start == NULL) {
		*Start = Entry;
	} else {
		Entry2 = *Start;
		while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
		Entry2->SetNext(Entry);
	}
}

void GSM_Backup::DeletePointersFromPBK()
{
	GSM_Backup_PBKEntry	*PBKEntry=NULL,*PBK2=NULL,*PBKEntry2,*Entry2;
	GSM_PBKSubEntry 	*SubEntry;
	GSM_PBKEntry 		*En;

	while (GetNext_PBK(&PBKEntry)) {
		SubEntry = NULL;
		En = new GSM_PBKEntry;
		while (PBKEntry->GetEntry()->GetNext(&SubEntry)) {
			switch (SubEntry->GetType()) {
			case PBK_DateTime_Call_Length:
				break; //not required for this memory
			case PBK_ID_Caller_Group:
				En->AddLong(SubEntry->GetType(),SubEntry->LongValue);
				break;
			case PBK_ID_Picture:
			case PBK_ID_Ringtone:
				break; //we delete them
			case PBK_Bool_PTT_Subscribed:
				En->AddBool(SubEntry->GetType(),SubEntry->BoolValue);
				break;
			default:
				//we delete voicetag from number too
				En->AddText(SubEntry->GetType(), SubEntry->GetText());
				break;
			}
		}

		En->Location = PBKEntry->GetEntry()->Location;
		En->Memory = PBKEntry->GetEntry()->Memory;

		PBKEntry2 = new GSM_Backup_PBKEntry;
		PBKEntry2->SetEntry(En);

		if (PBK2 == NULL) {
			PBK2 = PBKEntry2;
		} else {
			Entry2 = PBK2;
			while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
			Entry2->SetNext(PBKEntry2);
		}
	}

	delete PBK;

	PBK = PBK2;
}

void GSM_Backup::DeleteCallerFromPBK()
{
	GSM_Backup_PBKEntry	*PBKEntry=NULL,*PBK2=NULL,*PBKEntry2,*Entry2;
	GSM_PBKSubEntry 	*SubEntry,*SubEntry2;
	GSM_PBKEntry 		*En;

	while (GetNext_PBK(&PBKEntry)) {
		SubEntry = NULL;
		En = new GSM_PBKEntry;
		while (PBKEntry->GetEntry()->GetNext(&SubEntry)) {
			switch (SubEntry->GetType()) {
			case PBK_DateTime_Call_Length:
				break; //not required for this memory
			case PBK_ID_Caller_Group:
				//we delete it
				break;
			case PBK_ID_Picture:
			case PBK_ID_Ringtone:
				En->AddLong(SubEntry->GetType(),SubEntry->LongValue);
				break;
			case PBK_Bool_PTT_Subscribed:
				En->AddBool(SubEntry->GetType(),SubEntry->BoolValue);
				break;
			default:
				En->AddText(SubEntry->GetType(), SubEntry->GetText());
				if (SubEntry->VoiceTag!=-1) {
					SubEntry2 = NULL;
					while (En->GetNext(&SubEntry2)) {
						if (SubEntry2->GetNext()==NULL) {
							SubEntry2->VoiceTag = SubEntry->VoiceTag;
						}
					}
				}
				break;
			}
		}

		En->Location = PBKEntry->GetEntry()->Location;
		En->Memory = PBKEntry->GetEntry()->Memory;

		PBKEntry2 = new GSM_Backup_PBKEntry;
		PBKEntry2->SetEntry(En);

		if (PBK2 == NULL) {
			PBK2 = PBKEntry2;
		} else {
			Entry2 = PBK2;
			while (Entry2->GetNext()!=NULL) Entry2 = Entry2->GetNext();
			Entry2->SetNext(PBKEntry2);
		}
	}

	delete PBK;

	PBK = PBK2;
}

/* ------------------------------------------------------------------------- */

GSM_Backup_PBKEntry::GSM_Backup_PBKEntry()
{
	Next = NULL;
	Entry = NULL;
}

GSM_Backup_PBKEntry::~GSM_Backup_PBKEntry()
{
	delete(Next);
	delete(Entry);
}

void GSM_Backup_PBKEntry::SetNext(GSM_Backup_PBKEntry *Nxt)
{
	Next = Nxt;
}

GSM_Backup_PBKEntry *GSM_Backup_PBKEntry::GetNext()
{
	return Next;
}

GSM_PBKEntry *GSM_Backup_PBKEntry::GetEntry()
{
	return Entry;
}

void GSM_Backup_PBKEntry::SetEntry(GSM_PBKEntry *En)
{
	Entry = En;
}

/* ------------------------------------------------------------------------- */

GSM_Backup_CalEntry::GSM_Backup_CalEntry()
{
	Next = NULL;
	Entry = NULL;
}

GSM_Backup_CalEntry::~GSM_Backup_CalEntry()
{
	delete(Next);
	delete(Entry);
}

void GSM_Backup_CalEntry::SetNext(GSM_Backup_CalEntry *Nxt)
{
	Next = Nxt;
}

GSM_Backup_CalEntry *GSM_Backup_CalEntry::GetNext()
{
	return Next;
}

GSM_CalendarEntry *GSM_Backup_CalEntry::GetEntry()
{
	return Entry;
}

void GSM_Backup_CalEntry::SetEntry(GSM_CalendarEntry *En)
{
	Entry = En;
}

/* ------------------------------------------------------------------------- */

GSM_Backup_SMSEntry::GSM_Backup_SMSEntry()
{
	Next = NULL;
	Entry = NULL;
}

GSM_Backup_SMSEntry::~GSM_Backup_SMSEntry()
{
	delete(Next);
	delete(Entry);
}

void GSM_Backup_SMSEntry::SetNext(GSM_Backup_SMSEntry *Nxt)
{
	Next = Nxt;
}

GSM_Backup_SMSEntry *GSM_Backup_SMSEntry::GetNext()
{
	return Next;
}

GSM_SMSList *GSM_Backup_SMSEntry::GetEntry()
{
	return Entry;
}

void GSM_Backup_SMSEntry::SetEntry(GSM_SMSList *En)
{
	Entry = En;
}

/* ------------------------------------------------------------------------- */

GSM_Backup_MMSEntry::GSM_Backup_MMSEntry()
{
	Next = NULL;
	Entry = NULL;
}

GSM_Backup_MMSEntry::~GSM_Backup_MMSEntry()
{
	delete(Next);
	delete(Entry);
}

void GSM_Backup_MMSEntry::SetNext(GSM_Backup_MMSEntry *Nxt)
{
	Next = Nxt;
}

GSM_Backup_MMSEntry *GSM_Backup_MMSEntry::GetNext()
{
	return Next;
}

GSM_MMSFile *GSM_Backup_MMSEntry::GetEntry()
{
	return Entry;
}

void GSM_Backup_MMSEntry::SetEntry(GSM_MMSFile *En)
{
	Entry = En;
}

/* ------------------------------------------------------------------------- */

GSM_Backup_JADEntry::GSM_Backup_JADEntry()
{
	Next = NULL;
	Entry = NULL;
}

GSM_Backup_JADEntry::~GSM_Backup_JADEntry()
{
	delete(Next);
	delete(Entry);
}

void GSM_Backup_JADEntry::SetNext(GSM_Backup_JADEntry *Nxt)
{
	Next = Nxt;
}

GSM_Backup_JADEntry *GSM_Backup_JADEntry::GetNext()
{
	return Next;
}

GSM_File *GSM_Backup_JADEntry::GetEntry()
{
	return Entry;
}

void GSM_Backup_JADEntry::SetEntry(GSM_File *En)
{
	Entry = En;
}

/* ------------------------------------------------------------------------- */

GSM_Backup_NoteEntry::GSM_Backup_NoteEntry()
{
	Next = NULL;
	Entry = NULL;
}

GSM_Backup_NoteEntry::~GSM_Backup_NoteEntry()
{
	delete(Next);
	delete(Entry);
}

void GSM_Backup_NoteEntry::SetNext(GSM_Backup_NoteEntry *Nxt)
{
	Next = Nxt;
}

GSM_Backup_NoteEntry *GSM_Backup_NoteEntry::GetNext()
{
	return Next;
}

GSM_NoteEntry *GSM_Backup_NoteEntry::GetEntry()
{
	return Entry;
}

void GSM_Backup_NoteEntry::SetEntry(GSM_NoteEntry *En)
{
	Entry = En;
}

/* ------------------------------------------------------------------------- */

GSM_Backup_ToDoEntry::GSM_Backup_ToDoEntry()
{
	Next = NULL;
	Entry = NULL;
}

GSM_Backup_ToDoEntry::~GSM_Backup_ToDoEntry()
{
	delete(Next);
	delete(Entry);
}

void GSM_Backup_ToDoEntry::SetNext(GSM_Backup_ToDoEntry *Nxt)
{
	Next = Nxt;
}

GSM_Backup_ToDoEntry *GSM_Backup_ToDoEntry::GetNext()
{
	return Next;
}

GSM_ToDoEntry *GSM_Backup_ToDoEntry::GetEntry()
{
	return Entry;
}

void GSM_Backup_ToDoEntry::SetEntry(GSM_ToDoEntry *En)
{
	Entry = En;
}
