/* (C) 2003 - 2007 by Marcin Wiacek www.mwiacek.com */

#include "../../../cfg/config.h" //msvc2005
#include "../../misc/files.h"
#include "../../misc/coding/coding.h"
#include "../../misc/coding/md5.h"
#include "../gsmpbk.h"
#include "gsmback.h"

GSM_Error GSM_Backup::FindTextFileChecksum(INI_File *File, char *checksum)
{
	INI_File_Section 	*Section;
	INI_File_Entry 		*Entry;
	wchart			Buff,Buff2,Buff3;
	unsignedstring		Buff4;
	wchar_t			x[200];
	//variables taken from md5main.c
	md5_state_t 		state;
	md5_byte_t 		digest[16];
	char 			hex_output[16*2 + 1];
	unsigned int 		di;

	StringToUnicode("Checksum",x);

	Section = NULL;
	while (File->GetNextSection(&Section)) {
		if (UnicodeCaseCmp(x,Section->Name.data(),-1)) continue;

		Buff.append(Section->Name.data(),Section->Name.size());
		Buff3.clear();
		Entry = NULL;
		while (Section->GetNextEntry(&Entry)) {
			//we add next entry on start because it's done this way in Gammu
			Buff2.clear();
			Buff2.append(Entry->Name.data(),Entry->Name.size());
			Buff2.append(Entry->Value.data(),Entry->Value.size());
			Buff2.append(Buff3.data(),Buff3.size());
			Buff3.clear();
			Buff3.append(Buff2.data(),Buff2.size());
		}
		Buff.append(Buff3.data(),Buff3.size());
	}

	for (di=0;di<Buff.size();di++) {
		Buff4.push_back(Buff.data()[di]/256);
		Buff4.push_back(Buff.data()[di]%256);
	}

	//4 lines taken from md5main.c
	md5_init(&state);
	md5_append(&state, (const md5_byte_t *)Buff4.data(), Buff4.size());
	md5_finish(&state, digest);
	for (di = 0; di < 16; ++di) sprintf(hex_output + di * 2, "%02x", digest[di]);

	sprintf(checksum,"%s",hex_output);
	for (di = 0; di < strlen(checksum); di++) checksum[di] = toupper(checksum[di]);

	return GSM_Return_Error(GSM_ERR_NONE);
}

void GSM_Backup::SaveTextFilePart(wchar_t *Text, FILE *file, BOOLEAN LineEnd)
{
	int 		i = 0;
	unsignedstring 	Buffer;

	while(1) {
		if (Text[i] == 0x00) break;
		if (Text[i] == 13) {
			Buffer.push_back('\\'); Buffer.push_back(0); 
			Buffer.push_back('r');  Buffer.push_back(0); 
		} else if (Text[i] == 10) {
			Buffer.push_back('\\'); Buffer.push_back(0); 
			Buffer.push_back('n');  Buffer.push_back(0); 
		} else {
			Buffer.push_back(Text[i]%256);
			Buffer.push_back(Text[i]/256);
		}
		i++;
	}
	if (LineEnd) {
		Buffer.push_back(13);
		Buffer.push_back(0);
		Buffer.push_back(10);
		Buffer.push_back(0);
	}
	fwrite(Buffer.data(),1,Buffer.size(),file);
}

/**
 * method for saving phonebook entries to backup text file. used internally
 */
GSM_Error GSM_Backup::SavePbkToTextFile(FILE *file)
{
	GSM_Backup_PBKEntry	*PBKEntry;
	GSM_PBKSubEntry 	*PBKSubEntry;
	char			buff[100],buff2[100];
	int			Num,Num2;
	BOOLEAN			Found;

	Num = 1;
	PBKEntry = NULL;
	while (GetNext_PBK(&PBKEntry)) {
		if (PBKEntry->GetEntry()->Memory != MEM_PHONE) continue;

		Found = FALSE;
		Num2 = 1;
		PBKSubEntry = NULL;
		while (PBKEntry->GetEntry()->GetNext(&PBKSubEntry) == TRUE) {
			buff2[0] = 0;
			switch (PBKSubEntry->GetType()) {
			case PBK_Text_Phone_General  : sprintf(buff2,"NumberGeneral"); 	break;
			case PBK_Text_Phone_Mobile   : sprintf(buff2,"NumberMobile"); 	break;
			case PBK_Text_Phone_Home     : sprintf(buff2,"NumberHome"); 	break;
			case PBK_Text_Phone_Work     : sprintf(buff2,"NumberWork"); 	break;
			case PBK_Text_Phone_Fax      : sprintf(buff2,"NumberFax"); 	break;
			case PBK_Text_Postal	     : sprintf(buff2,"Address"); 	break;
			case PBK_Text_Postal_City    : sprintf(buff2,"City"); 		break;
			case PBK_Text_Postal_State   : sprintf(buff2,"State"); 		break;
			case PBK_Text_Postal_ZIP_Code: sprintf(buff2,"Zip"); 		break;
			case PBK_Text_Postal_Country : sprintf(buff2,"Country"); 	break;
			case PBK_Text_Postal_Street  : sprintf(buff2,"Street"); 	break;
			case PBK_Text_Email          : sprintf(buff2,"Email"); 		break;
			case PBK_Text_URL            : sprintf(buff2,"URL"); 		break;
			case PBK_Text_UserID	     : sprintf(buff2,"UserID"); 	break;
			case PBK_Text_Note	     : sprintf(buff2,"Note"); 		break;
			case PBK_Text_Name	     : sprintf(buff2,"Name"); 		break;
			case PBK_Text_Name_Last	     : sprintf(buff2,"LastName"); 	break;
			case PBK_Text_Name_First     : sprintf(buff2,"FirstName"); 	break;
			case PBK_Text_PTT            : sprintf(buff2,"PTT"); 		break;
			case PBK_Bool_PTT_Subscribed : sprintf(buff2,"PTTSubscribed"); 	break;
			case PBK_ID_Caller_Group     : sprintf(buff2,"CallerGroup");	break;
			case PBK_ID_Picture          : sprintf(buff2,"PictureID");	break;
			default			     : break;
			}
			if (buff2[0] == 0) continue;
			if (!Found) {
				SaveTextFilePart(StringToUnicodeReturn(""), file, TRUE);
				sprintf(buff,"[PhonePBK%03i]",Num);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				sprintf(buff,"Location = %03i",PBKEntry->GetEntry()->Location);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				Num++;
				Found = TRUE;
			}
			sprintf(buff,"Entry%02iType = ",Num2);
			SaveTextFilePart(StringToUnicodeReturn(buff), file, FALSE);
			SaveTextFilePart(StringToUnicodeReturn(buff2), file, TRUE);

			switch (PBKSubEntry->GetType()) {
			case PBK_Bool_PTT_Subscribed:
				if (PBKSubEntry->BoolValue) {
					sprintf(buff,"Entry%02iValue = yes",Num2);
				} else {
					sprintf(buff,"Entry%02iValue = no",Num2);
				}
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case PBK_ID_Caller_Group:
			case PBK_ID_Picture:
				sprintf(buff,"Entry%02iNumber = %i",Num2,PBKSubEntry->LongValue);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			default:
				sprintf(buff,"Entry%02iText = \"",Num2);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, FALSE);
				SaveTextFilePart(PBKSubEntry->GetText(), file, FALSE);
				sprintf(buff,"\"");
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
			}

			switch (PBKSubEntry->GetType()) {
			case PBK_Text_Phone_General:
			case PBK_Text_Phone_Mobile:
			case PBK_Text_Phone_Home:
			case PBK_Text_Phone_Work:
			case PBK_Text_Phone_Fax:
				if (PBKSubEntry->VoiceTag!=-1) {
					sprintf(buff,"Entry%02iVoiceTag = %i",Num2,PBKSubEntry->VoiceTag);
					SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				}
				break;
			default:
				break;
			}

			Num2++;
		}
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Backup::SaveCalendarToTextFile(FILE *file)
{
	GSM_CalendarSubEntry 	*CalSubEntry;
	GSM_Backup_CalEntry	*CalEntry;
	char			buff[100];
	int			Num;

	Num = 1;
	CalEntry = NULL;
	while (GetNext_Cal(&CalEntry)) {		
		SaveTextFilePart(StringToUnicodeReturn(""), file, TRUE);
		sprintf(buff,"[Calendar%03i]",Num);
		SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
		sprintf(buff,"Location = %03i",CalEntry->GetEntry()->Location);
		SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
		Num++;

		switch (CalEntry->GetEntry()->Type) {
		case Calendar_Type_Meeting :SaveTextFilePart(StringToUnicodeReturn("Type = Meeting"), file, TRUE);break;
		case Calendar_Type_Memo	   :SaveTextFilePart(StringToUnicodeReturn("Type = Memo"), file, TRUE);break;
		case Calendar_Type_Call	   :SaveTextFilePart(StringToUnicodeReturn("Type = Call"), file, TRUE);break;
		case Calendar_Type_Birthday:SaveTextFilePart(StringToUnicodeReturn("Type = Birthday"), file, TRUE);break;
		case Calendar_Type_Reminder:SaveTextFilePart(StringToUnicodeReturn("Type = Reminder"), file, TRUE);break;
		}

		CalSubEntry = NULL;
		while (CalEntry->GetEntry()->GetNext(&CalSubEntry) == TRUE) {
			switch (CalSubEntry->GetType()) {
			case Calendar_Text_Text:
				SaveTextFilePart(StringToUnicodeReturn("Text = \""), file, FALSE);
				SaveTextFilePart(CalSubEntry->GetText(), file, FALSE);
				SaveTextFilePart(StringToUnicodeReturn("\""), file, TRUE);
				break;
			case Calendar_Text_Phone:
				SaveTextFilePart(StringToUnicodeReturn("Phone = \""), file, FALSE);
				SaveTextFilePart(CalSubEntry->GetText(), file, FALSE);
				SaveTextFilePart(StringToUnicodeReturn("\""), file, TRUE);
				break;
			case Calendar_Text_Location:
				SaveTextFilePart(StringToUnicodeReturn("EventLocation = \""), file, FALSE);
				SaveTextFilePart(CalSubEntry->GetText(), file, FALSE);
				SaveTextFilePart(StringToUnicodeReturn("\""), file, TRUE);
				break;
			case Calendar_DateTime_Start:
				sprintf(buff,"StartTime = ");
				SaveVCalendarDateTime(CalSubEntry->GetDateTime(),buff);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_DateTime_End:
				sprintf(buff,"StopTime = ");
				SaveVCalendarDateTime(CalSubEntry->GetDateTime(),buff);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_DateTime_SilentAlarm:
			case Calendar_DateTime_ToneAlarm:
				sprintf(buff,"Alarm = ");
				SaveVCalendarDateTime(CalSubEntry->GetDateTime(),buff);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				if (CalSubEntry->GetType() == Calendar_DateTime_SilentAlarm) {
					SaveTextFilePart(StringToUnicodeReturn("AlarmType = Silent"), file, TRUE);
				} else {
					SaveTextFilePart(StringToUnicodeReturn("AlarmType = Tone"), file, TRUE);
				}
				break;
			case Calendar_DateTime_End_Repeat:
				sprintf(buff,"RepeatStopDate = ");
				SaveVCalendarDateTime(CalSubEntry->GetDateTime(),buff);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_Int_Repeat_Frequency:
				sprintf(buff,"RepeatFrequency = %i",CalSubEntry->GetInt());
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_Int_Repeat_DayOfWeek:
				sprintf(buff,"DayOfWeek = %i",CalSubEntry->GetInt());
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;			
			case Calendar_Int_Repeat_Day:
				sprintf(buff,"RepeatDay = %i",CalSubEntry->GetInt());
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			case Calendar_Int_Repeat_Month:
				sprintf(buff,"RepeatMonth = %i",CalSubEntry->GetInt());
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
				break;
			}
		}
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Backup::SaveNoteToTextFile(FILE *file)
{
	GSM_Backup_NoteEntry	*NoteEntry;
	char			buff[100];
	int			Num;
	
	Num = 1;
	NoteEntry = NULL;
	while (GetNext_Note(&NoteEntry)) {
		SaveTextFilePart(StringToUnicodeReturn(""), file, TRUE);
		sprintf(buff,"[Note%03i]",Num);
		SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
		sprintf(buff,"Location = %03i",NoteEntry->GetEntry()->Location);
		SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);

		sprintf(buff,"Text = \"");
		SaveTextFilePart(StringToUnicodeReturn(buff), file, FALSE);
		SaveTextFilePart((wchar_t *)NoteEntry->GetEntry()->Text.data(), file, FALSE);
		sprintf(buff,"\"");
		SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);

		Num++;
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Backup::SaveToDoToTextFile(FILE *file)
{
	GSM_Backup_ToDoEntry	*ToDoEntry;
	GSM_ToDoSubEntry		*SubEntry;
	char			buff[100];
	int			Num;
	
	Num = 1;
	ToDoEntry = NULL;
	while (GetNext_ToDo(&ToDoEntry)) {
		SaveTextFilePart(StringToUnicodeReturn(""), file, TRUE);
		sprintf(buff,"[TODO%03i]",Num);
		SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
		sprintf(buff,"Location = %03i",ToDoEntry->GetEntry()->Location);
		SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);

	        SubEntry = NULL;
	        while (ToDoEntry->GetEntry()->GetNext(&SubEntry)) {
            		switch (SubEntry->Type) {
		        case ToDo_Text_Text:
				sprintf(buff,"Text = \"");
				SaveTextFilePart(StringToUnicodeReturn(buff), file, FALSE);
				SaveTextFilePart((wchar_t *)SubEntry->Text.data(), file, FALSE);
				sprintf(buff,"\"");
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
		                break;
		        case ToDo_Priority:
		                switch (SubEntry->Priority) {
				case GSM_Priority_High:
					SaveTextFilePart(StringToUnicodeReturn("Priority = High"), file, TRUE);
					break;
				case GSM_Priority_Medium:
					SaveTextFilePart(StringToUnicodeReturn("Priority = Medium"), file, TRUE);
					break;
				case GSM_Priority_Low:
					SaveTextFilePart(StringToUnicodeReturn("Priority = Low"), file, TRUE);
					break;
		                }
		                break;
		        case ToDo_Bool_Completed:
				SaveTextFilePart(StringToUnicodeReturn("Completed = yes"), file, TRUE);
				break;
		        case ToDo_DateTime_End:
				sprintf(buff,"DueTime = ");
				SaveVCalendarDateTime(&SubEntry->DT,buff);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
		                break;
		        case ToDo_DateTime_ToneAlarm:
				sprintf(buff,"Alarm = ");
				SaveVCalendarDateTime(&SubEntry->DT,buff);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
		                break;
		        case ToDo_DateTime_SilentAlarm:
				sprintf(buff,"SilentAlarm = ");
				SaveVCalendarDateTime(&SubEntry->DT,buff);
				SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
			}
		}
		Num++;
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Backup::SaveToTextFile(char *FileName)
{
	INI_File		File;
	FILE			*file;
	char			buff[100];
	unsigned char 		buff3[100];
	GSM_DateTime		DT;

	if (FileName[0] == 0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);
	file = fopen(FileName,"wb");
	if (file == NULL) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	buff3[0] = 0xff;
	buff3[1] = 0xfe;
	fwrite(buff3,1,2,file);

	SaveTextFilePart(StringToUnicodeReturn("# This file format is compatible with Gammu, Gammu+"),file,TRUE);
	SaveTextFilePart(StringToUnicodeReturn("# and some based on them programs. See www.gammu.org for more info"), file, TRUE);
	SaveTextFilePart(StringToUnicodeReturn(""), file, TRUE);

	SaveTextFilePart(StringToUnicodeReturn("[Backup]"), file, TRUE);
	SaveTextFilePart(StringToUnicodeReturn("Format=1.05"), file, TRUE);

	sprintf(buff,"IMEI = \"%s\"",DeviceIMEI);
	SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);

	sprintf(buff,"Creator = \"Gammu+ %s",VERSION);
	if (strlen(GetOS()) != 0) sprintf(buff+strlen(buff),", %s",GetOS());
	if (strlen(GetCompiler()) != 0) sprintf(buff+strlen(buff),", %s",GetCompiler());
	sprintf(buff+strlen(buff),"\"");
	SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);

	sprintf(buff,"DateTime = ");
	GSM_GetCurrentDateTime(&DT);
	SaveVCalendarDateTime(&DT,buff);
	SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);

	sprintf(buff,"Phone = \"%s\"",DeviceModel);
	SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);

	SavePbkToTextFile(file);
	SaveCalendarToTextFile(file);
        SaveNoteToTextFile(file);
        SaveToDoToTextFile(file);

	fclose(file);

	File.ReadFile(FileName);
	FindTextFileChecksum(&File, (char *)buff3);
	file = fopen(FileName,"ab");
	SaveTextFilePart(StringToUnicodeReturn(""), file, TRUE);
	SaveTextFilePart(StringToUnicodeReturn("[Checksum]"), file, TRUE);
	sprintf(buff,"MD5=%s",buff3);
	SaveTextFilePart(StringToUnicodeReturn(buff), file, TRUE);
	fclose(file);

	return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

/**
 * method for reading phonebook from backup text file. Used internally
 */
GSM_Error GSM_Backup::ReadPbkFromTextFile(INI_File *File)
{
	INI_File_Section 	*Section;
	wchar_t			*value, x[200];
	char			x2[100];
	GSM_PBKEntry		*PBKEntry;
	GSM_PBK_SubEntryType	PBKType;
	GSM_PBKSubEntry 	*SubEntry;
	int			i;
	BOOLEAN			Found;
	wchart			Txt;

	StringToUnicode("PhonePBK",x);
	Section = NULL;
	while (File->GetNextSection(&Section)==TRUE) {
		if (wcsncmp(x,(wchar_t *)Section->Name.data(),8) != 0) continue;

		value = File->GetValueInSection(Section,StringToUnicodeReturn("Location"));
		if (value == NULL) continue;

		PBKEntry 		= new GSM_PBKEntry;
		PBKEntry->Location 	= atoi(UnicodeToStringReturn(value));
		PBKEntry->Memory	= MEM_PHONE;
		for (i=0;i<50;i++) {
			sprintf(x2,"Entry%02iType",i);
			value = File->GetValueInSection(Section,StringToUnicodeReturn(x2));
			if (value == NULL) continue;

			PBKType = PBK_Not_Assigned;
			if (!wcscmp(value,StringToUnicodeReturn("LastName"))) 		PBKType = PBK_Text_Name_Last;
			else if (!wcscmp(value,StringToUnicodeReturn("FirstName"))) 	PBKType = PBK_Text_Name_First;
			else if (!wcscmp(value,StringToUnicodeReturn("NumberMobile"))) 	PBKType = PBK_Text_Phone_Mobile;
			else if (!wcscmp(value,StringToUnicodeReturn("NumberHome"))) 	PBKType = PBK_Text_Phone_Home;
			else if (!wcscmp(value,StringToUnicodeReturn("NumberWork"))) 	PBKType = PBK_Text_Phone_Work;
			else if (!wcscmp(value,StringToUnicodeReturn("NumberFax"))) 	PBKType = PBK_Text_Phone_Fax;
			else if (!wcscmp(value,StringToUnicodeReturn("NumberGeneral"))) PBKType = PBK_Text_Phone_General;
			else if (!wcscmp(value,StringToUnicodeReturn("Address"))) 	PBKType = PBK_Text_Postal;
			else if (!wcscmp(value,StringToUnicodeReturn("City"))) 		PBKType = PBK_Text_Postal_City;
			else if (!wcscmp(value,StringToUnicodeReturn("State"))) 	PBKType = PBK_Text_Postal_State;
			else if (!wcscmp(value,StringToUnicodeReturn("Zip"))) 		PBKType = PBK_Text_Postal_ZIP_Code;
			else if (!wcscmp(value,StringToUnicodeReturn("Country"))) 	PBKType = PBK_Text_Postal_Country;
			else if (!wcscmp(value,StringToUnicodeReturn("Street"))) 	PBKType = PBK_Text_Postal_Street;
			else if (!wcscmp(value,StringToUnicodeReturn("Email"))) 	PBKType = PBK_Text_Email;
			else if (!wcscmp(value,StringToUnicodeReturn("URL"))) 		PBKType = PBK_Text_URL;
			else if (!wcscmp(value,StringToUnicodeReturn("UserID"))) 	PBKType = PBK_Text_UserID;
			else if (!wcscmp(value,StringToUnicodeReturn("Note"))) 		PBKType = PBK_Text_Note;
			else if (!wcscmp(value,StringToUnicodeReturn("PTT"))) 		PBKType = PBK_Text_PTT;
			if (PBKType == PBK_Not_Assigned) {
				if (!wcscmp(value,StringToUnicodeReturn("CallerGroup"))) 	PBKType = PBK_ID_Caller_Group;
				else if (!wcscmp(value,StringToUnicodeReturn("PictureID"))) 	PBKType = PBK_ID_Picture;

				if (PBKType == PBK_Not_Assigned) continue;

				sprintf(x2,"Entry%02iNumber",i);
				value = File->GetValueInSection(Section,StringToUnicodeReturn(x2));
				if (value == NULL) continue;

				PBKEntry->AddLong(PBKType,atol(UnicodeToStringReturn(value)));

				continue;
			}

			sprintf(x2,"Entry%02iText",i);
			value = File->GetValueInSection(Section,StringToUnicodeReturn(x2));
			if (value == NULL) continue;
			if (UnicodeLength(value)==0) continue;

			value[UnicodeLength(value)-1] = 0;
			ReadTextFilePart(value+1, &Txt);
			PBKEntry->AddText(PBKType,(wchar_t *)Txt.data());

			if (PBKType == PBK_Text_Phone_Mobile ||
			    PBKType == PBK_Text_Phone_Home ||
			    PBKType == PBK_Text_Phone_Work ||
			    PBKType == PBK_Text_Phone_Fax ||
			    PBKType == PBK_Text_Phone_General) {
				sprintf(x2,"Entry%02iVoiceTag",i);
				value = File->GetValueInSection(Section,StringToUnicodeReturn(x2));
				if (value != NULL) {
					SubEntry = NULL;
					while (PBKEntry->GetNext(&SubEntry)) {
						if (SubEntry->GetNext() == NULL) {
							SubEntry->VoiceTag = atol(UnicodeToStringReturn(value));
						}
					}
				}
			}
		}
		Found = FALSE;
		SubEntry = NULL;
		while (PBKEntry->GetNext(&SubEntry)) {
			switch (SubEntry->GetType()) {
			case PBK_Text_Name_First:
			case PBK_Text_Name_Last:
				Found = TRUE;
				break;
			default:
				break;
			}
		}
		if (!Found) {
			for (i=0;i<50;i++) {
				sprintf(x2,"Entry%02iType",i);
				value = File->GetValueInSection(Section,StringToUnicodeReturn(x2));
				if (value == NULL) continue;

				PBKType = PBK_Not_Assigned;
				if (!wcscmp(value,StringToUnicodeReturn("Name"))) PBKType = PBK_Text_Name;
				if (PBKType == PBK_Not_Assigned) continue;

				sprintf(x2,"Entry%02iText",i);
				value = File->GetValueInSection(Section,StringToUnicodeReturn(x2));
				if (value == NULL) continue;
				if (UnicodeLength(value)==0) continue;

				value[UnicodeLength(value)-1] = 0;
				PBKEntry->AddText(PBKType,value+1);
			}
		}
		Add_PBK(PBKEntry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Backup::ReadCalendarFromTextFile(INI_File *File)
{
	wchar_t			*value, x[200];
	GSM_CalendarEntry	*CalEntry;
	GSM_Calendar_Type	CalType;
	GSM_DateTime		DT;
	INI_File_Section 	*Section;

	StringToUnicode("Calendar",x);
	Section = NULL;
	while (File->GetNextSection(&Section)==TRUE) {
		if (wcsncmp(x,(wchar_t *)Section->Name.data(),8) != 0) continue;

		value = File->GetValueInSection(Section,StringToUnicodeReturn("Type"));
		if (value == NULL) continue;

		CalType = Calendar_Type_Not_Assigned;
		if (!wcscmp(value,StringToUnicodeReturn("Meeting"))) 		CalType = Calendar_Type_Meeting;
		else if (!wcscmp(value,StringToUnicodeReturn("Memo"))) 		CalType = Calendar_Type_Memo;
		else if (!wcscmp(value,StringToUnicodeReturn("Call"))) 		CalType = Calendar_Type_Call;
		else if (!wcscmp(value,StringToUnicodeReturn("Birthday"))) 	CalType = Calendar_Type_Birthday;
		else if (!wcscmp(value,StringToUnicodeReturn("Reminder"))) 	CalType = Calendar_Type_Reminder;
		if (CalType == Calendar_Type_Not_Assigned) continue;

		CalEntry = new GSM_CalendarEntry;
		CalEntry->Type = CalType;

		// ----------------------- times ------------------------------

		value = File->GetValueInSection(Section,StringToUnicodeReturn("StartTime"));
		if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
			CalEntry->AddDateTime(Calendar_DateTime_Start, DT);
		}

		value = File->GetValueInSection(Section,StringToUnicodeReturn("StopTime"));
		if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
			CalEntry->AddDateTime(Calendar_DateTime_End, DT);
		}

		value = File->GetValueInSection(Section,StringToUnicodeReturn("AlarmType"));
		if (value != NULL && !strcmp(UnicodeToStringReturn(value),"Silent")) {
			value = File->GetValueInSection(Section,StringToUnicodeReturn("Alarm"));
			if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
				CalEntry->AddDateTime(Calendar_DateTime_SilentAlarm, DT);
			}
		} else {
			value = File->GetValueInSection(Section,StringToUnicodeReturn("Alarm"));
			if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
				CalEntry->AddDateTime(Calendar_DateTime_ToneAlarm, DT);
			}
		}
		
		value = File->GetValueInSection(Section,StringToUnicodeReturn("RepeatStopDate"));
		if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
			CalEntry->AddDateTime(Calendar_DateTime_End_Repeat, DT);
		}

		// ----------------------- texts ------------------------------

		value = File->GetValueInSection(Section,StringToUnicodeReturn("EventLocation"));
		if (value != NULL && UnicodeLength(value)!=0) {
			value[UnicodeLength(value)-1] = 0;
			CalEntry->AddText(Calendar_Text_Location, value+1);
		}

		value = File->GetValueInSection(Section,StringToUnicodeReturn("Text"));
		if (value != NULL && UnicodeLength(value)!=0) {
			value[UnicodeLength(value)-1] = 0;
			CalEntry->AddText(Calendar_Text_Text, value+1);
		}

		value = File->GetValueInSection(Section,StringToUnicodeReturn("Phone"));
		if (value != NULL && UnicodeLength(value)!=0) {
			value[UnicodeLength(value)-1] = 0;
			CalEntry->AddText(Calendar_Text_Phone, value+1);
		}

		// ------------------------ int -------------------------------

		value = File->GetValueInSection(Section,StringToUnicodeReturn("RepeatDayOfWeek"));
		if (value != NULL) {
			CalEntry->AddInt(Calendar_Int_Repeat_DayOfWeek, atoi(UnicodeToStringReturn(value)));
		}

		value = File->GetValueInSection(Section,StringToUnicodeReturn("RepeatDay"));
		if (value != NULL) {
			CalEntry->AddInt(Calendar_Int_Repeat_Day, atoi(UnicodeToStringReturn(value)));
		}

		value = File->GetValueInSection(Section,StringToUnicodeReturn("RepeatMonth"));
		if (value != NULL) {
			CalEntry->AddInt(Calendar_Int_Repeat_Month, atoi(UnicodeToStringReturn(value)));
		}

		value = File->GetValueInSection(Section,StringToUnicodeReturn("RepeatFrequency"));
		if (value != NULL) {
			CalEntry->AddInt(Calendar_Int_Repeat_Frequency, atoi(UnicodeToStringReturn(value)));
		}

		Add_Cal(CalEntry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Backup::ReadNoteFromTextFile(INI_File *File)
{
	wchar_t			*value, x[200];
	GSM_NoteEntry		*NoteEntry;
	INI_File_Section 	*Section;
	wchart			Txt;

	StringToUnicode("Note",x);
	Section = NULL;
	while (File->GetNextSection(&Section)==TRUE) {
		if (wcsncmp(x,(wchar_t *)Section->Name.data(),4) != 0) continue;

		value = File->GetValueInSection(Section,StringToUnicodeReturn("Text"));
		if (value == NULL) continue;

		ReadTextFilePart(value+1, &Txt);
		NoteEntry = new GSM_NoteEntry;
		NoteEntry->Text.append(Txt.data(),Txt.size()-1);

		value = File->GetValueInSection(Section,StringToUnicodeReturn("Location"));
		if (value == NULL) continue;
		NoteEntry->Location = atoi(UnicodeToStringReturn(value));

		Add_Note(NoteEntry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Backup::ReadToDoFromTextFile(INI_File *File)
{
	wchar_t			*value, x[200];
	GSM_ToDoEntry		*ToDoEntry;
	GSM_ToDoSubEntry	*ToDoSubEntry;
	INI_File_Section 	*Section;
	GSM_ToDo_Priority	Priority;
	GSM_DateTime		DT;
	wchart			Txt;

	StringToUnicode("TODO",x);
	Section = NULL;
	while (File->GetNextSection(&Section)==TRUE) {
		if (wcsncmp(x,(wchar_t *)Section->Name.data(),4) != 0) continue;

		value = File->GetValueInSection(Section,StringToUnicodeReturn("Location"));
		if (value == NULL) continue;

		ToDoEntry = new GSM_ToDoEntry;
		ToDoEntry->Location = atoi(UnicodeToStringReturn(value));

		value = File->GetValueInSection(Section,StringToUnicodeReturn("Text"));
		if (value != NULL) {
			ReadTextFilePart(value+1, &Txt);
			ToDoSubEntry = new GSM_ToDoSubEntry;
			ToDoSubEntry->Text.append(Txt.data(),Txt.size()-1);
			ToDoSubEntry->Type = ToDo_Text_Text;
			ToDoEntry->AddSubEntry(ToDoSubEntry);
		}

		value = File->GetValueInSection(Section,StringToUnicodeReturn("Priority"));
		if (value != NULL) {
			Priority = GSM_Priority_Not_Assigned;
			if (!wcscmp(value,StringToUnicodeReturn("High"))) 		Priority = GSM_Priority_High;
			else if (!wcscmp(value,StringToUnicodeReturn("Medium"))) 	Priority = GSM_Priority_Medium;
			else if (!wcscmp(value,StringToUnicodeReturn("Low"))) 		Priority = GSM_Priority_Low;
			if (Priority != GSM_Priority_Not_Assigned) {
				ToDoSubEntry = new GSM_ToDoSubEntry;
				ToDoSubEntry->Priority = Priority;
				ToDoSubEntry->Type = ToDo_Priority;
				ToDoEntry->AddSubEntry(ToDoSubEntry);
			}
		}

		value = File->GetValueInSection(Section,StringToUnicodeReturn("Completed"));
		if (value != NULL && !wcscmp(value,StringToUnicodeReturn("yes"))) {
			ToDoSubEntry = new GSM_ToDoSubEntry;
			ToDoSubEntry->BoolValue = TRUE;
			ToDoSubEntry->Type = ToDo_Bool_Completed;
			ToDoEntry->AddSubEntry(ToDoSubEntry);
		}

		value = File->GetValueInSection(Section,StringToUnicodeReturn("DueTime"));
		if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
			ToDoSubEntry = new GSM_ToDoSubEntry;
			memcpy(&ToDoSubEntry->DT,&DT,sizeof(GSM_DateTime));
			ToDoSubEntry->Type = ToDo_DateTime_End;
			ToDoEntry->AddSubEntry(ToDoSubEntry);
		}

		value = File->GetValueInSection(Section,StringToUnicodeReturn("Alarm"));
		if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
			ToDoSubEntry = new GSM_ToDoSubEntry;
			memcpy(&ToDoSubEntry->DT,&DT,sizeof(GSM_DateTime));
			ToDoSubEntry->Type = ToDo_DateTime_ToneAlarm;
			ToDoEntry->AddSubEntry(ToDoSubEntry);
		}

		value = File->GetValueInSection(Section,StringToUnicodeReturn("SilentAlarm"));
		if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &DT)==TRUE) {
			ToDoSubEntry = new GSM_ToDoSubEntry;
			memcpy(&ToDoSubEntry->DT,&DT,sizeof(GSM_DateTime));
			ToDoSubEntry->Type = ToDo_DateTime_SilentAlarm;
			ToDoEntry->AddSubEntry(ToDoSubEntry);
		}

		Add_ToDo(ToDoEntry);
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Backup::ReadFromTextFile(char *FileName)
{
	INI_File 		File;
	wchar_t			*value, x[200];

	if (!File.ReadFile(FileName)) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	StringToUnicode("Backup",x);
	value = File.GetValue(x,StringToUnicodeReturn("Format"));
	if (value == NULL) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	value = File.GetValue(x,StringToUnicodeReturn("IMEI"));
	if (value != NULL) {
		sprintf(DeviceIMEI,"%s",UnicodeToStringReturn(value+1));
		DeviceIMEI[strlen(DeviceIMEI)-1] = 0;
	}

	value = File.GetValue(x,StringToUnicodeReturn("Creator"));
	if (value != NULL) {
		sprintf(FileCreator,"%s",UnicodeToStringReturn(value+1));
		FileCreator[strlen(FileCreator)-1] = 0;
	}

	value = File.GetValue(x,StringToUnicodeReturn("Phone"));
	if (value != NULL) {
		sprintf(DeviceModel,"%s",UnicodeToStringReturn(value+1));
		DeviceModel[strlen(DeviceModel)-1] = 0;
	}

	value = File.GetValue(x,StringToUnicodeReturn("DateTime"));
	if (value != NULL && ReadVCalendarDateTime(UnicodeToStringReturn(value), &FileDateTime)==TRUE) {
		FileDateTimeAvailable=TRUE;
	}

	if ((File.Buffer.data()[0] == 0xFE && File.Buffer.data()[1] == 0xFF) ||
	    (File.Buffer.data()[0] == 0xFF && File.Buffer.data()[1] == 0xFE)) {
		StringToUnicode("Checksum",x);
		value = File.GetValue(x,StringToUnicodeReturn("MD5"));
		if (value != NULL) {
			sprintf(FileMD5Original,"%s",UnicodeToStringReturn(value));
			FindTextFileChecksum(&File, (char *)FileMD5Calculated);
		}
	}

	ReadPbkFromTextFile(&File);
	ReadCalendarFromTextFile(&File);
	ReadNoteFromTextFile(&File);
	ReadToDoFromTextFile(&File);

	return GSM_Return_Error(GSM_ERR_NONE);
}

void GSM_Backup::ReadTextFilePart(wchar_t *Src, wchart *Dest)
{
	int i = 0,Level=0;
	unsignedstring Buffer;

	Dest->clear();
	for (i=0;i<UnicodeLength(Src);i++) {
		if (Level == 0) {
			if (Src[i]=='\\') {
				Level = 1;
			} else {
				Dest->push_back(Src[i]);
			}
		} else {
			if (Src[i]=='r') {
				Dest->push_back(13);
			} else if (Src[i]=='n') {
				Dest->push_back(10);
			} else {
				Dest->push_back('\\');
				Dest->push_back(Src[i]);
			}
			Level = 0;
		}
	}
	if (Level == 1) Dest->push_back('\\');
}
