/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../../service/gsmmisc.h"
#include "../../device/gsmdev.h"
#include "phonet.h"

GSM_Error GSM_Protocol_PHONET::Open(char *Prot)
{
	unsigned char Buff[] = {0x04};

        (*Debug)->Deb("[STATE     : opening protocol phonet]\n");

	Phone_ID = 0x00;
        if (!strcmp(Prot,"irdaphonet")) {
		Frame_ID = 0x14;
		PC_ID 	 = 0x0C;

		return GSM_Return_Error(GSM_ERR_NONE);
	} else if (!strcmp(Prot,"phonetblue") || !strcmp(Prot,"bluephonet") || !strcmp(Prot,"bluerfphonet")) {
		Frame_ID = 0x19;
		PC_ID 	 = 0x10;

		Write(Buff, 1, (unsigned char)0xD0);

		return GSM_Return_Error(GSM_ERR_NONE);
	} else if (!strcmp(Prot,"dku2phonet") || !strcmp(Prot,"dku2")) {
		Frame_ID = 0x1B;
		PC_ID 	 = 0x0C;

		return GSM_Return_Error(GSM_ERR_NONE);
	}
        return GSM_Return_Error(GSM_ERR_UNKNOWN);
}

GSM_Error GSM_Protocol_PHONET::Close()
{
        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Protocol_PHONET::Write(unsigned char *buffer, int length, unsigned char type)
{
	unsignedstring Buffer;

	Buffer.push_back(Frame_ID);
	Buffer.push_back(Phone_ID);
	Buffer.push_back(PC_ID);
	Buffer.push_back(type);
	Buffer.push_back(length/256);
	Buffer.push_back(length%256);
	Buffer.append((const unsigned char *)buffer,length);

	GSM_Protocol::Write(buffer,length,type);
	return (*Device)->Write(Buffer.data(),Buffer.size());
}

GSM_Error GSM_Protocol_PHONET::Dispatch(unsigned char *buffer, int length, int *position)
{
	int len, i = (*position);

	while (i < length) {
		if (State == MSG_Sync) {
			CheckReadByte(buffer[i], Frame_ID, MSG_Destination);
		} else if (State == MSG_Destination) {
			CheckReadByte(buffer[i], PC_ID, MSG_Source);
		} else if (State == MSG_Source) {
			CheckReadByte(buffer[i], Phone_ID, MSG_Type);
		} else if (State == MSG_Type) {
			MsgReceived.Type 	= buffer[i];	
			State 			= MSG_Length1;
		} else if (State == MSG_Length1) {
			MsgReceived.Length 	= buffer[i]*256;
			State 			= MSG_Length2;
		} else if (State == MSG_Length2) {
			MsgReceived.Buffer.clear();
			MsgReceived.Length 	= MsgReceived.Length + buffer[i];
			State 			= MSG_Message;
		} else if (State == MSG_Message) {
			len = length - i;
			if (len > MsgReceived.Length) len = MsgReceived.Length;

			MsgReceived.Buffer.append((const unsigned char *)buffer+i,len);
			i+=len;

			if (MsgReceived.Buffer.size() < (unsigned int)MsgReceived.Length) continue;

			(*position)		= i;
			State 			= MSG_Sync;
			return GSM_Return_Error(GSM_ERR_NEWMESSAGE);
		}
		i++;
	}
	(*position) = i;
	return GSM_Return_Error(GSM_ERR_NONE);
}
