/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include <stdio.h>

#include "../../service/gsmmisc.h"
#include "../../service/gsmpbk.h"
#include "../../protocol/gsmprot.h"
#include "../gsmphone.h"

#ifndef __ndct34
#define __ndct34

#define NOKIA_FRAME1 0x00, 0x01, 0x00

const int ID_GetID	       	= 1 + ID_Start;
const int ID_GetCalendarInfo    = 2 + ID_Start;

/* DCT3 and later */
#define NPBK_SIM_SPEEDDIAL      0x04 // Speed dial on SIM
#define NPBK_NAME	       	0x07 // Text: name
#define NPBK_EMAIL	      	0x08 // Text: email adress
#define NPBK_POSTAL	     	0x09 // Text: postal address
#define NPBK_NOTE	       	0x0A // Text: note
#define NPBK_NUMBER	     	0x0B // Text: All phone numbers types
#define    NPBK_NUMBER_UNKNOWN1 0x00
#define    NPBK_NUMBER_UNKNOWN2 0x01 // Not assigned dialed number
#define    NPBK_NUMBER_HOME     0x02
#define    NPBK_NUMBER_MOBILE   0x03
#define    NPBK_NUMBER_FAX      0x04
#define    NPBK_NUMBER_WORK     0x06
#define    NPBK_NUMBER_GENERAL  0x0A
#define    NPBK_NUMBER_UNKNOWN3 0x0B
//0x0C -> videotelephone number ?
#define    NPBK_NUMBER_BUG      0x55 // firmware bug for Call Register in DCT4
				     // visible after using Save from Call 
				     // Register menu and saving number
				     // to existing phonebook entry
#define NPBK_RINGTONE_ID	0x0C // ID: Ringtone
#define NPBK_DATETIME	   	0x13 // Call register: date and time
#define NPBK_UNKNOWN1	   	0x19 // Call register: with missed calls
#define NPBK_SPEEDDIAL	  	0x1A // Speed dial
#define NPBK_GROUP_LOGO_BODY	0x1B // Caller memory - logo
#define NPBK_GROUP_LOGO_ON	0x1C // Caller memory - is logo on or not
#define NPBK_GROUP_ID	      	0x1E // Caller group number in pbk entry

/* DCT4 and later */
#define NPBK_URL		0x2C // Text: URL address
#define NPBK_SMSLIST_ID	 	0x2E // ID: SMS list
#define NPBK_VOICETAG_ID	0x2F // ID: Voice tag
#define NPBK_PICTURE_ID	 	0x33 // ID: Picture
#define NPBK_RINGTONEFILE_ID    0x37 // ID: Ringtone from filesystem or internal
#define NPBK_USER_ID	    	0x38 // Text: user ID
#define NPBK_UNKNOWN2	   	0x3B // ID: conversation list ?
#define NPBK_UNKNOWN3	   	0x3C // ID: Instant Messaging service list ?
#define NPBK_UNKNOWN4	   	0x3D // ID: presence list ?
#define NPBK_PUSHTOTALK_ID      0x3F // ID: SIP Address (Push to Talk address)
#define NPBK_PUSHTOTALK_SUBSC   0x42 // is PTT subscribed ?
#define NPBK_GROUP2_ID	  	0x43 // ID: Caller group type 2 (6230i,later)

/* Series 40 3.0 and later */
#define NPBK_CALL_LENGTH	0x44
// 0x45 -> videofile for call
#define NPBK_NAME_FIRST		0x46
#define NPBK_NAME_LAST		0x47
#define NPBK_POSTAL2		0x4A
#define	   NPBK_POSTAL2_ADDRESS 0x4B
#define    NPBK_POSTAL2_STREET  0x4C
#define	   NPBK_POSTAL2_CITY	0x4D
#define	   NPBK_POSTAL2_STATE 	0x4E
#define    NPBK_POSTAL2_ZIPCODE 0x4F
#define    NPBK_POSTAL2_COUNTRY 0x50
// 0x52 -> formal name
// 0x53 -> video sharing sip
// 0x54 -> job title
// 0x55 -> Companyname
// 0x56 -> nickname
// 0x57 -> birthday

typedef struct {
	unsignedint	     Types;
	GSM_MemoryType	     Memory;
} GSM_PBK_Features;

typedef struct {
	unsignedint	     Locations;
	int		     Length;
} GSM_Cal_Loc;

typedef struct {
	unsignedint	     Locations;
	int		     FolderID;
} GSM_SMS_Loc;

class GSM_Phone_NDCT34
{
public:
	GSM_Phone_NDCT34(int id, DebugInfo **Debug2, GSM_AllPhones **Pho2);
	~GSM_Phone_NDCT34();

	GSM_Error       GetCodeNameModel	(unsigned char *Mod);
	GSM_Error       GetFirmwareVersion      (unsigned char *Firm);
	GSM_Error       GetFirmwareDate	 	(unsigned char *Dat);
	GSM_Error       GetNextCalendar1	(GSM_CalendarEntry *Entry, BOOLEAN start, int *Current, int *Max);
	GSM_Error       AddCalendar1	    	(GSM_CalendarEntry *Entry);
	GSM_Error       AddCalendar2	    	(GSM_CalendarEntry *Entry);
	GSM_Error       DeleteCalendar	  	(GSM_CalendarEntry *Entry);
	GSM_Error 	GetPBKFeatures		(GSM_PBK_Features *Features);

	GSM_Error       ReplyGetID	      	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *Ident);
	GSM_Error       ReplySetPBK	     	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error       ReplyDelPBK	     	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error       ReplyGetCalendarInfo1   (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error       ReplyGetNextCalendar1   (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error       ReplyGetFirstCalPos1    (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error       ReplyAddCalendar1       (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error       ReplyAddCalendar2       (GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error       ReplyDelCalendar	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);
	GSM_Error 	ReplyGetPBKFeatures	(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S);

	int	    	GetID		   	();
	unsigned char   Get7110DCT4MemoryType   (GSM_MemoryType Type);
	char	    	*GetFrameID	     	();
	void	    	SetFrameID	      	(char *Id);
	GSM_Error       DecodePBKToEntry	(const unsigned char *Buffer, GSM_PBKEntry *Entry);
	GSM_Error       EncodeEntryToPBK	(unsignedstring *Buffer, GSM_PBKEntry *Entry, int *Number, GSM_PBK_Features *Features);
private:
	int	     	CurrentCalendarNumber;
	GSM_Cal_Loc     CalendarLocations;

	int	     	ID;
	char	    	*FrameID;
	DebugInfo       **Debug;
	GSM_Phone       **Pho;
	GSM_AllPhones   **AllPhones;

	GSM_Error       PrivGetID	       	();
	GSM_Error       GetCalendarInfo1	();
	GSM_Error       GetFirstCalendarPos1    (int *Location);
};

wchar_t	 	*NokiaGetUnicodeString	  	(const unsigned char *Buffer);
wchar_t	 	*NokiaGetUnicodeSimple	  	(const unsigned char *Buffer, int Len);
int	     	NokiaSetUnicodeString	   	(const wchar_t *src, unsignedstring *Dest);
GSM_DateTime    *NokiaGetDT		     	(const unsigned char *Buffer);
GSM_Error       NokiaGetCalendarRecurranceRepeat(DebugInfo *Debug, GSM_CalendarEntry *Entry, const unsigned char *Buffer, const unsigned char *RepeatBuffer);
GSM_Error       NokiaSetCalendarRecurranceRepeat(DebugInfo *Debug, GSM_CalendarEntry *Entry, unsigned char *Buffer, unsigned char *RepeatBuffer);

#endif
