/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include "../../../cfg/config.h" //msvc2005
#include "../../misc/coding/coding.h"
#include "../../service/gsmmisc.h"
#include "../gsmphone.h"
#include "ndct34.h"

GSM_Phone_NDCT34::GSM_Phone_NDCT34(int id, DebugInfo **Debug2, GSM_AllPhones **Pho2)
{
	FrameID	   = NULL;
	ID	   = id;
	Debug	   = Debug2;
	Pho	   = &((*Pho2)->Current);
	AllPhones  = Pho2;
}

int GSM_Phone_NDCT34::GetID()
{
	return ID;
}

GSM_Phone_NDCT34::~GSM_Phone_NDCT34()
{
	free(FrameID);
}

GSM_Error GSM_Phone_NDCT34::ReplyGetID(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *Ident)
{
	int i;

	for (i=0;i<msg->Length;i++) {
		if (msg->Buffer[i] == 0x00) {
			Ident[i] = 32;
		} else {
			Ident[i] = msg->Buffer[i];
		}
	}
	Ident[i] = 0x00;
	(*Debug)->Deb("RECEIVED: phone identification\n");
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::PrivGetID()
{
	unsigned char   Buff[] = {NOKIA_FRAME1, 0x03, 0x00};
	unsigned char   Id[200];
	GSM_Error       error;

	(*Debug)->Deb("SENT: Get identification\n");
	error=(*Pho)->Write(Buff, 5, 0xD1, 2, ID_GetID+ID, Id);
	if (error.Code == GSM_ERR_NONE) SetFrameID((char *)Id);
	return error;
}

GSM_Error GSM_Phone_NDCT34::GetCodeNameModel(unsigned char *Mod)
{
	GSM_Error       error;
	int	     	i=5,counter=0;

	if (FrameID == NULL) {
		error = PrivGetID();
		if (error.Code != GSM_ERR_NONE) return error;			   
	}
	Mod[0] = 0x00;
	while(1) {
		if (FrameID[i]==0x0a) {
			if (counter == 2) break;
			counter++;
		} else {
			if (counter == 2) {
				Mod[strlen((const char *)Mod)+1] = 0x00;
				Mod[strlen((const char *)Mod)]   = FrameID[i];
			}
		}
		i++;
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::GetFirmwareVersion(unsigned char *Firm)
{
	GSM_Error       error;
	int	     	i=4,counter=0;

	if (FrameID == NULL) {
		error = PrivGetID();
		if (error.Code != GSM_ERR_NONE) return error;			   
	}
	Firm[0] = 0x00;
	while(1) {
		if (FrameID[i]==0x0a) {
			break;
		} else {
			counter++;
			if (counter >= 3) {
				if (strlen((const char *)Firm) == 0 && FrameID[i]==0x20) {
				} else {
					Firm[strlen((const char *)Firm)+1] = 0x00;
					Firm[strlen((const char *)Firm)]   = FrameID[i];
				}
			}
		}
		i++;
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::GetFirmwareDate(unsigned char *Dat)
{
	GSM_Error       error;
	int	     	i=4,counter=0;

	if (FrameID == NULL) {
		error = PrivGetID();
		if (error.Code != GSM_ERR_NONE) return error;			   
	}
	Dat[0] = 0x00;
	while(1) {
		if (FrameID[i]==0x0a) {
			if (counter == 1) break;
			counter++;
		} else {
			if (counter == 1) {
				Dat[strlen((const char *)Dat)+1] = 0x00;
				Dat[strlen((const char *)Dat)]   = FrameID[i];
			}
		}
		i++;
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

unsigned char GSM_Phone_NDCT34::Get7110DCT4MemoryType(GSM_MemoryType Type)
{
	switch (Type) {
		case MEM_PHONE_DIALLED  : return 0x01;
		case MEM_PHONE_MISSED   : return 0x02;
		case MEM_PHONE_RECEIVED : return 0x03;
		case MEM_PHONE	  	: return 0x05;
		case MEM_SIM	    	: return 0x06;
		case MEM_SIM_OWN	: return 0x17;
		case MEM_PHONE_SMS_LOGS	: return 0x27;
		default		 	: return 0x00;
	}
}

char *GSM_Phone_NDCT34::GetFrameID()
{
	return FrameID;
}

void GSM_Phone_NDCT34::SetFrameID(char *Id)
{
	FrameID = (char *)malloc(strlen((const char *)Id)+1);
	memcpy(FrameID,(const char *)Id,strlen((const char *)Id)+1);
}

GSM_Error GSM_Phone_NDCT34::EncodeEntryToPBK(unsignedstring *Buffer, GSM_PBKEntry *Entry, int *Number, GSM_PBK_Features *Features)
{
	GSM_PBKSubEntry	 *SubEntry;
	unsigned int	 i;
	int		 Type, Type2, Type3, MaxNum;
	int		 Name=1;//1-old name,2-last/first
	unsignedstring	 TempBuffer, TempBuffer2;
	BOOLEAN		 Avail;
	wchart		 Buff;

	SubEntry  = NULL;
	while (Entry->GetNext(&SubEntry)) {
		SubEntry->SetError = GSM_Return_Error(GSM_ERR_TOO_MANY_ENTRIES);
	}
	MaxNum = (*Number);
	(*Number) = 0;

	if (Features != NULL) {
		for (i=0;i<Features->Types.size();i++) {
			if (Features->Types.data()[i] == NPBK_NAME_LAST) {
				Name=2;
				break;
			}
		}
	}
	SubEntry  = NULL;
	while (Entry->GetNext(&SubEntry)) {
		if (SubEntry->GetType()==PBK_Text_Name_Last) {
			Buff.append(SubEntry->GetText(),UnicodeLength(SubEntry->GetText()));
		}	
	}
	SubEntry  = NULL;
	while (Entry->GetNext(&SubEntry)) {
		if (SubEntry->GetType()==PBK_Text_Name_First) {
			if (Buff.size()!=0) Buff.push_back(' ');
			Buff.append(SubEntry->GetText(),UnicodeLength(SubEntry->GetText()));
		}
	}
	if (Name==1) {
		if (Buff.size()!=0) {
			SubEntry  = NULL;
			while (Entry->GetNext(&SubEntry)) {
				if (SubEntry->GetType()==PBK_Text_Name_First) {
					SubEntry->SetError = GSM_Return_Error(GSM_ERR_NONE);
				}
				if (SubEntry->GetType()==PBK_Text_Name_Last) {
					SubEntry->SetError = GSM_Return_Error(GSM_ERR_NONE);
				}
			}

			if ((*Number)==MaxNum && MaxNum>0) return GSM_Return_Error(GSM_ERR_NONE);

			TempBuffer.clear();
			TempBuffer.push_back(((Buff.length()+1)*2)%256);
			NokiaSetUnicodeString(Buff.data(),&TempBuffer);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);

			Buffer->push_back(NPBK_NAME);
			Buffer->push_back(0x00);
			Buffer->push_back((TempBuffer.size()+6) / 256);
			Buffer->push_back((TempBuffer.size()+6) % 256);
			Buffer->push_back(++(*Number));
			Buffer->append((const unsigned char*)TempBuffer.data(),TempBuffer.size());
			Buffer->push_back(0x00);
			Name=0;
		}
	} else if (Name==2) {
		if (Buff.size()==0) {
			SubEntry = NULL;
			while (Entry->GetNext(&SubEntry)) {
				if (SubEntry->GetType()!=PBK_Text_Name) continue;

				if ((*Number)==MaxNum && MaxNum>0) return GSM_Return_Error(GSM_ERR_NONE);

				TempBuffer.clear();
				TempBuffer.push_back(((UnicodeLength(SubEntry->GetText())+1)*2)%256);
				NokiaSetUnicodeString(SubEntry->GetText(),&TempBuffer);
				TempBuffer.push_back(0x00);
				TempBuffer.push_back(0x00);
				TempBuffer.push_back(0x00);

				SubEntry->SetError = GSM_Return_Error(GSM_ERR_NONE);
				Buffer->push_back(NPBK_NAME_LAST);
				Buffer->push_back(0x00);
				Buffer->push_back((TempBuffer.size()+6) / 256);
				Buffer->push_back((TempBuffer.size()+6) % 256);
				Buffer->push_back(++(*Number));
				Buffer->append((const unsigned char*)TempBuffer.data(),TempBuffer.size());
				Buffer->push_back(0x00);
			}
			Name=0;
		}
	}

	SubEntry  = NULL;
	while (Entry->GetNext(&SubEntry)) {
		TempBuffer.clear();
		Type = 0x00;
		Type3 = NPBK_NOTE;

		switch (SubEntry->GetType()) {
		case PBK_Text_Phone_General:
			Type = NPBK_NUMBER_GENERAL; //no break
		case PBK_Text_Phone_Mobile:
			if (Type == 0x00) Type = NPBK_NUMBER_MOBILE; //no break
		case PBK_Text_Phone_Home:
			if (Type == 0x00) Type = NPBK_NUMBER_HOME; //no break
		case PBK_Text_Phone_Work:
			if (Type == 0x00) Type = NPBK_NUMBER_WORK; //no break
		case PBK_Text_Phone_Fax:
			if (Type == 0x00) Type = NPBK_NUMBER_FAX;
			Type2 = NPBK_NUMBER;
			Type3 = 0x00;
			TempBuffer.push_back(Type);
			TempBuffer.push_back(0x00);
			SubEntry->VoiceTagSetError = GSM_Return_Error(GSM_ERR_NONE);
			if (SubEntry->VoiceTag != -1) {
				SubEntry->VoiceTagSetError = GSM_Return_Error(GSM_ERR_NONE);
				Avail = FALSE;
				for (i=0;i<Features->Types.size();i++) {
					if (Features->Types.data()[i] == NPBK_VOICETAG_ID) {
						Avail = TRUE;
						break;
					}
				}
				if (Avail) {
					TempBuffer.push_back(0x00);
				} else {
					//check for 7110 and don't allow
					SubEntry->VoiceTagSetError = GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
					TempBuffer.push_back(SubEntry->VoiceTag); //voice tag in dct3
				}
			} else {
				TempBuffer.push_back(0x00);
			}
			TempBuffer.push_back(((UnicodeLength(SubEntry->GetText())+1)*2)/256);
			TempBuffer.push_back(((UnicodeLength(SubEntry->GetText())+1)*2)%256);
			NokiaSetUnicodeString(SubEntry->GetText(),&TempBuffer);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);
			if (SubEntry->VoiceTag != -1 && Avail) {
				SubEntry->SetError = GSM_Return_Error(GSM_ERR_NONE);
				Avail = FALSE;
				for (i=0;i<Features->Types.size();i++) {
					if (Features->Types.data()[i] == Type2) {
						Avail = TRUE;
						break;
					}
				}
				if (!Avail) {
					SubEntry->SetError = GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
					TempBuffer.clear();
					break;
				}
				if ((*Number)==MaxNum && MaxNum>0) return GSM_Return_Error(GSM_ERR_NONE);
				Buffer->push_back(Type2);
				Buffer->push_back(0x00);
				Buffer->push_back((TempBuffer.size()+6) / 256);
				Buffer->push_back((TempBuffer.size()+6) % 256);
				Buffer->push_back(++(*Number));
				Buffer->append((const unsigned char*)TempBuffer.data(),TempBuffer.size());
				Buffer->push_back(0x00);
				TempBuffer.clear();

				if ((*Number)==MaxNum && MaxNum>0) return GSM_Return_Error(GSM_ERR_NONE);
				Buffer->push_back(NPBK_VOICETAG_ID);
				Buffer->push_back(0x00);
				Buffer->push_back((2+6) / 256);
				Buffer->push_back((2+6) % 256);
				Buffer->push_back(0x00); //additional byte (other than in normal block)
				Buffer->push_back((*Number)++);
				Buffer->push_back(SubEntry->VoiceTag/256);//block byte 1
				Buffer->push_back(SubEntry->VoiceTag%256);//block byte 2 - voice tag
			}
			if (SubEntry->SMSLists.length() != 0) {
			}
			break;		  
		case PBK_Text_Postal:
		case PBK_Text_Postal_Street:
		case PBK_Text_Postal_City:
		case PBK_Text_Postal_State:
		case PBK_Text_Postal_ZIP_Code:
		case PBK_Text_Postal_Country:
			break;
		case PBK_Text_Email:
			if (Type == 0x00) Type = NPBK_EMAIL; //no break
		case PBK_Text_URL:
			if (Type == 0x00) Type = NPBK_URL; //no break
		case PBK_Text_UserID:
			if (Type == 0x00) Type = NPBK_USER_ID; //no break
		case PBK_Text_Note:
			if (Type == 0x00) Type = NPBK_NOTE; //no break
		case PBK_Text_Name:
			if (Type == 0x00) {
				Type = NPBK_NAME; //no break
				if (Name!=1) break;
			}
		case PBK_Text_Name_First:
			if (Type == 0x00) {
				Type = NPBK_NAME_FIRST; //no break
				if (Name!=2) break;
			}
		case PBK_Text_Name_Last:
			if (Type == 0x00) {
				Type = NPBK_NAME_LAST; //no break
				if (Name!=2) break;
			}
		case PBK_Text_PTT:
			if (Type == 0x00) Type = NPBK_PUSHTOTALK_ID; //no break
			Type2 = Type;
			TempBuffer.push_back(((UnicodeLength(SubEntry->GetText())+1)*2)%256);
			NokiaSetUnicodeString(SubEntry->GetText(),&TempBuffer);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);
			break;
		case PBK_ID_Picture:
			Type2 = NPBK_PICTURE_ID;
			SubEntry->SetError = GSM_Return_Error(GSM_ERR_NONE);
			Avail = FALSE;
			for (i=0;i<Features->Types.size();i++) {
				if (Features->Types.data()[i] == Type2) {
					Avail = TRUE;
					break;
				}
			}
			if (!Avail) {
				SubEntry->SetError = GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
				TempBuffer.clear();
				break;
			}
			if ((*Number)==MaxNum && MaxNum>0) return GSM_Return_Error(GSM_ERR_NONE);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(SubEntry->LongValue / (256*256*256));
			TempBuffer.push_back(SubEntry->LongValue / (256*256));
			TempBuffer.push_back(SubEntry->LongValue / 256);
			TempBuffer.push_back(SubEntry->LongValue % 256);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);
			Buffer->push_back(Type2);
			Buffer->push_back(0x00);
			Buffer->push_back((TempBuffer.size()+6) / 256);
			Buffer->push_back((TempBuffer.size()+6) % 256);
			Buffer->push_back(++(*Number));
			Buffer->append((const unsigned char*)TempBuffer.data(),TempBuffer.size());
			Buffer->push_back(0x01);//difference from normal block
			TempBuffer.clear();			
			break;
		case PBK_ID_Ringtone:
			Avail = FALSE;
			for (i=0;i<Features->Types.size();i++) {
				if (Features->Types.data()[i] == NPBK_RINGTONEFILE_ID) {
					Avail = TRUE;
					break;
				}
			}
			if (Avail) {
				//FIXME: add
				break;
			}
			Avail = FALSE;
			for (i=0;i<Features->Types.size();i++) {
				if (Features->Types.data()[i] == NPBK_RINGTONE_ID) {
					Avail = TRUE;
					break;
				}
			}
			if (!Avail) {
			}
//			entry->Entries[i].AddError = ERR_NONE;
//			string[0] = 0x00;
//			string[1] = 0x00;
//			string[2] = entry->Entries[i].Number;
//			count += N71_65_PackPBKBlock(s, N7110_PBK_RINGTONE_ID, 3, block++, string, req + count);
//			count --;
//			req[count-5] = 8;
			break;
		case PBK_ID_Caller_Group:
			SubEntry->SetError = GSM_Return_Error(GSM_ERR_NONE);
			Avail = FALSE;
			for (i=0;i<Features->Types.size();i++) {
				if (Features->Types.data()[i] == NPBK_GROUP2_ID) {
					Avail = TRUE;
					break;
				}
			}
			if (Avail) {
				if ((*Number)==MaxNum && MaxNum>0) return GSM_Return_Error(GSM_ERR_NONE);
				TempBuffer.push_back(0x00);
				TempBuffer.push_back(0x00);
				Buffer->push_back(NPBK_GROUP2_ID);
				Buffer->push_back(0x00);
				Buffer->push_back((TempBuffer.size()+6) / 256);
				Buffer->push_back((TempBuffer.size()+6) % 256);
				Buffer->push_back(++(*Number));
				Buffer->append((const unsigned char*)TempBuffer.data(),TempBuffer.size());
				Buffer->push_back(SubEntry->LongValue%256);//difference from normal block
				TempBuffer.clear();			
				break;
			}
			Type2 = NPBK_GROUP_ID;
			Type3 = 0x00;
			TempBuffer.push_back(SubEntry->LongValue%256);
			TempBuffer.push_back(0x00);
			break;
		default:
			return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		}

		if (TempBuffer.size() != 0) {
			SubEntry->SetError = GSM_Return_Error(GSM_ERR_NONE);
			Avail = FALSE;
			for (i=0;i<Features->Types.size();i++) {
				if (Features->Types.data()[i] == Type2) {
					Avail = TRUE;
					break;
				}
			}
			//we check, if we can convert it to other
			if (!Avail && Type != 0x00) {
				Type2 = Type3;
				if (Features->Types.data()[i] == Type2) {
					Avail = TRUE;
					break;
				}
			}
			if (!Avail) {
				SubEntry->SetError = GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
				continue;
			}
			if ((*Number)==MaxNum && MaxNum>0) return GSM_Return_Error(GSM_ERR_NONE);
			Buffer->push_back(Type2);
			Buffer->push_back(0x00);
			Buffer->push_back((TempBuffer.size()+6) / 256);
			Buffer->push_back((TempBuffer.size()+6) % 256);
			Buffer->push_back(++(*Number));
			Buffer->append((const unsigned char*)TempBuffer.data(),TempBuffer.size());
			Buffer->push_back(0x00);
		}
	}

	//---------------------- address entries ------------------------------
	Avail = TRUE;
	if (Features != NULL) {
		Avail = FALSE;
		for (i=0;i<Features->Types.size();i++) {
			if (Features->Types.data()[i] == NPBK_POSTAL2) {
				Avail = TRUE;
				break;
			}
		}
	}
//	Avail = FALSE;
	i = 0;
	SubEntry  = NULL;
	while (Entry->GetNext(&SubEntry)) {
		Type = 0x00;
		TempBuffer.clear();
		switch (SubEntry->GetType()) {
		case PBK_Text_Postal:
			Type = NPBK_POSTAL2_ADDRESS;
			break;
		case PBK_Text_Postal_Street:
			Type = NPBK_POSTAL2_STREET;
			break;
		case PBK_Text_Postal_City:
			Type = NPBK_POSTAL2_CITY;
			break;
		case PBK_Text_Postal_State:
			Type = NPBK_POSTAL2_STATE;
			break;
		case PBK_Text_Postal_ZIP_Code:
			Type = NPBK_POSTAL2_ZIPCODE;
			break;
		case PBK_Text_Postal_Country:
			Type = NPBK_POSTAL2_COUNTRY;
		default:
			break;
		}

		if (Type == 0) continue;

		if (Avail) {
			SubEntry->SetError = GSM_Return_Error(GSM_ERR_NONE);
			i++;

			TempBuffer.push_back(0x07);
			TempBuffer.push_back(((UnicodeLength(SubEntry->GetText())+1)*2)%256);
			NokiaSetUnicodeString(SubEntry->GetText(),&TempBuffer);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);

			TempBuffer2.push_back(Type);
			TempBuffer2.push_back(0x00);
			TempBuffer2.push_back((TempBuffer.size()+4) / 256);
			TempBuffer2.push_back((TempBuffer.size()+4) % 256);
			TempBuffer2.append((const unsigned char*)TempBuffer.data(),TempBuffer.size());
		} else {
			if ((*Number)==MaxNum && MaxNum>0) return GSM_Return_Error(GSM_ERR_NONE);

			if (Type == NPBK_POSTAL2_ADDRESS) {
				SubEntry->SetError = GSM_Return_Error(GSM_ERR_NONE);
				Type = NPBK_POSTAL;
			} else {
				SubEntry->SetError = GSM_Return_Error(GSM_ERR_CONVERTED);
				Type = NPBK_NOTE;
			}
			TempBuffer.push_back(((UnicodeLength(SubEntry->GetText())+1)*2)%256);
			NokiaSetUnicodeString(SubEntry->GetText(),&TempBuffer);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);
			TempBuffer.push_back(0x00);

			Buffer->push_back(Type);
			Buffer->push_back(0x00);
			Buffer->push_back((TempBuffer.size()+6) / 256);
			Buffer->push_back((TempBuffer.size()+6) % 256);
			Buffer->push_back(++(*Number));
			Buffer->append((const unsigned char*)TempBuffer.data(),TempBuffer.size());
			Buffer->push_back(0x00);
		}

	}
	if (Avail && i!=0) {
		if ((*Number)==MaxNum && MaxNum>0) return GSM_Return_Error(GSM_ERR_NONE);

		TempBuffer.clear();
		TempBuffer.push_back(0x00);
		TempBuffer.push_back(i);

		Buffer->push_back(NPBK_POSTAL2);
		Buffer->push_back(0x00);
		Buffer->push_back((TempBuffer.size()+6) / 256);
		Buffer->push_back((TempBuffer.size()+6) % 256);
		Buffer->push_back(++(*Number));
		Buffer->push_back(0x00);
		Buffer->append((const unsigned char*)TempBuffer.data(),TempBuffer.size());

		Buffer->append((const unsigned char*)TempBuffer2.data(),TempBuffer2.size());
	}

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::DecodePBKToEntry(const unsigned char *Buffer, GSM_PBKEntry *Entry)
{
	int		     	i, j, Pos = 1,Num;
	GSM_PBK_SubEntryType    Type;
	GSM_PBKSubEntry 	*SubEntry,*PrevSubEntry=NULL;
	BOOLEAN			Found,LastFirst=FALSE;
	unsignedint		Nums;

	(*Debug)->Deb("  %i blocks\n",Buffer[0]);
	for (i=0;i<Buffer[0];i++) {
		(*Debug)->Deb("    Block length %i, type %02X\n",Buffer[Pos+2]*256+Buffer[Pos+3],Buffer[Pos]);
		Type = PBK_Not_Assigned;

		switch (Buffer[Pos]) {
		case NPBK_NUMBER:
			switch (Buffer[Pos+5]) {
			case NPBK_NUMBER_UNKNOWN1:
			case NPBK_NUMBER_UNKNOWN2:
			case NPBK_NUMBER_UNKNOWN3:
			case NPBK_NUMBER_GENERAL:
			case NPBK_NUMBER_BUG:
				Type = PBK_Text_Phone_General;
				(*Debug)->Deb("      General number");
				break;
			case NPBK_NUMBER_MOBILE:
				Type = PBK_Text_Phone_Mobile;
				(*Debug)->Deb("      Mobile number");
				break;
			case NPBK_NUMBER_HOME:
				Type = PBK_Text_Phone_Home;
				(*Debug)->Deb("      Home number");
				break;
			case NPBK_NUMBER_WORK:
				Type = PBK_Text_Phone_Work;
				(*Debug)->Deb("      Work number");
				break;
			case NPBK_NUMBER_FAX:
				Type = PBK_Text_Phone_Fax;
				(*Debug)->Deb("      Fax number");
				break;
			default:
				(*Debug)->Deb("      Unknown number \"%s\"\n",UnicodeToStringReturn(NokiaGetUnicodeString(Buffer+Pos+10)));
				return GSM_Return_Error(GSM_ERR_UNKNOWN);
			}
			(*Debug)->Deb(" \"%s\"\n",UnicodeToStringReturn(NokiaGetUnicodeString(Buffer+Pos+10)));
			Entry->AddText(Type, NokiaGetUnicodeString(Buffer+Pos+10));
			Nums.push_back(i);

			/* ID for voice tags in DCT3 phones like 6210 */
			if (Buffer[Pos+7] != 0) {
				SubEntry = NULL;
				while (Entry->GetNext(&SubEntry)) {
					if (SubEntry->GetNext()==NULL) {
						SubEntry->VoiceTag = Buffer[Pos+7];
					}
				}
			}
			break;
		case NPBK_NOTE:
			if (Type == PBK_Not_Assigned) {
				Type = PBK_Text_Note;
				(*Debug)->Deb("      Text note");
			}
		case NPBK_POSTAL: //no break;
			if (Type == PBK_Not_Assigned) {
				Type = PBK_Text_Postal;
				(*Debug)->Deb("      Postal");
			}
		case NPBK_EMAIL: // no break;
			if (Type == PBK_Not_Assigned) {
				Type = PBK_Text_Email;
				(*Debug)->Deb("      Email");
			}
		case NPBK_NAME: // no break;
			if (Type == PBK_Not_Assigned) {
				(*Debug)->Deb("      Name\n");
				break;
			}
		case NPBK_NAME_FIRST: // no break;
			if (Type == PBK_Not_Assigned) {
				LastFirst = TRUE;
				Type = PBK_Text_Name_First;
				(*Debug)->Deb("      First name\n");
			}
		case NPBK_NAME_LAST: // no break;
			if (Type == PBK_Not_Assigned) {
				LastFirst = TRUE;
				Type = PBK_Text_Name_Last;
				(*Debug)->Deb("      Last name\n");
			}
		case NPBK_URL: // no break;
			if (Type == PBK_Not_Assigned) {
				Type = PBK_Text_URL;
				(*Debug)->Deb("      URL");
			}
		case NPBK_PUSHTOTALK_ID: //no break
			if (Type == PBK_Not_Assigned) {
				Type = PBK_Text_PTT;
				(*Debug)->Deb("      Push To Talk");
			}
		case NPBK_USER_ID: // no break;
			if (Type == PBK_Not_Assigned) {
				Type = PBK_Text_UserID;
				(*Debug)->Deb("      User ID");
			}
			(*Debug)->Deb(" \"%s\"\n",UnicodeToStringReturn(NokiaGetUnicodeString(Buffer+Pos+6)));
			Entry->AddText(Type, NokiaGetUnicodeString(Buffer+Pos+6));
			Nums.push_back(i);
			break;
		case NPBK_POSTAL2:
			Num = Buffer[Pos+7];
			for (j=0;j<Num;j++) {
				Pos+=Buffer[Pos+2]*256+Buffer[Pos+3];
				Type = PBK_Not_Assigned;
				switch (Buffer[Pos]) {
				case NPBK_POSTAL2_ADDRESS: //no break
					if (Type == PBK_Not_Assigned) {
						Type = PBK_Text_Postal;
						(*Debug)->Deb("      Address");
					}
				case NPBK_POSTAL2_STREET: //no break
					if (Type == PBK_Not_Assigned)  {
						Type = PBK_Text_Postal_Street;
						(*Debug)->Deb("      Street");
					}
				case NPBK_POSTAL2_CITY: //no break
					if (Type == PBK_Not_Assigned) {
						Type = PBK_Text_Postal_City;
						(*Debug)->Deb("      City");
					}
				case NPBK_POSTAL2_STATE: //no break
					if (Type == PBK_Not_Assigned)   {
						Type = PBK_Text_Postal_State;
						(*Debug)->Deb("      State");
					}
				case NPBK_POSTAL2_ZIPCODE: //no break
					if (Type == PBK_Not_Assigned)  {
						Type = PBK_Text_Postal_ZIP_Code;
						(*Debug)->Deb("      ZIP code");
					}
				case NPBK_POSTAL2_COUNTRY: //no break
					if (Type == PBK_Not_Assigned) {
						Type = PBK_Text_Postal_Country;
						(*Debug)->Deb("      Country");
					}
				default: //no break
					if (Type == PBK_Not_Assigned) {
						(*Debug)->Deb("      Unknown adress \"%s\"\n",UnicodeToStringReturn(NokiaGetUnicodeString(Buffer+Pos+10)));
						return GSM_Return_Error(GSM_ERR_UNKNOWN);
					}
				}
				(*Debug)->Deb(" \"%s\"\n",UnicodeToStringReturn(NokiaGetUnicodeString(Buffer+Pos+6)));
				Entry->AddText(Type, NokiaGetUnicodeString(Buffer+Pos+6));
				Nums.push_back(i);
			}
			break;
		case NPBK_DATETIME:
			(*Debug)->Deb("      DateTime\n");
			Entry->AddDateTime(PBK_DateTime_Call_Length, *NokiaGetDT(Buffer+Pos+6));
			Nums.push_back(i);
			break;
		case NPBK_CALL_LENGTH:
			(*Debug)->Deb("      Call length\n");
			Found = FALSE;
			SubEntry = NULL;
			while (Entry->GetNext(&SubEntry) == TRUE) {
				switch (SubEntry->GetType()) {
				case PBK_DateTime_Call_Length:
					if (SubEntry->CallLength != -1) {
						Found = TRUE;
						break;
					}
					PrevSubEntry = SubEntry;
				}
				if (Found) break;
			}
			PrevSubEntry->CallLength = Buffer[Pos+9]*256*256+Buffer[Pos+10]*256+Buffer[Pos+11];
			break;
		case NPBK_GROUP_ID:
			(*Debug)->Deb("      Caller group 1\n");
			if (Buffer[Pos+5]!=0) {
				Entry->AddLong(PBK_ID_Caller_Group, Buffer[Pos+5]);
				Nums.push_back(i);
			}
			break;
		case NPBK_GROUP2_ID:
			(*Debug)->Deb("      Caller group 2\n");
			Entry->AddLong(PBK_ID_Caller_Group, Buffer[Pos+7]);
			Nums.push_back(i);
			break;
		case NPBK_VOICETAG_ID:
			(*Debug)->Deb("      Voice tag ID %i for number %i\n",Buffer[Pos+6]*256+Buffer[Pos+7],Buffer[Pos+5]);
			SubEntry = NULL;
			j=0;
			while (true) {
				if (!Entry->GetNext(&SubEntry)) break;
				switch (SubEntry->GetType()) {
				case PBK_Text_Phone_General:
				case PBK_Text_Phone_Mobile:
				case PBK_Text_Phone_Home:
				case PBK_Text_Phone_Work:
				case PBK_Text_Phone_Fax:
					j++;
					break;
				default:
					break;
				}
				if (j==Buffer[Pos+5]) {
					SubEntry->VoiceTag = Buffer[Pos+6]*256+Buffer[Pos+7];
					break;
				}
			}
			break;
		case NPBK_PICTURE_ID:
			(*Debug)->Deb("      Picture ID\n");
			Entry->AddLong(PBK_ID_Picture, Buffer[Pos+8]*256*256*256+Buffer[Pos+9]*256*256+Buffer[Pos+10]*256+Buffer[Pos+11]);
			Nums.push_back(i);
			break;
		case NPBK_RINGTONE_ID:
			(*Debug)->Deb("      Ringtone ID\n");
			Entry->AddLong(PBK_ID_Ringtone, Buffer[Pos+7]);
			break;
		case NPBK_RINGTONEFILE_ID:
			(*Debug)->Deb("      Ringtone file ID (S40 3.0)\n");
			Entry->AddLong(PBK_ID_Ringtone, Buffer[Pos+10]*256+Buffer[Pos+11]);
			break;
		case NPBK_SMSLIST_ID:
//			smprintf(s, "Entry %i is assigned to SMS list %i\n",Block[5]-1,Block[9]);
//			i = 0;
//			while(entry->Entries[Block[5]-1].SMSList[i] != 0) i++;
//			entry->Entries[Block[5]-1].SMSList[i+1] = 0;
//			entry->Entries[Block[5]-1].SMSList[i]   = Block[9];

			(*Debug)->Deb("      SMS list ID (3510)\n");
			break;
		case NPBK_PUSHTOTALK_SUBSC:
			(*Debug)->Deb("      PTT subscription\n");
			if (Buffer[Pos+5] == 0x01) {
				Entry->AddBool(PBK_Bool_PTT_Subscribed, true);
			} else {
				Entry->AddBool(PBK_Bool_PTT_Subscribed, false);
			}
			Nums.push_back(i);
			break;
		//todo
		case NPBK_SIM_SPEEDDIAL:
			(*Debug)->Deb("      Speed dial\n");
			break;
		case NPBK_SPEEDDIAL:
			(*Debug)->Deb("      Speed dial\n");
			break;
		case NPBK_UNKNOWN1:
			(*Debug)->Deb("      Unknown 1\n");
			break;
		case NPBK_UNKNOWN2:
			(*Debug)->Deb("      Unknown 2\n");
			break;
		case NPBK_UNKNOWN3:
			(*Debug)->Deb("      Unknown 3\n");
			break;
		case NPBK_UNKNOWN4:
			(*Debug)->Deb("      Unknown 4\n");
			break;
		default:
			(*Debug)->Deb("      Unknown block\n");
			return GSM_Return_Error(GSM_ERR_UNKNOWN);
		}
		Pos+=Buffer[Pos+2]*256+Buffer[Pos+3];
	}
	if (!LastFirst) {
		(*Debug)->Deb("  Searching for name\n");

		Pos = 1;
		for (i=0;i<Buffer[0];i++) {
			(*Debug)->Deb("    Block length %i, type %02X\n",Buffer[Pos+2]*256+Buffer[Pos+3],Buffer[Pos]);
			Type = PBK_Not_Assigned;

			if (Buffer[Pos]==NPBK_NAME) {
				(*Debug)->Deb("      Name");
				(*Debug)->Deb(" \"%s\"\n",UnicodeToStringReturn(NokiaGetUnicodeString(Buffer+Pos+6)));
				Entry->AddText(PBK_Text_Name, NokiaGetUnicodeString(Buffer+Pos+6));
				break;
			}
			Pos+=Buffer[Pos+2]*256+Buffer[Pos+3];
		}
	}
	SubEntry = NULL;
	while (Entry->GetNext(&SubEntry) == TRUE) {
		if (SubEntry->GetType()!=PBK_DateTime_Call_Length) continue;
		if (SubEntry->CallLength == 0) SubEntry->CallLength=-1;
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::ReplyGetPBKFeatures(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_PBK_Features *Entry = (GSM_PBK_Features *)S;
	int 		 i,pos=6;

	Entry->Types.clear();
	for (i=0;i<msg->Buffer.data()[5]-1;i++) {
		Entry->Types.push_back(msg->Buffer.data()[pos+4]);
		pos+=msg->Buffer.data()[pos+3];
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::GetPBKFeatures(GSM_PBK_Features *Features)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x25, 
			        0x05, 	// memory type
			        0x00};

	Buff[4] = Get7110DCT4MemoryType(Features->Memory);
	if (Buff[4] == 0x00) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	(*Debug)->Deb("SENT: getting phonebook features\n");
	return (*Pho)->Write(Buff, sizeof(Buff), 0x03, 2, ID_GetPBK+ID, Features);
}

GSM_Error GSM_Phone_NDCT34::ReplySetPBK(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	if (msg->Buffer.data()[6] == 0x0F) {
		(*Debug)->Deb("RECEIVED: error setting PBK entry");
		switch (msg->Buffer.data()[10]) {
		case 0x25:
			(*Debug)->Deb(", you try to save into entry with caller group assigment in phone with caller groups standard 2 (like in 6230i)\n");
			return GSM_Return_Error(GSM_ERR_FILE_EXIST);
		case 0x29:
//			smprintf(s, "no caller group with given number (6230i)\n");
//			return ERR_MEMORY;
		case 0x36:
			(*Debug)->Deb(", too long text in subentry\n");
			return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		case 0x3C:
			(*Debug)->Deb(", 0 subentries\n");
			return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		case 0x3d:
			(*Debug)->Deb(", unknown subentry type\n");
			return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		case 0x3e:
			(*Debug)->Deb(", too much subentries\n");
			return GSM_Return_Error(GSM_ERR_TOO_MANY_ENTRIES);
		default:
			(*Debug)->Deb(", code %02X\n",msg->Buffer.data()[10]);
			return GSM_Return_Error(GSM_ERR_UNKNOWN);
		}
	}

	(*Debug)->Deb("RECEIVED: PBK entry set OK\n");
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::ReplyDelPBK(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::ReplyGetCalendarInfo1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_Cal_Loc     *CalendarLocations = (GSM_Cal_Loc *)S;
	int	     i;

	(*Debug)->Deb("RECEIVED: calendar entries info method 1\n");

	if (CalendarLocations->Locations.size()==0) {
		CalendarLocations->Length = msg->Buffer.data()[4]*256 + msg->Buffer.data()[5];
		(*Debug)->Deb("   Entries in phone: %i\n",CalendarLocations->Length);
	}

	(*Debug)->Deb("   Entries in frame: %i\n",msg->Buffer.data()[6]);

	for (i=0;i<msg->Buffer.data()[6];i++) {
		CalendarLocations->Locations.push_back(msg->Buffer.data()[8+(i*2)]*256+msg->Buffer.data()[9+(i*2)]);
	}

	if (msg->Buffer.data()[6] == 1 && msg->Buffer.data()[8+(0*2)]*256+msg->Buffer.data()[9+(0*2)] == 0) {
		return GSM_Return_Error(GSM_ERR_EMPTY);
	}
	if (msg->Buffer.data()[6] == 0) return GSM_Return_Error(GSM_ERR_EMPTY);

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::GetCalendarInfo1()
{
	GSM_Error       error;
	unsigned char   Buff[] = {
		NOKIA_FRAME1, 0x3A,
		0xFF, 0xFE};	    // first location number

	CalendarLocations.Locations.clear();
	CalendarLocations.Length = 0;

	while (1) {     
		if (CalendarLocations.Locations.size() > 0) {
			Buff[4] = CalendarLocations.Locations.data()[CalendarLocations.Locations.size()-1] / 256;
			Buff[5] = CalendarLocations.Locations.data()[CalendarLocations.Locations.size()-1] % 256;
		}

		(*Debug)->Deb("SENT: getting locations for calendar method 1\n");
		error = (*Pho)->Write(Buff, sizeof(Buff), 0x13, 4, ID_GetCalendarInfo+ID,&CalendarLocations);
		if (error.Code != GSM_ERR_NONE && error.Code != GSM_ERR_EMPTY) return error;

		if (CalendarLocations.Locations.length()==CalendarLocations.Length) {
			return GSM_Return_Error(GSM_ERR_NONE);
		} else {
			if (error.Code == GSM_ERR_EMPTY) {
				CalendarLocations.Length = CalendarLocations.Locations.length();
				return GSM_Return_Error(GSM_ERR_NONE);
			}
		}
	}
}

GSM_Error GSM_Phone_NDCT34::ReplyGetNextCalendar1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	time_t			  	timet;
	struct tm		       	tmstruct;
	GSM_DateTime		    	DT;
	GSM_CalendarEntry	       	*Calendar = (GSM_CalendarEntry *)S;
	int			     	Alarm = 0xffff; //no alarm
	GSM_Calendar_SubEntryType       AlarmType = Calendar_DateTime_ToneAlarm;

	(*Debug)->Deb("RECEIVED: calendar entry method 1\n");

	switch(msg->Buffer.data()[6]) {
	case 0x01:
		(*Debug)->Deb("   meeting\n");
		Calendar->Type = Calendar_Type_Meeting;
		break;
	case 0x02:
		(*Debug)->Deb("   call\n");
		Calendar->Type = Calendar_Type_Call;
		break;
	case 0x04:
		(*Debug)->Deb("   birthday\n");
		Calendar->Type = Calendar_Type_Birthday;
		break;
	case 0x08:
		(*Debug)->Deb("   memo\n");
		Calendar->Type = Calendar_Type_Memo;
		break;
	default:
		return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}

	memcpy(&DT,NokiaGetDT(msg->Buffer.data()+8),sizeof(GSM_DateTime));
	if (Calendar->Type == Calendar_Type_Birthday) {
		DT.Year = msg->Buffer.data()[18]*256 + msg->Buffer.data()[19];
		if (DT.Year == 0xFFFF) DT.Year = 0;
		DT.Hour	   = 23;
		DT.Minute	 = 59;
		DT.Second	 = 58;
	} else {
		if (Calendar->Type == Calendar_Type_Memo) {
			DT.Hour   = 0;
			DT.Minute = 0;
		}
		DT.Second	 = 0;
	}
	(*Debug)->Deb("   Start date time: %02i-%02i-%04i %02i:%02i:%02i\n",
			DT.Day,DT.Month,DT.Year,DT.Hour,DT.Minute,DT.Second);
	Calendar->AddDateTime(Calendar_DateTime_Start, DT);

	switch (Calendar->Type) {
	case Calendar_Type_Memo:
		NokiaGetCalendarRecurranceRepeat(*Debug,Calendar, msg->Buffer.data()+12,NULL);
		if (msg->Buffer.data()[14] != 0) {
			Calendar->AddText(Calendar_Text_Text, NokiaGetUnicodeSimple(msg->Buffer.data()+16,msg->Buffer.data()[14]));
		}
		break;
	case Calendar_Type_Birthday:
		Calendar->AddInt(Calendar_Int_Repeat_Frequency, 1);
		Calendar->AddInt(Calendar_Int_Repeat_Day, DT.Day);
		Calendar->AddInt(Calendar_Int_Repeat_Month, DT.Month);
		if (msg->Buffer.data()[21] != 0) {
			Calendar->AddText(Calendar_Text_Text, NokiaGetUnicodeSimple(msg->Buffer.data()+22,msg->Buffer.data()[21]));
		}
		Alarm = msg->Buffer.data()[14]*256*256*256+msg->Buffer.data()[15]*256*256;
		Alarm += msg->Buffer.data()[16]*256+msg->Buffer.data()[17];
		if (msg->Buffer.data()[20] != 0) AlarmType = Calendar_DateTime_SilentAlarm;
		break;
	case Calendar_Type_Meeting:
		NokiaGetCalendarRecurranceRepeat(*Debug,Calendar, msg->Buffer.data()+16,NULL);
		if (msg->Buffer.data()[18] != 0) {
			Calendar->AddText(Calendar_Text_Text, NokiaGetUnicodeSimple(msg->Buffer.data()+20,msg->Buffer.data()[18]));
		}
		Alarm = msg->Buffer.data()[14]*256+msg->Buffer.data()[15];
		break;
	case Calendar_Type_Call:
		NokiaGetCalendarRecurranceRepeat(*Debug,Calendar, msg->Buffer.data()+16,NULL);
		if (msg->Buffer.data()[18] != 0) {
			Calendar->AddText(Calendar_Text_Text, NokiaGetUnicodeSimple(msg->Buffer.data()+20,msg->Buffer.data()[18]));
		}
		if (msg->Buffer.data()[19] != 0) {
			Calendar->AddText(Calendar_Text_Phone, NokiaGetUnicodeSimple(msg->Buffer.data()+20+msg->Buffer.data()[18]*2,msg->Buffer.data()[19]));
		}
		Alarm = msg->Buffer.data()[14]*256+msg->Buffer.data()[15];
		break;
	default:
		break;
	}

	if (Alarm == 0xffff) return GSM_Return_Error(GSM_ERR_NONE);

	(*Debug)->Deb("   Alarm difference : %i\n",Alarm);

	if (Calendar->Type == Calendar_Type_Birthday) DT.Year = 2000;

	timet = GSMDateTime2TimeT(&DT);

	if (Calendar->Type == Calendar_Type_Birthday) timet -= Alarm;
	if (Calendar->Type == Calendar_Type_Meeting ||
	    Calendar->Type == Calendar_Type_Call) {
		timet -= 60*Alarm;
	}

	memcpy(&tmstruct,localtime(&timet),sizeof(struct tm));
	DT.Year	 	= tmstruct.tm_year + 1900;
	DT.Month	= tmstruct.tm_mon+1;
	DT.Day	  	= tmstruct.tm_mday;
	DT.Hour	 	= tmstruct.tm_hour;
	DT.Minute       = tmstruct.tm_min;
	DT.Second       = tmstruct.tm_sec;

	(*Debug)->Deb("   Alarm : %02i-%02i-%04i %02i:%02i:%02i\n",
			DT.Day,DT.Month,DT.Year,DT.Hour,DT.Minute,DT.Second);
	Calendar->AddDateTime(AlarmType, DT);

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::GetNextCalendar1(GSM_CalendarEntry *Entry, BOOLEAN start, int *Current, int *Max)
{
	GSM_Error	       error;
	unsigned char	   Buff[] = {
		NOKIA_FRAME1, 0x19,
		0x00, 0x00};	    // location

	if (start == TRUE) {
		error = GetCalendarInfo1();
		if (error.Code != GSM_ERR_NONE) return error;
		CurrentCalendarNumber = 0;
	}

	Entry->ClearAll();

	if (CurrentCalendarNumber >= CalendarLocations.Length) {
		CalendarLocations.Locations.clear();
		return GSM_Return_Error(GSM_ERR_EMPTY);
	}

	Entry->Location = CalendarLocations.Locations.data()[CurrentCalendarNumber];

	Buff[4] = Entry->Location / 256;
	Buff[5] = Entry->Location % 256;

	CurrentCalendarNumber++;

	*Current = CurrentCalendarNumber;
	*Max = CalendarLocations.Length;

	(*Debug)->Deb("SENT: getting calendar note method 1\n");
	return (*Pho)->Write(Buff, sizeof(Buff), 0x13, 4, ID_GetCalendar+ID,Entry);
}

GSM_Error GSM_Phone_NDCT34::ReplyGetFirstCalPos1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	int *Location = (int *)S;

	(*Debug)->Deb("RECEIVED: first free calendar location (method 1) is %i\n",msg->Buffer.data()[4]*256 + msg->Buffer.data()[5]);
	*Location = msg->Buffer.data()[4]*256 + msg->Buffer.data()[5];
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::GetFirstCalendarPos1(int *Location)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x31};

	(*Debug)->Deb("SENT: Getting first free calendar note location (method 1)\n");
	return (*Pho)->Write(Buff, sizeof(Buff), 0x13, 2, ID_GetFirstCalendarPos+ID, Location);
}

GSM_Error GSM_Phone_NDCT34::ReplyAddCalendar1(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::AddCalendar1(GSM_CalendarEntry *Entry)
{
	GSM_Error	       	error;
	time_t		  	timet1, timet2;
	unsignedstring	  	Buffer;
	GSM_CalendarSubEntry    *SubEntry, *Text = NULL, *Location = NULL;
	GSM_CalendarSubEntry    *Phone = NULL, *DateStart = NULL, *Alarm = NULL;
	int     		Loc;
	unsigned char	   	NoteType, NoteType2,Buff[2];
	unsigned int	    	diff;

	SubEntry = NULL;
	while (Entry->GetNext(&SubEntry) == TRUE) {
		switch (SubEntry->GetType()) {
		case Calendar_Text_Text:
			Text = SubEntry;
			break;
		case Calendar_Text_Phone:
			Phone = SubEntry;
			break;
		case Calendar_Text_Location:
			Location = SubEntry;
			break;
		case Calendar_DateTime_Start:
			DateStart = SubEntry;
			break;
		case Calendar_DateTime_SilentAlarm:
		case Calendar_DateTime_ToneAlarm:
			Alarm = SubEntry;
			break;
		case Calendar_Int_Repeat_Frequency:
			SubEntry->GetInt();
			break;
		case Calendar_Int_Repeat_DayOfWeek:
			SubEntry->GetInt();
			break;
		case Calendar_Int_Repeat_Day:
			SubEntry->GetInt();
			break;
		case Calendar_Int_Repeat_Month:
			SubEntry->GetInt();
			break;
		}
	}

	if (DateStart == NULL) return GSM_Return_Error(GSM_ERR_UNKNOWN);
	
	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);

	switch(Entry->Type) {
	case Calendar_Type_Meeting:
		NoteType=0x01; NoteType2=0x01;
		break;
	case Calendar_Type_Memo:
		NoteType=0x07; NoteType2=0x08;
		break;
	case Calendar_Type_Call:
		NoteType=0x03; NoteType2=0x02;
		break;
	case Calendar_Type_Birthday:
		NoteType=0x05; NoteType2=0x04;
		break;
	default:
		return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
	}

	Buffer.push_back(NoteType);

	//location
	error = GetFirstCalendarPos1(&Loc);
	if (error.Code != GSM_ERR_NONE) return error;
	//for dct4 we set it
	if (strstr((*Pho)->ModuleName,"dct4") != NULL) {
		Buffer.push_back(Loc/256);
		Buffer.push_back(Loc%256);
	} else {
		Buffer.push_back(0);
		Buffer.push_back(0);
	}

	Buffer.push_back(NoteType2);
	Buffer.push_back(0x00);
	Buffer.push_back(DateStart->GetDateTime()->Year / 256);
	Buffer.push_back(DateStart->GetDateTime()->Year % 256);
	Buffer.push_back(DateStart->GetDateTime()->Month);
	Buffer.push_back(DateStart->GetDateTime()->Day);

	if (Alarm != NULL) {
		timet1  = GSMDateTime2TimeT(DateStart->GetDateTime());
		timet2  = GSMDateTime2TimeT(Alarm->GetDateTime());
		diff    = timet1 - timet2;
	}

	switch(Entry->Type) {
	case Calendar_Type_Meeting:
	case Calendar_Type_Call:
		Buffer.push_back(DateStart->GetDateTime()->Hour);
		Buffer.push_back(DateStart->GetDateTime()->Minute);

		//alarm
		if (Alarm == NULL) {
			Buffer.push_back(0xff);
			Buffer.push_back(0xff);
		} else {
			Buffer.push_back(diff /60 / 256);
			Buffer.push_back(diff /60 % 256);
		}

		//recurrance
		NokiaSetCalendarRecurranceRepeat(*Debug, Entry, Buff, NULL);
		Buffer.push_back(Buff[0]);
		Buffer.push_back(Buff[1]);
		
		if (Text != NULL) {
			Buffer.push_back(UnicodeLength(Text->GetText()));
		} else {
			Buffer.push_back(0);
		}
		if (Entry->Type==Calendar_Type_Call && Phone != NULL) {
			Buffer.push_back(UnicodeLength(Phone->GetText()));
		} else {
			Buffer.push_back(0);
		}
		if (Text != NULL) {
			NokiaSetUnicodeString(Text->GetText(),&Buffer);
		}
		if (Entry->Type==Calendar_Type_Call && Phone != NULL) {
			NokiaSetUnicodeString(Phone->GetText(),&Buffer);
		}
		break;
	case Calendar_Type_Memo:
		//recurrance
		NokiaSetCalendarRecurranceRepeat(*Debug, Entry, Buff, NULL);
		Buffer.push_back(Buff[0]);
		Buffer.push_back(Buff[1]);

		if (Text != NULL) {
			Buffer.push_back(UnicodeLength(Text->GetText()));
			Buffer.push_back(0);
			NokiaSetUnicodeString(Text->GetText(),&Buffer);
		} else {
			Buffer.push_back(0);
			Buffer.push_back(0);
		}

		break;
	case Calendar_Type_Birthday:
		Buffer.push_back(0);
		Buffer.push_back(0);

		if (Alarm == NULL) {
			Buffer.push_back(0);
			Buffer.push_back(0);
			Buffer.push_back(0xff);
			Buffer.push_back(0xff);
		} else {
			Buffer.push_back(diff / (256*256*256));
			Buffer.push_back(diff / (256*256));
			Buffer.push_back(diff / 256);
			Buffer.push_back(diff % 256);
		}
		if (Alarm != NULL && Alarm->GetType() == Calendar_DateTime_SilentAlarm) {
			Buffer.push_back(0x01);
		} else {
			Buffer.push_back(0);
		}
		if (Text != NULL) {
			Buffer.push_back(UnicodeLength(Text->GetText()));
			NokiaSetUnicodeString(Text->GetText(),&Buffer);
		} else {
			Buffer.push_back(0);
		}
		break;
	}

	Buffer.push_back(0);

	(*Debug)->Deb("SENT: Adding calendar note (method 1)\n");
	return (*Pho)->Write((unsigned char *)Buffer.data(), Buffer.size(), 0x13, 4, ID_AddCalendar+ID,Entry);
}

GSM_Error GSM_Phone_NDCT34::ReplyAddCalendar2(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::AddCalendar2(GSM_CalendarEntry *Entry)
{
	GSM_DateTime	    Date,Date2;
	time_t		  timet1, timet2;
	unsignedstring	  Buffer,Buffer2;
	GSM_CalendarSubEntry    *SubEntry, *Text = NULL, *Location = NULL;
	GSM_CalendarSubEntry    *Phone = NULL, *DateStart = NULL, *Alarm = NULL;
	unsigned int	    diff;
	GSM_Error	       error;
	unsigned char	   Buff[2];

	SubEntry = NULL;
	while (Entry->GetNext(&SubEntry) == TRUE) {
		switch (SubEntry->GetType()) {
		case Calendar_Text_Text:
			Text = SubEntry;
			break;
		case Calendar_Text_Phone:
			Phone = SubEntry;
			break;
		case Calendar_Text_Location:
			Location = SubEntry;
			break;
		case Calendar_DateTime_Start:
			DateStart = SubEntry;
			break;
		case Calendar_DateTime_SilentAlarm:
		case Calendar_DateTime_ToneAlarm:
			Alarm = SubEntry;
			break;
		case Calendar_Int_Repeat_Frequency:
			SubEntry->GetInt();
			break;
		case Calendar_Int_Repeat_DayOfWeek:
			SubEntry->GetInt();
			break;
		case Calendar_Int_Repeat_Day:
			SubEntry->GetInt();
			break;
		case Calendar_Int_Repeat_Month:
			SubEntry->GetInt();
			break;
		}
	}

	if (DateStart == NULL) return GSM_Return_Error(GSM_ERR_UNKNOWN);
	
	Buffer.push_back(0x00);
	Buffer.push_back(0x1);
	Buffer.push_back(0x00);
	Buffer.push_back(0x40);

	Buffer.push_back(0x40); //frame length - 7

	Buffer.push_back(0x00);
	Buffer.push_back(0x00);
	Buffer.push_back(0x00);
	Buffer.push_back(0x00);

	if (Entry->Type != Calendar_Type_Birthday) {
		Date.Year       = 2030; Date.Month      = 01; Date.Day    = 01;
		Date.Hour       = 00;   Date.Minute     = 00; Date.Second = 00;
	} else {
		Date.Year       = 2029; Date.Month      = 12; Date.Day    = 31;
		Date.Hour       = 22;   Date.Minute     = 59; Date.Second = 58;
	}
	timet1 = GSMDateTime2TimeT(&Date);
	memcpy(&Date,DateStart->GetDateTime(),sizeof(GSM_DateTime));
	if (Entry->Type != Calendar_Type_Birthday) {
		Date.Year -= 20;
	} else {
		/* 6230 and probably other new models handle it differently
		   we don't make difference from 1980 year */
		if ((*AllPhones)->Feature("cal62")==TRUE || (*AllPhones)->Feature("cal65")==TRUE ||
		    (*AllPhones)->Feature("cal35")==TRUE) {
			Date.Year = 1980;
		}
		Date.Hour = 22; Date.Minute = 58; Date.Second = 58;
	}
	timet2 = GSMDateTime2TimeT(&Date);
	diff  = timet2-timet1;
	Buffer.push_back(diff / (256*256*256));
	Buffer.push_back(diff / (256*256));
	Buffer.push_back(diff / 256);
	Buffer.push_back(diff % 256);

	//alarm diff
	if (Alarm != NULL) {
		if (Entry->Type == Calendar_Type_Birthday) {
			error = (*Pho)->GetDateTime(&Date2);
			switch (error.Code) {
				case GSM_ERR_EMPTY:
				case GSM_ERR_NOT_SUPPORTED:
					return error;
	//			      GSM_GetCurrentDateTime(&Date2);
					break;
				case GSM_ERR_NONE:
					break;
				default:
					return error;
			}
			Date.Year       = Date2.Year;
			Date.Hour       = 23;
			Date.Minute     = 59;
		} else {
			Date.Year += 20;
		}
		timet2  = GSMDateTime2TimeT(&Date);
		timet1  = GSMDateTime2TimeT(Alarm->GetDateTime());
		diff    = timet2-timet1;

		/* Sometimes we have difference in minutes */
		if (Entry->Type == Calendar_Type_Meeting) diff = diff / 60;
		if ((*AllPhones)->Feature("cal35")==FALSE) {
			if (Entry->Type == Calendar_Type_Memo ||
			    Entry->Type == Calendar_Type_Call) {
				diff = diff / 60;
			}
		}

		Buffer.push_back(diff / (256*256*256));
		Buffer.push_back(diff / (256*256));
		Buffer.push_back(diff / 256);
		Buffer.push_back(diff % 256);
	} else {
		Buffer.push_back(0x00);
		Buffer.push_back(0x00);
		Buffer.push_back(0xff);
		Buffer.push_back(0xff);
	}

	Buffer.push_back(0x40); //frame length - 7

	switch(Entry->Type) {
	case Calendar_Type_Meeting:
	case Calendar_Type_Reminder:
		if ((*AllPhones)->Feature("cal62")==TRUE || (*AllPhones)->Feature("cal65")==TRUE) {
			if (Entry->Type == Calendar_Type_Reminder) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		} else {
			if (Entry->Type == Calendar_Type_Meeting) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
		}
		Buffer.push_back(0x01);
		break;
	case Calendar_Type_Call:
		Buffer.push_back(0x02);
		break;
	case Calendar_Type_Birthday:
		Buffer.push_back(0x04);
		break;
	case Calendar_Type_Memo:
		Buffer.push_back(0x08);
		break;
	default:
		return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);
	}

	//recurrance
	NokiaSetCalendarRecurranceRepeat(*Debug, Entry, Buff, NULL);
	Buffer.push_back(Buff[0]);
	Buffer.push_back(Buff[1]);

	Buffer.push_back(0x00);
	Buffer.push_back(0x00);
	Buffer.push_back(0x00);
	Buffer.push_back(0x00);

	if (Entry->Type == Calendar_Type_Call) {
		if (Phone != NULL) {
			Buffer.push_back(UnicodeLength(Phone->GetText()));
		} else {
			Buffer.push_back(0);
		}
		if (Text != NULL) {
			Buffer.push_back(UnicodeLength(Text->GetText()));
		} else {
			Buffer.push_back(0);
		}
		if (Phone != NULL) {
			NokiaSetUnicodeString(Phone->GetText(),&Buffer);
		}
	} else if (Entry->Type == Calendar_Type_Birthday) {
		Buffer.push_back(DateStart->GetDateTime()->Year / 256);
		Buffer.push_back(DateStart->GetDateTime()->Year % 256);
		if (Alarm != NULL && Alarm->GetType() == Calendar_DateTime_SilentAlarm) {
			Buffer.push_back(0x01);
		} else {
			Buffer.push_back(0);
		}
		if (Text != NULL) {
			Buffer.push_back(UnicodeLength(Text->GetText()));
		} else {
			Buffer.push_back(0);
		}
	} else {
		if (Text != NULL) {
			Buffer.push_back(UnicodeLength(Text->GetText()));
		} else {
			Buffer.push_back(0);
		}
		Buffer.push_back(0x00);
	}

	if (Text != NULL) {
		NokiaSetUnicodeString(Text->GetText(),&Buffer);
	}

	Buffer.push_back(0x00);
	Buffer.push_back(0x00);

	Buffer2.push_back(Buffer.size()-7);
	Buffer.replace(4,1,Buffer2);
	Buffer.replace(17,1,Buffer2);

	(*Debug)->Deb("SENT: Adding calendar note (method 2)\n");
	return (*Pho)->Write((unsigned char *)Buffer.data(), Buffer.size(), 0x13, 4, ID_AddCalendar+ID,Entry);
}

GSM_Error GSM_Phone_NDCT34::ReplyDelCalendar(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT34::DeleteCalendar(GSM_CalendarEntry *Entry)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x0B, 
				0x00, 0x00};  //location

	Buff[4] = Entry->Location / 256;
	Buff[5] = Entry->Location % 256;

	(*Debug)->Deb("SENT: Deleting calendar entry\n");
	return (*Pho)->Write(Buff, sizeof(Buff), 0x13, 2, ID_DelCalendar+ID, NULL);
}

//-----------------------------------------------------------------------------

wchar_t *NokiaGetUnicodeString(const unsigned char *Buffer)
{
	static	  wchar_t dst[500];
	int	     pos=0;

	while (Buffer[pos*2] != 0 || Buffer[pos*2+1] != 0) {
		dst[pos] = Buffer[pos*2] * 256 + Buffer[pos*2+1];
		pos++;
	}
	dst[pos] = 0;
	return dst;
}

wchar_t *NokiaGetUnicodeSimple(const unsigned char *Buffer, int Len)
{
	static	  wchar_t dst[5000];
	int	     i;

	for (i=0;i<Len;i++) {
		dst[i] = Buffer[i*2] * 256 + Buffer[i*2+1];
	}
	dst[i] = 0;

	return dst;
}

int NokiaSetUnicodeString(const wchar_t *src, unsignedstring *Dest)
{
	int pos=0;

	while (src[pos] != 0) {
		Dest->push_back(src[pos] / 256);
		Dest->push_back(src[pos] % 256);
		pos++;
	}
	return pos;
}

GSM_DateTime *NokiaGetDT(const unsigned char *Buffer)
{
	static GSM_DateTime DT;

	DT.Year   = Buffer[0] * 256 + Buffer[1];
	DT.Month  = Buffer[2];
	DT.Day    = Buffer[3];
	DT.Hour   = Buffer[4];
	DT.Minute = Buffer[5];
	DT.Second = Buffer[6];

	return &DT;
}

// gets Recurrance/Repeat info from frame into Calendar structure
GSM_Error NokiaGetCalendarRecurranceRepeat(DebugInfo *Debug, GSM_CalendarEntry *Entry, const unsigned char *Buffer, const unsigned char *RepeatBuffer)
{
	time_t		  timet;
	struct tm	       tmstruct;
	int		     i, Repeat, Recurrance = Buffer[0]*256 + Buffer[1];
	GSM_CalendarSubEntry    *SubEntry;
	GSM_DateTime	    DT;

	if (Recurrance == 0) return GSM_Return_Error(GSM_ERR_NONE);
	Debug->Deb("Recurrance : %i hours\n",Recurrance);
	/* --------- Nokia related ----------------- */
	/* dct3 and dct4: 65535 is 1 year */
	if (Recurrance == 0xffff) Recurrance=24*365;
	/* dct3: unavailable, dct4: 65534 is 30 days (every month) */
	if (Recurrance == 0xffff-1) Recurrance=24*30;
	/* ----------------------------------------- */

	SubEntry = NULL;
	while (Entry->GetNext(&SubEntry) == TRUE) {
		if (SubEntry->GetType()==Calendar_DateTime_Start) break;
	}
	if (SubEntry == NULL || SubEntry->GetType()!=Calendar_DateTime_Start) return GSM_Return_Error(GSM_ERR_UNKNOWN);
	memcpy(&DT,SubEntry->GetDateTime(),sizeof(GSM_DateTime));

	//every day = freq to 1
	if (Recurrance == 24) {
		Entry->AddInt(Calendar_Int_Repeat_Frequency, 1);
	}
	//every week = freq to 1 & dayofweek to (weekday for start date)
	if (Recurrance == 24*7) {
		Entry->AddInt(Calendar_Int_Repeat_Frequency, 1);
		Entry->AddInt(Calendar_Int_Repeat_DayOfWeek, 
			DayOfWeek(DT.Year,DT.Month,DT.Day));
	}
	//every 2 weeks = freq to 2 & dayofweek to (weekday for start date)
	if (Recurrance == 24*14) {
		Entry->AddInt(Calendar_Int_Repeat_Frequency, 2);
		Entry->AddInt(Calendar_Int_Repeat_DayOfWeek, 
			DayOfWeek(DT.Year,DT.Month,DT.Day));
	}
	//every month = freq to 1 & day to (day for start date)
	if (Recurrance == 24*30) {
		Entry->AddInt(Calendar_Int_Repeat_Frequency, 1);
		Entry->AddInt(Calendar_Int_Repeat_Day, SubEntry->GetDateTime()->Day);
	}
	//every year = freq to 1 & day to (day for start date) & month to (month for start date)
	if (Recurrance == 24*365) {
		Entry->AddInt(Calendar_Int_Repeat_Frequency, 1);
		Entry->AddInt(Calendar_Int_Repeat_Day, SubEntry->GetDateTime()->Day);
		Entry->AddInt(Calendar_Int_Repeat_Month, SubEntry->GetDateTime()->Month);
	}

	if (RepeatBuffer == NULL) return GSM_Return_Error(GSM_ERR_NONE);
	Repeat = RepeatBuffer[0]*256+RepeatBuffer[1];
	if (Repeat == 0) return GSM_Return_Error(GSM_ERR_NONE);
	Debug->Deb("Repeat : %i times\n",Repeat);
	Repeat--;

	if (Recurrance==24*30) {
		for (i=0;i<Repeat;i++) {
			if (DT.Month == 12) {
				DT.Month = 1;
				DT.Year++;
			} else {
				DT.Month++;
			}
		}
		Debug->Deb("   End repeat : %02i-%02i-%04i %02i:%02i:%02i\n",
				DT.Day,DT.Month,DT.Year,DT.Hour,DT.Minute,DT.Second);
		Entry->AddDateTime(Calendar_DateTime_End_Repeat, DT);
		return GSM_Return_Error(GSM_ERR_NONE);
	}
	if (Recurrance==24*365) {
		DT.Year += Repeat;
		Debug->Deb("   End repeat : %02i-%02i-%04i %02i:%02i:%02i\n",
				DT.Day,DT.Month,DT.Year,DT.Hour,DT.Minute,DT.Second);
		Entry->AddDateTime(Calendar_DateTime_End_Repeat, DT);
		return GSM_Return_Error(GSM_ERR_NONE);
	}
	if (Recurrance != 24 && Recurrance != 24*7 && Recurrance != 24*14) return GSM_Return_Error(GSM_ERR_UNKNOWN);

	timet	   = GSMDateTime2TimeT(&DT);
	timet	  += 60*60*Recurrance*Repeat;
	memcpy(&tmstruct,localtime(&timet),sizeof(struct tm));
	DT.Year	 	= tmstruct.tm_year + 1900;
	DT.Month	= tmstruct.tm_mon+1;
	DT.Day	  	= tmstruct.tm_mday;
	DT.Hour	 	= tmstruct.tm_hour;
	DT.Minute       = tmstruct.tm_min;
	DT.Second       = tmstruct.tm_sec;

	Debug->Deb("   End repeat : %02i-%02i-%04i %02i:%02i:%02i\n",
			DT.Day,DT.Month,DT.Year,DT.Hour,DT.Minute,DT.Second);
	Entry->AddDateTime(Calendar_DateTime_End_Repeat, DT);

	return GSM_Return_Error(GSM_ERR_NONE);
}

//sets Buffer & RepeatBuffer from Calendar structure
GSM_Error NokiaSetCalendarRecurranceRepeat(DebugInfo *Debug, GSM_CalendarEntry *Entry, unsigned char *Buffer, unsigned char *RepeatBuffer)
{
	GSM_CalendarSubEntry    *SubEntry, *DateStart = NULL, *DateEnd = NULL;
	int		     	RepeatEach = -1, RepeatDOW = -1, RepeatDay = -1, RepeatMonth = -1, Recurrance = 0;
	int		     	DOW,Repeat=0;
	time_t		  	ttime1,ttime2;
	GSM_DateTime	    	DT;

	SubEntry = NULL;
	while (Entry->GetNext(&SubEntry) == TRUE) {
		switch (SubEntry->GetType()) {
		case Calendar_DateTime_Start:
			DateStart = SubEntry;
			break;
		case Calendar_DateTime_End:
			DateEnd = SubEntry;
			break;
		case Calendar_Int_Repeat_Frequency:
			RepeatEach = SubEntry->GetInt();
			break;
		case Calendar_Int_Repeat_DayOfWeek:
			RepeatDOW = SubEntry->GetInt();
			break;		  
		case Calendar_Int_Repeat_Day:
			RepeatDay = SubEntry->GetInt();
			break;
		case Calendar_Int_Repeat_Month:
			RepeatMonth = SubEntry->GetInt();
			break;
		}
	}

	DOW = DayOfWeek(DateStart->GetDateTime()->Year,
			DateStart->GetDateTime()->Month,
			DateStart->GetDateTime()->Day);

	if (RepeatEach == 1   && RepeatDay == -1 && 
	    RepeatMonth == -1 && RepeatDOW == -1) {
		Recurrance = 24; //each day
	}
	if (RepeatEach == 1   && RepeatDay == -1 && 
	    RepeatMonth == -1 && RepeatDOW == DOW) {
		Recurrance = 24*7; //one week
	}
	if (RepeatEach == 2   && RepeatDay == -1 && 
	    RepeatMonth == -1 && RepeatDOW == DOW) {
		Recurrance = 24*14; //two weeks
	}
	if (RepeatEach == 1   && RepeatDay == DateStart->GetDateTime()->Day && 
	    RepeatMonth == -1 && RepeatDOW == -1) {
		Recurrance = 0xffff-1; //month
	}
	if (RepeatEach == 1 && RepeatDay == DateStart->GetDateTime()->Day && 
	    RepeatMonth == DateStart->GetDateTime()->Month && RepeatDOW == -1) {
		Recurrance = 0xffff; //year
	}

	Buffer[0] = Recurrance/256;
	Buffer[1] = Recurrance%256;

	if (RepeatBuffer == NULL) return GSM_Return_Error(GSM_ERR_NONE);

	RepeatBuffer[0] = 0;
	RepeatBuffer[1] = 0;

	if (DateEnd == NULL) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	ttime1 = GSMDateTime2TimeT(DateStart->GetDateTime());
	ttime2 = GSMDateTime2TimeT(DateEnd->GetDateTime());
	if (ttime2 - ttime1 <= 0) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	switch (Recurrance) {
		case 24:
		case 24*7:
		case 24*14:
			Repeat = (ttime2 - ttime1) / (60*60*Recurrance) + 1;
			break;
		case 0xffff-1:
			memcpy(&DT,DateStart->GetDateTime(),sizeof(GSM_DateTime));
			while (1) {
				if ((DT.Year == DateEnd->GetDateTime()->Year && 
				     DT.Month > DateEnd->GetDateTime()->Month) ||
				    (DT.Year > DateEnd->GetDateTime()->Year)) break;
				if (DT.Month == 12) {
					DT.Month = 1;
					DT.Year++;
				} else {
					DT.Month++;
				}
				Repeat++;
			}
			break;
		case 0xffff:
			Repeat = DateEnd->GetDateTime()->Year-DateStart->GetDateTime()->Year+1;
			break;
	}

	RepeatBuffer[0] = Repeat/256;
	RepeatBuffer[1] = Repeat%256;

	return GSM_Return_Error(GSM_ERR_NONE);
}
