/* (C) 2003 - 2005 by Marcin Wiacek www.mwiacek.com */

#include "../../gsmphone.h"
#include "../../../service/gsmmisc.h"
#include "../ndct34.h"
#include "../../../misc/coding/coding.h"

#include "ndct3.h"

GSM_Phone_NDCT3::GSM_Phone_NDCT3(int id,DebugInfo **Debug2, GSM_Phone **Pho2, GSM_Protocol **Prot2)
{
	ID 	= id;
	Debug 	= Debug2;
	Pho 	= Pho2;
	Prot 	= Prot2;
}

int GSM_Phone_NDCT3::GetID()
{
	return ID;
}

GSM_Error GSM_Phone_NDCT3::ReplySetSecurity(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *Ident)
{
	(*Debug)->Deb("RECEIVED: set state of security commands\n");
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT3::SetSecurity(unsigned char status)
{
	unsigned char Buff[] = {0x00, 0x01, 0x64, 0x01};

	/* 0x00 - phone on
	 * 0x01 - phone off
	 * 0x03 - soft reset. When use it and had during session
	 *        changed time & date some phones (like 6150 or 6210) can ask
         *        for time & date after reset or disable clock on the screen
	 * 0x04 - hard reset
	 * 0x06 - CONTACT SERVICE
	 */
	if (status == 0x06) return GSM_Return_Error(GSM_ERR_UNKNOWN);
	Buff[3] = status;

	(*Debug)->Deb("SENT: Setting state of security commands\n");
	return (*Pho)->Write(Buff, sizeof(Buff), 0x40, 4, ID_SetSecurity+ID, NULL);
}

GSM_Error GSM_Phone_NDCT3::ReplyGetIMEI(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *IMEI)
{
	memcpy(IMEI,msg->Buffer.data()+4, 16);
	(*Debug)->Deb("RECEIVED: IMEI %s\n",IMEI);
        return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT3::GetIMEI(unsigned char *IMEI)
{
	unsigned char 	Buff[] = {0x00, 0x01, 0x66, 0x00};
	GSM_Error 	error;

	error = SetSecurity(0x01);
	if (error.Code != GSM_ERR_NONE) return error;

	(*Debug)->Deb("SENT: getting IMEI\n");
	return (*Pho)->Write(Buff, sizeof(Buff), 0x40, 2, ID_GetIMEI+ID, IMEI);
}

GSM_Error GSM_Phone_NDCT3::ReplyGetDateTime(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_DateTime *DT = (GSM_DateTime *)S;

	(*Debug)->Deb("RECEIVED: datetime\n");

	if (msg->Buffer.data()[4] == 0x01) {
		memcpy(DT,NokiaGetDT(msg->Buffer.data()+8),sizeof(GSM_DateTime));
		return GSM_Return_Error(GSM_ERR_NONE);
	}
	return GSM_Return_Error(GSM_ERR_EMPTY);
}

GSM_Error GSM_Phone_NDCT3::GetDateTime(GSM_DateTime *DT, unsigned char msgtype)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x62};

	(*Debug)->Deb("SENT: getting datetime\n");
	return (*Pho)->Write(Buff, sizeof(Buff), msgtype, 4, ID_GetDateTime+ID, DT);
}

GSM_Error GSM_Phone_NDCT3::DecodeSMSFrame(GSM_SMSEntry *SMS, const unsigned char *buffer, int len)
{
	int len2;
	
	SMS->PhoneNumbers.ClearAll();
	SMS->SMSCNumber.clear();
	SMS->UserData.clear();

	if (len < 13) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
	if (buffer[0]+1 > 13) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
	SMS->SMSCNumber.append(buffer,buffer[0]+1);

	SMS->firstbyte = buffer[12];

	switch (SMS->GetType()) {
	case SMS_Deliver:
		if (len < 36) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
		SMS->TPPID   = buffer[13];
		SMS->TPDCS   = buffer[14];
		SMS->TPUDL   = buffer[15];

		//len for phone number is saved in semioctets. we convert it
		len2 = buffer[16];
		if (len2 % 2) len2++;
		if ((len2/2+1)+1 > 28-16) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
		SMS->PhoneNumbers.Add(buffer+16,(len2/2+1)+2);

		memcpy(SMS->DateTime,buffer+28,7);
		SMS->UserData.append(buffer+35,len-35);
		break;
	case SMS_Report:
		if (len < 36) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
		SMS->TPMR     = buffer[13];
		SMS->TPStatus = buffer[14];

		//len for phone number is saved in semioctets. we convert it
		len2 = buffer[15];
		if (len2 % 2) len2++;
		if ((len2/2+1)+1 > 27-15) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
		SMS->PhoneNumbers.Add(buffer+15,(len2/2+1)+1);

		memcpy(SMS->DateTime,buffer+27,7);
		memcpy(SMS->SMSCTime,buffer+34,7);
		break;
	case SMS_Submit:
		if (len < 37) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
		SMS->TPMR    = buffer[13];
		SMS->TPPID   = buffer[14];
		SMS->TPDCS   = buffer[15];
		SMS->TPUDL   = buffer[16];

		//phone number

		SMS->TPVP    = buffer[29];
		SMS->UserData.append(buffer+36,len-36);

		break;
	}
	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT3::EncodeSMSFrameToBuffer(GSM_SMSEntry *SMS, unsignedstring *Buffer)
{
	unsignedstring 		Temp,Temp2;
	int 			num=0;
	unsigned char		buff[50];
	GSM_SMSNumbersSubEntry 	*Number;

	if (SMS->GetType()==SMS_Report) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	if (SMS->SMSCNumber.size() > 12) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);

	Number = NULL;
	while (SMS->PhoneNumbers.GetNext(&Number)) {
		if (Number->PhoneNumber.size() > 12) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);
		num++;
	}
	if (num>1) return GSM_Return_Error(GSM_ERR_GPLUS_NOT_SUPPORTED);

	num = 0;

	memcpy(buff,SMS->SMSCNumber.data(),SMS->SMSCNumber.size());
	Buffer->append(buff,12);

	Buffer->push_back(SMS->firstbyte);

	switch (SMS->GetType()) {
	case SMS_Deliver:
		Buffer->push_back(SMS->TPPID);
		Buffer->push_back(SMS->TPDCS);
		Buffer->push_back(SMS->TPUDL);

		Number = NULL;
		if (SMS->PhoneNumbers.GetNext(&Number)) {
			memcpy(buff,Number->PhoneNumber.data(),Number->PhoneNumber.size());
		}
		Buffer->append(buff,12);

		Buffer->append(SMS->DateTime,7);
		break;
	case SMS_Submit:
		Buffer->push_back(SMS->TPMR);
		Buffer->push_back(SMS->TPPID);
		Buffer->push_back(SMS->TPDCS);
		Buffer->push_back(SMS->TPUDL);

		Number = NULL;
		if (SMS->PhoneNumbers.GetNext(&Number)) {
			memcpy(buff,Number->PhoneNumber.data(),Number->PhoneNumber.size());
		}
		Buffer->append(buff,12);

		Buffer->push_back(SMS->TPVP);
		Buffer->append(buff,6);//to fill space
		break;
	default:
		break;
	}
	Buffer->append(SMS->UserData.data());

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT3::ReplyGetSMSC(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S)
{
	GSM_SMSC 	*SMSC = (GSM_SMSC *)S;
	GSM_Error	error;
	wchar_t		Buff[50];

	(*Debug)->Deb("RECEIVED: SMSC\n");

	switch (msg->Buffer.data()[3]) {
		case 0x34:	break;
		case 0x35:	return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
		default  :	return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}

	switch (msg->Buffer.data()[6]) {
		case 0x00: SMSC->Format = SMS_Text; 	break;
		case 0x22: SMSC->Format = SMS_Fax; 	break;
		case 0x26: SMSC->Format = SMS_Pager;	break;
		case 0x32: SMSC->Format = SMS_Email;	break;
		default  : SMSC->Format = SMS_Text;
	}

	SMSC->RelativeValidity = msg->Buffer.data()[8];
	if (msg->Buffer.data()[8] == 0x00) SMSC->RelativeValidity = SMS_RelativeValidity_Max_Time;

	SMSC->SetName(StringToUnicodeReturn((char *)msg->Buffer.data()+33));
	(*Debug)->Deb("  Name %s\n",UnicodeToStringReturn(SMSC->GetName()));

	error = GSM_DecodeSMSNumber(Buff, msg->Buffer.data()+9, msg->Buffer.data()[9], TRUE);
	if (error.Code != GSM_ERR_NONE) return error;
	SMSC->SetDefaultNumber(Buff);
	(*Debug)->Deb("  Default number %s\n",UnicodeToStringReturn(SMSC->GetDefaultNumber()));

	error = GSM_DecodeSMSNumber(Buff, msg->Buffer.data()+21, msg->Buffer.data()[21], FALSE);
	if (error.Code != GSM_ERR_NONE) return error;
	SMSC->SetSMSCNumber(Buff);
	(*Debug)->Deb("  Number %s\n",UnicodeToStringReturn(SMSC->GetSMSCNumber()));

	return GSM_Return_Error(GSM_ERR_NONE);
}

GSM_Error GSM_Phone_NDCT3::GetSMSC(GSM_SMSC *SMSC)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x33, 0x64,
				0x00};		// location

	if (SMSC->Location == 0 || SMSC->Location > 255) return GSM_Return_Error(GSM_ERR_INVALID_LOCATION);
	
	Buff[5] = SMSC->Location;
	
	(*Debug)->Deb("SENT: getting SMSC\n");
	return (*Pho)->Write(Buff, sizeof(Buff), 0x02, 4, ID_GetSMSC+ID, SMSC); 
}

GSM_Error GSM_Phone_NDCT3::GetSMSStatus(GSM_SMSStatus *Status)
{
	unsigned char Buff[] = {NOKIA_FRAME1, 0x36, 0x64};

	(*Debug)->Deb("SENT: getting status for SMS\n");
	return (*Pho)->Write(Buff, sizeof(Buff), 0x14, 4, ID_GetSMSStatus+ID, Status);
}

GSM_Error GSM_Phone_NDCT3::ReplySendSMS(GSM_Protocol_Message *msg, DebugInfo **Debug, unsigned char *S,void (*SMSSendReply)(int TPMR))
{
	switch (msg->Buffer.data()[8]) {
	case 0x02:
		if (SMSSendReply != NULL) SMSSendReply(msg->Buffer.data()[5]);
		return GSM_Return_Error(GSM_ERR_NONE);
	default:
		if (SMSSendReply != NULL) SMSSendReply(-1);
		return GSM_Return_Error(GSM_ERR_UNKNOWN);
	}
}

GSM_Error GSM_Phone_NDCT3::SendSMS(GSM_SMSEntry *SMS)
{
	GSM_Error 		error;
	unsignedstring  	Buffer;

	if (SMS->GetType()!=SMS_Submit) return GSM_Return_Error(GSM_ERR_NOT_SUPPORTED);

	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x00);
	Buffer.push_back(0x01);
	Buffer.push_back(0x02);
	Buffer.push_back(0x00);

	error = EncodeSMSFrameToBuffer(SMS, &Buffer);
	if (error.Code != GSM_ERR_NONE) return error;

	(*Debug)->Deb("SENT: Sending SMS\n");
	return (*Prot)->Write((unsigned char *)Buffer.data(), Buffer.size(), 0x02);
}
